/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2019-07-21 06:41:44 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_nd_booking_booking` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_post` int(11) NOT NULL,
  `title_post` varchar(255) NOT NULL,
  `date` varchar(255) NOT NULL,
  `date_from` varchar(255) NOT NULL,
  `date_to` varchar(255) NOT NULL,
  `guests` int(11) NOT NULL,
  `final_trip_price` int(11) NOT NULL,
  `extra_services` varchar(255) NOT NULL,
  `id_user` int(11) NOT NULL,
  `user_first_name` varchar(255) NOT NULL,
  `user_last_name` varchar(255) NOT NULL,
  `paypal_email` varchar(255) NOT NULL,
  `user_phone` varchar(255) NOT NULL,
  `user_address` varchar(255) NOT NULL,
  `user_city` varchar(255) NOT NULL,
  `user_country` varchar(255) NOT NULL,
  `user_message` varchar(255) NOT NULL,
  `user_arrival` varchar(255) NOT NULL,
  `user_coupon` varchar(255) NOT NULL,
  `paypal_payment_status` varchar(255) NOT NULL,
  `paypal_currency` varchar(255) NOT NULL,
  `paypal_tx` varchar(255) NOT NULL,
  `action_type` varchar(255) NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=749 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1311 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=119 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `path` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `path_hash` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `resize` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `lossy` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `error` varchar(55) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  `term_order` int(4) DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT '0',
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT '0',
  `blockedHits` int(10) unsigned DEFAULT '0',
  `expiration` bigint(20) unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT '0',
  `statusCode` int(11) NOT NULL DEFAULT '200',
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8575 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '1000',
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `type` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=585 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `target_post_id` bigint(20) unsigned NOT NULL,
  `type` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=199 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_meta` (
  `object_id` bigint(20) unsigned NOT NULL,
  `internal_link_count` int(10) unsigned DEFAULT NULL,
  `incoming_link_count` int(10) unsigned DEFAULT NULL,
  UNIQUE KEY `object_id` (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Un commentateur WordPress", "wapuu@wordpress.example", "https://wordpress.org/", "", "2019-07-10 11:20:20", "2019-07-10 09:20:20", "Bonjour, ceci est un commentaire.\nPour débuter avec la modération, la modification et la suppression de commentaires, veuillez visiter l’écran des Commentaires dans le Tableau de bord.\nLes avatars des personnes qui commentent arrivent depuis <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "22", "nicdark", "test@test.com", "", "95.233.189.65", "2017-07-21 13:57:38", "2017-07-21 13:57:38", "Sed quis rutrum tellus, sit amet viverra felis. Cras sagittis sem sit amet urna feugiat rutrum.", "0", "1", "", "", "0", "1");
INSERT INTO `wp_comments` VALUES("3", "22", "nicdark", "test@test.com", "", "95.233.189.65", "2017-07-21 13:58:03", "2017-07-21 13:58:03", "Vivamus bibendum nibh in dolor pharetra, a euismod nulla dignissim. Aenean viverra tincidunt nibh, in imperdiet nunc.", "0", "1", "", "", "0", "1");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20190721_gitelesecuriesdesabbys", "8c977a67a801eda15676_20190721063958", "21", "2019-07-21 06:41:44", "unknown", "O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-07-21 06:39:58\";s:7:\"Version\";s:6:\"1.3.16\";s:9:\"VersionWP\";s:5:\"5.2.2\";s:9:\"VersionDB\";s:6:\"5.7.23\";s:10:\"VersionPHP\";s:6:\"7.2.10\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:31:\"20190721_gitelesecuriesdesabbys\";s:4:\"Hash\";s:35:\"8c977a67a801eda15676_20190721063958\";s:8:\"NameHash\";s:67:\"20190721_gitelesecuriesdesabbys_8c977a67a801eda15676_20190721063958\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:61:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-snapshots/tmp\";s:8:\"StoreURL\";s:49:\"http://localhost/gite-ecuries-abbys/wp-snapshots/\";s:8:\"ScanFile\";s:77:\"20190721_gitelesecuriesdesabbys_8c977a67a801eda15676_20190721063958_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.5\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:79:\"20190721_gitelesecuriesdesabbys_8c977a67a801eda15676_20190721063958_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:44:\"/Applications/MAMP/htdocs/gite-ecuries-abbys\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":5:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":6:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":25:{s:7:\"Created\";s:19:\"2019-07-21 06:39:58\";s:7:\"Version\";s:6:\"1.3.16\";s:9:\"VersionWP\";s:5:\"5.2.2\";s:9:\"VersionDB\";s:6:\"5.7.23\";s:10:\"VersionPHP\";s:6:\"7.2.10\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:31:\"20190721_gitelesecuriesdesabbys\";s:4:\"Hash\";s:35:\"8c977a67a801eda15676_20190721063958\";s:8:\"NameHash\";s:67:\"20190721_gitelesecuriesdesabbys_8c977a67a801eda15676_20190721063958\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:9:\"StorePath\";s:61:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-snapshots/tmp\";s:8:\"StoreURL\";s:49:\"http://localhost/gite-ecuries-abbys/wp-snapshots/\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:23;s:9:\"Installer\";O:13:\"DUP_Installer\":11:{s:4:\"File\";s:81:\"20190721_gitelesecuriesdesabbys_8c977a67a801eda15676_20190721063958_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:80:\"20190721_gitelesecuriesdesabbys_8c977a67a801eda15676_20190721063958_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":15:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:1:{s:14:\"wp_commentmeta\";s:1:\"0\";}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:25:\"\0DUP_Database\0dbStorePath\";s:142:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-snapshots/tmp/20190721_gitelesecuriesdesabbys_8c977a67a801eda15676_20190721063958_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:53:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-admin\";i:1;s:63:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-content/uploads\";i:2;s:65:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-content/languages\";i:3;s:62:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-content/themes\";i:4;s:56:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:44:\"/Applications/MAMP/htdocs/gite-ecuries-abbys\";i:1;s:55:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-content\";}}s:9:\"Installer\";r:86;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:130;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://localhost/gite-ecuries-abbys", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://localhost/gite-ecuries-abbys", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Gîte les ecuries des abbys", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Un site utilisant WordPress", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "hombtch@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G \\h i \\m\\i\\n", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j F Y G \\h i \\m\\i\\n", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:23:{i:0;s:27:\"autoptimize/autoptimize.php\";i:1;s:53:\"child-theme-configurator/child-theme-configurator.php\";i:2;s:33:\"classic-editor/classic-editor.php\";i:3;s:36:\"contact-form-7/wp-contact-form-7.php\";i:4;s:31:\"cookie-notice/cookie-notice.php\";i:5;s:32:\"duplicate-page/duplicatepage.php\";i:6;s:25:\"duplicator/duplicator.php\";i:7;s:45:\"enable-media-replace/enable-media-replace.php\";i:8;s:33:\"instagram-feed/instagram-feed.php\";i:9;s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";i:10;s:27:\"js_composer/js_composer.php\";i:11;s:35:\"login-recaptcha/login-nocaptcha.php\";i:12;s:27:\"maintenance/maintenance.php\";i:13;s:25:\"nd-booking/nd-booking.php\";i:14;s:31:\"nd-shortcodes/nd-shortcodes.php\";i:15;s:35:\"rename-wp-login/rename-wp-login.php\";i:16;s:23:\"revslider/revslider.php\";i:17;s:37:\"user-role-editor/user-role-editor.php\";i:18;s:33:\"w3-total-cache/w3-total-cache.php\";i:19;s:23:\"wordfence/wordfence.php\";i:20;s:41:\"wordpress-importer/wordpress-importer.php\";i:21;s:24:\"wordpress-seo/wp-seo.php\";i:22;s:23:\"wp-smushit/wp-smush.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:3:{i:0;s:85:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-content/themes/hotelbooking/style.css\";i:1;s:91:\"/Applications/MAMP/htdocs/gite-ecuries-abbys/wp-content/themes/hotelbooking-child/style.css\";i:3;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "hotelbooking", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "hotelbooking-child", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_whitelist", "1", "yes");
INSERT INTO `wp_options` VALUES("43", "blacklist_keys", "", "no");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "44719", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:6:{s:27:\"autoptimize/autoptimize.php\";s:29:\"autoptimizeMain::on_uninstall\";s:33:\"instagram-feed/instagram-feed.php\";s:22:\"sb_instagram_uninstall\";s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";s:15:\"hicpo_uninstall\";s:35:\"rename-wp-login/rename-wp-login.php\";a:2:{i:0;s:15:\"Rename_WP_Login\";i:1;s:9:\"uninstall\";}s:33:\"classic-editor/classic-editor.php\";a:2:{i:0;s:14:\"Classic_Editor\";i:1;s:9:\"uninstall\";}s:53:\"child-theme-configurator/child-theme-configurator.php\";s:22:\"chld_thm_cfg_uninstall\";}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "Europe/Paris", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "20", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "16", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "initial_db_version", "44719", "yes");
INSERT INTO `wp_options` VALUES("94", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:85:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:29:\"manage_instagram_feed_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:20:\"wpseo_manage_options\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:31:\"vc_access_rules_post_types/page\";b:1;s:43:\"vc_access_rules_post_types/nd_booking_cpt_1\";b:1;s:43:\"vc_access_rules_post_types/nd_booking_cpt_2\";b:1;s:43:\"vc_access_rules_post_types/nd_booking_cpt_4\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:24:\"vc_access_rules_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:44:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:14:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:46:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:45:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_frontend_editor\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("95", "fresh_site", "0", "yes");
INSERT INTO `wp_options` VALUES("96", "WPLANG", "fr_FR", "yes");
INSERT INTO `wp_options` VALUES("97", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "sidebars_widgets", "a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:24:\"nd_booking_sidebar_cpt_1\";a:0:{}s:28:\"nd_options_footer_4_column_1\";a:0:{}s:28:\"nd_options_footer_4_column_2\";a:0:{}s:28:\"nd_options_footer_4_column_3\";a:0:{}s:28:\"nd_options_footer_4_column_4\";a:0:{}s:30:\"nd_options_woocommerce_sidebar\";a:0:{}s:15:\"nicdark_sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "cron", "a:13:{i:1563693620;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1563693772;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1563694208;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1563700820;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1563700828;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1563700830;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1563700973;a:2:{s:15:\"ao_cachechecker\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:19:\"wpseo-reindex-links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1563701408;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1563739204;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1563826742;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"4863fc07efb9aa52060b088e5303fb12\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1563826742;}}}}i:1564085942;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"9e308430e6f5729982f0b2b9f23f4aad\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1564085942;}}}}i:1564408800;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_options` VALUES("113", "theme_mods_twentynineteen", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1562751751;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}s:18:\"nav_menu_locations\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("130", "can_compress_scripts", "1", "no");
INSERT INTO `wp_options` VALUES("145", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:17:\"hombtch@gmail.com\";s:7:\"version\";s:5:\"5.1.1\";s:9:\"timestamp\";i:1562750443;}", "no");
INSERT INTO `wp_options` VALUES("151", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("152", "wpcf7", "a:2:{s:7:\"version\";s:5:\"5.1.3\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";d:1562757760;s:7:\"version\";s:5:\"5.1.3\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "yes");
INSERT INTO `wp_options` VALUES("153", "cookie_notice_options", "a:24:{s:8:\"position\";s:6:\"bottom\";s:12:\"message_text\";s:153:\"We use cookies to ensure that we give you the best experience on our website. If you continue to use this site we will assume that you are happy with it.\";s:9:\"css_style\";s:9:\"bootstrap\";s:9:\"css_class\";s:6:\"button\";s:11:\"accept_text\";s:2:\"Ok\";s:11:\"refuse_text\";s:2:\"No\";s:10:\"refuse_opt\";s:2:\"no\";s:11:\"refuse_code\";s:0:\"\";s:16:\"refuse_code_head\";s:0:\"\";s:14:\"revoke_cookies\";b:0;s:18:\"revoke_cookies_opt\";s:9:\"automatic\";s:11:\"revoke_text\";s:14:\"Revoke cookies\";s:11:\"redirection\";b:0;s:8:\"see_more\";s:2:\"no\";s:11:\"link_target\";s:6:\"_blank\";s:4:\"time\";s:5:\"month\";s:11:\"hide_effect\";s:4:\"fade\";s:9:\"on_scroll\";b:0;s:16:\"on_scroll_offset\";i:100;s:6:\"colors\";a:2:{s:4:\"text\";s:4:\"#fff\";s:3:\"bar\";s:4:\"#000\";}s:12:\"see_more_opt\";a:5:{s:4:\"text\";s:14:\"Privacy policy\";s:9:\"link_type\";s:4:\"page\";s:2:\"id\";s:5:\"empty\";s:4:\"link\";s:0:\"\";s:4:\"sync\";b:0;}s:16:\"script_placement\";s:6:\"header\";s:9:\"translate\";b:0;s:19:\"deactivation_delete\";s:2:\"no\";}", "no");
INSERT INTO `wp_options` VALUES("154", "cookie_notice_version", "1.2.46", "no");
INSERT INTO `wp_options` VALUES("155", "duplicate_page_options", "a:4:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";s:21:\"duplicate_post_editor\";s:7:\"classic\";}", "yes");
INSERT INTO `wp_options` VALUES("156", "duplicator_settings", "a:13:{s:7:\"version\";s:6:\"1.3.16\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:16:\"uninstall_tables\";b:1;s:13:\"package_debug\";b:0;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:17:\"active_package_id\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("157", "duplicator_version_plugin", "1.3.16", "yes");
INSERT INTO `wp_options` VALUES("158", "sb_instagram_settings", "a:3:{s:21:\"sb_instagram_show_btn\";b:1;s:24:\"sb_instagram_show_header\";b:1;s:28:\"sb_instagram_show_follow_btn\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("159", "hicpo_ver", "3.1.2", "yes");
INSERT INTO `wp_options` VALUES("160", "login_nocaptcha_message_type", "notice-error", "yes");
INSERT INTO `wp_options` VALUES("161", "login_nocaptcha_error", "Login NoCaptcha has not been properly configured. <a href=\"options-general.php?page=login-recaptcha/admin.php\">Click here</a> to configure.", "yes");
INSERT INTO `wp_options` VALUES("163", "user_role_editor", "a:1:{s:11:\"ure_version\";s:6:\"4.51.1\";}", "yes");
INSERT INTO `wp_options` VALUES("164", "wp_backup_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:62:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:29:\"manage_instagram_feed_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("165", "ure_tasks_queue", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("166", "wordfence_ls_version", "1.0.2", "yes");
INSERT INTO `wp_options` VALUES("167", "wordfence_version", "7.3.4", "yes");
INSERT INTO `wp_options` VALUES("168", "wordfence_case", "", "yes");
INSERT INTO `wp_options` VALUES("169", "wordfence_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("170", "wordfenceActivated", "1", "yes");
INSERT INTO `wp_options` VALUES("171", "wf_plugin_act_error", "", "yes");
INSERT INTO `wp_options` VALUES("172", "wpseo", "a:20:{s:15:\"ms_defaults_set\";b:0;s:7:\"version\";s:4:\"11.6\";s:20:\"disableadvanced_meta\";b:1;s:19:\"onpage_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1562750568;s:13:\"myyoast-oauth\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("173", "wpseo_titles", "a:71:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:14:\"person_logo_id\";i:0;s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:15:\"company_logo_id\";i:0;s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("174", "wpseo_social", "a:19:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("175", "wpseo_flush_rewrite", "1", "yes");
INSERT INTO `wp_options` VALUES("176", "autoptimize_version", "2.5.1", "yes");
INSERT INTO `wp_options` VALUES("177", "autoptimize_service_availablity", "a:2:{s:12:\"extra_imgopt\";a:3:{s:6:\"status\";s:2:\"up\";s:5:\"hosts\";a:1:{i:1;s:26:\"https://cdn.shortpixel.ai/\";}s:16:\"launch-threshold\";s:4:\"4096\";}s:7:\"critcss\";a:2:{s:6:\"status\";s:2:\"up\";s:5:\"hosts\";a:1:{i:1;s:24:\"https://criticalcss.com/\";}}}", "yes");
INSERT INTO `wp_options` VALUES("180", "wp-smush-settings", "a:19:{s:11:\"networkwide\";b:0;s:4:\"auto\";b:1;s:5:\"lossy\";b:0;s:10:\"strip_exif\";b:1;s:6:\"resize\";b:0;s:9:\"detection\";b:0;s:8:\"original\";b:0;s:6:\"backup\";b:0;s:10:\"png_to_jpg\";b:0;s:7:\"nextgen\";b:0;s:2:\"s3\";b:0;s:9:\"gutenberg\";b:0;s:3:\"cdn\";b:0;s:11:\"auto_resize\";b:0;s:4:\"webp\";b:1;s:5:\"usage\";b:1;s:17:\"accessible_colors\";b:0;s:9:\"keep_data\";b:1;s:9:\"lazy_load\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("181", "_transient_timeout_wpseo_link_table_inaccessible", "1594286573", "no");
INSERT INTO `wp_options` VALUES("182", "_transient_wpseo_link_table_inaccessible", "0", "no");
INSERT INTO `wp_options` VALUES("183", "_transient_timeout_wpseo_meta_table_inaccessible", "1594286573", "no");
INSERT INTO `wp_options` VALUES("184", "_transient_wpseo_meta_table_inaccessible", "0", "no");
INSERT INTO `wp_options` VALUES("187", "w3tc_state", "{\"common.install\":1562750574,\"license.status\":\"no_key\",\"license.next_check\":1564122679,\"license.terms\":\"\",\"common.show_note.flush_statics_needed\":false,\"common.show_note.flush_statics_needed.timestamp\":1562774840,\"common.show_note.flush_posts_needed\":false,\"common.show_note.flush_posts_needed.timestamp\":1562774840,\"common.show_note.plugins_updated\":false,\"common.show_note.plugins_updated.timestamp\":1562774840,\"minify.show_note.need_flush\":false,\"minify.show_note.need_flush.timestamp\":1562774840,\"objectcache.show_note.flush_needed\":false,\"objectcache.show_note.flush_needed.timestamp\":1562774840}", "no");
INSERT INTO `wp_options` VALUES("189", "_transient_timeout_instagram_feed_rating_notice_waiting", "1563960174", "no");
INSERT INTO `wp_options` VALUES("190", "_transient_instagram_feed_rating_notice_waiting", "waiting", "no");
INSERT INTO `wp_options` VALUES("191", "sbi_rating_notice", "pending", "yes");
INSERT INTO `wp_options` VALUES("192", "login_nocaptcha_key", "", "yes");
INSERT INTO `wp_options` VALUES("193", "login_nocaptcha_secret", "", "yes");
INSERT INTO `wp_options` VALUES("194", "login_nocaptcha_whitelist", "", "yes");
INSERT INTO `wp_options` VALUES("196", "maintenance_db_version", "1", "yes");
INSERT INTO `wp_options` VALUES("197", "maintenance_options", "a:25:{s:10:\"page_title\";s:29:\"Website is under construction\";s:7:\"heading\";s:22:\"Maintenance mode is on\";s:11:\"description\";s:30:\"Website will be available soon\";s:11:\"footer_text\";s:35:\"© Gîte les ecuries des abbys 2019\";s:10:\"logo_width\";s:3:\"220\";s:11:\"logo_height\";s:0:\"\";s:4:\"logo\";s:1:\"0\";s:11:\"retina_logo\";s:1:\"0\";s:7:\"body_bg\";s:1:\"6\";s:17:\"bg_image_portrait\";s:1:\"0\";s:13:\"preloader_img\";s:1:\"0\";s:13:\"body_bg_color\";s:7:\"#111111\";s:10:\"font_color\";s:7:\"#ffffff\";s:17:\"controls_bg_color\";s:7:\"#111111\";s:16:\"body_font_family\";s:9:\"Open Sans\";s:16:\"body_font_subset\";s:3:\"300\";s:17:\"admin_bar_enabled\";s:1:\"1\";s:15:\"gg_analytics_id\";s:0:\"\";s:14:\"blur_intensity\";s:1:\"5\";s:8:\"is_login\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:13:\"ffc_statistic\";s:1:\"1\";s:18:\"ffc_subscribe_name\";s:0:\"\";s:19:\"ffc_subscribe_email\";s:0:\"\";s:5:\"state\";i:0;}", "yes");
INSERT INTO `wp_options` VALUES("198", "wdev-frash", "a:3:{s:7:\"plugins\";a:1:{s:23:\"wp-smushit/wp-smush.php\";i:1562750578;}s:5:\"queue\";a:2:{s:32:\"7de3619981caadc55f30a002bfb299f6\";a:4:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:5:\"email\";s:7:\"show_at\";i:1562750578;s:6:\"sticky\";b:1;}s:32:\"fc50097023d0d34c5a66f6cddcf77694\";a:3:{s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:4:\"type\";s:4:\"rate\";s:7:\"show_at\";i:1563777183;}}s:4:\"done\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("199", "wp-smush-install-type", "existing", "no");
INSERT INTO `wp_options` VALUES("200", "wp-smush-version", "3.2.1", "no");
INSERT INTO `wp_options` VALUES("205", "autoptimize_imgopt_launched", "on", "yes");
INSERT INTO `wp_options` VALUES("238", "rewrite_rules", "a:213:{s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:8:\"rooms/?$\";s:36:\"index.php?post_type=nd_booking_cpt_1\";s:38:\"rooms/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=nd_booking_cpt_1&feed=$matches[1]\";s:33:\"rooms/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=nd_booking_cpt_1&feed=$matches[1]\";s:25:\"rooms/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=nd_booking_cpt_1&paged=$matches[1]\";s:11:\"services/?$\";s:36:\"index.php?post_type=nd_booking_cpt_2\";s:41:\"services/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=nd_booking_cpt_2&feed=$matches[1]\";s:36:\"services/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=nd_booking_cpt_2&feed=$matches[1]\";s:28:\"services/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=nd_booking_cpt_2&paged=$matches[1]\";s:11:\"branches/?$\";s:36:\"index.php?post_type=nd_booking_cpt_4\";s:41:\"branches/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=nd_booking_cpt_4&feed=$matches[1]\";s:36:\"branches/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=nd_booking_cpt_4&feed=$matches[1]\";s:28:\"branches/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=nd_booking_cpt_4&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"rooms/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"rooms/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"rooms/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"rooms/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"rooms/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"rooms/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"rooms/([^/]+)/embed/?$\";s:49:\"index.php?nd_booking_cpt_1=$matches[1]&embed=true\";s:26:\"rooms/([^/]+)/trackback/?$\";s:43:\"index.php?nd_booking_cpt_1=$matches[1]&tb=1\";s:46:\"rooms/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?nd_booking_cpt_1=$matches[1]&feed=$matches[2]\";s:41:\"rooms/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?nd_booking_cpt_1=$matches[1]&feed=$matches[2]\";s:34:\"rooms/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?nd_booking_cpt_1=$matches[1]&paged=$matches[2]\";s:41:\"rooms/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?nd_booking_cpt_1=$matches[1]&cpage=$matches[2]\";s:30:\"rooms/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?nd_booking_cpt_1=$matches[1]&page=$matches[2]\";s:22:\"rooms/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"rooms/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"rooms/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"rooms/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"rooms/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"rooms/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"services/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"services/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"services/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"services/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"services/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"services/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"services/([^/]+)/embed/?$\";s:49:\"index.php?nd_booking_cpt_2=$matches[1]&embed=true\";s:29:\"services/([^/]+)/trackback/?$\";s:43:\"index.php?nd_booking_cpt_2=$matches[1]&tb=1\";s:49:\"services/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?nd_booking_cpt_2=$matches[1]&feed=$matches[2]\";s:44:\"services/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?nd_booking_cpt_2=$matches[1]&feed=$matches[2]\";s:37:\"services/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?nd_booking_cpt_2=$matches[1]&paged=$matches[2]\";s:44:\"services/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?nd_booking_cpt_2=$matches[1]&cpage=$matches[2]\";s:33:\"services/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?nd_booking_cpt_2=$matches[1]&page=$matches[2]\";s:25:\"services/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"services/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"services/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"services/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"services/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"services/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"exceptions/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"exceptions/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"exceptions/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"exceptions/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"exceptions/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"exceptions/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"exceptions/([^/]+)/embed/?$\";s:49:\"index.php?nd_booking_cpt_3=$matches[1]&embed=true\";s:31:\"exceptions/([^/]+)/trackback/?$\";s:43:\"index.php?nd_booking_cpt_3=$matches[1]&tb=1\";s:39:\"exceptions/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?nd_booking_cpt_3=$matches[1]&paged=$matches[2]\";s:46:\"exceptions/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?nd_booking_cpt_3=$matches[1]&cpage=$matches[2]\";s:35:\"exceptions/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?nd_booking_cpt_3=$matches[1]&page=$matches[2]\";s:27:\"exceptions/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"exceptions/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"exceptions/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"exceptions/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"exceptions/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"exceptions/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"branches/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"branches/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"branches/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"branches/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"branches/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"branches/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"branches/([^/]+)/embed/?$\";s:49:\"index.php?nd_booking_cpt_4=$matches[1]&embed=true\";s:29:\"branches/([^/]+)/trackback/?$\";s:43:\"index.php?nd_booking_cpt_4=$matches[1]&tb=1\";s:49:\"branches/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?nd_booking_cpt_4=$matches[1]&feed=$matches[2]\";s:44:\"branches/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?nd_booking_cpt_4=$matches[1]&feed=$matches[2]\";s:37:\"branches/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?nd_booking_cpt_4=$matches[1]&paged=$matches[2]\";s:44:\"branches/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?nd_booking_cpt_4=$matches[1]&cpage=$matches[2]\";s:33:\"branches/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?nd_booking_cpt_4=$matches[1]&page=$matches[2]\";s:25:\"branches/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"branches/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"branches/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"branches/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"branches/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"branches/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"locations/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"locations/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"locations/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"locations/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"locations/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"locations/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"locations/([^/]+)/embed/?$\";s:42:\"index.php?locations=$matches[1]&embed=true\";s:30:\"locations/([^/]+)/trackback/?$\";s:36:\"index.php?locations=$matches[1]&tb=1\";s:38:\"locations/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?locations=$matches[1]&paged=$matches[2]\";s:45:\"locations/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?locations=$matches[1]&cpage=$matches[2]\";s:34:\"locations/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?locations=$matches[1]&page=$matches[2]\";s:26:\"locations/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"locations/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"locations/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"locations/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"locations/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"locations/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=16&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("241", "current_theme", "HotelBooking Child", "yes");
INSERT INTO `wp_options` VALUES("242", "theme_mods_hotelbooking", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"main-menu\";i:15;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1562765017;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:24:\"nd_booking_sidebar_cpt_1\";a:0:{}s:28:\"nd_options_footer_4_column_1\";a:0:{}s:28:\"nd_options_footer_4_column_2\";a:0:{}s:28:\"nd_options_footer_4_column_3\";a:0:{}s:28:\"nd_options_footer_4_column_4\";a:0:{}s:30:\"nd_options_woocommerce_sidebar\";a:0:{}s:15:\"nicdark_sidebar\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("243", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("244", "nicdark_theme_author", "1", "yes");
INSERT INTO `wp_options` VALUES("254", "revslider_servers", "a:1:{i:0;s:16:\"themepunch.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("255", "revslider_server_refresh", "1562751836", "yes");
INSERT INTO `wp_options` VALUES("256", "revslider-update-check-short", "1563690667", "yes");
INSERT INTO `wp_options` VALUES("257", "revslider-templates-check", "1563690669", "yes");
INSERT INTO `wp_options` VALUES("263", "revslider-library-check", "1562752402", "yes");
INSERT INTO `wp_options` VALUES("264", "rs-library", "a:2:{s:7:\"objects\";a:179:{i:238;a:14:{s:2:\"id\";s:3:\"238\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:237;a:14:{s:2:\"id\";s:3:\"237\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:236;a:14:{s:2:\"id\";s:3:\"236\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:235;a:14:{s:2:\"id\";s:3:\"235\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:234;a:14:{s:2:\"id\";s:3:\"234\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:233;a:14:{s:2:\"id\";s:3:\"233\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:232;a:14:{s:2:\"id\";s:3:\"232\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:231;a:14:{s:2:\"id\";s:3:\"231\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:230;a:14:{s:2:\"id\";s:3:\"230\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:229;a:14:{s:2:\"id\";s:3:\"229\";s:4:\"type\";s:1:\"3\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";}i:198;a:13:{s:2:\"id\";s:3:\"198\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";}i:197;a:13:{s:2:\"id\";s:3:\"197\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:196;a:13:{s:2:\"id\";s:3:\"196\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:195;a:13:{s:2:\"id\";s:3:\"195\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:194;a:13:{s:2:\"id\";s:3:\"194\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:193;a:13:{s:2:\"id\";s:3:\"193\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:192;a:13:{s:2:\"id\";s:3:\"192\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:191;a:13:{s:2:\"id\";s:3:\"191\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:190;a:13:{s:2:\"id\";s:3:\"190\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:189;a:13:{s:2:\"id\";s:3:\"189\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";}i:188;a:13:{s:2:\"id\";s:3:\"188\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:187;a:13:{s:2:\"id\";s:3:\"187\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";}i:186;a:13:{s:2:\"id\";s:3:\"186\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:185;a:13:{s:2:\"id\";s:3:\"185\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:184;a:13:{s:2:\"id\";s:3:\"184\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:183;a:13:{s:2:\"id\";s:3:\"183\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:182;a:13:{s:2:\"id\";s:3:\"182\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:181;a:13:{s:2:\"id\";s:3:\"181\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:180;a:13:{s:2:\"id\";s:3:\"180\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:179;a:13:{s:2:\"id\";s:3:\"179\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:177;a:13:{s:2:\"id\";s:3:\"177\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:175;a:13:{s:2:\"id\";s:3:\"175\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:174;a:13:{s:2:\"id\";s:3:\"174\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:173;a:13:{s:2:\"id\";s:3:\"173\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";}i:172;a:13:{s:2:\"id\";s:3:\"172\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:171;a:13:{s:2:\"id\";s:3:\"171\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:170;a:13:{s:2:\"id\";s:3:\"170\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:169;a:13:{s:2:\"id\";s:3:\"169\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:168;a:13:{s:2:\"id\";s:3:\"168\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:167;a:13:{s:2:\"id\";s:3:\"167\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:166;a:13:{s:2:\"id\";s:3:\"166\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:165;a:13:{s:2:\"id\";s:3:\"165\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:164;a:13:{s:2:\"id\";s:3:\"164\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:163;a:13:{s:2:\"id\";s:3:\"163\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:162;a:13:{s:2:\"id\";s:3:\"162\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:161;a:13:{s:2:\"id\";s:3:\"161\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:160;a:13:{s:2:\"id\";s:3:\"160\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:159;a:13:{s:2:\"id\";s:3:\"159\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:158;a:13:{s:2:\"id\";s:3:\"158\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:157;a:13:{s:2:\"id\";s:3:\"157\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:156;a:13:{s:2:\"id\";s:3:\"156\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:155;a:13:{s:2:\"id\";s:3:\"155\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:154;a:13:{s:2:\"id\";s:3:\"154\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:153;a:13:{s:2:\"id\";s:3:\"153\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:152;a:13:{s:2:\"id\";s:3:\"152\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:151;a:13:{s:2:\"id\";s:3:\"151\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:150;a:13:{s:2:\"id\";s:3:\"150\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:149;a:13:{s:2:\"id\";s:3:\"149\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:148;a:13:{s:2:\"id\";s:3:\"148\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:147;a:13:{s:2:\"id\";s:3:\"147\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:146;a:13:{s:2:\"id\";s:3:\"146\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";}i:145;a:13:{s:2:\"id\";s:3:\"145\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:144;a:13:{s:2:\"id\";s:3:\"144\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:143;a:13:{s:2:\"id\";s:3:\"143\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:142;a:13:{s:2:\"id\";s:3:\"142\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:141;a:13:{s:2:\"id\";s:3:\"141\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:140;a:13:{s:2:\"id\";s:3:\"140\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:139;a:13:{s:2:\"id\";s:3:\"139\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:138;a:13:{s:2:\"id\";s:3:\"138\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:137;a:13:{s:2:\"id\";s:3:\"137\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:136;a:13:{s:2:\"id\";s:3:\"136\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:135;a:13:{s:2:\"id\";s:3:\"135\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:134;a:13:{s:2:\"id\";s:3:\"134\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:133;a:13:{s:2:\"id\";s:3:\"133\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:132;a:13:{s:2:\"id\";s:3:\"132\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:131;a:13:{s:2:\"id\";s:3:\"131\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:130;a:13:{s:2:\"id\";s:3:\"130\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:129;a:13:{s:2:\"id\";s:3:\"129\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:128;a:13:{s:2:\"id\";s:3:\"128\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:127;a:13:{s:2:\"id\";s:3:\"127\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";}i:126;a:13:{s:2:\"id\";s:3:\"126\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:125;a:13:{s:2:\"id\";s:3:\"125\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:124;a:13:{s:2:\"id\";s:3:\"124\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:123;a:13:{s:2:\"id\";s:3:\"123\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:122;a:13:{s:2:\"id\";s:3:\"122\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:121;a:13:{s:2:\"id\";s:3:\"121\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:120;a:13:{s:2:\"id\";s:3:\"120\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:119;a:13:{s:2:\"id\";s:3:\"119\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:118;a:13:{s:2:\"id\";s:3:\"118\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:117;a:13:{s:2:\"id\";s:3:\"117\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";}i:116;a:13:{s:2:\"id\";s:3:\"116\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:115;a:13:{s:2:\"id\";s:3:\"115\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:114;a:13:{s:2:\"id\";s:3:\"114\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:113;a:13:{s:2:\"id\";s:3:\"113\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:112;a:13:{s:2:\"id\";s:3:\"112\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:111;a:13:{s:2:\"id\";s:3:\"111\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:110;a:13:{s:2:\"id\";s:3:\"110\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:109;a:13:{s:2:\"id\";s:3:\"109\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:108;a:13:{s:2:\"id\";s:3:\"108\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:107;a:13:{s:2:\"id\";s:3:\"107\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:106;a:13:{s:2:\"id\";s:3:\"106\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:105;a:13:{s:2:\"id\";s:3:\"105\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:104;a:13:{s:2:\"id\";s:3:\"104\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:103;a:13:{s:2:\"id\";s:3:\"103\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:102;a:13:{s:2:\"id\";s:3:\"102\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:101;a:13:{s:2:\"id\";s:3:\"101\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:100;a:13:{s:2:\"id\";s:3:\"100\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:99;a:13:{s:2:\"id\";s:2:\"99\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:98;a:13:{s:2:\"id\";s:2:\"98\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:97;a:13:{s:2:\"id\";s:2:\"97\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:96;a:13:{s:2:\"id\";s:2:\"96\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:95;a:13:{s:2:\"id\";s:2:\"95\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:94;a:13:{s:2:\"id\";s:2:\"94\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:93;a:13:{s:2:\"id\";s:2:\"93\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:92;a:13:{s:2:\"id\";s:2:\"92\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:91;a:13:{s:2:\"id\";s:2:\"91\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:90;a:13:{s:2:\"id\";s:2:\"90\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:89;a:13:{s:2:\"id\";s:2:\"89\";s:4:\"type\";s:1:\"2\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";}i:88;a:13:{s:2:\"id\";s:2:\"88\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:87;a:13:{s:2:\"id\";s:2:\"87\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:86;a:13:{s:2:\"id\";s:2:\"86\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:85;a:13:{s:2:\"id\";s:2:\"85\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:84;a:13:{s:2:\"id\";s:2:\"84\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:83;a:13:{s:2:\"id\";s:2:\"83\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:82;a:13:{s:2:\"id\";s:2:\"82\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:81;a:13:{s:2:\"id\";s:2:\"81\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:80;a:13:{s:2:\"id\";s:2:\"80\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:79;a:13:{s:2:\"id\";s:2:\"79\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:78;a:13:{s:2:\"id\";s:2:\"78\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:77;a:13:{s:2:\"id\";s:2:\"77\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:76;a:13:{s:2:\"id\";s:2:\"76\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:75;a:13:{s:2:\"id\";s:2:\"75\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:74;a:13:{s:2:\"id\";s:2:\"74\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:73;a:13:{s:2:\"id\";s:2:\"73\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:72;a:13:{s:2:\"id\";s:2:\"72\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:71;a:13:{s:2:\"id\";s:2:\"71\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:70;a:13:{s:2:\"id\";s:2:\"70\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:69;a:13:{s:2:\"id\";s:2:\"69\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:68;a:13:{s:2:\"id\";s:2:\"68\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:67;a:13:{s:2:\"id\";s:2:\"67\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:66;a:13:{s:2:\"id\";s:2:\"66\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:65;a:13:{s:2:\"id\";s:2:\"65\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:64;a:13:{s:2:\"id\";s:2:\"64\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:63;a:13:{s:2:\"id\";s:2:\"63\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:62;a:13:{s:2:\"id\";s:2:\"62\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";}i:49;a:13:{s:2:\"id\";s:2:\"49\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:48;a:13:{s:2:\"id\";s:2:\"48\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:47;a:13:{s:2:\"id\";s:2:\"47\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:46;a:13:{s:2:\"id\";s:2:\"46\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:45;a:13:{s:2:\"id\";s:2:\"45\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:44;a:13:{s:2:\"id\";s:2:\"44\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:43;a:13:{s:2:\"id\";s:2:\"43\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:42;a:13:{s:2:\"id\";s:2:\"42\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:41;a:13:{s:2:\"id\";s:2:\"41\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:40;a:13:{s:2:\"id\";s:2:\"40\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:39;a:13:{s:2:\"id\";s:2:\"39\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:38;a:13:{s:2:\"id\";s:2:\"38\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:37;a:13:{s:2:\"id\";s:2:\"37\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:36;a:13:{s:2:\"id\";s:2:\"36\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:35;a:13:{s:2:\"id\";s:2:\"35\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:34;a:13:{s:2:\"id\";s:2:\"34\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:33;a:13:{s:2:\"id\";s:2:\"33\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:32;a:13:{s:2:\"id\";s:2:\"32\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:31;a:13:{s:2:\"id\";s:2:\"31\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:30;a:13:{s:2:\"id\";s:2:\"30\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:29;a:13:{s:2:\"id\";s:2:\"29\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:28;a:13:{s:2:\"id\";s:2:\"28\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";}i:27;a:13:{s:2:\"id\";s:2:\"27\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:26;a:13:{s:2:\"id\";s:2:\"26\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:25;a:13:{s:2:\"id\";s:2:\"25\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:24;a:13:{s:2:\"id\";s:2:\"24\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:23;a:13:{s:2:\"id\";s:2:\"23\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:22;a:13:{s:2:\"id\";s:2:\"22\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:21;a:13:{s:2:\"id\";s:2:\"21\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:20;a:13:{s:2:\"id\";s:2:\"20\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";}i:11;a:13:{s:2:\"id\";s:2:\"11\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:10;a:13:{s:2:\"id\";s:2:\"10\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:9;a:13:{s:2:\"id\";s:1:\"9\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}i:8;a:13:{s:2:\"id\";s:1:\"8\";s:4:\"type\";s:1:\"1\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"data\";s:0:\"\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("265", "revslider_checktables", "1", "yes");
INSERT INTO `wp_options` VALUES("266", "rs_tables_created", "1", "yes");
INSERT INTO `wp_options` VALUES("267", "revslider_table_version", "1.0.6", "yes");
INSERT INTO `wp_options` VALUES("268", "revslider-global-settings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("271", "revslider_update_version", "5.2.5.5", "yes");
INSERT INTO `wp_options` VALUES("272", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("273", "vc_version", "5.7", "yes");
INSERT INTO `wp_options` VALUES("283", "nd_options_breadcrumbs_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("284", "nd_options_archive_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("285", "nd_options_comment_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("286", "nd_options_page_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("287", "nd_options_post_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("288", "nd_options_search_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("289", "nd_options_woocommerce_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("290", "nd_options_eventscalendar_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("291", "nd_options_customizer_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("292", "nd_options_locations_enable", "", "yes");
INSERT INTO `wp_options` VALUES("378", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("381", "nd_options_customizer_font_color_h", "#1c1c1c", "yes");
INSERT INTO `wp_options` VALUES("382", "nd_options_customizer_font_color_p", "#878787", "yes");
INSERT INTO `wp_options` VALUES("383", "nd_options_customizer_forms_errors_border_color", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("384", "nd_options_customizer_header_2_bg_responsive", "#151515", "yes");
INSERT INTO `wp_options` VALUES("385", "nd_options_customizer_top_header_2_display_responsive", "1", "yes");
INSERT INTO `wp_options` VALUES("386", "nd_options_customizer_forms_errors_bg", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("387", "nd_options_customizer_forms_ok_bg", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("388", "nd_options_customizer_top_header_2_right_content", "[nd_login bg_color=\'#c19b76\' float=\'right\' href=\'http://localhost/gite-ecuries-abbys/my-account/\'][nd_icon_text icon=\'\' margin=\'16px 20px 16px 10px\'  text=\'Add Your Review\' image=\'\' link=\'http://localhost/gite-ecuries-abbys/my-account/\' float=\'right\'][nd_alert id=\'nd_options_alert_1\' number=\'4\' number-bg-color=\'#c19b76\' margin=\'15px 10px\' float=\'right\'][nd_alert_message href=\'http://www.nicdarkthemes.com/themes/hotel/wp/demo/hotel/search/\' image=\'http://www.nicdarkthemes.com/themes/hotel/wp/demo/hotel/wp-content/uploads/2017/07/img-11.jpg\' title=\'Best Hotel Plugin\' description=\'CHECK FEATURES\'][nd_alert_message href=\'#\' image=\'http://www.nicdarkthemes.com/themes/hotel/wp/demo/hotel/wp-content/uploads/2017/07/img-11.jpg\' title=\'Multi Purpose\' description=\'A LOT OF DEMOS\'][nd_alert_message href=\'#\' image=\'http://www.nicdarkthemes.com/themes/hotel/wp/demo/hotel/wp-content/uploads/2017/07/img-11.jpg\' title=\'No Code Required\' description=\'VERY EASY TO USE\'][/nd_alert][nd_icon_text icon=\'\' margin=\'16px 10px\' text=\'My Bookings\' image=\'\' link=\'http://localhost/gite-ecuries-abbys/my-account/\' float=\'right\']", "yes");
INSERT INTO `wp_options` VALUES("389", "nd_options_customizer_forms_errors_border_width", "0px", "yes");
INSERT INTO `wp_options` VALUES("390", "nd_options_customizer_forms_errors_border_radius", "0px", "yes");
INSERT INTO `wp_options` VALUES("391", "nd_options_customizer_forms_errors_padding", "5px", "yes");
INSERT INTO `wp_options` VALUES("392", "nd_options_customizer_footer_4_left_content", "[nd_icon_text margin=\'20px 20px 0px 0px\' text=\'Home\' font=\'first\' text-color=\'#fff\' link=\'#\' class=\'nd_options_font_size_12\'][nd_icon_text text=\'About Us\' font=\'first\' margin=\'20px 20px 0px 0px\' text-color=\'#fff\' link=\'#\' class=\'nd_options_font_size_12 nd_options_margin_right_20\'][nd_icon_text text=\'Services\' font=\'first\' margin=\'20px 20px 0px 0px\' text-color=\'#fff\' link=\'#\' class=\'nd_options_font_size_12 nd_options_margin_right_20\'][nd_icon_text text=\'Booking\' font=\'first\' margin=\'20px 20px 0px 0px\' text-color=\'#fff\' link=\'#\' class=\'nd_options_font_size_12 nd_options_margin_right_20\'][nd_icon_text text=\'Contact\' font=\'first\' margin=\'20px 20px 0px 0px\' text-color=\'#fff\' link=\'#\' class=\'nd_options_font_size_12 nd_options_margin_right_20\']", "yes");
INSERT INTO `wp_options` VALUES("393", "nd_options_customizer_footer_4_right_content", "[nd_options_image nd_options_align=\'right\' nd_options_image=\'642\' nd_options_width=\'370px\' nd_options_class=\'nd_options_width_100_percentage_all_iphone_important\']", "yes");
INSERT INTO `wp_options` VALUES("394", "nd_options_customizer_footer_4_bg", "#1c1c1c", "yes");
INSERT INTO `wp_options` VALUES("395", "nd_options_customizer_footer_4_border", "#151515", "yes");
INSERT INTO `wp_options` VALUES("396", "nd_options_customizer_footer_4_copyright_bg", "#151515", "yes");
INSERT INTO `wp_options` VALUES("397", "nd_options_customizer_comments_layout", "layout-5", "yes");
INSERT INTO `wp_options` VALUES("398", "nd_options_customizer_forms_errors_text_color", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("399", "nd_options_customizer_font_family_h", "Gilda+Display", "yes");
INSERT INTO `wp_options` VALUES("400", "nd_options_customizer_font_family_p", "Roboto:300,400,700", "yes");
INSERT INTO `wp_options` VALUES("401", "nd_options_customizer_font_family_third", "Gilda+Display", "yes");
INSERT INTO `wp_options` VALUES("402", "nd_options_customizer_header_layout", "header-2", "yes");
INSERT INTO `wp_options` VALUES("403", "nd_options_customizer_header_2_logo", "1215", "yes");
INSERT INTO `wp_options` VALUES("404", "nd_options_customizer_header_2_logo_responsive", "1215", "yes");
INSERT INTO `wp_options` VALUES("405", "nd_options_customizer_header_2_bg", "#1c1c1c", "yes");
INSERT INTO `wp_options` VALUES("406", "nd_options_customizer_header_2_menu_color", "#d1d1d1", "yes");
INSERT INTO `wp_options` VALUES("407", "nd_options_customizer_top_header_2_bg", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("408", "nd_options_customizer_header_2_divider_color", "#1c1c1c", "yes");
INSERT INTO `wp_options` VALUES("409", "nd_options_customizer_footer_layout", "footer-4", "yes");
INSERT INTO `wp_options` VALUES("410", "nd_options_customizer_footer_1_bg", "#1c1c1c", "yes");
INSERT INTO `wp_options` VALUES("411", "nd_options_customizer_footer_1_text_color", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("412", "nd_options_customizer_forms_bg", "#f9f9f9", "yes");
INSERT INTO `wp_options` VALUES("413", "nd_options_customizer_forms_border_color", "#f1f1f1", "yes");
INSERT INTO `wp_options` VALUES("414", "nd_options_customizer_forms_border_width", "1px", "yes");
INSERT INTO `wp_options` VALUES("415", "nd_options_customizer_forms_border_radius", "0px", "yes");
INSERT INTO `wp_options` VALUES("416", "nd_options_customizer_forms_text_color", "#878787", "yes");
INSERT INTO `wp_options` VALUES("417", "nd_options_customizer_forms_padding", "10px 20px", "yes");
INSERT INTO `wp_options` VALUES("418", "nd_options_customizer_page_layout", "layout-5", "yes");
INSERT INTO `wp_options` VALUES("419", "nd_options_customizer_header_2_logo_margin_top", "27", "yes");
INSERT INTO `wp_options` VALUES("420", "nd_options_customizer_forms_submit_bg", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("421", "nd_options_customizer_forms_submit_border_color", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("422", "nd_options_customizer_forms_submit_text_color", "#ffffff", "yes");
INSERT INTO `wp_options` VALUES("423", "nd_options_customizer_forms_submit_border_width", "0px", "yes");
INSERT INTO `wp_options` VALUES("424", "nd_options_customizer_forms_submit_border_radius", "0px", "yes");
INSERT INTO `wp_options` VALUES("425", "nd_options_customizer_forms_submit_padding", "10px 20px", "yes");
INSERT INTO `wp_options` VALUES("426", "nd_options_customizer_archives_archive_layout", "layout-5", "yes");
INSERT INTO `wp_options` VALUES("427", "nd_options_customizer_archives_archive_image", "775", "yes");
INSERT INTO `wp_options` VALUES("428", "nd_options_customizer_archives_archive_image_position", "nd_options_background_position_center", "yes");
INSERT INTO `wp_options` VALUES("429", "nd_options_customizer_archives_search_layout", "layout-5", "yes");
INSERT INTO `wp_options` VALUES("430", "nd_options_customizer_archives_search_image", "775", "yes");
INSERT INTO `wp_options` VALUES("431", "nd_options_customizer_archives_search_image_position", "nd_options_background_position_center", "yes");
INSERT INTO `wp_options` VALUES("432", "nd_options_customizer_top_header_2_left_content", "[nd_icon_text icon=\'\' margin=\'16px 0px\' text=\'Payment Options\' image=\'http://www.nicdarkthemes.com/themes/hotel/wp/demo/hotel/wp-content/uploads/2017/07/icon-1.png\' link=\'http://www.nicdarkthemes.com/themes/hotel/wp/demo/hotel/terms-and-conditions/\' float=\'\'][nd_icon_text icon=\'\' text=\'Terms Conditions\' margin=\'16px 0px\'  image=\'http://www.nicdarkthemes.com/themes/hotel/wp/demo/hotel/wp-content/uploads/2017/07/icon-2.png\' link=\'http://www.nicdarkthemes.com/themes/hotel/wp/demo/hotel/terms-and-conditions/\' float=\'\'][nd_icon_text icon=\'\' text=\'US\' margin=\'16px 0px\' image=\'\' link=\'#\' float=\'\'][nd_icon_text icon=\'\' margin=\'16px 0px\' text=\'IT\' image=\'\' link=\'#\' float=\'\'][nd_icon_text icon=\'\' text=\'ES\' image=\'\' margin=\'16px 0px\' link=\'#\' float=\'\']", "yes");
INSERT INTO `wp_options` VALUES("433", "nd_options_customizer_header_2_sticky", "1", "yes");
INSERT INTO `wp_options` VALUES("434", "nd_options_customizer_post_layout", "layout-5", "yes");
INSERT INTO `wp_options` VALUES("435", "nd_options_customizer_footer_4_columns", "1", "yes");
INSERT INTO `wp_options` VALUES("436", "nd_options_customizer_labels_color_hot", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("437", "nd_options_customizer_labels_color_new", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("438", "nd_options_customizer_labels_color_best", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("439", "rs_cache_overlay", "5.4.8.3", "yes");
INSERT INTO `wp_options` VALUES("483", "nd_booking_booking_request_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("484", "nd_booking_booking_page", "30", "yes");
INSERT INTO `wp_options` VALUES("485", "nd_booking_checkout_page", "32", "yes");
INSERT INTO `wp_options` VALUES("486", "nd_booking_terms_page", "34", "yes");
INSERT INTO `wp_options` VALUES("487", "nd_booking_account_page", "633", "yes");
INSERT INTO `wp_options` VALUES("488", "nd_booking_order_page", "657", "yes");
INSERT INTO `wp_options` VALUES("489", "nd_booking_message_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("490", "nd_booking_paypal_message_checkout", "Insert your content", "yes");
INSERT INTO `wp_options` VALUES("491", "nd_booking_booking_request_message_checkout", "", "yes");
INSERT INTO `wp_options` VALUES("492", "nd_booking_bank_transfer_message_checkout", "Insert your content", "yes");
INSERT INTO `wp_options` VALUES("493", "nd_booking_plugin_dev_mode", "1", "yes");
INSERT INTO `wp_options` VALUES("494", "nd_booking_payment_on_arrive_message_checkout", "Please use details below and pay on arrive", "yes");
INSERT INTO `wp_options` VALUES("495", "nd_booking_paypal_currency", "EUR", "yes");
INSERT INTO `wp_options` VALUES("496", "nd_booking_customizer_plugin_style", "default-style", "yes");
INSERT INTO `wp_options` VALUES("497", "nd_booking_visualcomposer_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("498", "nd_booking_paypal_developer", "", "yes");
INSERT INTO `wp_options` VALUES("499", "nd_booking_search_page", "28", "yes");
INSERT INTO `wp_options` VALUES("500", "nd_booking_currency", "€", "yes");
INSERT INTO `wp_options` VALUES("501", "nd_booking_units_of_measure", "M²", "yes");
INSERT INTO `wp_options` VALUES("502", "nd_booking_customizer_color_dark_1", "#1c1c1c", "yes");
INSERT INTO `wp_options` VALUES("503", "nd_booking_customizer_color_1", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("504", "nd_booking_customizer_color_2", "#c19b76", "yes");
INSERT INTO `wp_options` VALUES("505", "nd_booking_customizer_color_dark_2", "#151515", "yes");
INSERT INTO `wp_options` VALUES("506", "nd_booking_price_range_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("507", "nd_booking_services_filter_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("508", "nd_booking_extra_services_filter_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("509", "nd_booking_packages_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("510", "nd_booking_similar_rooms_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("511", "nd_booking_paypal_enable", "", "yes");
INSERT INTO `wp_options` VALUES("512", "nd_booking_payment_on_arrive_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("528", "w3tc_extensions_hooks", "{\"actions\":[],\"filters\":{\"w3tc_notes\":[\"w3tc_notes_wordpress_seo\"]},\"next_check_date\":1563777079}", "yes");
INSERT INTO `wp_options` VALUES("531", "chld_thm_cfg_options_configvars", "a:40:{s:8:\"addl_css\";N;s:8:\"forcedep\";N;s:8:\"swappath\";N;s:8:\"cssunreg\";N;s:9:\"csswphead\";N;s:10:\"cssnotheme\";N;s:7:\"reorder\";N;s:10:\"parnt_deps\";N;s:10:\"child_deps\";a:1:{i:0;s:13:\"nicdark-style\";}s:9:\"hasstyles\";i:1;s:11:\"parntloaded\";N;s:11:\"childloaded\";s:13:\"nicdark-style\";s:11:\"ignoreparnt\";N;s:9:\"qpriority\";i:10;s:9:\"mpriority\";i:10;s:7:\"enqueue\";s:7:\"enqueue\";s:8:\"handling\";s:7:\"primary\";s:9:\"templates\";a:11:{i:0;s:7:\"404.php\";i:1;s:9:\"index.php\";i:2;s:11:\"archive.php\";i:3;s:12:\"comments.php\";i:4;s:15:\"woocommerce.php\";i:5;s:10:\"search.php\";i:6;s:10:\"header.php\";i:7;s:10:\"footer.php\";i:8;s:10:\"single.php\";i:9;s:8:\"page.php\";i:10;s:11:\"sidebar.php\";}s:7:\"max_sel\";N;s:7:\"imports\";a:2:{s:5:\"child\";a:0:{}s:5:\"parnt\";a:0:{}}s:13:\"child_version\";s:3:\"1.0\";s:12:\"child_author\";s:7:\"Nicdark\";s:10:\"child_name\";s:18:\"HotelBooking Child\";s:14:\"child_themeuri\";s:68:\"https://themeforest.net/collections/2503200-nicdark-wordpress-themes\";s:15:\"child_authoruri\";s:28:\"http://www.nicdarkthemes.com\";s:11:\"child_descr\";s:34:\"Wonderful theme for your Business.\";s:10:\"child_tags\";s:188:\"one-column,two-columns,right-sidebar,custom-header,custom-menu,editor-style,featured-images,microformats,post-formats,rtl-language-support,sticky-post,translation-ready,accessibility-ready\";s:5:\"parnt\";s:12:\"hotelbooking\";s:5:\"child\";s:18:\"hotelbooking-child\";s:10:\"configtype\";s:5:\"theme\";s:6:\"valkey\";i:214;s:7:\"rulekey\";i:64;s:5:\"qskey\";i:534;s:6:\"selkey\";i:517;s:8:\"querykey\";i:7;s:8:\"tokenkey\";N;s:6:\"recent\";N;s:9:\"converted\";i:1;s:5:\"fsize\";i:495;s:7:\"version\";s:5:\"2.5.0\";}", "no");
INSERT INTO `wp_options` VALUES("532", "chld_thm_cfg_options_dict_qs", "a:534:{i:1;s:3:\"1:1\";i:2;s:3:\"1:2\";i:3;s:3:\"1:3\";i:4;s:3:\"1:4\";i:5;s:3:\"1:5\";i:6;s:3:\"1:6\";i:7;s:3:\"1:7\";i:8;s:3:\"1:8\";i:9;s:3:\"1:9\";i:10;s:4:\"1:10\";i:11;s:4:\"1:11\";i:12;s:4:\"1:12\";i:13;s:4:\"1:13\";i:14;s:4:\"1:14\";i:15;s:4:\"1:15\";i:16;s:4:\"2:16\";i:17;s:4:\"2:17\";i:18;s:4:\"2:18\";i:19;s:4:\"2:19\";i:20;s:4:\"2:20\";i:21;s:4:\"2:21\";i:22;s:4:\"2:22\";i:23;s:4:\"2:23\";i:24;s:4:\"2:24\";i:25;s:4:\"2:25\";i:26;s:4:\"2:26\";i:27;s:4:\"2:27\";i:28;s:4:\"2:28\";i:29;s:4:\"2:29\";i:30;s:4:\"2:30\";i:31;s:4:\"2:31\";i:32;s:4:\"2:32\";i:33;s:4:\"2:33\";i:34;s:4:\"2:34\";i:35;s:4:\"2:35\";i:36;s:4:\"2:15\";i:37;s:4:\"2:36\";i:38;s:4:\"2:37\";i:39;s:4:\"2:38\";i:40;s:4:\"2:39\";i:41;s:4:\"3:40\";i:42;s:4:\"3:41\";i:43;s:4:\"4:40\";i:44;s:4:\"4:42\";i:45;s:4:\"4:41\";i:46;s:4:\"5:43\";i:47;s:4:\"5:40\";i:48;s:4:\"5:41\";i:49;s:4:\"6:43\";i:50;s:4:\"6:40\";i:51;s:4:\"6:44\";i:52;s:4:\"6:45\";i:53;s:4:\"6:41\";i:54;s:4:\"7:46\";i:55;s:4:\"7:47\";i:56;s:4:\"7:48\";i:57;s:4:\"7:49\";i:58;s:4:\"7:50\";i:59;s:4:\"7:51\";i:60;s:4:\"7:52\";i:61;s:4:\"7:53\";i:62;s:4:\"7:54\";i:63;s:4:\"7:55\";i:64;s:4:\"7:56\";i:65;s:4:\"7:57\";i:66;s:4:\"7:58\";i:67;s:4:\"7:59\";i:68;s:4:\"7:60\";i:69;s:4:\"7:61\";i:70;s:4:\"7:62\";i:71;s:4:\"7:63\";i:72;s:4:\"7:43\";i:73;s:4:\"7:64\";i:74;s:4:\"7:40\";i:75;s:4:\"7:65\";i:76;s:4:\"7:66\";i:77;s:4:\"7:67\";i:78;s:4:\"7:41\";i:79;s:4:\"7:68\";i:80;s:4:\"7:69\";i:81;s:4:\"7:70\";i:82;s:4:\"7:71\";i:83;s:4:\"7:72\";i:84;s:4:\"7:73\";i:85;s:4:\"7:74\";i:86;s:4:\"7:75\";i:87;s:4:\"7:76\";i:88;s:4:\"7:77\";i:89;s:4:\"7:78\";i:90;s:4:\"7:79\";i:91;s:4:\"7:80\";i:92;s:4:\"7:81\";i:93;s:4:\"7:82\";i:94;s:4:\"7:83\";i:95;s:4:\"7:84\";i:96;s:4:\"7:85\";i:97;s:4:\"7:86\";i:98;s:4:\"7:87\";i:99;s:4:\"7:88\";i:100;s:4:\"7:89\";i:101;s:4:\"7:90\";i:102;s:4:\"7:91\";i:103;s:4:\"7:92\";i:104;s:4:\"7:93\";i:105;s:4:\"7:94\";i:106;s:4:\"7:95\";i:107;s:4:\"7:96\";i:108;s:4:\"7:97\";i:109;s:4:\"7:98\";i:110;s:4:\"7:99\";i:111;s:5:\"7:100\";i:112;s:5:\"7:101\";i:113;s:5:\"7:102\";i:114;s:5:\"7:103\";i:115;s:5:\"7:104\";i:116;s:5:\"7:105\";i:117;s:5:\"7:106\";i:118;s:5:\"7:107\";i:119;s:5:\"7:108\";i:120;s:5:\"7:109\";i:121;s:5:\"7:110\";i:122;s:5:\"7:111\";i:123;s:5:\"7:112\";i:124;s:5:\"7:113\";i:125;s:5:\"7:114\";i:126;s:5:\"7:115\";i:127;s:5:\"7:116\";i:128;s:5:\"7:117\";i:129;s:5:\"7:118\";i:130;s:5:\"7:119\";i:131;s:5:\"7:120\";i:132;s:5:\"7:121\";i:133;s:5:\"7:122\";i:134;s:5:\"7:123\";i:135;s:5:\"7:124\";i:136;s:5:\"7:125\";i:137;s:5:\"7:126\";i:138;s:5:\"7:127\";i:139;s:5:\"7:128\";i:140;s:5:\"7:129\";i:141;s:5:\"7:130\";i:142;s:5:\"7:131\";i:143;s:5:\"7:132\";i:144;s:5:\"7:133\";i:145;s:5:\"7:134\";i:146;s:5:\"7:135\";i:147;s:5:\"7:136\";i:148;s:5:\"7:137\";i:149;s:5:\"7:138\";i:150;s:5:\"7:139\";i:151;s:5:\"7:140\";i:152;s:5:\"7:141\";i:153;s:5:\"7:142\";i:154;s:5:\"7:143\";i:155;s:5:\"7:144\";i:156;s:5:\"7:145\";i:157;s:5:\"7:146\";i:158;s:5:\"7:147\";i:159;s:5:\"7:148\";i:160;s:5:\"7:149\";i:161;s:5:\"7:150\";i:162;s:5:\"7:151\";i:163;s:5:\"7:152\";i:164;s:5:\"7:153\";i:165;s:5:\"7:154\";i:166;s:5:\"7:155\";i:167;s:5:\"7:156\";i:168;s:5:\"7:157\";i:169;s:5:\"7:158\";i:170;s:5:\"7:159\";i:171;s:5:\"7:160\";i:172;s:5:\"7:161\";i:173;s:5:\"7:162\";i:174;s:5:\"7:163\";i:175;s:5:\"7:164\";i:176;s:5:\"7:165\";i:177;s:5:\"7:166\";i:178;s:5:\"7:167\";i:179;s:5:\"7:168\";i:180;s:5:\"7:169\";i:181;s:5:\"7:170\";i:182;s:5:\"7:171\";i:183;s:5:\"7:172\";i:184;s:5:\"7:173\";i:185;s:5:\"7:174\";i:186;s:5:\"7:175\";i:187;s:5:\"7:176\";i:188;s:5:\"7:177\";i:189;s:5:\"7:178\";i:190;s:5:\"7:179\";i:191;s:5:\"7:180\";i:192;s:5:\"7:181\";i:193;s:5:\"7:182\";i:194;s:5:\"7:183\";i:195;s:5:\"7:184\";i:196;s:5:\"7:185\";i:197;s:5:\"7:186\";i:198;s:5:\"7:187\";i:199;s:5:\"7:188\";i:200;s:5:\"7:189\";i:201;s:5:\"7:190\";i:202;s:5:\"7:191\";i:203;s:5:\"7:192\";i:204;s:5:\"7:193\";i:205;s:5:\"7:194\";i:206;s:5:\"7:195\";i:207;s:5:\"7:196\";i:208;s:5:\"7:197\";i:209;s:5:\"7:198\";i:210;s:5:\"7:199\";i:211;s:5:\"7:200\";i:212;s:5:\"7:201\";i:213;s:5:\"7:202\";i:214;s:5:\"7:203\";i:215;s:5:\"7:204\";i:216;s:5:\"7:205\";i:217;s:5:\"7:206\";i:218;s:5:\"7:207\";i:219;s:5:\"7:208\";i:220;s:5:\"7:209\";i:221;s:5:\"7:210\";i:222;s:5:\"7:211\";i:223;s:5:\"7:212\";i:224;s:5:\"7:213\";i:225;s:5:\"7:214\";i:226;s:5:\"7:215\";i:227;s:5:\"7:216\";i:228;s:5:\"7:217\";i:229;s:5:\"7:218\";i:230;s:5:\"7:219\";i:231;s:5:\"7:220\";i:232;s:5:\"7:221\";i:233;s:5:\"7:222\";i:234;s:5:\"7:223\";i:235;s:5:\"7:224\";i:236;s:5:\"7:225\";i:237;s:5:\"7:226\";i:238;s:5:\"7:227\";i:239;s:5:\"7:228\";i:240;s:5:\"7:229\";i:241;s:5:\"7:230\";i:242;s:5:\"7:231\";i:243;s:5:\"7:232\";i:244;s:5:\"7:233\";i:245;s:5:\"7:234\";i:246;s:5:\"7:235\";i:247;s:5:\"7:236\";i:248;s:5:\"7:237\";i:249;s:5:\"7:238\";i:250;s:5:\"7:239\";i:251;s:5:\"7:240\";i:252;s:5:\"7:241\";i:253;s:5:\"7:242\";i:254;s:5:\"7:243\";i:255;s:5:\"7:244\";i:256;s:5:\"7:245\";i:257;s:5:\"7:246\";i:258;s:5:\"7:247\";i:259;s:5:\"7:248\";i:260;s:5:\"7:249\";i:261;s:5:\"7:250\";i:262;s:5:\"7:251\";i:263;s:5:\"7:252\";i:264;s:5:\"7:253\";i:265;s:5:\"7:254\";i:266;s:5:\"7:255\";i:267;s:5:\"7:256\";i:268;s:5:\"7:257\";i:269;s:5:\"7:258\";i:270;s:5:\"7:259\";i:271;s:5:\"7:260\";i:272;s:5:\"7:261\";i:273;s:5:\"7:262\";i:274;s:5:\"7:263\";i:275;s:5:\"7:264\";i:276;s:5:\"7:265\";i:277;s:5:\"7:266\";i:278;s:5:\"7:267\";i:279;s:5:\"7:268\";i:280;s:5:\"7:269\";i:281;s:5:\"7:270\";i:282;s:5:\"7:271\";i:283;s:5:\"7:272\";i:284;s:5:\"7:273\";i:285;s:5:\"7:274\";i:286;s:5:\"7:275\";i:287;s:5:\"7:276\";i:288;s:5:\"7:277\";i:289;s:5:\"7:278\";i:290;s:5:\"7:279\";i:291;s:5:\"7:280\";i:292;s:5:\"7:281\";i:293;s:5:\"7:282\";i:294;s:5:\"7:283\";i:295;s:5:\"7:284\";i:296;s:5:\"7:285\";i:297;s:5:\"7:286\";i:298;s:5:\"7:287\";i:299;s:5:\"7:288\";i:300;s:5:\"7:289\";i:301;s:5:\"7:290\";i:302;s:5:\"7:291\";i:303;s:5:\"7:292\";i:304;s:5:\"7:293\";i:305;s:5:\"7:294\";i:306;s:5:\"7:295\";i:307;s:5:\"7:296\";i:308;s:5:\"7:297\";i:309;s:5:\"7:298\";i:310;s:5:\"7:299\";i:311;s:5:\"7:300\";i:312;s:5:\"7:301\";i:313;s:5:\"7:302\";i:314;s:5:\"7:303\";i:315;s:5:\"7:304\";i:316;s:5:\"7:305\";i:317;s:5:\"7:306\";i:318;s:5:\"7:307\";i:319;s:5:\"7:308\";i:320;s:5:\"7:309\";i:321;s:5:\"7:310\";i:322;s:5:\"7:311\";i:323;s:5:\"7:312\";i:324;s:5:\"7:313\";i:325;s:5:\"7:314\";i:326;s:5:\"7:315\";i:327;s:5:\"7:316\";i:328;s:5:\"7:317\";i:329;s:5:\"7:318\";i:330;s:5:\"7:319\";i:331;s:5:\"7:320\";i:332;s:5:\"7:321\";i:333;s:5:\"7:322\";i:334;s:5:\"7:323\";i:335;s:5:\"7:324\";i:336;s:5:\"7:325\";i:337;s:5:\"7:326\";i:338;s:5:\"7:327\";i:339;s:5:\"7:328\";i:340;s:5:\"7:329\";i:341;s:5:\"7:330\";i:342;s:5:\"7:331\";i:343;s:5:\"7:332\";i:344;s:5:\"7:333\";i:345;s:5:\"7:334\";i:346;s:5:\"7:335\";i:347;s:5:\"7:336\";i:348;s:5:\"7:337\";i:349;s:5:\"7:338\";i:350;s:5:\"7:339\";i:351;s:5:\"7:340\";i:352;s:5:\"7:341\";i:353;s:5:\"7:342\";i:354;s:5:\"7:343\";i:355;s:5:\"7:344\";i:356;s:5:\"7:345\";i:357;s:5:\"7:346\";i:358;s:5:\"7:347\";i:359;s:5:\"7:348\";i:360;s:5:\"7:349\";i:361;s:5:\"7:350\";i:362;s:5:\"7:351\";i:363;s:5:\"7:352\";i:364;s:5:\"7:353\";i:365;s:5:\"7:354\";i:366;s:5:\"7:355\";i:367;s:5:\"7:356\";i:368;s:5:\"7:357\";i:369;s:5:\"7:358\";i:370;s:5:\"7:359\";i:371;s:5:\"7:360\";i:372;s:5:\"7:361\";i:373;s:5:\"7:362\";i:374;s:5:\"7:363\";i:375;s:5:\"7:364\";i:376;s:5:\"7:365\";i:377;s:5:\"7:366\";i:378;s:5:\"7:367\";i:379;s:5:\"7:368\";i:380;s:5:\"7:369\";i:381;s:5:\"7:370\";i:382;s:5:\"7:371\";i:383;s:5:\"7:372\";i:384;s:5:\"7:373\";i:385;s:5:\"7:374\";i:386;s:5:\"7:375\";i:387;s:5:\"7:376\";i:388;s:5:\"7:377\";i:389;s:5:\"7:378\";i:390;s:5:\"7:379\";i:391;s:5:\"7:380\";i:392;s:5:\"7:381\";i:393;s:5:\"7:382\";i:394;s:5:\"7:383\";i:395;s:5:\"7:384\";i:396;s:5:\"7:385\";i:397;s:5:\"7:386\";i:398;s:5:\"7:387\";i:399;s:5:\"7:388\";i:400;s:5:\"7:389\";i:401;s:5:\"7:390\";i:402;s:5:\"7:391\";i:403;s:5:\"7:392\";i:404;s:5:\"7:393\";i:405;s:5:\"7:394\";i:406;s:5:\"7:395\";i:407;s:5:\"7:396\";i:408;s:5:\"7:397\";i:409;s:5:\"7:398\";i:410;s:5:\"7:399\";i:411;s:5:\"7:400\";i:412;s:5:\"7:401\";i:413;s:5:\"7:402\";i:414;s:5:\"7:403\";i:415;s:5:\"7:404\";i:416;s:5:\"7:405\";i:417;s:5:\"7:406\";i:418;s:5:\"7:407\";i:419;s:5:\"7:408\";i:420;s:5:\"7:409\";i:421;s:5:\"7:410\";i:422;s:5:\"7:411\";i:423;s:5:\"7:412\";i:424;s:5:\"7:413\";i:425;s:5:\"7:414\";i:426;s:5:\"7:415\";i:427;s:5:\"7:416\";i:428;s:5:\"7:417\";i:429;s:5:\"7:418\";i:430;s:5:\"7:419\";i:431;s:5:\"7:420\";i:432;s:5:\"7:421\";i:433;s:5:\"7:422\";i:434;s:5:\"7:423\";i:435;s:5:\"7:424\";i:436;s:5:\"7:425\";i:437;s:5:\"7:426\";i:438;s:5:\"7:427\";i:439;s:5:\"7:428\";i:440;s:5:\"7:429\";i:441;s:5:\"7:430\";i:442;s:4:\"7:15\";i:443;s:4:\"7:38\";i:444;s:4:\"7:37\";i:445;s:5:\"7:431\";i:446;s:5:\"7:432\";i:447;s:5:\"7:433\";i:448;s:4:\"7:36\";i:449;s:5:\"7:434\";i:450;s:5:\"7:435\";i:451;s:5:\"7:436\";i:452;s:5:\"7:437\";i:453;s:4:\"7:39\";i:454;s:5:\"7:438\";i:455;s:5:\"7:439\";i:456;s:5:\"7:440\";i:457;s:5:\"7:441\";i:458;s:5:\"7:442\";i:459;s:5:\"7:443\";i:460;s:5:\"7:444\";i:461;s:5:\"7:445\";i:462;s:5:\"7:446\";i:463;s:5:\"7:447\";i:464;s:5:\"7:448\";i:465;s:5:\"7:449\";i:466;s:5:\"7:450\";i:467;s:5:\"7:451\";i:468;s:5:\"7:452\";i:469;s:5:\"7:453\";i:470;s:5:\"7:454\";i:471;s:5:\"7:455\";i:472;s:5:\"7:456\";i:473;s:5:\"7:457\";i:474;s:5:\"7:458\";i:475;s:5:\"7:459\";i:476;s:5:\"7:460\";i:477;s:5:\"7:461\";i:478;s:5:\"7:462\";i:479;s:5:\"7:463\";i:480;s:5:\"7:464\";i:481;s:5:\"7:465\";i:482;s:5:\"7:466\";i:483;s:5:\"7:467\";i:484;s:5:\"7:468\";i:485;s:5:\"7:469\";i:486;s:5:\"7:470\";i:487;s:5:\"7:471\";i:488;s:5:\"7:472\";i:489;s:5:\"7:473\";i:490;s:5:\"7:474\";i:491;s:5:\"7:475\";i:492;s:5:\"7:476\";i:493;s:5:\"7:477\";i:494;s:5:\"7:478\";i:495;s:5:\"7:479\";i:496;s:5:\"7:480\";i:497;s:5:\"7:481\";i:498;s:5:\"7:482\";i:499;s:5:\"7:483\";i:500;s:5:\"7:484\";i:501;s:5:\"7:485\";i:502;s:5:\"7:486\";i:503;s:5:\"7:487\";i:504;s:5:\"7:488\";i:505;s:5:\"7:489\";i:506;s:5:\"7:490\";i:507;s:4:\"7:14\";i:508;s:5:\"7:491\";i:509;s:5:\"7:492\";i:510;s:5:\"7:493\";i:511;s:5:\"7:494\";i:512;s:5:\"7:495\";i:513;s:5:\"7:496\";i:514;s:5:\"7:497\";i:515;s:5:\"7:498\";i:516;s:5:\"7:499\";i:517;s:5:\"7:500\";i:518;s:5:\"7:501\";i:519;s:5:\"7:502\";i:520;s:5:\"7:503\";i:521;s:5:\"7:504\";i:522;s:5:\"7:505\";i:523;s:5:\"7:506\";i:524;s:5:\"7:507\";i:525;s:5:\"7:508\";i:526;s:5:\"7:509\";i:527;s:5:\"7:510\";i:528;s:5:\"7:511\";i:529;s:5:\"7:512\";i:530;s:5:\"7:513\";i:531;s:5:\"7:514\";i:532;s:5:\"7:515\";i:533;s:5:\"7:516\";i:534;s:5:\"7:517\";}", "no");
INSERT INTO `wp_options` VALUES("533", "chld_thm_cfg_options_dict_sel", "a:517:{i:1;s:36:\".nicdark_display_none_all_responsive\";i:2;s:33:\".nicdark_display_block_responsive\";i:3;s:40:\".nicdark_width_100_percentage_responsive\";i:4;s:39:\".nicdark_width_50_percentage_responsive\";i:5;s:37:\".nicdark_text_align_center_responsive\";i:6;s:35:\".nicdark_text_align_left_responsive\";i:7;s:32:\".nicdark_margin_top_5_responsive\";i:8;s:47:\".nicdark_border_top_1_solid_greydark_responsive\";i:9;s:31:\".nicdark_cursor_move_responsive\";i:10;s:32:\".nicdark_font_size_40_responsive\";i:11;s:34:\".nicdark_line_height_40_responsive\";i:12;s:30:\".nicdark_padding_20_responsive\";i:13;s:30:\".nicdark_padding_15_responsive\";i:14;s:33:\".nicdark_comments_ul li .children\";i:15;s:30:\".nicdark_navigation_1 div > ul\";i:16;s:32:\".nicdark_display_none_all_iphone\";i:17;s:33:\".nicdark_display_block_all_iphone\";i:18;s:40:\".nicdark_width_100_percentage_all_iphone\";i:19;s:39:\".nicdark_width_50_percentage_all_iphone\";i:20;s:28:\".nicdark_width_50_all_iphone\";i:21;s:29:\".nicdark_width_250_all_iphone\";i:22;s:37:\".nicdark_text_align_center_all_iphone\";i:23;s:35:\".nicdark_padding_right_0_all_iphone\";i:24;s:34:\".nicdark_padding_left_0_all_iphone\";i:25;s:29:\".nicdark_padding_0_all_iphone\";i:26;s:30:\".nicdark_padding_40_all_iphone\";i:27;s:32:\".nicdark_font_size_40_all_iphone\";i:28;s:32:\".nicdark_font_size_20_all_iphone\";i:29;s:32:\".nicdark_font_size_10_all_iphone\";i:30;s:34:\".nicdark_line_height_40_all_iphone\";i:31;s:34:\".nicdark_line_height_20_all_iphone\";i:32;s:37:\".nicdark_position_relative_all_iphone\";i:33;s:33:\".nicdark_margin_top_20_all_iphone\";i:34;s:32:\".nicdark_margin_top_5_all_iphone\";i:35;s:33:\".nicdark_margin_left_0_all_iphone\";i:36;s:96:\".nicdark_navigation_1 div > ul li > ul.sub-menu, .nicdark_navigation_1 div > ul li > ul.children\";i:37;s:41:\".nicdark_navigation_1 div > ul > li:after\";i:38;s:35:\".nicdark_navigation_1 div > ul > li\";i:39;s:130:\".nicdark_navigation_1 div > ul li > ul.sub-menu li > ul.sub-menu, .nicdark_navigation_1 div > ul li > ul.children li > ul.children\";i:40;s:18:\".nicdark_container\";i:41;s:205:\".nicdark_grid_1, .nicdark_grid_2, .nicdark_grid_3, .nicdark_grid_4, .nicdark_grid_5, .nicdark_grid_6, .nicdark_grid_7, .nicdark_grid_8, .nicdark_grid_9, .nicdark_grid_10, .nicdark_grid_11, .nicdark_grid_12\";i:42;s:39:\".nicdark_width_100_percentage_ipad_port\";i:43;s:4:\"body\";i:44;s:41:\".nicdark_width_100_percentage_iphone_port\";i:45;s:36:\".nicdark_text_align_left_iphone_port\";i:46;s:10:\".alignnone\";i:47;s:29:\".aligncenter, div.aligncenter\";i:48;s:11:\".alignright\";i:49;s:10:\".alignleft\";i:50;s:16:\"a img.alignright\";i:51;s:15:\"a img.alignnone\";i:52;s:15:\"a img.alignleft\";i:53;s:17:\"a img.aligncenter\";i:54;s:13:\".bypostauthor\";i:55;s:11:\".wp-caption\";i:56;s:21:\".wp-caption.alignnone\";i:57;s:21:\".wp-caption.alignleft\";i:58;s:22:\".wp-caption.alignright\";i:59;s:16:\".gallery-caption\";i:60;s:15:\".wp-caption img\";i:61;s:29:\".wp-caption p.wp-caption-text\";i:62;s:19:\".screen-reader-text\";i:63;s:25:\".screen-reader-text:focus\";i:64;s:24:\"#start_nicdark_framework\";i:65;s:23:\".nicdark_clearfix:after\";i:66;s:13:\".nicdark_site\";i:67;s:16:\".nicdark_section\";i:68;s:15:\".nicdark_grid_1\";i:69;s:15:\".nicdark_grid_2\";i:70;s:15:\".nicdark_grid_3\";i:71;s:15:\".nicdark_grid_4\";i:72;s:15:\".nicdark_grid_5\";i:73;s:15:\".nicdark_grid_6\";i:74;s:15:\".nicdark_grid_7\";i:75;s:15:\".nicdark_grid_8\";i:76;s:15:\".nicdark_grid_9\";i:77;s:16:\".nicdark_grid_10\";i:78;s:16:\".nicdark_grid_11\";i:79;s:16:\".nicdark_grid_12\";i:80;s:25:\"p, h1, h2, h3, h4, h5, h6\";i:81;s:86:\"h1, h2, h3, h4, h5, h6, .nicdark_datepicker .ui-datepicker-header .ui-datepicker-title\";i:82;s:54:\"p, input, label, textarea, select, .nicdark_datepicker\";i:83;s:5:\"a img\";i:84;s:1:\"b\";i:85;s:2:\"h1\";i:86;s:2:\"h2\";i:87;s:2:\"h3\";i:88;s:2:\"h4\";i:89;s:2:\"h5\";i:90;s:2:\"h6\";i:91;s:1:\"p\";i:92;s:30:\"input, label, textarea, select\";i:93;s:85:\"h1, h2, h3, h4, h5, h6, .nicdark_first_font, .nicdark_datepicker .ui-datepicker-title\";i:94;s:79:\"p, a, input, label, .nicdark_second_font, .nicdark_datepicker, textarea, select\";i:95;s:19:\".nicdark_third_font\";i:96;s:23:\"input, textarea, select\";i:97;s:5:\"table\";i:98;s:45:\".nicdark_tabs .ui-tabs-active.ui-state-active\";i:99;s:19:\".nicdark_datepicker\";i:100;s:34:\".nicdark_datepicker .ui-datepicker\";i:101;s:41:\".nicdark_datepicker .ui-datepicker-header\";i:102;s:43:\".nicdark_datepicker .ui-datepicker-calendar\";i:103;s:39:\".nicdark_datepicker .ui-datepicker-prev\";i:104;s:39:\".nicdark_datepicker .ui-datepicker-next\";i:105;s:62:\".nicdark_datepicker .ui-datepicker-header .ui-datepicker-title\";i:106;s:46:\".nicdark_datepicker .ui-datepicker-calendar th\";i:107;s:94:\".nicdark_datepicker .ui-datepicker-calendar th, .nicdark_datepicker .ui-datepicker-calendar td\";i:108;s:52:\".nicdark_datepicker .ui-datepicker-unselectable span\";i:109;s:38:\".nicdark_datepicker a.ui-state-default\";i:110;s:26:\".nicdark_text_align_center\";i:111;s:25:\".nicdark_text_align_right\";i:112;s:24:\".nicdark_text_align_left\";i:113;s:33:\".nicdark_text_transform_uppercase\";i:114;s:20:\".nicdark_color_white\";i:115;s:19:\".nicdark_color_grey\";i:116;s:23:\".nicdark_color_greydark\";i:117;s:35:\".nicdark_color_greydark_hover:hover\";i:118;s:21:\".nicdark_color_f1f1f1\";i:119;s:20:\".nicdark_color_green\";i:120;s:32:\".nicdark_color_green_hover:hover\";i:121;s:21:\".nicdark_color_orange\";i:122;s:33:\".nicdark_color_orange_hover:hover\";i:123;s:59:\".nicdark_placeholder_color_white::-webkit-input-placeholder\";i:124;s:50:\".nicdark_placeholder_color_white::-moz-placeholder\";i:125;s:54:\".nicdark_placeholder_color_white:-ms-input-placeholder\";i:126;s:49:\".nicdark_placeholder_color_white:-moz-placeholder\";i:127;s:22:\".nicdark_font_size_100\";i:128;s:21:\".nicdark_font_size_90\";i:129;s:21:\".nicdark_font_size_80\";i:130;s:21:\".nicdark_font_size_70\";i:131;s:21:\".nicdark_font_size_60\";i:132;s:21:\".nicdark_font_size_50\";i:133;s:21:\".nicdark_font_size_40\";i:134;s:21:\".nicdark_font_size_30\";i:135;s:21:\".nicdark_font_size_25\";i:136;s:21:\".nicdark_font_size_20\";i:137;s:21:\".nicdark_font_size_15\";i:138;s:21:\".nicdark_font_size_14\";i:139;s:21:\".nicdark_font_size_13\";i:140;s:21:\".nicdark_font_size_12\";i:141;s:21:\".nicdark_font_size_11\";i:142;s:21:\".nicdark_font_size_10\";i:143;s:20:\".nicdark_font_size_8\";i:144;s:28:\".nicdark_font_weight_lighter\";i:145;s:25:\".nicdark_letter_spacing_2\";i:146;s:25:\".nicdark_letter_spacing_3\";i:147;s:20:\".nicdark_height_1000\";i:148;s:19:\".nicdark_height_600\";i:149;s:19:\".nicdark_height_570\";i:150;s:19:\".nicdark_height_550\";i:151;s:19:\".nicdark_height_500\";i:152;s:19:\".nicdark_height_450\";i:153;s:19:\".nicdark_height_400\";i:154;s:19:\".nicdark_height_300\";i:155;s:19:\".nicdark_height_250\";i:156;s:19:\".nicdark_height_200\";i:157;s:19:\".nicdark_height_150\";i:158;s:19:\".nicdark_height_100\";i:159;s:18:\".nicdark_height_90\";i:160;s:18:\".nicdark_height_80\";i:161;s:18:\".nicdark_height_70\";i:162;s:18:\".nicdark_height_60\";i:163;s:18:\".nicdark_height_55\";i:164;s:18:\".nicdark_height_50\";i:165;s:18:\".nicdark_height_40\";i:166;s:18:\".nicdark_height_33\";i:167;s:18:\".nicdark_height_30\";i:168;s:18:\".nicdark_height_25\";i:169;s:18:\".nicdark_height_20\";i:170;s:18:\".nicdark_height_15\";i:171;s:18:\".nicdark_height_13\";i:172;s:18:\".nicdark_height_10\";i:173;s:17:\".nicdark_height_5\";i:174;s:17:\".nicdark_height_3\";i:175;s:17:\".nicdark_height_2\";i:176;s:17:\".nicdark_height_1\";i:177;s:20:\".nicdark_height_auto\";i:178;s:30:\".nicdark_height_100_percentage\";i:179;s:22:\".nicdark_line_height_5\";i:180;s:23:\".nicdark_line_height_16\";i:181;s:23:\".nicdark_line_height_17\";i:182;s:23:\".nicdark_line_height_18\";i:183;s:23:\".nicdark_line_height_20\";i:184;s:23:\".nicdark_line_height_25\";i:185;s:23:\".nicdark_line_height_31\";i:186;s:23:\".nicdark_line_height_30\";i:187;s:23:\".nicdark_line_height_35\";i:188;s:23:\".nicdark_line_height_50\";i:189;s:18:\".nicdark_width_700\";i:190;s:18:\".nicdark_width_300\";i:191;s:18:\".nicdark_width_200\";i:192;s:18:\".nicdark_width_170\";i:193;s:18:\".nicdark_width_150\";i:194;s:18:\".nicdark_width_100\";i:195;s:17:\".nicdark_width_90\";i:196;s:17:\".nicdark_width_70\";i:197;s:17:\".nicdark_width_60\";i:198;s:17:\".nicdark_width_55\";i:199;s:17:\".nicdark_width_33\";i:200;s:29:\".nicdark_width_30_hover:hover\";i:201;s:17:\".nicdark_width_25\";i:202;s:16:\".nicdark_width_5\";i:203;s:29:\".nicdark_width_100_percentage\";i:204;s:28:\".nicdark_width_85_percentage\";i:205;s:28:\".nicdark_width_80_percentage\";i:206;s:28:\".nicdark_width_75_percentage\";i:207;s:28:\".nicdark_width_70_percentage\";i:208;s:28:\".nicdark_width_66_percentage\";i:209;s:28:\".nicdark_width_65_percentage\";i:210;s:28:\".nicdark_width_60_percentage\";i:211;s:28:\".nicdark_width_55_percentage\";i:212;s:28:\".nicdark_width_50_percentage\";i:213;s:28:\".nicdark_width_35_percentage\";i:214;s:28:\".nicdark_width_33_percentage\";i:215;s:28:\".nicdark_width_40_percentage\";i:216;s:28:\".nicdark_width_30_percentage\";i:217;s:28:\".nicdark_width_25_percentage\";i:218;s:28:\".nicdark_width_20_percentage\";i:219;s:28:\".nicdark_width_15_percentage\";i:220;s:28:\".nicdark_width_10_percentage\";i:221;s:27:\".nicdark_width_5_percentage\";i:222;s:17:\".nicdark_bg_white\";i:223;s:29:\".nicdark_bg_white_hover:hover\";i:224;s:16:\".nicdark_bg_blue\";i:225;s:17:\".nicdark_bg_green\";i:226;s:29:\".nicdark_bg_green_hover:hover\";i:227;s:16:\".nicdark_bg_grey\";i:228;s:18:\".nicdark_bg_grey_2\";i:229;s:18:\".nicdark_bg_grey_3\";i:230;s:20:\".nicdark_bg_greydark\";i:231;s:32:\".nicdark_bg_greydark_hover:hover\";i:232;s:18:\".nicdark_bg_orange\";i:233;s:15:\".nicdark_bg_red\";i:234;s:18:\".nicdark_bg_yellow\";i:235;s:22:\".nicdark_bg_orangedark\";i:236;s:22:\".nicdark_bg_blue_alpha\";i:237;s:23:\".nicdark_bg_green_alpha\";i:238;s:26:\".nicdark_bg_greydark_alpha\";i:239;s:28:\".nicdark_bg_greydark_alpha_4\";i:240;s:28:\".nicdark_bg_greydark_alpha_6\";i:241;s:28:\".nicdark_bg_greydark_alpha_8\";i:242;s:28:\".nicdark_bg_greydark_alpha_9\";i:243;s:24:\".nicdark_background_none\";i:244;s:36:\".nicdark_background_none_hover:hover\";i:245;s:35:\".nicdark_bg_greydark_alpha_gradient\";i:246;s:37:\".nicdark_bg_greydark_alpha_gradient_2\";i:247;s:37:\".nicdark_bg_greydark_alpha_gradient_3\";i:248;s:37:\".nicdark_bg_greydark_alpha_gradient_4\";i:249;s:37:\".nicdark_bg_greydark_alpha_gradient_5\";i:250;s:33:\".nicdark_bg_gradient_red_to_green\";i:251;s:22:\".nicdark_filter_blur_5\";i:252;s:17:\".nicdark_margin_0\";i:253;s:17:\".nicdark_margin_5\";i:254;s:18:\".nicdark_margin_10\";i:255;s:18:\".nicdark_margin_15\";i:256;s:18:\".nicdark_margin_20\";i:257;s:25:\".nicdark_margin_bottom_20\";i:258;s:25:\".nicdark_margin_bottom_10\";i:259;s:22:\".nicdark_margin_top_50\";i:260;s:22:\".nicdark_margin_top_40\";i:261;s:22:\".nicdark_margin_top_20\";i:262;s:22:\".nicdark_margin_top_13\";i:263;s:22:\".nicdark_margin_top_10\";i:264;s:21:\".nicdark_margin_top_5\";i:265;s:21:\".nicdark_margin_top_2\";i:266;s:23:\".nicdark_margin_right_5\";i:267;s:24:\".nicdark_margin_right_10\";i:268;s:24:\".nicdark_margin_right_20\";i:269;s:24:\".nicdark_margin_right_40\";i:270;s:24:\".nicdark_margin_right_50\";i:271;s:24:\".nicdark_margin_right_60\";i:272;s:22:\".nicdark_margin_left_0\";i:273;s:22:\".nicdark_margin_left_5\";i:274;s:23:\".nicdark_margin_left_10\";i:275;s:23:\".nicdark_margin_left_15\";i:276;s:23:\".nicdark_margin_left_20\";i:277;s:23:\".nicdark_margin_left_40\";i:278;s:23:\".nicdark_margin_left_80\";i:279;s:23:\".nicdark_margin_left_60\";i:280;s:23:\".nicdark_margin_left_70\";i:281;s:24:\".nicdark_margin_left_120\";i:282;s:24:\".nicdark_margin_left_200\";i:283;s:24:\".nicdark_margin_left_220\";i:284;s:24:\".nicdark_margin_left_240\";i:285;s:32:\".nicdark_margin_left_negative_15\";i:286;s:34:\".nicdark_margin_bottom_negative_15\";i:287;s:35:\".nicdark_margin_bottom_100_negative\";i:288;s:35:\".nicdark_margin_bottom_105_negative\";i:289;s:31:\".nicdark_margin_top_negative_30\";i:290;s:32:\".nicdark_margin_top_negative_225\";i:291;s:32:\".nicdark_margin_top_negative_300\";i:292;s:18:\".nicdark_padding_0\";i:293;s:18:\".nicdark_padding_5\";i:294;s:21:\".nicdark_padding_5_10\";i:295;s:18:\".nicdark_padding_8\";i:296;s:21:\".nicdark_padding_8_20\";i:297;s:19:\".nicdark_padding_10\";i:298;s:22:\".nicdark_padding_10_20\";i:299;s:22:\".nicdark_padding_20_10\";i:300;s:22:\".nicdark_padding_13_10\";i:301;s:19:\".nicdark_padding_13\";i:302;s:19:\".nicdark_padding_15\";i:303;s:22:\".nicdark_padding_15_35\";i:304;s:19:\".nicdark_padding_20\";i:305;s:19:\".nicdark_padding_28\";i:306;s:22:\".nicdark_padding_20_50\";i:307;s:22:\".nicdark_padding_20_25\";i:308;s:19:\".nicdark_padding_30\";i:309;s:19:\".nicdark_padding_40\";i:310;s:22:\".nicdark_padding_40_20\";i:311;s:19:\".nicdark_padding_50\";i:312;s:19:\".nicdark_padding_60\";i:313;s:19:\".nicdark_padding_80\";i:314;s:19:\".nicdark_padding_90\";i:315;s:20:\".nicdark_padding_100\";i:316;s:21:\".nicdark_padding_1020\";i:317;s:20:\".nicdark_padding_510\";i:318;s:26:\".nicdark_padding_botttom_0\";i:319;s:26:\".nicdark_padding_botttom_5\";i:320;s:27:\".nicdark_padding_botttom_10\";i:321;s:22:\".nicdark_padding_top_0\";i:322;s:23:\".nicdark_padding_top_10\";i:323;s:25:\".nicdark_padding_left_220\";i:324;s:25:\".nicdark_padding_left_120\";i:325;s:25:\".nicdark_padding_left_100\";i:326;s:24:\".nicdark_padding_left_90\";i:327;s:24:\".nicdark_padding_left_80\";i:328;s:24:\".nicdark_padding_left_70\";i:329;s:24:\".nicdark_padding_left_50\";i:330;s:24:\".nicdark_padding_left_45\";i:331;s:24:\".nicdark_padding_left_40\";i:332;s:24:\".nicdark_padding_left_25\";i:333;s:24:\".nicdark_padding_left_20\";i:334;s:24:\".nicdark_padding_left_10\";i:335;s:23:\".nicdark_padding_left_5\";i:336;s:23:\".nicdark_padding_left_0\";i:337;s:24:\".nicdark_padding_right_0\";i:338;s:24:\".nicdark_padding_right_5\";i:339;s:25:\".nicdark_padding_right_10\";i:340;s:25:\".nicdark_padding_right_20\";i:341;s:25:\".nicdark_padding_right_40\";i:342;s:24:\".nicdark_border_radius_3\";i:343;s:25:\".nicdark_border_radius_15\";i:344;s:25:\".nicdark_border_radius_25\";i:345;s:25:\".nicdark_border_radius_50\";i:346;s:37:\".nicdark_border_radius_100_percentage\";i:347;s:23:\".nicdark_border_width_2\";i:348;s:17:\".nicdark_border_0\";i:349;s:29:\".nicdark_border_1_solid_white\";i:350;s:29:\".nicdark_border_2_solid_white\";i:351;s:41:\".nicdark_border_2_solid_white_hover:hover\";i:352;s:28:\".nicdark_border_1_solid_grey\";i:353;s:30:\".nicdark_border_1_solid_grey_2\";i:354;s:29:\".nicdark_border_3_solid_white\";i:355;s:29:\".nicdark_border_3_dashed_grey\";i:356;s:29:\".nicdark_border_1_solid_green\";i:357;s:41:\".nicdark_border_1_solid_green_hover:hover\";i:358;s:29:\".nicdark_border_2_solid_green\";i:359;s:30:\".nicdark_border_1_solid_orange\";i:360;s:27:\".nicdark_border_top_width_0\";i:361;s:32:\".nicdark_border_top_1_solid_grey\";i:362;s:36:\".nicdark_border_top_1_solid_greydark\";i:363;s:32:\".nicdark_border_top_2_solid_grey\";i:364;s:30:\".nicdark_border_bottom_width_0\";i:365;s:30:\".nicdark_border_bottom_width_2\";i:366;s:35:\".nicdark_border_bottom_1_solid_grey\";i:367;s:35:\".nicdark_border_bottom_2_solid_grey\";i:368;s:40:\".nicdark_border_bottom_2_solid_greendark\";i:369;s:36:\".nicdark_border_bottom_4_solid_white\";i:370;s:36:\".nicdark_border_bottom_3_solid_white\";i:371;s:39:\".nicdark_border_bottom_1_solid_greydark\";i:372;s:28:\".nicdark_border_left_width_0\";i:373;s:29:\".nicdark_border_right_width_0\";i:374;s:30:\".nicdark_box_sizing_border_box\";i:375;s:24:\".nicdark_list_style_none\";i:376;s:23:\".nicdark_display_inline\";i:377;s:29:\".nicdark_display_inline_block\";i:378;s:22:\".nicdark_display_block\";i:379;s:21:\".nicdark_display_none\";i:380;s:22:\".nicdark_display_table\";i:381;s:27:\".nicdark_display_table_cell\";i:382;s:30:\".nicdark_vertical_align_middle\";i:383;s:27:\".nicdark_vertical_align_top\";i:384;s:30:\".nicdark_vertical_align_bottom\";i:385;s:19:\".nicdark_float_left\";i:386;s:20:\".nicdark_float_right\";i:387;s:30:\".nicdark_background_size_cover\";i:388;s:27:\".nicdark_background_size_25\";i:389;s:35:\".nicdark_background_position_center\";i:390;s:42:\".nicdark_background_position_center_bottom\";i:391;s:39:\".nicdark_background_position_center_top\";i:392;s:36:\".nicdark_background_repeat_no_repeat\";i:393;s:26:\".nicdark_position_absolute\";i:394;s:26:\".nicdark_position_relative\";i:395;s:23:\".nicdark_position_fixed\";i:396;s:27:\".nicdark_right_300_negative\";i:397;s:16:\".nicdark_right_0\";i:398;s:17:\".nicdark_right_20\";i:399;s:15:\".nicdark_left_0\";i:400;s:16:\".nicdark_left_10\";i:401;s:16:\".nicdark_left_15\";i:402;s:25:\".nicdark_left_65_negative\";i:403;s:14:\".nicdark_top_0\";i:404;s:14:\".nicdark_top_5\";i:405;s:24:\".nicdark_top_40_negative\";i:406;s:24:\".nicdark_top_10_negative\";i:407;s:23:\".nicdark_top_5_negative\";i:408;s:23:\".nicdark_top_3_negative\";i:409;s:15:\".nicdark_top_10\";i:410;s:15:\".nicdark_top_17\";i:411;s:15:\".nicdark_top_20\";i:412;s:18:\".nicdark_bottom_20\";i:413;s:18:\".nicdark_bottom_30\";i:414;s:27:\".nicdark_bottom_35_negative\";i:415;s:24:\".nicdark_overflow_hidden\";i:416;s:24:\".nicdark_overflow_x_auto\";i:417;s:24:\".nicdark_overflow_y_auto\";i:418;s:20:\".nicdark_cursor_move\";i:419;s:23:\".nicdark_cursor_pointer\";i:420;s:24:\".nicdark_cursor_zoom_out\";i:421;s:18:\".nicdark_outline_0\";i:422;s:27:\".nicdark_z_index_1_negative\";i:423;s:18:\".nicdark_z_index_9\";i:424;s:19:\".nicdark_z_index_99\";i:425;s:20:\".nicdark_z_index_999\";i:426;s:31:\".nicdark_transition_all_08_ease\";i:427;s:18:\".nicdark_opacity_0\";i:428;s:19:\".nicdark_opacity_07\";i:429;s:31:\".nicdark_opacity_05_hover:hover\";i:430;s:29:\".nicdark_zoom_1_1_hover:hover\";i:431;s:52:\".nicdark_navigation_1 div > ul > li:last-child:after\";i:432;s:30:\".nicdark_navigation_1 div li a\";i:433;s:108:\".nicdark_navigation_1 div > ul li:hover > ul.sub-menu, .nicdark_navigation_1 div > ul li:hover > ul.children\";i:434;s:106:\".nicdark_navigation_1 div > ul li > ul.sub-menu > li, .nicdark_navigation_1 div > ul li > ul.children > li\";i:435;s:118:\".nicdark_navigation_1 div > ul li > ul.sub-menu > li:hover, .nicdark_navigation_1 div > ul li > ul.children > li:hover\";i:436;s:128:\".nicdark_navigation_1 div > ul li > ul.sub-menu > li:last-child, .nicdark_navigation_1 div > ul li > ul.children > li:last-child\";i:437;s:106:\".nicdark_navigation_1 div > ul li > ul.sub-menu li a, .nicdark_navigation_1 div > ul li > ul.children li a\";i:438;s:38:\".nicdark_navigation_1_sidebar div > ul\";i:439;s:43:\".nicdark_navigation_1_sidebar div > ul > li\";i:440;s:38:\".nicdark_navigation_1_sidebar div li a\";i:441;s:40:\".nicdark_navigation_1_sidebar div li > a\";i:442;s:54:\".nicdark_navigation_1_sidebar div li > a::first-letter\";i:443;s:112:\".nicdark_navigation_1_sidebar div > ul li > ul.sub-menu, .nicdark_navigation_1_sidebar div > ul li > ul.children\";i:444;s:122:\".nicdark_navigation_1_sidebar div > ul li > ul.sub-menu > li, .nicdark_navigation_1_sidebar div > ul li > ul.children > li\";i:445;s:122:\".nicdark_navigation_1_sidebar div > ul li > ul.sub-menu li a, .nicdark_navigation_1_sidebar div > ul li > ul.children li a\";i:446;s:26:\".nicdark_image_archive img\";i:447;s:57:\"#start_nicdark_framework.home #nicdark_header_img_archive\";i:448;s:33:\".navigation.pagination .nav-links\";i:449;s:47:\".navigation.pagination .nav-links .page-numbers\";i:450;s:55:\".navigation.pagination .nav-links .page-numbers.current\";i:451;s:24:\".nicdark_sidebar .widget\";i:452;s:61:\".nicdark_sidebar .widget img, .nicdark_sidebar .widget select\";i:453;s:27:\".nicdark_sidebar .widget h3\";i:454;s:38:\".nicdark_sidebar .widget.widget_search\";i:455;s:57:\".nicdark_sidebar .widget.widget_search input[type=\"text\"]\";i:456;s:52:\".nicdark_sidebar .widget.widget_search #searchsubmit\";i:457;s:27:\".nicdark_sidebar .widget ul\";i:458;s:34:\".nicdark_sidebar .widget > ul > li\";i:459;s:45:\".nicdark_sidebar .widget > ul > li:last-child\";i:460;s:30:\".nicdark_sidebar .widget ul li\";i:461;s:36:\".nicdark_sidebar .widget ul.children\";i:462;s:47:\".nicdark_sidebar .widget ul.children:last-child\";i:463;s:46:\".nicdark_sidebar .widget.widget_calendar table\";i:464;s:52:\".nicdark_sidebar .widget.widget_calendar table thead\";i:465;s:49:\".nicdark_sidebar .widget.widget_calendar table th\";i:466;s:49:\".nicdark_sidebar .widget.widget_calendar table td\";i:467;s:57:\".nicdark_sidebar .widget.widget_calendar table tbody td a\";i:468;s:57:\".nicdark_sidebar .widget.widget_calendar table tfoot td a\";i:469;s:55:\".nicdark_sidebar .widget.widget_calendar table tfoot td\";i:470;s:60:\".nicdark_sidebar .widget.widget_calendar table tfoot td#prev\";i:471;s:60:\".nicdark_sidebar .widget.widget_calendar table tfoot td#next\";i:472;s:54:\".nicdark_sidebar .widget.widget_calendar table caption\";i:473;s:31:\".nicdark_sidebar .widget div ul\";i:474;s:38:\".nicdark_sidebar .widget div > ul > li\";i:475;s:49:\".nicdark_sidebar .widget div > ul > li:last-child\";i:476;s:34:\".nicdark_sidebar .widget div ul li\";i:477;s:40:\".nicdark_sidebar .widget div ul.sub-menu\";i:478;s:51:\".nicdark_sidebar .widget div ul.sub-menu:last-child\";i:479;s:43:\".nicdark_sidebar .widget.widget_tag_cloud a\";i:480;s:31:\".sticky .nicdark_bg_btn_archive\";i:481;s:24:\"#nicdark_bg_date_archive\";i:482;s:18:\"#nicdark_tags_list\";i:483;s:20:\"#nicdark_tags_list a\";i:484;s:24:\"#nicdark_categories_list\";i:485;s:27:\"#nicdark_categories_list ul\";i:486;s:30:\"#nicdark_categories_list ul li\";i:487;s:19:\"#nicdark_link_pages\";i:488;s:21:\"#nicdark_link_pages a\";i:489;s:20:\".nicdark_comments_ul\";i:490;s:23:\".nicdark_comments_ul li\";i:491;s:51:\".nicdark_comments_ul li .reply a.comment-reply-link\";i:492;s:90:\".nicdark_comments_ul li .comment-author .fn, .nicdark_comments_ul li .comment-author .fn a\";i:493;s:43:\".nicdark_comments_ul li .comment-author img\";i:494;s:39:\".nicdark_comments_ul li .comment-author\";i:495;s:43:\".nicdark_comments_ul li .comment-author .fn\";i:496;s:45:\".nicdark_comments_ul li .comment-author .says\";i:497;s:94:\"#nicdark_comments_form h3.comment-reply-title, #respond.comment-respond h3.comment-reply-title\";i:498;s:47:\"#respond.comment-respond h3.comment-reply-title\";i:499;s:104:\"#nicdark_comments_form label, #nicdark_comments_form input[type=\'text\'], #nicdark_comments_form textarea\";i:500;s:43:\"#nicdark_comments_form input[type=\'submit\']\";i:501;s:24:\"#nicdark_comments_form p\";i:502;s:113:\"#commentform.comment-form label, #commentform.comment-form input[type=\'text\'], #commentform.comment-form textarea\";i:503;s:46:\"#commentform.comment-form input[type=\'submit\']\";i:504;s:27:\"#commentform.comment-form p\";i:505;s:639:\".nicdark_container_page_php p, .nicdark_container_page_php h1, .nicdark_container_page_php h2, .nicdark_container_page_php h3, .nicdark_container_page_php h4, .nicdark_container_page_php h5, .nicdark_container_page_php h6, .nicdark_container_single_php p, .nicdark_container_single_php h1, .nicdark_container_single_php h2, .nicdark_container_single_php h3, .nicdark_container_single_php h4, .nicdark_container_single_php h5, .nicdark_container_single_php h6, .nicdark_comments_php p, .nicdark_comments_php h1, .nicdark_comments_php h2, .nicdark_comments_php h3, .nicdark_comments_php h4, .nicdark_comments_php h5, .nicdark_comments_php h6\";i:506;s:62:\".nicdark_container_page_php a, .nicdark_container_single_php a\";i:507;s:114:\".nicdark_comments_php blockquote, .nicdark_container_page_php blockquote, .nicdark_container_single_php blockquote\";i:508;s:129:\".nicdark_comments_php blockquote cite, .nicdark_container_page_php blockquote cite, .nicdark_container_single_php blockquote cite\";i:509;s:99:\".nicdark_comments_php table, .nicdark_container_page_php table, .nicdark_container_single_php table\";i:510;s:218:\".nicdark_comments_php table td, .nicdark_comments_php table th, .nicdark_container_page_php table td, .nicdark_container_page_php table th, .nicdark_container_single_php table td, .nicdark_container_single_php table th\";i:511;s:108:\".nicdark_comments_php table th, .nicdark_container_page_php table th, .nicdark_container_single_php table th\";i:512;s:274:\".nicdark_comments_php dl, .nicdark_comments_php dt, .nicdark_comments_php dd, .nicdark_container_page_php dl, .nicdark_container_page_php dt, .nicdark_container_page_php dd, .nicdark_container_single_php dl, .nicdark_container_single_php dt, .nicdark_container_single_php dd\";i:513;s:90:\".nicdark_comments_php dt, .nicdark_container_page_php dt, .nicdark_container_single_php dt\";i:514;s:90:\".nicdark_comments_php dd, .nicdark_container_page_php dd, .nicdark_container_single_php dd\";i:515;s:93:\".nicdark_comments_php ins, .nicdark_container_page_php ins, .nicdark_container_single_php ins\";i:516;s:93:\".nicdark_comments_php pre, .nicdark_container_page_php pre, .nicdark_container_single_php pre\";i:517;s:197:\".nicdark_container_page_php img, .nicdark_container_single_php img, .nicdark_container_page_php iframe, .nicdark_container_single_php iframe, .nicdark_comments_php img, .nicdark_comments_php iframe\";}", "no");
INSERT INTO `wp_options` VALUES("534", "chld_thm_cfg_options_dict_query", "a:7:{i:1;s:65:\"@media only screen and (min-width: 320px) and (max-width: 1199px)\";i:2;s:64:\"@media only screen and (min-width: 320px) and (max-width: 767px)\";i:3;s:65:\"@media only screen and (min-width: 960px) and (max-width: 1199px)\";i:4;s:64:\"@media only screen and (min-width: 768px) and (max-width: 959px)\";i:5;s:64:\"@media only screen and (min-width: 480px) and (max-width: 767px)\";i:6;s:64:\"@media only screen and (min-width: 320px) and (max-width: 479px)\";i:7;s:4:\"base\";}", "no");
INSERT INTO `wp_options` VALUES("535", "chld_thm_cfg_options_dict_rule", "a:64:{i:1;s:7:\"display\";i:2;s:5:\"width\";i:3;s:10:\"text-align\";i:4;s:10:\"margin-top\";i:5;s:10:\"border-top\";i:6;s:6:\"cursor\";i:7;s:9:\"font-size\";i:8;s:11:\"line-height\";i:9;s:11:\"padding-top\";i:10;s:13:\"padding-right\";i:11;s:14:\"padding-bottom\";i:12;s:12:\"padding-left\";i:13;s:12:\"margin-right\";i:14;s:13:\"margin-bottom\";i:15;s:11:\"margin-left\";i:16;s:10:\"list-style\";i:17;s:8:\"position\";i:18;s:4:\"left\";i:19;s:3:\"top\";i:20;s:24:\"-webkit-text-size-adjust\";i:21;s:5:\"float\";i:22;s:12:\"border-width\";i:23;s:16:\"background-color\";i:24;s:6:\"border\";i:25;s:9:\"max-width\";i:26;s:6:\"height\";i:27;s:4:\"clip\";i:28;s:8:\"overflow\";i:29;s:13:\"border-radius\";i:30;s:10:\"box-shadow\";i:31;s:5:\"color\";i:32;s:11:\"font-weight\";i:33;s:15:\"text-decoration\";i:34;s:7:\"z-index\";i:35;s:14:\"letter-spacing\";i:36;s:11:\"font-family\";i:37;s:10:\"overflow-x\";i:38;s:7:\"content\";i:39;s:5:\"clear\";i:40;s:10:\"visibility\";i:41;s:10:\"transition\";i:42;s:10:\"box-sizing\";i:43;s:7:\"outline\";i:44;s:15:\"border-collapse\";i:45;s:13:\"border-bottom\";i:46;s:14:\"text-transform\";i:47;s:16:\"background-image\";i:48;s:6:\"filter\";i:49;s:14:\"-webkit-filter\";i:50;s:16:\"border-top-width\";i:51;s:19:\"border-bottom-width\";i:52;s:17:\"border-left-width\";i:53;s:18:\"border-right-width\";i:54;s:14:\"vertical-align\";i:55;s:15:\"background-size\";i:56;s:19:\"background-position\";i:57;s:17:\"background-repeat\";i:58;s:5:\"right\";i:59;s:6:\"bottom\";i:60;s:10:\"overflow-y\";i:61;s:7:\"opacity\";i:62;s:4:\"zoom\";i:63;s:10:\"font-style\";i:64;s:11:\"border-left\";}", "no");
INSERT INTO `wp_options` VALUES("536", "chld_thm_cfg_options_dict_val", "a:214:{i:1;s:4:\"none\";i:2;s:5:\"block\";i:3;s:4:\"100%\";i:4;s:3:\"50%\";i:5;s:6:\"center\";i:6;s:4:\"left\";i:7;s:3:\"5px\";i:8;s:17:\"1px solid #595959\";i:9;s:4:\"move\";i:10;s:4:\"40px\";i:11;s:4:\"20px\";i:12;s:4:\"15px\";i:13;s:1:\"0\";i:14;s:4:\"10px\";i:15;s:4:\"50px\";i:16;s:5:\"250px\";i:17;s:8:\"relative\";i:18;s:5:\"-85px\";i:19;s:4:\"60px\";i:20;s:5:\"960px\";i:21;s:5:\"748px\";i:22;s:5:\"460px\";i:23;s:5:\"300px\";i:24;s:4:\"auto\";i:25;s:5:\"right\";i:26;s:4:\"#fff\";i:27;s:17:\"1px solid #f0f0f0\";i:28;s:3:\"96%\";i:29;s:3:\"3px\";i:30;s:6:\"0 none\";i:31;s:5:\"98.5%\";i:32;s:4:\"11px\";i:33;s:4:\"17px\";i:34;s:3:\"4px\";i:35;s:24:\"rect(1px, 1px, 1px, 1px)\";i:36;s:8:\"absolute\";i:37;s:3:\"1px\";i:38;s:6:\"hidden\";i:39;s:7:\"#f1f1f1\";i:40;s:30:\"0 0 2px 2px rgba(0, 0, 0, 0.6)\";i:41;s:7:\"#21759b\";i:42;s:4:\"14px\";i:43;s:8:\"0.875rem\";i:44;s:4:\"bold\";i:45;s:6:\"normal\";i:46;s:4:\"23px\";i:47;s:6:\"100000\";i:48;s:7:\"lighter\";i:49;s:7:\"#a3a3a3\";i:50;s:4:\"27px\";i:51;s:20:\"\'Roboto\', sans-serif\";i:52;s:6:\"1200px\";i:53;s:2:\"\"\"\";i:54;s:4:\"both\";i:55;s:13:\"all 0.8s ease\";i:56;s:6:\"inline\";i:57;s:10:\"border-box\";i:58;s:5:\"8.33%\";i:59;s:6:\"16.66%\";i:60;s:3:\"25%\";i:61;s:6:\"33.33%\";i:62;s:6:\"41.66%\";i:63;s:6:\"58.33%\";i:64;s:6:\"66.66%\";i:65;s:3:\"75%\";i:66;s:6:\"83.33%\";i:67;s:6:\"91.66%\";i:68;s:7:\"#1c1c1c\";i:69;s:7:\"#878787\";i:70;s:6:\"bolder\";i:71;s:4:\"30px\";i:72;s:4:\"25px\";i:73;s:4:\"13px\";i:74;s:27:\"\'Gilda Display\', sans-serif\";i:75;s:18:\"\'Hind\', sans-serif\";i:76;s:7:\"#f9f9f9\";i:77;s:17:\"1px solid #f1f1f1\";i:78;s:8:\"collapse\";i:79;s:15:\"0 2px 0 #c19b76\";i:80;s:12:\"inline-table\";i:81;s:3:\"95%\";i:82;s:7:\"#727475\";i:83;s:7:\"#c19b76\";i:84;s:9:\"uppercase\";i:85;s:7:\"#efc94c\";i:86;s:5:\"100px\";i:87;s:4:\"90px\";i:88;s:4:\"80px\";i:89;s:4:\"70px\";i:90;s:4:\"45px\";i:91;s:4:\"12px\";i:92;s:3:\"8px\";i:93;s:3:\"2px\";i:94;s:6:\"1000px\";i:95;s:5:\"600px\";i:96;s:5:\"570px\";i:97;s:5:\"550px\";i:98;s:5:\"500px\";i:99;s:5:\"450px\";i:100;s:5:\"400px\";i:101;s:5:\"200px\";i:102;s:5:\"150px\";i:103;s:4:\"55px\";i:104;s:4:\"33px\";i:105;s:4:\"16px\";i:106;s:4:\"18px\";i:107;s:4:\"31px\";i:108;s:4:\"35px\";i:109;s:5:\"700px\";i:110;s:5:\"170px\";i:111;s:3:\"85%\";i:112;s:3:\"80%\";i:113;s:3:\"70%\";i:114;s:3:\"65%\";i:115;s:3:\"60%\";i:116;s:3:\"55%\";i:117;s:3:\"35%\";i:118;s:3:\"40%\";i:119;s:3:\"30%\";i:120;s:3:\"20%\";i:121;s:3:\"15%\";i:122;s:3:\"10%\";i:123;s:2:\"5%\";i:124;s:7:\"#e4e4e4\";i:125;s:7:\"#c17676\";i:126;s:7:\"#ffda44\";i:127;s:7:\"#c4aa87\";i:128;s:25:\"rgba(138, 198, 208, 0.75)\";i:129;s:25:\"rgba(112, 193, 144, 0.95)\";i:130;s:23:\"rgba(101, 100, 96, 0.3)\";i:131;s:23:\"rgba(101, 100, 96, 0.4)\";i:132;s:23:\"rgba(101, 100, 96, 0.6)\";i:133;s:23:\"rgba(101, 100, 96, 0.8)\";i:134;s:23:\"rgba(101, 100, 96, 0.9)\";i:135;s:102:\"-moz-linear-gradient(top, rgba(101,100,96,0) 0%, rgba(101,100,96,0.1) 60%, rgba(101,100,96,0.65) 100%)\";i:136;s:103:\"-webkit-linear-gradient(top, rgba(101,100,96,0) 0%,rgba(101,100,96,0.1) 60%,rgba(101,100,96,0.65) 100%)\";i:137;s:101:\"linear-gradient(to bottom, rgba(101,100,96,0) 0%,rgba(101,100,96,0.1) 60%,rgba(101,100,96,0.65) 100%)\";i:138;s:125:\"-moz-linear-gradient(top, rgba(101,100,96,0.8) 0%, rgba(101,100,96,0) 35%, rgba(101,100,96,0) 45%, rgba(101,100,96,0.8) 100%)\";i:139;s:125:\"-webkit-linear-gradient(top, rgba(101,100,96,0.8) 0%,rgba(101,100,96,0) 35%,rgba(101,100,96,0) 45%,rgba(101,100,96,0.8) 100%)\";i:140;s:123:\"linear-gradient(to bottom, rgba(101,100,96,0.8) 0%,rgba(101,100,96,0) 35%,rgba(101,100,96,0) 45%,rgba(101,100,96,0.8) 100%)\";i:141;s:52:\"top:rgba(101,100,96,0):0%:rgba(101,100,96,0.65):100%\";i:142;s:102:\"-moz-linear-gradient(top, rgba(101,100,96,0.65) 0%, rgba(101,100,96,0.1) 60%, rgba(101,100,96,0) 100%)\";i:143;s:103:\"-webkit-linear-gradient(top, rgba(101,100,96,0.65) 0%,rgba(101,100,96,0.1) 60%,rgba(101,100,96,0) 100%)\";i:144;s:101:\"linear-gradient(to bottom, rgba(101,100,96,0.65) 0%,rgba(101,100,96,0.1) 60%,rgba(101,100,96,0) 100%)\";i:145;s:101:\"-moz-linear-gradient(top, rgba(101,100,96,0.6) 0%, rgba(101,100,96,0.6) 75%, rgba(101,100,96,0) 100%)\";i:146;s:102:\"-webkit-linear-gradient(top, rgba(101,100,96,0.6) 0%,rgba(101,100,96,0.6) 75%,rgba(101,100,96,0) 100%)\";i:147;s:100:\"linear-gradient(to bottom, rgba(101,100,96,0.6) 0%,rgba(101,100,96,0.6) 75%,rgba(101,100,96,0) 100%)\";i:148;s:16:\"rgb(204,133,133)\";i:149;s:126:\"-moz-linear-gradient(left, rgba(204,133,133,1) 0%, rgba(204,133,133,1) 61%, rgba(104,183,140,1) 82%, rgba(104,183,140,1) 100%)\";i:150;s:126:\"-webkit-linear-gradient(left, rgba(204,133,133,1) 0%,rgba(204,133,133,1) 61%,rgba(104,183,140,1) 82%,rgba(104,183,140,1) 100%)\";i:151;s:122:\"linear-gradient(to right, rgba(204,133,133,1) 0%,rgba(204,133,133,1) 61%,rgba(104,183,140,1) 82%,rgba(104,183,140,1) 100%)\";i:152;s:9:\"blur(5px)\";i:153;s:5:\"120px\";i:154;s:5:\"220px\";i:155;s:5:\"240px\";i:156;s:5:\"-15px\";i:157;s:6:\"-100px\";i:158;s:6:\"-105px\";i:159;s:5:\"-30px\";i:160;s:6:\"-225px\";i:161;s:6:\"-300px\";i:162;s:4:\"28px\";i:163;s:12:\"0 solid #fff\";i:164;s:14:\"1px solid #fff\";i:165;s:14:\"2px solid #fff\";i:166;s:17:\"1px solid #a3a3a3\";i:167;s:14:\"3px solid #fff\";i:168;s:18:\"3px dashed #f1f1f1\";i:169;s:17:\"1px solid #c19b76\";i:170;s:17:\"2px solid #c19b76\";i:171;s:17:\"1px solid #efc94c\";i:172;s:17:\"2px solid #f1f1f1\";i:173;s:17:\"2px solid #64ab84\";i:174;s:14:\"4px solid #fff\";i:175;s:12:\"inline-block\";i:176;s:5:\"table\";i:177;s:10:\"table-cell\";i:178;s:6:\"middle\";i:179;s:3:\"top\";i:180;s:6:\"bottom\";i:181;s:5:\"cover\";i:182;s:13:\"center center\";i:183;s:13:\"center bottom\";i:184;s:10:\"center top\";i:185;s:9:\"no-repeat\";i:186;s:5:\"fixed\";i:187;s:5:\"-65px\";i:188;s:5:\"-40px\";i:189;s:5:\"-10px\";i:190;s:4:\"-5px\";i:191;s:4:\"-3px\";i:192;s:5:\"-35px\";i:193;s:7:\"pointer\";i:194;s:8:\"zoom-out\";i:195;s:2:\"-1\";i:196;s:1:\"9\";i:197;s:2:\"99\";i:198;s:3:\"999\";i:199;s:3:\"0.7\";i:200;s:3:\"0.5\";i:201;s:3:\"1.1\";i:202;s:7:\"#5a5a5a\";i:203;s:8:\"\'Roboto\'\";i:204;s:5:\"-20px\";i:205;s:17:\"0 2px 5px #f1f1f1\";i:206;s:12:\"0 solid #000\";i:207;s:7:\"initial\";i:208;s:9:\"lowercase\";i:209;s:15:\"0 solid #f1f1f1\";i:210;s:4:\"#444\";i:211;s:15:\"\'Gilda Display\'\";i:212;s:9:\"underline\";i:213;s:6:\"scroll\";i:214;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("537", "chld_thm_cfg_options_dict_seq", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("538", "chld_thm_cfg_options_dict_token", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("539", "chld_thm_cfg_options_val_ndx", "a:533:{i:1;s:12:\"VE=hT?GUZA$A\";i:2;s:12:\"VE=hT?GUpA$A\";i:3;s:12:\"EH=hT?GU5A$A\";i:4;s:12:\"EH=hT?GU/A$A\";i:5;s:13:\">J=hT?GU~AlBA\";i:6;s:13:\">J=hT?GUOBlBA\";i:7;s:13:\"9M=hT?GUeBlBA\";i:8;s:13:\"sP=hT?GUuBlBA\";i:9;s:13:\"bS=hT?GU!BlBA\";i:10;s:13:\"KV=hT?GU>BlBA\";i:11;s:13:\"_X=hT?GU>BlBA\";i:12;s:46:\"+a=hT?GUDClB#L.4Fxs@CA|e=hT?GUDClB,L.4Fxs@CABA\";i:13;s:46:\"+a=hT?GUTClB#L.4Fx}MDA|e=hT?GUTClB,L.4Fx}MDABA\";i:14;s:100:\"*M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUzClB#L.4Fx~5DA|e=hT?GUzClB,L.4Fx~5DACt=hT?GUZA$A\";i:15;s:13:\">J=hT?GU~AlBA\";i:16;s:12:\"VE=hT?GUZA$A\";i:17;s:12:\"VE=hT?GUpA$A\";i:18;s:12:\"EH=hT?GU5A$A\";i:19;s:12:\"EH=hT?GU/A$A\";i:20;s:13:\"EH=hT?GU(ClBA\";i:21;s:13:\"EH=hT?GU^ClBA\";i:22;s:13:\">J=hT?GU~AlBA\";i:23;s:13:\"yd=hT?GUjClBA\";i:24;s:13:\"Qj=hT?GUjClBA\";i:25;s:46:\"+a=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDABA\";i:26;s:46:\"+a=hT?GU>BlB#L.4Fx~5CA|e=hT?GU>BlB,L.4Fx~5CABA\";i:27;s:13:\"KV=hT?GU>BlBA\";i:28;s:13:\"KV=hT?GUDClBA\";i:29;s:13:\"KV=hT?GUzClBA\";i:30;s:13:\"_X=hT?GU>BlBA\";i:31;s:13:\"_X=hT?GUDClBA\";i:32;s:13:\"Wx=hT?GUIDlBA\";i:33;s:13:\"9M=hT?GUDClBA\";i:34;s:13:\"9M=hT?GUeBlBA\";i:35;s:13:\"4r=hT?GUjClBA\";i:36;s:12:\"VE=hT?GUZA$A\";i:37;s:24:\"5r=hT?GUYDlBEM.4Fx}MBABA\";i:38;s:12:\"VE=hT?GUZA$A\";i:39;s:12:\"VE=hT?GUpA$A\";i:40;s:46:\"7r=hT?GUYDlBEM.4Fx}MBAq1=hT?GUjClB7L.4Fxs@EABA\";i:41;s:13:\"EH=hT?GU4DlBA\";i:42;s:12:\"EH=hT?GU5A$A\";i:43;s:13:\"EH=hT?GU.DlBA\";i:44;s:12:\"EH=hT?GU5A$A\";i:45;s:12:\"EH=hT?GU5A$A\";i:46;s:12:\"!5=hT?GUZA$A\";i:47;s:13:\"EH=hT?GU}DlBA\";i:48;s:12:\"EH=hT?GU5A$A\";i:49;s:12:\"!5=hT?GUZA$A\";i:50;s:13:\"EH=hT?GUNElBA\";i:51;s:12:\"EH=hT?GU5A$A\";i:52;s:13:\">J=hT?GUOBlBA\";i:53;s:12:\"EH=hT?GU5A$A\";i:54;s:46:\"$M=hT?GUeBlB;L.4Fxs@CAkn=hT?GUDClB^L.4FxrjDABA\";i:55;s:56:\"ZE=hT?GUpA$A>CSOYM5qBtaS_Q3nE3OC$A}CSOYM5qBtJV_Q3nE3OC$A\";i:56;s:57:\"x8=hT?GUtElBnL.4Fxs@BA1k=hT?GUjClB?L.4Fxs@CATq=hT?GUDClBA\";i:57;s:57:\"x8=hT?GUOBlBnL.4Fxs@BA1k=hT?GUDClB?L.4Fxs@CATq=hT?GUjClBA\";i:58;s:57:\"x8=hT?GUtElBnL.4Fxs@BA1k=hT?GUjClB?L.4Fxs@CATq=hT?GUDClBA\";i:59;s:46:\"$M=hT?GUeBlB;L.4Fxs@CAkn=hT?GUDClB^L.4FxrjDABA\";i:60;s:57:\"x8=hT?GUOBlBnL.4Fxs@BA1k=hT?GUDClB?L.4Fxs@CATq=hT?GUjClBA\";i:61;s:34:\"XE=hT?GUpA$A~CSOYMXwCtaS_Q3nE3OC$A\";i:62;s:13:\"c#=hT?GUjClBA\";i:63;s:90:\"S&=hT?GU9ElBcM.4Fxs@GAf+=hT?GUCFlB7L.4Fxs@BANc=hT?GUSFlB(L.4Fx~5DA+h=hT?GUSFlBjL.4FxrjBABA\";i:64;s:46:\"$M=hT?GUeBlB;L.4Fxs@CAkn=hT?GUDClB^L.4FxrjDABA\";i:65;s:46:\"$M=hT?GUeBlB;L.4Fxs@CAkn=hT?GUDClB^L.4FxrjDABA\";i:66;s:46:\"$M=hT?GUeBlB;L.4FxrjDAkn=hT?GUDClB^L.4Fxs@CABA\";i:67;s:13:\"c#=hT?GUjClBA\";i:68;s:134:\"F*=hT?GUiFlBkM.4Fx}MGAYL=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAf+=hT?GUyFlB7L.4FxrjDANc=hT?GUjClB(L.4FxrjDA+h=hT?GUjClBfL.4Fx}MGABA\";i:69;s:112:\"TV=hT?GU&FlB3L.4FxrjIAYL=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4Fx~5IA|e=hT?GUeBlB,L.4Fx~5IABA\";i:70;s:57:\"m==hT?GUXGlBAM.4Fx}M/AO/=hT?GU3GlBfL.4FxrjJA,>=hT?GU,GlBA\";i:71;s:217:\"oCR*,\",ub@;b5FKyLvSQ[zNAz(kt,ub@wc5F*xLvSQ[zHD3(/\",ub@Vd5FRtLvSQ[zCA:>ht,uj@`d5F>+VAEA>hT?GU<HlBkM.4Fx}MGA7y=hT?GUeBlB3L.4FxrjLAeZ=hT?GUTClB#L.4Fx~5LA|e=hT?GUsHlB,L.4Fx~5LA;C>hT?GUZA$ACDSOYM5qBt:C_Q3nE3OC$ARDSOYM6|DtA\";i:72;s:111:\"+M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDAD\"_Q3nE3YE$ASDSOYMifDtA\";i:73;s:57:\"9}=hT?GU%IlBzL.4Fx~5KAvW=hT?GU[IlB<M.4Fxs@MAHO>hT?GU,GlBA\";i:74;s:101:\"MH=hT?GUWJlBnL.4Fx}MGA1k=hT?GUdElB?L.4Fx}MGATq=hT?GUdElB7L.4FxrjDANc=hT?GUjClB(L.4FxrjDA+h=hT?GUjClBA\";i:75;s:57:\"fS>hT?GUmJlBbL.4Fx~5AAO/=hT?GUjClB}M.4Fx~5NAvW>hT?GU,GlBA\";i:76;s:35:\"v8=hT?GUOBlBfL.4Fxs@AAeZ>hT?GU+JlBA\";i:77;s:23:\"FH=hT?GU5A$AEDSOYMAlBtA\";i:78;s:79:\"/a=hT?GUTClB#L.4Fx}MDA|e=hT?GUTClB,L.4Fx}MDAI7=hT?GUOBlBbL.4Fx}MOANc>hT?GULKlBA\";i:79;s:13:\"EH=hT?GUbKlBA\";i:80;s:13:\"EH=hT?GUrKlBA\";i:81;s:13:\"EH=hT?GU7KlBA\";i:82;s:13:\"EH=hT?GU;KlBA\";i:83;s:13:\"EH=hT?GUALlBA\";i:84;s:12:\"EH=hT?GU/A$A\";i:85;s:13:\"EH=hT?GUQLlBA\";i:86;s:13:\"EH=hT?GUgLlBA\";i:87;s:13:\"EH=hT?GUwLlBA\";i:88;s:13:\"EH=hT?GU$LlBA\";i:89;s:13:\"EH=hT?GU@LlBA\";i:90;s:12:\"EH=hT?GU5A$A\";i:91;s:90:\")M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDABA\";i:92;s:13:\"5}=hT?GUFMlBA\";i:93;s:13:\"5}=hT?GUVMlBA\";i:94;s:13:\"`)=hT?GUjClBA\";i:95;s:13:\"mB>hT?GUlMlBA\";i:96;s:24:\"LV=hT?GU1MlB3L.4Fxs@RABA\";i:97;s:24:\"LV=hT?GU*MlB3L.4Fx}MSABA\";i:98;s:24:\"LV=hT?GUDClB3L.4Fxs@CABA\";i:99;s:24:\"LV=hT?GU]FlB3L.4FxrjIABA\";i:100;s:24:\"LV=hT?GUTClB3L.4Fx}MDABA\";i:101;s:24:\"LV=hT?GU`MlB3L.4FxrjSABA\";i:102;s:24:\"LV=hT?GUsHlB3L.4Fx~5MABA\";i:103;s:13:\"KV=hT?GUTClBA\";i:104;s:13:\"9M>hT?GUKNlBA\";i:105;s:13:\"9M>hT?GUGJlBA\";i:106;s:13:\"9M>hT?GUaNlBA\";i:107;s:90:\"S&=hT?GUqNlBNN.4FxrjDAw(=hT?GU6NlB7L.4Fx~5DANc=hT?GUDClB(L.4Fx~5DA+h=hT?GUDClBJN.4FxrjOABA\";i:108;s:13:\"Qj>hT?GU:NlBA\";i:109;s:13:\":`=hT?GU\"NlBA\";i:110;s:35:\"v8=hT?GUOBlBfL.4Fxs@AApI=hT?GU~AlBA\";i:111;s:24:\"u8=hT?GUOBlBfL.4Fxs@AABA\";i:112;s:24:\"u8=hT?GUOBlBfL.4Fxs@AABA\";i:113;s:50:\"YE=hT?GUPOlBfL.4FxrjUAYL=hT?IUTClB~/BA$T_Q3nE3JB$A\";i:114;s:12:\"VE=hT?GUZA$A\";i:115;s:12:\"VE=hT?GUZA$A\";i:116;s:89:\"S&=hT?GUqNlB7L.4Fxs@CANc=hT?GUDClB(L.4Fxs@CA+h=hT?GUDClBzL.4Fxs@CAD\"_Q3nE3SG$AcDSOYMj<FtA\";i:117;s:13:\"5}=hT?GUvOlBA\";i:118;s:46:\"+a=hT?GUzClB#L.4Fxs@BA|e=hT?GUzClB,L.4Fxs@BABA\";i:119;s:13:\"L&=hT?GU9ElBA\";i:120;s:79:\"R&=hT?GU#OlB4M.4Fx~5GAeZ=hT?GUeBlB#L.4Fxs@BA|e=hT?GUeBlB,L.4Fxs@BA2[=hT?GUjClBA\";i:121;s:13:\">J=hT?GU~AlBA\";i:122;s:13:\">J=hT?GUtElBA\";i:123;s:13:\">J=hT?GUOBlBA\";i:124;s:13:\"/o>hT?GU?OlBA\";i:125;s:13:\"5}=hT?GU9ElBA\";i:126;s:13:\"5}=hT?GUVMlBA\";i:127;s:13:\"5}=hT?GUFMlBA\";i:128;s:13:\"5}=hT?GUFMlBA\";i:129;s:13:\"5}=hT?GU|GlBA\";i:130;s:13:\"5}=hT?GU#OlBA\";i:131;s:13:\"5}=hT?GU#OlBA\";i:132;s:13:\"5}=hT?GUEPlBA\";i:133;s:13:\"5}=hT?GUEPlBA\";i:134;s:13:\"5}=hT?GU9ElBA\";i:135;s:13:\"5}=hT?GU9ElBA\";i:136;s:13:\"5}=hT?GU9ElBA\";i:137;s:13:\"5}=hT?GU9ElBA\";i:138;s:24:\"LV=hT?GUUPlB3L.4Fx~5VABA\";i:139;s:24:\"LV=hT?GUkPlB3L.4Fxs@VABA\";i:140;s:24:\"LV=hT?GU0PlB3L.4Fx}MWABA\";i:141;s:24:\"LV=hT?GU)PlB3L.4FxrjWABA\";i:142;s:24:\"LV=hT?GUoDlB3L.4Fxs@EABA\";i:143;s:24:\"LV=hT?GU(ClB3L.4Fxs@DABA\";i:144;s:24:\"LV=hT?GU>BlB3L.4Fx~5WABA\";i:145;s:24:\"LV=hT?GU1MlB3L.4Fxs@RABA\";i:146;s:24:\"LV=hT?GU*MlB3L.4Fx}MSABA\";i:147;s:24:\"LV=hT?GUDClB3L.4Fxs@CABA\";i:148;s:24:\"LV=hT?GUTClB3L.4Fx}MDABA\";i:149;s:24:\"LV=hT?GUsHlB3L.4Fx~5KABA\";i:150;s:24:\"LV=hT?GU`MlB3L.4FxrjSABA\";i:151;s:24:\"LV=hT?GUJQlB3L.4Fxs@WABA\";i:152;s:24:\"LV=hT?GU&FlB3L.4Fxs@WABA\";i:153;s:24:\"LV=hT?GUzClB3L.4Fx~5DABA\";i:154;s:24:\"LV=hT?GUZQlB3L.4Fx}MXABA\";i:155;s:13:\"mB>hT?GUxIlBA\";i:156;s:13:\">J>hT?GUpQlBA\";i:157;s:13:\">J>hT?GUSFlBA\";i:158;s:13:\"z:=hT?GU5QlBA\";i:159;s:13:\"z:=hT?GU/QlBA\";i:160;s:13:\"z:=hT?GU~QlBA\";i:161;s:13:\"z:=hT?GUORlBA\";i:162;s:13:\"z:=hT?GUeRlBA\";i:163;s:13:\"z:=hT?GUuRlBA\";i:164;s:13:\"z:=hT?GU!RlBA\";i:165;s:13:\"z:=hT?GUNElBA\";i:166;s:13:\"z:=hT?GU^ClBA\";i:167;s:13:\"z:=hT?GU>RlBA\";i:168;s:13:\"z:=hT?GUDSlBA\";i:169;s:13:\"z:=hT?GUUPlBA\";i:170;s:13:\"z:=hT?GUkPlBA\";i:171;s:13:\"z:=hT?GU0PlBA\";i:172;s:13:\"z:=hT?GU)PlBA\";i:173;s:13:\"z:=hT?GUoDlBA\";i:174;s:13:\"z:=hT?GUTSlBA\";i:175;s:13:\"z:=hT?GU(ClBA\";i:176;s:13:\"z:=hT?GU>BlBA\";i:177;s:13:\"z:=hT?GUjSlBA\";i:178;s:13:\"z:=hT?GU1MlBA\";i:179;s:13:\"z:=hT?GU*MlBA\";i:180;s:13:\"z:=hT?GUDClBA\";i:181;s:13:\"z:=hT?GUTClBA\";i:182;s:13:\"z:=hT?GU`MlBA\";i:183;s:13:\"z:=hT?GUzClBA\";i:184;s:13:\"z:=hT?GUeBlBA\";i:185;s:13:\"z:=hT?GUSFlBA\";i:186;s:13:\"z:=hT?GUpQlBA\";i:187;s:13:\"z:=hT?GU3GlBA\";i:188;s:13:\"z:=hT?GUdElBA\";i:189;s:12:\"z:=hT?GU5A$A\";i:190;s:13:\"_X=hT?GUeBlBA\";i:191;s:13:\"_X=hT?GUzSlBA\";i:192;s:13:\"_X=hT?GU]FlBA\";i:193;s:13:\"_X=hT?GU(SlBA\";i:194;s:13:\"_X=hT?GUDClBA\";i:195;s:13:\"_X=hT?GU*MlBA\";i:196;s:13:\"_X=hT?GU^SlBA\";i:197;s:13:\"_X=hT?GU1MlBA\";i:198;s:13:\"_X=hT?GUITlBA\";i:199;s:13:\"_X=hT?GU(ClBA\";i:200;s:13:\"EH=hT?GUYTlBA\";i:201;s:13:\"EH=hT?GUNElBA\";i:202;s:13:\"EH=hT?GU>RlBA\";i:203;s:13:\"EH=hT?GUoTlBA\";i:204;s:13:\"EH=hT?GUDSlBA\";i:205;s:13:\"EH=hT?GUUPlBA\";i:206;s:13:\"EH=hT?GUkPlBA\";i:207;s:13:\"EH=hT?GU)PlBA\";i:208;s:13:\"EH=hT?GUoDlBA\";i:209;s:13:\"EH=hT?GUTSlBA\";i:210;s:13:\"EH=hT?GUjSlBA\";i:211;s:13:\"EH=hT?GU1MlBA\";i:212;s:13:\"EH=hT?GU*MlBA\";i:213;s:13:\"EH=hT?GUeBlBA\";i:214;s:12:\"EH=hT?GU5A$A\";i:215;s:13:\"EH=hT?GU4TlBA\";i:216;s:13:\"EH=hT?GU.TlBA\";i:217;s:13:\"EH=hT?GUwLlBA\";i:218;s:13:\"EH=hT?GU}TlBA\";i:219;s:13:\"EH=hT?GUgLlBA\";i:220;s:13:\"EH=hT?GUNUlBA\";i:221;s:13:\"EH=hT?GUdUlBA\";i:222;s:13:\"EH=hT?GUtUlBA\";i:223;s:12:\"EH=hT?GU/A$A\";i:224;s:13:\"EH=hT?GU9UlBA\";i:225;s:13:\"EH=hT?GU;KlBA\";i:226;s:13:\"EH=hT?GU=UlBA\";i:227;s:13:\"EH=hT?GUCVlBA\";i:228;s:13:\"EH=hT?GU7KlBA\";i:229;s:13:\"EH=hT?GUSVlBA\";i:230;s:13:\"EH=hT?GUiVlBA\";i:231;s:13:\"EH=hT?GUyVlBA\";i:232;s:13:\"EH=hT?GU&VlBA\";i:233;s:13:\"L&=hT?GU9ElBA\";i:234;s:13:\"L&=hT?GU9ElBA\";i:235;s:13:\"L&=hT?GU#OlBA\";i:236;s:13:\"L&=hT?GU#OlBA\";i:237;s:13:\"L&=hT?GU#OlBA\";i:238;s:13:\"L&=hT?GUqNlBA\";i:239;s:13:\"L&=hT?GU%IlBA\";i:240;s:13:\"L&=hT?GU]VlBA\";i:241;s:13:\"L&=hT?GUFMlBA\";i:242;s:13:\"L&=hT?GUFMlBA\";i:243;s:13:\"L&=hT?GU#OlBA\";i:244;s:13:\"L&=hT?GUHWlBA\";i:245;s:13:\"L&=hT?GUXWlBA\";i:246;s:13:\"L&=hT?GUnWlBA\";i:247;s:14:\"L&=hT?GU}j$ACA\";i:248;s:14:\"L&=hT?GU~@$ACA\";i:249;s:14:\"L&=hT?GU}j%ACA\";i:250;s:14:\"L&=hT?GU~@%ACA\";i:251;s:14:\"L&=hT?GU}j&ACA\";i:252;s:14:\"L&=hT?GU~@&ACA\";i:253;s:14:\"L&=hT?GU}j(ACA\";i:254;s:12:\"4r>hT?GUZA$A\";i:255;s:12:\"4r>hT?GUZA$A\";i:256;s:26:\"4r>hT?KU~@(A]Q}j)A_Q~@)AGA\";i:257;s:26:\"4r>hT?KU}j*A]Q~@*A_Q}j+AGA\";i:258;s:14:\"4r>hT?GU~@+ACA\";i:259;s:26:\"4r>hT?KU}j,A]Q~@,A_Q}j.AGA\";i:260;s:26:\"4r>hT?KU~@.A]Q}j/A_Q~@/AGA\";i:261;s:38:\"M&=hT?GU}j:Am_%(k)Vo`,6B3(=1cDht!R9GFB\";i:262;s:26:\"ou>hT?GU}j<A7F&(k)No`,9BIA\";i:263;s:46:\"$M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDABA\";i:264;s:46:\"$M=hT?GUeBlB;L.4Fxs@BAkn=hT?GUeBlB^L.4Fxs@BABA\";i:265;s:46:\"$M=hT?GUzClB;L.4Fx~5DAkn=hT?GUzClB^L.4Fx~5DABA\";i:266;s:46:\"$M=hT?GUTClB;L.4Fx}MDAkn=hT?GUTClB^L.4Fx}MDABA\";i:267;s:46:\"$M=hT?GUDClB;L.4Fxs@CAkn=hT?GUDClB^L.4Fxs@CABA\";i:268;s:13:\"/o=hT?GUDClBA\";i:269;s:13:\"/o=hT?GUzClBA\";i:270;s:13:\"9M=hT?GU(ClBA\";i:271;s:13:\"9M=hT?GU>BlBA\";i:272;s:13:\"9M=hT?GUDClBA\";i:273;s:13:\"9M=hT?GU`MlBA\";i:274;s:13:\"9M=hT?GUzClBA\";i:275;s:13:\"9M=hT?GUeBlBA\";i:276;s:13:\"9M=hT?GUpQlBA\";i:277;s:13:\"\"l=hT?GUeBlBA\";i:278;s:13:\"\"l=hT?GUzClBA\";i:279;s:13:\"\"l=hT?GUDClBA\";i:280;s:13:\"\"l=hT?GU>BlBA\";i:281;s:13:\"\"l=hT?GU(ClBA\";i:282;s:13:\"\"l=hT?GUoDlBA\";i:283;s:13:\"4r=hT?GUjClBA\";i:284;s:13:\"4r=hT?GUeBlBA\";i:285;s:13:\"4r=hT?GUzClBA\";i:286;s:13:\"4r=hT?GUTClBA\";i:287;s:13:\"4r=hT?GUDClBA\";i:288;s:13:\"4r=hT?GU>BlBA\";i:289;s:13:\"4r=hT?GU0PlBA\";i:290;s:13:\"4r=hT?GUoDlBA\";i:291;s:13:\"4r=hT?GU)PlBA\";i:292;s:14:\"4r=hT?GU~@<ACA\";i:293;s:13:\"4r=hT?GU>RlBA\";i:294;s:14:\"4r=hT?GU}j=ACA\";i:295;s:14:\"4r=hT?GU~@=ACA\";i:296;s:14:\"4r=hT?GU}j>ACA\";i:297;s:14:\"/o=hT?GU}j>ACA\";i:298;s:14:\"/o=hT?GU~@>ACA\";i:299;s:14:\"/o=hT?GU}j?ACA\";i:300;s:14:\"9M=hT?GU~@?ACA\";i:301;s:14:\"9M=hT?GU}j@ACA\";i:302;s:14:\"9M=hT?GU~@@ACA\";i:303;s:46:\"+a=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDABA\";i:304;s:46:\"+a=hT?GUeBlB#L.4Fxs@BA|e=hT?GUeBlB,L.4Fxs@BABA\";i:305;s:46:\"+a=hT?GUeBlB#L.4Fx~5DA|e=hT?GUeBlB,L.4Fx~5DABA\";i:306;s:46:\"+a=hT?GUZQlB#L.4Fx}MXA|e=hT?GUZQlB,L.4Fx}MXABA\";i:307;s:46:\"+a=hT?GUZQlB#L.4Fxs@CA|e=hT?GUZQlB,L.4Fxs@CABA\";i:308;s:46:\"+a=hT?GUzClB#L.4Fx~5DA|e=hT?GUzClB,L.4Fx~5DABA\";i:309;s:46:\"+a=hT?GUzClB#L.4Fxs@CA|e=hT?GUzClB,L.4Fxs@CABA\";i:310;s:46:\"+a=hT?GUDClB#L.4Fx~5DA|e=hT?GUDClB,L.4Fx~5DABA\";i:311;s:46:\"+a=hT?GU`MlB#L.4Fx~5DA|e=hT?GU`MlB,L.4Fx~5DABA\";i:312;s:46:\"+a=hT?GU`MlB#L.4FxrjSA|e=hT?GU`MlB,L.4FxrjSABA\";i:313;s:46:\"+a=hT?GUTClB#L.4Fx}MDA|e=hT?GUTClB,L.4Fx}MDABA\";i:314;s:46:\"+a=hT?GUTClB#L.4Fx}MbA|e=hT?GUTClB,L.4Fx}MbABA\";i:315;s:46:\"+a=hT?GUDClB#L.4Fxs@CA|e=hT?GUDClB,L.4Fxs@CABA\";i:316;s:50:\"+a=hT?GU}j[Aa4#(k)No`,,B3()\",ub@=10DQA*\",ub@=10DQA\";i:317;s:46:\"+a=hT?GUDClB#L.4Fxs@DA|e=hT?GUDClB,L.4Fxs@DABA\";i:318;s:46:\"+a=hT?GUDClB#L.4Fx}MSA|e=hT?GUDClB,L.4Fx}MSABA\";i:319;s:46:\"+a=hT?GU1MlB#L.4Fxs@RA|e=hT?GU1MlB,L.4Fxs@RABA\";i:320;s:46:\"+a=hT?GU>BlB#L.4Fx~5CA|e=hT?GU>BlB,L.4Fx~5CABA\";i:321;s:46:\"+a=hT?GU>BlB#L.4Fxs@CA|e=hT?GU>BlB,L.4Fxs@CABA\";i:322;s:46:\"+a=hT?GU(ClB#L.4Fxs@DA|e=hT?GU(ClB,L.4Fxs@DABA\";i:323;s:46:\"+a=hT?GUoDlB#L.4Fxs@EA|e=hT?GUoDlB,L.4Fxs@EABA\";i:324;s:46:\"+a=hT?GU0PlB#L.4Fx}MWA|e=hT?GU0PlB,L.4Fx}MWABA\";i:325;s:46:\"+a=hT?GUkPlB#L.4Fxs@VA|e=hT?GUkPlB,L.4Fxs@VABA\";i:326;s:46:\"+a=hT?GUUPlB#L.4Fx~5VA|e=hT?GUUPlB,L.4Fx~5VABA\";i:327;s:46:\"+a=hT?GUzClB#L.4Fxs@CA|e=hT?GUzClB,L.4Fxs@CABA\";i:328;s:46:\"+a=hT?GUeBlB#L.4Fx~5DA|e=hT?GUeBlB,L.4Fx~5DABA\";i:329;s:13:\"hg=hT?GUjClBA\";i:330;s:13:\"hg=hT?GUeBlBA\";i:331;s:13:\"hg=hT?GUzClBA\";i:332;s:13:\"(a=hT?GUjClBA\";i:333;s:13:\"(a=hT?GUzClBA\";i:334;s:14:\"Qj=hT?GU}j=ACA\";i:335;s:14:\"Qj=hT?GU~@<ACA\";i:336;s:13:\"Qj=hT?GUUPlBA\";i:337;s:13:\"Qj=hT?GUkPlBA\";i:338;s:13:\"Qj=hT?GU0PlBA\";i:339;s:13:\"Qj=hT?GU)PlBA\";i:340;s:13:\"Qj=hT?GU(ClBA\";i:341;s:13:\"Qj=hT?GU_PlBA\";i:342;s:13:\"Qj=hT?GU>BlBA\";i:343;s:13:\"Qj=hT?GU*MlBA\";i:344;s:13:\"Qj=hT?GUDClBA\";i:345;s:13:\"Qj=hT?GUzClBA\";i:346;s:13:\"Qj=hT?GUeBlBA\";i:347;s:13:\"Qj=hT?GUjClBA\";i:348;s:13:\"yd=hT?GUjClBA\";i:349;s:13:\"yd=hT?GUeBlBA\";i:350;s:13:\"yd=hT?GUzClBA\";i:351;s:13:\"yd=hT?GUDClBA\";i:352;s:13:\"yd=hT?GU>BlBA\";i:353;s:13:\"A^=hT?GUSFlBA\";i:354;s:13:\"A^=hT?GUTClBA\";i:355;s:13:\"A^=hT?GU*MlBA\";i:356;s:13:\"A^=hT?GU(ClBA\";i:357;s:12:\"A^=hT?GU5A$A\";i:358;s:13:\"c#=hT?GUpQlBA\";i:359;s:14:\"`)=hT?GU~@[ACA\";i:360;s:14:\"`)=hT?GU}j]ACA\";i:361;s:14:\"`)=hT?GU~@]ACA\";i:362;s:14:\"`)=hT?GU~@]ACA\";i:363;s:13:\"`)=hT?GU6NlBA\";i:364;s:14:\"`)=hT?GU}j^ACA\";i:365;s:14:\"`)=hT?GU~@^ACA\";i:366;s:14:\"`)=hT?GU}j_ACA\";i:367;s:14:\"`)=hT?GU~@_ACA\";i:368;s:14:\"`)=hT?GU~@_ACA\";i:369;s:14:\"`)=hT?GU}j`ACA\";i:370;s:14:\"`)=hT?GU~@`ACA\";i:371;s:13:\"F0>hT?GUjClBA\";i:372;s:13:\"sP=hT?GU6NlBA\";i:373;s:13:\"sP=hT?GUuBlBA\";i:374;s:14:\"sP=hT?GU}j{ACA\";i:375;s:13:\"?2>hT?GUjClBA\";i:376;s:13:\"?2>hT?GUpQlBA\";i:377;s:13:\"\"l>hT?GU6NlBA\";i:378;s:14:\"\"l>hT?GU}j{ACA\";i:379;s:14:\"\"l>hT?GU~@{ACA\";i:380;s:14:\"\"l>hT?GU}j|ACA\";i:381;s:14:\"\"l>hT?GU~@^ACA\";i:382;s:13:\"\"l>hT?GUuBlBA\";i:383;s:13:\"!5>hT?GUjClBA\";i:384;s:13:\"t8>hT?GUjClBA\";i:385;s:13:\"yd>hT?GULKlBA\";i:386;s:12:\"nu=hT?GUZA$A\";i:387;s:13:\"VE=hT?GU{JlBA\";i:388;s:14:\"VE=hT?GU~@|ACA\";i:389;s:12:\"VE=hT?GUpA$A\";i:390;s:12:\"VE=hT?GUZA$A\";i:391;s:14:\"VE=hT?GU}j}ACA\";i:392;s:14:\"VE=hT?GU~@}ACA\";i:393;s:14:\"c#>hT?GU}j~AEA\";i:394;s:14:\"c#>hT?GU~@~AEA\";i:395;s:14:\"c#>hT?GU}j\"AEA\";i:396;s:13:\"t8=hT?GUOBlBA\";i:397;s:13:\"t8=hT?GUtElBA\";i:398;s:14:\"L&>hT?GU~@\"AEA\";i:399;s:13:\"L&>hT?GU*MlBA\";i:400;s:14:\"`)>hT?GU}jABEA\";i:401;s:14:\"`)>hT?GU~@ABEA\";i:402;s:14:\"`)>hT?GU}jBBEA\";i:403;s:14:\"),>hT?GU~@BBEA\";i:404;s:13:\"Wx=hT?GUnGlBA\";i:405;s:13:\"Wx=hT?GUIDlBA\";i:406;s:14:\"Wx=hT?GU}jCBEA\";i:407;s:14:\"z:>hT?GU~@@ACA\";i:408;s:13:\"z:>hT?GUjClBA\";i:409;s:13:\"z:>hT?GUDClBA\";i:410;s:13:\"F0=hT?GUjClBA\";i:411;s:13:\"F0=hT?GUzClBA\";i:412;s:13:\"F0=hT?GUTClBA\";i:413;s:14:\"F0=hT?GU~@CBEA\";i:414;s:13:\"?2=hT?GUjClBA\";i:415;s:13:\"?2=hT?GUeBlBA\";i:416;s:14:\"?2=hT?GU}jDBEA\";i:417;s:14:\"?2=hT?GU~@DBEA\";i:418;s:14:\"?2=hT?GU}jEBEA\";i:419;s:14:\"?2=hT?GU~@EBEA\";i:420;s:13:\"?2=hT?GUzClBA\";i:421;s:13:\"?2=hT?GU]FlBA\";i:422;s:13:\"?2=hT?GUDClBA\";i:423;s:13:\"i=>hT?GUDClBA\";i:424;s:13:\"i=>hT?GU1MlBA\";i:425;s:14:\"i=>hT?GU}jFBEA\";i:426;s:13:\"R@=hT?GU,GlBA\";i:427;s:13:\"sP>hT?GUdElBA\";i:428;s:13:\"R@>hT?GUdElBA\";i:429;s:13:\"bS=hT?GU!BlBA\";i:430;s:14:\"bS=hT?GU~@FBEA\";i:431;s:14:\"bS=hT?GU}jGBEA\";i:432;s:13:\"hg>hT?GUjClBA\";i:433;s:14:\"EH>hT?GU~@GBEA\";i:434;s:14:\"EH>hT?GU}jHBEA\";i:435;s:14:\"EH>hT?GU~@HBEA\";i:436;s:14:\"EH>hT?GU}jIBEA\";i:437;s:13:\"(a>hT?GU+JlBA\";i:438;s:13:\"A^>hT?GUjClBA\";i:439;s:14:\"A^>hT?GU~@IBEA\";i:440;s:14:\"A^>hT?GU}jJBEA\";i:441;s:14:\":`>hT?GU~@JBEA\";i:442;s:111:\"wu=hT?GUZA$A>CSOYMj<BtaS_Q3nE3RB$A}CSOYMj<BtJV_Q3nE3RB$A^CSOYMj<BtGO_Q3nE3RB$A`CSOYMj<Bt@Q_Q3nE3RB$A=CSOYM@1CtA\";i:443;s:58:\"ZE=hT?GU~@|A8y#(k)NoLF:CjXzXJI|+GA^9#(k)NoLF:CzXzXJI|+GACA\";i:444;s:81:\"hS>hT?GUmJlBbL.4Fx}M4h6F%tLvSQ[zNAc4it,ub@<I5FrvLvSQ[zNA:>it,ub@<I5FqyLvSQ[zie0WA\";i:445;s:57:\"fS>hT?GUmJlBnL.4FxrjDA1k=hT?GUjClB?L.4FxrjDATq=hT?GUjClBA\";i:446;s:47:\"8}=hT?GUVMlBzL.4Fx~5KAYL>hT?GU~@KBEA%(k)NoHR:CA\";i:447;s:12:\"VE=hT?GUpA$A\";i:448;s:157:\"QH>hT?GU}jIBbLjt,ub@%Z5F%tLvSQ[zNAc4it,ub@xJ5FrvLvSQ[zNA:>it,uj@xJ5F=ZASxWPDVE^2*NbA3(MIXL+uLvSQ[zNA/hit,ub@xJ5FLvLvSQ[zNAEA$(k)NoyAlBbL.4FxrjAA6F=hT?GUoTlBA\";i:449;s:102:\";a=hT?GUzClB#L.4Fxs@CA|e=hT?GUzClB,L.4Fxs@CA1k>hT?GU6NlBjL.4Fx~5BA%$=hT?GU9ElBAM.4FxrjEAl_=hT?GU~@LBEA\";i:450;s:13:\"L&=hT?GUqNlBA\";i:451;s:14:\"\"l>hT?GU}jMBEA\";i:452;s:36:\"7}=hT?GUvOlBzL.4Fxs@WAkn>hT?GU~@MBEA\";i:453;s:46:\"7r=hT?GUDSlBIM.4FxrjDAeZ=hT?GUjClB,L.4Fx~5DABA\";i:454;s:100:\"vu=hT?GUZA$A>CSOYMj<BtaS_Q3nE3RB$A}CSOYMj<BtJV_Q3nE3RB$A^CSOYMj<BtGO_Q3nE3RB$A`CSOYMj<Bt@Q_Q3nE3RB$A\";i:455;s:69:\"aE=hT?GU~@|AZL#(k)NoXB:CbXzXJI|+GAa4#(k)No+E:CrXzXJI{ZHAx(#(k)No+E:CA\";i:457;s:92:\":a=hT?GUzClB#L.4FxrjDA|e=hT?GUzClB,L.4FxrjDA;C=hT?GU~@|Aln#(k)NoGE:CyazXJI{Z5XaL]KVElg*N1AIA\";i:458;s:13:\"/o>hT?GU?OlBA\";i:459;s:100:\"*M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDACt=hT?GUZA$A\";i:460;s:57:\",a=hT?GUjClB#L.4Fxs@CA|e=hT?GUjClB,L.4Fxs@CApI=hT?GUOBlBA\";i:461;s:13:\"KV=hT?GUsHlBA\";i:462;s:35:\"v8=hT?GUOBlBgM.4Fxs@AAO/=hT?GUdElBA\";i:463;s:12:\"VE=hT?GUZA$A\";i:464;s:13:\">J=hT?GU~AlBA\";i:465;s:69:\"PV=hT?GUDClB<M.4Fx}Mc16F%tLvSQ[zNAc4it,ub@WK5FrvLvSQ[zNA:>it,ub@WK5FA\";i:466;s:13:\"5}=hT?GUvOlBA\";i:467;s:13:\"/o=hT?GU>BlBA\";i:468;s:12:\"),=hT?GU5A$A\";i:469;s:24:\":o=hT?GUDClB8M.4FxrjLABA\";i:470;s:24:\"u8=hT?GUOBlBfL.4Fxs@AABA\";i:471;s:13:\"t8=hT?GUOBlBA\";i:472;s:169:\"pS=hT?GU~@FB:>kt,ub@!S5FFxLvSQ[z^Az(mt,ub@r75FVxLvSQ[zNAFtlt,ub@=1rERtzBJHNzRmuW_EqI:$vbnBi\"pBJHNz`awWDHqI:$vbuARtqBJHNz`awWoIqI:$vbuAQA:\",ub@ff5FPzLvSQ[zCB2W,\",ub@4E5FA\";i:473;s:100:\"*M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDACt=hT?GUZA$A\";i:474;s:57:\",a=hT?GUzClB#L.4Fx~5DA|e=hT?GUzClB,L.4Fx~5DA1k>hT?GU6NlBA\";i:475;s:25:\"ig=hT?GUjClBVN.4Fx}Mw56FA\";i:476;s:46:\"+a=hT?GUzClB#L.4FxrjDA|e=hT?GUzClB,L.4FxrjDABA\";i:477;s:46:\"+a=hT?GUzClB#L.4Fx~5DA|e=hT?GUzClB,L.4Fx~5DABA\";i:478;s:13:\"hg=hT?GUjClBA\";i:479;s:56:\"]J=hT?GU~AlBYM.4Fx~5GA6F=hT?GU5A$AHDSOYMj<FtXL_Q3nE3BB$A\";i:480;s:13:\"5}=hT?GUvOlBA\";i:481;s:46:\"+a=hT?GUzClB#L.4Fxs@BA|e=hT?GUzClB,L.4Fxs@BABA\";i:482;s:46:\"+a=hT?GUzClB#L.4Fxs@BA|e=hT?GUzClB,L.4Fxs@BABA\";i:483;s:79:\"#}=hT?GU9ElBYM.4Fxs@UAeZ=hT?GUeBlB#L.4Fxs@BA|e=hT?GUeBlB,L.4Fxs@BA2[=hT?GUjClBA\";i:484;s:91:\"$}=hT?GU9ElBYM.4Fx}MV66F2uLvSQ[zHAyWit,ub@dF5F{uLvSQ[zHAFtit,ub@dF5FKyLvSQ[zNA:>ht,ub@(z5FA\";i:485;s:13:\"hg=hT?GUDClBA\";i:486;s:13:\">J=hT?GUtElBA\";i:487;s:13:\">J=hT?GUOBlBA\";i:488;s:124:\"UV=hT?GUDClB4M.4Fx~5UAD\"_Q3nE3AE$ATDSOYM*+VllBYM.4Fx}MTAeZ=hT?GUDClB#L.4Fxs@CA|e=hT?GUDClB,L.4Fxs@CAw(=hT?GU6NlBVN.4FxrjDABA\";i:489;s:100:\"*M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDACt=hT?GUZA$A\";i:490;s:57:\",a=hT?GUzClB#L.4Fx~5DA|e=hT?GUzClB,L.4Fx~5DA1k>hT?GU6NlBA\";i:491;s:25:\"ig=hT?GUjClBVN.4Fx}Mw56FA\";i:492;s:46:\"+a=hT?GUzClB#L.4FxrjDA|e=hT?GUzClB,L.4FxrjDABA\";i:493;s:46:\"+a=hT?GUzClB#L.4Fx~5DA|e=hT?GUzClB,L.4Fx~5DABA\";i:494;s:13:\"hg=hT?GUjClBA\";i:495;s:129:\"=a=hT?GUeBlB#L.4Fx~5DA|e=hT?GUeBlB,L.4Fx~5DAw(=hT?GU6NlBwM.4FxrjDA;C=hT?GU~@|AwW#(k)No8C:C7XzXJI|+DA.>#(k)No8C:C;XzX&N|+DA]QjC:CA\";i:496;s:13:\"L&=hT?GUHWlBA\";i:497;s:13:\"A^=hT?GUjClBA\";i:498;s:36:\"7}=hT?GUvOlB<M.4Fx}Mc16F%tLvSQ[zLAEA\";i:499;s:151:\"?a=hT?GUZQlB#L.4Fx}MXA|e=hT?GUZQlB,L.4Fx}MXAw(=hT?GU6NlBzL.4FxrjSAvW=hT?GU`MlBbL.4Fx}M4h6F%tLvSQ[zHAc4it,ub@WK5FrvLvSQ[zHA:>it,uj@WK5F>+GAR/$(k)No+E:CA\";i:500;s:36:\"7}=hT?GUvOlB<M.4Fx}Mc16F%tLvSQ[zLAEA\";i:501;s:90:\")M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDABA\";i:502;s:151:\"?a=hT?GUZQlB#L.4Fx}MXA|e=hT?GUZQlB,L.4Fx}MXAw(=hT?GU6NlBzL.4FxrjSAvW=hT?GU`MlBbL.4Fx}M4h6F%tLvSQ[zHAc4it,ub@WK5FrvLvSQ[zHA:>it,uj@WK5F>+GAR/$(k)No+E:CA\";i:503;s:13:\">J>hT?GUzClBA\";i:504;s:14:\"9M>hT?GU~@KBEA\";i:505;s:100:\"*M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDACt=hT?GUZA$A\";i:506;s:68:\"&M=hT?GUDClB;L.4FxrjDAkn=hT?GUDClB^L.4FxrjDAI7=hT?GUOBlBfL.4Fxs@AABA\";i:507;s:100:\"*M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUzClB#L.4Fx~5CA|e=hT?GUzClB,L.4Fx~5CACt=hT?GUZA$A\";i:508;s:147:\"*}=hT?GU9ElBnL.4FxrjDA;C=hT?GU~@|ADt#(k)No?Z:CFZzXJI|+GAln$(k)Nojd:CbXzXJI|+DAa4#(k)Noyg:CrXzXJI|+DAx(#(k)Noyg:CLXzXJI|+kA.>%(k)No(d:C9ZzXJI{Z2QaLA\";i:509;s:47:\"8}=hT?GUvOlB8M.4Fx}MLAYL>hT?GU~@KB:>ot,ub@Eg5FA\";i:510;s:36:\"C^=hT?GU5A$A;CSOYMXwEt|;_Q3nE3\"!sABA\";i:511;s:14:\"VE=hT?GU}j}ACA\";i:512;s:70:\"aE=hT?GU~@}A,h&(k)No`,|B2W)\",ub@xJ5F+uLvSQ[zOA/hit,ub@xJ5FLvLvSQ[zOAEA\";i:513;s:26:\"WE=hT?GU~@}A,h&(k)No`,|BIA\";i:514;s:24:\"nB>hT?GUlMlB?L.4Fx~5DABA\";i:515;s:13:\"9M=hT?GUDClBA\";i:516;s:24:\"u8=hT?GUOBlBfL.4Fxs@AABA\";i:517;s:57:\"~)=hT?GUjClB4M.4Fx~5GA2[=hT?GUjClBYM.4Fxs@UAYL=hT?GUzClBA\";i:518;s:68:\"&M=hT?GUzClB;L.4FxrjDAkn=hT?GUzClB^L.4FxrjDAI7=hT?GUOBlBfL.4Fxs@AABA\";i:519;s:24:\"u8=hT?GUOBlBfL.4Fxs@AABA\";i:520;s:80:\"A*=hT?GUjClB4M.4Fx~5GA2[=hT?GUjClB<M.4Fx}Mc16FJ1LvSQ[z_A:>jt,ub@+65F%tLvSQ[zOAEA\";i:521;s:68:\"&M=hT?GUzClB;L.4FxrjDAkn=hT?GUzClB^L.4FxrjDAI7=hT?GUOBlBfL.4Fxs@AABA\";i:522;s:24:\"!M=hT?GUzClB?L.4Fx~5DABA\";i:523;s:25:\"WE>hT?GU}jPB:>kt,ub@G65FA\";i:524;s:124:\"V&=hT?GUqNlBnL.4FxrjDA1k=hT?GUjClB?L.4FxrjDATq=hT?GUjClB7L.4Fxs@BANc=hT?GUDClB(L.4Fxs@BA+h=hT?GUDClBJN.4FxrjOABA`Q3nE3~RrABA\";i:525;s:24:\"6}=hT?GUvOlBbL.4Fx~5AABA\";i:526;s:122:\",M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDANc>hT?GULKlBcM.4FxrjTA6F=hT?GU5A$A\";i:527;s:112:\"+M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUzClB#L.4Fx~5DA|e=hT?GUzClB,L.4Fx~5DANc>hT?GULKlBcM.4FxrjTABA\";i:528;s:13:\"L&=hT?GUqNlBA\";i:529;s:90:\")M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAeZ=hT?GUjClB#L.4FxrjDA|e=hT?GUjClB,L.4FxrjDABA\";i:530;s:13:\"5}=hT?GUvOlBA\";i:531;s:13:\"/o=hT?GUDClBA\";i:532;s:80:\"R&=hT?GU}jOB:>kt,ub@!S5F:yLvSQ[zBAbLit,ub@/%5F+uLvSQ[zHA/hit,ub@/%5FLvLvSQ[zHAEA\";i:533;s:135:\".M=hT?GUjClB;L.4FxrjDAkn=hT?GUjClB^L.4FxrjDAw(=hT?GU6NlBJN.4FxrjOAeZ=hT?GUDClB#L.4Fxs@CA|e=hT?GUDClB,L.4Fxs@CA,>=hT?GU,GlB@M.4Fx}Mf86FA\";i:534;s:23:\"*,=hT?GU5A$AJDSOYMXwCtA\";}", "no");
INSERT INTO `wp_options` VALUES("542", "theme_mods_hotelbooking-child", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:18:\"nav_menu_locations\";a:1:{s:9:\"main-menu\";i:15;}}", "yes");
INSERT INTO `wp_options` VALUES("546", "nd_booking_container", "", "yes");
INSERT INTO `wp_options` VALUES("547", "nd_booking_price_guests", "", "yes");
INSERT INTO `wp_options` VALUES("548", "nd_booking_price_range_min_value", "", "yes");
INSERT INTO `wp_options` VALUES("549", "nd_booking_price_range_default_value", "", "yes");
INSERT INTO `wp_options` VALUES("550", "nd_booking_price_range_max_value", "", "yes");
INSERT INTO `wp_options` VALUES("551", "nd_booking_slug", "", "yes");
INSERT INTO `wp_options` VALUES("552", "nd_booking_slug_singular", "", "yes");
INSERT INTO `wp_options` VALUES("553", "nd_booking_email_template", "Default Template", "yes");
INSERT INTO `wp_options` VALUES("554", "nd_booking_city_tax", "21%", "yes");
INSERT INTO `wp_options` VALUES("555", "nd_booking_vat", "223 455678 23", "yes");
INSERT INTO `wp_options` VALUES("556", "nd_booking_paypal_email", "", "yes");
INSERT INTO `wp_options` VALUES("557", "nd_booking_paypal_token", "", "yes");
INSERT INTO `wp_options` VALUES("558", "nd_booking_stripe_checkout", "", "yes");
INSERT INTO `wp_options` VALUES("559", "nd_booking_stripe_public_key", "", "yes");
INSERT INTO `wp_options` VALUES("560", "nd_booking_stripe_secret_key", "", "yes");
INSERT INTO `wp_options` VALUES("561", "nd_booking_stripe_currency", "USD", "yes");
INSERT INTO `wp_options` VALUES("564", "theme_switched_via_customizer", "", "yes");
INSERT INTO `wp_options` VALUES("565", "customize_stashed_theme_mods", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("567", "nd_options_customizer_eventscalendar_plugin_style", "custom-style-1", "yes");
INSERT INTO `wp_options` VALUES("579", "nd_booking_integration_enable", "", "yes");
INSERT INTO `wp_options` VALUES("580", "nd_booking_coupon_enable", "1", "yes");
INSERT INTO `wp_options` VALUES("581", "nd_booking_stripe_enable", "", "yes");
INSERT INTO `wp_options` VALUES("582", "nd_booking_integration_wpml", "1", "yes");
INSERT INTO `wp_options` VALUES("611", "w3tc_generic_widgetservices", "{\"content\":{\"items\":[{\"name\":\"Premium Support Response (Usually <1h First Response)\",\"parameter_name\":\"field4\",\"parameter_value\":\"Premium Support Response (Usually <1h First Response)\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Performance Audit \\/ Consult (Theme, Plugin, Content, Server)\",\"parameter_name\":\"field4\",\"parameter_value\":\"Performance Audit \\/ Consult (Theme, Plugin, Content, Server)\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Plugin Configuration\",\"parameter_name\":\"field4\",\"parameter_value\":\"Plugin Configuration\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"SSL Performance Setup\",\"parameter_name\":\"field4\",\"parameter_value\":\"SSL Performance Setup\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Full Site Delivery Setup\",\"parameter_name\":\"field4\",\"parameter_value\":\"Full Site Delivery Setup\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Hosting Environment Troubleshooting\",\"parameter_name\":\"field4\",\"parameter_value\":\"Hosting Environment Troubleshooting\",\"form_hash\":\"m5pom8z0qy59rm\"},{\"name\":\"Performance Monitoring\",\"parameter_name\":\"field4\",\"parameter_value\":\"Performance Monitoring\",\"form_hash\":\"m5pom8z0qy59rm\"}],\"ui_strings\":{\"cdn.maxcdn.signUpAndSave\":\"Sign Up Now and save !\",\"cdn.maxcdn.signUpAndSave.description\":\"MaxCDN is a service that lets you speed up your site even more with W3 Total Cache. Sign up now to recieve a special offer!\",\"cdn.stackpath.signUpAndSave\":\"Sign Up Now and save !\",\"cdn.stackpath.signUpAndSave.description\":\"StackPath is a service that lets you speed up your site even more with W3 Total Cache. Sign up now and save!\",\"cdn.stackpath2.signUpAndSave\":\"Sign Up Now and save !\",\"cdn.stackpath2.signUpAndSave.description\":\"StackPath is a service that lets you speed up your site even more with W3 Total Cache. Sign up now to recieve a special offer!\",\"minify.general.header\":\"Reduce load time by decreasing the size and number of <acronym title=\'Cascading Style Sheet\'>CSS<\\/acronym> and <acronym title=\'JavaScript\'>JS<\\/acronym> files. Automatically remove unncessary data from <acronym title=\'Cascading Style Sheet\'>CSS<\\/acronym>, <acronym title=\'JavaScript\'>JS<\\/acronym>, feed, page and post <acronym title=\'Hypertext Markup Language\'>HTML<\\/acronym>.\",\"newrelic.general.header\":\"New Relic may not be installed or not active on this server. <a href=\'%s\' target=\'_blank\'>Sign up for a (free) account<\\/a>. Visit <a href=\'%s\' target=\'_blank\'>New Relic<\\/a> for installation instructions.\",\"reverseproxy.general.header\":\"A reverse proxy adds scale to an server by handling requests before WordPress does. Purge settings are set on the <a href=\'%s\'>Page Cache settings<\\/a> page and <a href=\'%s\'>Browser Cache settings<\\/a> are set on the browser cache settings page.\",\"cdnfsd.general.header\":\"Host the entire website with your compatible <acronym title=\'Content Delivery Network\'>CDN<\\/acronym> provider to reduce page load time.\",\"cdn.general.header\":\"Host static files with your <acronym title=\'Content Delivery Network\'>CDN<\\/acronym> to reduce page load time.\",\"cdn.stackpath.widget.existing\":\"If you\'re an existing StackPath customer, enable <acronym title=\'Content Delivery Network\'>CDN<\\/acronym> and:\",\"cdn.stackpath2.widget.existing\":\"If you\'re an existing StackPath customer, enable <acronym title=\'Content Delivery Network\'>CDN<\\/acronym> and:\",\"cdn.stackpath2.widget.works_magically\":\"StackPath works magically with W3 Total Cache.\",\"cdn.stackpath.widget.header\":\"Dramatically increase website speeds in just a few clicks! Add the StackPath content delivery network (<acronym title=\'Content Delivery Network\'>CDN<\\/acronym>) service to your site.\",\"cdn.stackpath2.widget.header\":\"Dramatically increase website speeds in just a few clicks! Add the StackPath content delivery network (<acronym title=\'Content Delivery Network\'>CDN<\\/acronym>) service to your site.\"}},\"expires\":1563379622}", "no");
INSERT INTO `wp_options` VALUES("630", "new_admin_email", "hombtch@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("648", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("702", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("703", "revslider-latest-version", "6.0.6", "yes");
INSERT INTO `wp_options` VALUES("704", "revslider-stable-version", "4.2", "yes");
INSERT INTO `wp_options` VALUES("705", "revslider-notices", "a:1:{i:0;O:8:\"stdClass\":7:{s:7:\"version\";s:5:\"5.9.9\";s:4:\"text\";s:466:\"<div style=\"width: 1000px; height: 390px;\"><a href=\"https://getsliderrevolution.com\" target=\"_blank\" style=\"float:left;\"><img alt=\"Buy Slider Revolution 6\" src=\"//updates.themepunch.tools/banners/rs60/sixzero_left.jpg\" width=\"670\" height=\"390\"></a><a href=\"https://youtu.be/mn5hC07aGvE\" target=\"_blank\" style=\"float:right;\"><img alt=\"Watch Slider Revolution 6 Video\" src=\"//updates.themepunch.tools/banners/rs60/sixzero_right.jpg\" width=\"330\" height=\"390\"></a></div>\";s:4:\"code\";s:10:\"TPRS600-01\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("706", "revslider-dashboard", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("707", "revslider-addons", "O:8:\"stdClass\":26:{s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:65:\"//updates.themepunch.tools/addons/images/whiteboard_widget_bg.jpg\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_whiteboard.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_backup.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_wpgallery.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_wprelated.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"5.3.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_typewriter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"1.1.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:64:\"//updates.themepunch.tools/addons/images/addon_socialsharing.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"5.3.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:68:\"//updates.themepunch.tools/addons/images/addon_underconstruction.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:55:\"//updates.themepunch.tools/addons/images/addon_snow.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"1.0.6\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_particles.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:59:\"//updates.themepunch.tools/addons/images/addon_polyfold.jpg\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:54:\"//updates.themepunch.tools/addons/images/addon_404.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_wpadjacent.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_filmstrip.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:56:\"//updates.themepunch.tools/addons/images/addon_login.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:1;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_wpfeatured.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_slicey.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"1.0.3\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch.tools/addons/images/addon_beforeafter.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"1.0.5\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:58:\"//updates.themepunch.tools/addons/images/addon_weather.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:7:\"5.4.5.2\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:23:\"Display images in 360°\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:59:\"//updates.themepunch.tools/addons/images/addon_panorama.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:58:\"//updates.themepunch.tools/addons/images/addon_duotone.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"1.0.1\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_reveal.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:57:\"//updates.themepunch.tools/addons/images/addon_reload.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:62:\"//updates.themepunch.tools/addons/images/addon_bubblemorph.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_distortion.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:60:\"//updates.themepunch.tools/addons/images/addon_exploding.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":11:{s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"5.4.6\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"1.0.0\";s:10:\"background\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:6:\"global\";b:0;s:4:\"logo\";O:8:\"stdClass\":3:{s:3:\"img\";s:61:\"//updates.themepunch.tools/addons/images/addon_paintbrush.jpg\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}}}", "yes");
INSERT INTO `wp_options` VALUES("710", "_site_transient_timeout_theme_roots", "1563692437", "no");
INSERT INTO `wp_options` VALUES("711", "_site_transient_theme_roots", "a:5:{s:18:\"hotelbooking-child\";s:7:\"/themes\";s:12:\"hotelbooking\";s:7:\"/themes\";s:14:\"twentynineteen\";s:7:\"/themes\";s:15:\"twentyseventeen\";s:7:\"/themes\";s:13:\"twentysixteen\";s:7:\"/themes\";}", "no");
INSERT INTO `wp_options` VALUES("714", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-5.2.2.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-5.2.2.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"5.2.2\";s:7:\"version\";s:5:\"5.2.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.0\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1563690854;s:15:\"version_checked\";s:5:\"5.2.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("715", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1563690658;s:7:\"checked\";a:5:{s:18:\"hotelbooking-child\";s:14:\"1.0.1562761516\";s:12:\"hotelbooking\";s:3:\"1.0\";s:14:\"twentynineteen\";s:3:\"1.3\";s:15:\"twentyseventeen\";s:3:\"2.1\";s:13:\"twentysixteen\";s:3:\"1.9\";}s:8:\"response\";a:3:{s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.1.4.zip\";s:8:\"requires\";s:5:\"4.9.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentyseventeen\";a:6:{s:5:\"theme\";s:15:\"twentyseventeen\";s:11:\"new_version\";s:3:\"2.2\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentyseventeen/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentyseventeen.2.2.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:13:\"twentysixteen\";a:6:{s:5:\"theme\";s:13:\"twentysixteen\";s:11:\"new_version\";s:3:\"2.0\";s:3:\"url\";s:43:\"https://wordpress.org/themes/twentysixteen/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/theme/twentysixteen.2.0.zip\";s:8:\"requires\";s:3:\"4.4\";s:12:\"requires_php\";s:5:\"5.2.4\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("716", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1563690660;s:7:\"checked\";a:25:{s:19:\"akismet/akismet.php\";s:5:\"4.1.2\";s:27:\"autoptimize/autoptimize.php\";s:5:\"2.5.1\";s:53:\"child-theme-configurator/child-theme-configurator.php\";s:5:\"2.5.0\";s:33:\"classic-editor/classic-editor.php\";s:3:\"1.5\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"5.1.3\";s:31:\"cookie-notice/cookie-notice.php\";s:6:\"1.2.46\";s:33:\"instagram-feed/instagram-feed.php\";s:6:\"1.12.1\";s:32:\"duplicate-page/duplicatepage.php\";s:3:\"3.5\";s:25:\"duplicator/duplicator.php\";s:6:\"1.3.16\";s:45:\"enable-media-replace/enable-media-replace.php\";s:5:\"3.3.1\";s:21:\"hello-dolly/hello.php\";s:5:\"1.7.2\";s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";s:5:\"3.1.2\";s:35:\"login-recaptcha/login-nocaptcha.php\";s:5:\"1.6.4\";s:27:\"maintenance/maintenance.php\";s:5:\"3.6.3\";s:25:\"nd-booking/nd-booking.php\";s:3:\"2.4\";s:31:\"nd-shortcodes/nd-shortcodes.php\";s:3:\"5.8\";s:35:\"rename-wp-login/rename-wp-login.php\";s:5:\"2.5.5\";s:23:\"revslider/revslider.php\";s:7:\"5.4.8.3\";s:23:\"wp-smushit/wp-smush.php\";s:5:\"3.2.1\";s:37:\"user-role-editor/user-role-editor.php\";s:6:\"4.51.1\";s:33:\"w3-total-cache/w3-total-cache.php\";s:7:\"0.9.7.5\";s:23:\"wordfence/wordfence.php\";s:5:\"7.3.4\";s:41:\"wordpress-importer/wordpress-importer.php\";s:5:\"0.6.4\";s:27:\"js_composer/js_composer.php\";s:3:\"5.7\";s:24:\"wordpress-seo/wp-seo.php\";s:4:\"11.6\";}s:8:\"response\";a:7:{s:32:\"duplicate-page/duplicatepage.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-page\";s:4:\"slug\";s:14:\"duplicate-page\";s:6:\"plugin\";s:32:\"duplicate-page/duplicatepage.php\";s:11:\"new_version\";s:3:\"3.8\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-page/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/duplicate-page.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-page/assets/icon-128x128.jpg?rev=1412874\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-page/assets/banner-772x250.jpg?rev=1410328\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.3.18\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.3.18.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2083921\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2083921\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2085472\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.2\";s:12:\"requires_php\";s:6:\"5.2.17\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:45:\"enable-media-replace/enable-media-replace.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:34:\"w.org/plugins/enable-media-replace\";s:4:\"slug\";s:20:\"enable-media-replace\";s:6:\"plugin\";s:45:\"enable-media-replace/enable-media-replace.php\";s:11:\"new_version\";s:5:\"3.3.3\";s:3:\"url\";s:51:\"https://wordpress.org/plugins/enable-media-replace/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/enable-media-replace.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/enable-media-replace/assets/icon-256x256.png?rev=1940728\";s:2:\"1x\";s:73:\"https://ps.w.org/enable-media-replace/assets/icon-128x128.png?rev=1940728\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:76:\"https://ps.w.org/enable-media-replace/assets/banner-1544x500.png?rev=1940728\";s:2:\"1x\";s:75:\"https://ps.w.org/enable-media-replace/assets/banner-772x250.png?rev=1940728\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.2\";s:12:\"requires_php\";s:3:\"5.4\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:35:\"rename-wp-login/rename-wp-login.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:29:\"w.org/plugins/rename-wp-login\";s:4:\"slug\";s:15:\"rename-wp-login\";s:6:\"plugin\";s:35:\"rename-wp-login/rename-wp-login.php\";s:11:\"new_version\";s:5:\"2.6.0\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/rename-wp-login/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/rename-wp-login.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/rename-wp-login/assets/icon-256x256.png?rev=975550\";s:2:\"1x\";s:67:\"https://ps.w.org/rename-wp-login/assets/icon-128x128.png?rev=975550\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.2\";s:12:\"requires_php\";b:0;s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:37:\"user-role-editor/user-role-editor.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:30:\"w.org/plugins/user-role-editor\";s:4:\"slug\";s:16:\"user-role-editor\";s:6:\"plugin\";s:37:\"user-role-editor/user-role-editor.php\";s:11:\"new_version\";s:6:\"4.51.2\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/user-role-editor/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/user-role-editor.4.51.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/user-role-editor/assets/icon-256x256.jpg?rev=1020390\";s:2:\"1x\";s:69:\"https://ps.w.org/user-role-editor/assets/icon-128x128.jpg?rev=1020390\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/user-role-editor/assets/banner-772x250.png?rev=1263116\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.2\";s:12:\"requires_php\";s:3:\"5.5\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":12:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:5:\"7.3.5\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wordfence.7.3.5.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/wordfence/assets/icon-256x256.png?rev=2070855\";s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"5.2.2\";s:12:\"requires_php\";s:3:\"5.3\";s:13:\"compatibility\";O:8:\"stdClass\":0:{}}s:27:\"js_composer/js_composer.php\";O:8:\"stdClass\":6:{s:4:\"slug\";s:11:\"js_composer\";s:11:\"new_version\";s:5:\"6.0.5\";s:6:\"plugin\";s:27:\"js_composer/js_composer.php\";s:3:\"url\";s:0:\"\";s:7:\"package\";b:0;s:4:\"name\";s:21:\"WPBakery Page Builder\";}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:17:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"4.1.2\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.4.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:59:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=969272\";s:2:\"1x\";s:59:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=969272\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:61:\"https://ps.w.org/akismet/assets/banner-772x250.jpg?rev=479904\";}s:11:\"banners_rtl\";a:0:{}}s:27:\"autoptimize/autoptimize.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/autoptimize\";s:4:\"slug\";s:11:\"autoptimize\";s:6:\"plugin\";s:27:\"autoptimize/autoptimize.php\";s:11:\"new_version\";s:5:\"2.5.1\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/autoptimize/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/autoptimize.2.5.1.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:64:\"https://ps.w.org/autoptimize/assets/icon-128x128.png?rev=1864142\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/autoptimize/assets/banner-772x250.jpg?rev=1315920\";}s:11:\"banners_rtl\";a:0:{}}s:53:\"child-theme-configurator/child-theme-configurator.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:38:\"w.org/plugins/child-theme-configurator\";s:4:\"slug\";s:24:\"child-theme-configurator\";s:6:\"plugin\";s:53:\"child-theme-configurator/child-theme-configurator.php\";s:11:\"new_version\";s:5:\"2.5.0\";s:3:\"url\";s:55:\"https://wordpress.org/plugins/child-theme-configurator/\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/plugin/child-theme-configurator.2.5.0.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:77:\"https://ps.w.org/child-theme-configurator/assets/icon-128x128.png?rev=1557885\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:79:\"https://ps.w.org/child-theme-configurator/assets/banner-772x250.jpg?rev=1557885\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:3:\"1.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/classic-editor.1.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"5.1.3\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.5.1.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-256x256.png?rev=984007\";s:2:\"1x\";s:66:\"https://ps.w.org/contact-form-7/assets/icon-128x128.png?rev=984007\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}}s:31:\"cookie-notice/cookie-notice.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/cookie-notice\";s:4:\"slug\";s:13:\"cookie-notice\";s:6:\"plugin\";s:31:\"cookie-notice/cookie-notice.php\";s:11:\"new_version\";s:6:\"1.2.46\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/cookie-notice/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/cookie-notice.1.2.46.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/cookie-notice/assets/icon-256x256.png?rev=1805756\";s:2:\"1x\";s:66:\"https://ps.w.org/cookie-notice/assets/icon-128x128.png?rev=1805756\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/cookie-notice/assets/banner-772x250.png?rev=1805749\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"instagram-feed/instagram-feed.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/instagram-feed\";s:4:\"slug\";s:14:\"instagram-feed\";s:6:\"plugin\";s:33:\"instagram-feed/instagram-feed.php\";s:11:\"new_version\";s:6:\"1.12.1\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/instagram-feed/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/instagram-feed.1.12.1.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/instagram-feed/assets/icon-128x128.png?rev=2123267\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/instagram-feed/assets/banner-772x250.png?rev=2109702\";}s:11:\"banners_rtl\";a:0:{}}s:21:\"hello-dolly/hello.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:21:\"hello-dolly/hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}}s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:41:\"w.org/plugins/intuitive-custom-post-order\";s:4:\"slug\";s:27:\"intuitive-custom-post-order\";s:6:\"plugin\";s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";s:11:\"new_version\";s:5:\"3.1.2\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/intuitive-custom-post-order/\";s:7:\"package\";s:76:\"https://downloads.wordpress.org/plugin/intuitive-custom-post-order.3.1.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/intuitive-custom-post-order/assets/icon-256x256.png?rev=1078797\";s:2:\"1x\";s:80:\"https://ps.w.org/intuitive-custom-post-order/assets/icon-128x128.png?rev=1078797\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:83:\"https://ps.w.org/intuitive-custom-post-order/assets/banner-1544x500.png?rev=1209666\";s:2:\"1x\";s:82:\"https://ps.w.org/intuitive-custom-post-order/assets/banner-772x250.png?rev=1078755\";}s:11:\"banners_rtl\";a:0:{}}s:35:\"login-recaptcha/login-nocaptcha.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:29:\"w.org/plugins/login-recaptcha\";s:4:\"slug\";s:15:\"login-recaptcha\";s:6:\"plugin\";s:35:\"login-recaptcha/login-nocaptcha.php\";s:11:\"new_version\";s:5:\"1.6.4\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/login-recaptcha/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/login-recaptcha.1.6.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:68:\"https://ps.w.org/login-recaptcha/assets/icon-256x256.png?rev=1137538\";s:2:\"1x\";s:68:\"https://ps.w.org/login-recaptcha/assets/icon-128x128.png?rev=1137538\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:71:\"https://ps.w.org/login-recaptcha/assets/banner-1544x500.png?rev=1137538\";s:2:\"1x\";s:70:\"https://ps.w.org/login-recaptcha/assets/banner-772x250.png?rev=1137538\";}s:11:\"banners_rtl\";a:0:{}}s:27:\"maintenance/maintenance.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:25:\"w.org/plugins/maintenance\";s:4:\"slug\";s:11:\"maintenance\";s:6:\"plugin\";s:27:\"maintenance/maintenance.php\";s:11:\"new_version\";s:5:\"3.6.3\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/maintenance/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/maintenance.3.6.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/maintenance/assets/icon-256x256.png?rev=993211\";s:2:\"1x\";s:64:\"https://ps.w.org/maintenance/assets/icon-128x128.png?rev=1220832\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:66:\"https://ps.w.org/maintenance/assets/banner-772x250.png?rev=1637471\";}s:11:\"banners_rtl\";a:0:{}}s:25:\"nd-booking/nd-booking.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/nd-booking\";s:4:\"slug\";s:10:\"nd-booking\";s:6:\"plugin\";s:25:\"nd-booking/nd-booking.php\";s:11:\"new_version\";s:3:\"2.4\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/nd-booking/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/nd-booking.2.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/nd-booking/assets/icon-256x256.jpg?rev=1695896\";s:2:\"1x\";s:63:\"https://ps.w.org/nd-booking/assets/icon-128x128.jpg?rev=1695896\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/nd-booking/assets/banner-1544x500.jpg?rev=1695896\";s:2:\"1x\";s:65:\"https://ps.w.org/nd-booking/assets/banner-772x250.jpg?rev=1695896\";}s:11:\"banners_rtl\";a:0:{}}s:31:\"nd-shortcodes/nd-shortcodes.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/nd-shortcodes\";s:4:\"slug\";s:13:\"nd-shortcodes\";s:6:\"plugin\";s:31:\"nd-shortcodes/nd-shortcodes.php\";s:11:\"new_version\";s:3:\"5.8\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/nd-shortcodes/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/nd-shortcodes.5.8.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/nd-shortcodes/assets/icon-256x256.jpg?rev=1498667\";s:2:\"1x\";s:66:\"https://ps.w.org/nd-shortcodes/assets/icon-128x128.jpg?rev=1498667\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/nd-shortcodes/assets/banner-1544x500.jpg?rev=1498667\";s:2:\"1x\";s:68:\"https://ps.w.org/nd-shortcodes/assets/banner-772x250.jpg?rev=1498667\";}s:11:\"banners_rtl\";a:0:{}}s:23:\"wp-smushit/wp-smush.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:24:\"w.org/plugins/wp-smushit\";s:4:\"slug\";s:10:\"wp-smushit\";s:6:\"plugin\";s:23:\"wp-smushit/wp-smush.php\";s:11:\"new_version\";s:5:\"3.2.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/wp-smushit/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/wp-smushit.3.2.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/wp-smushit/assets/icon-256x256.jpg?rev=1513049\";s:2:\"1x\";s:63:\"https://ps.w.org/wp-smushit/assets/icon-128x128.jpg?rev=1513049\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wp-smushit/assets/banner-1544x500.png?rev=1863697\";s:2:\"1x\";s:65:\"https://ps.w.org/wp-smushit/assets/banner-772x250.png?rev=1863697\";}s:11:\"banners_rtl\";a:0:{}}s:33:\"w3-total-cache/w3-total-cache.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:28:\"w.org/plugins/w3-total-cache\";s:4:\"slug\";s:14:\"w3-total-cache\";s:6:\"plugin\";s:33:\"w3-total-cache/w3-total-cache.php\";s:11:\"new_version\";s:7:\"0.9.7.5\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/w3-total-cache/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/w3-total-cache.0.9.7.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/w3-total-cache/assets/icon-256x256.png?rev=1041806\";s:2:\"1x\";s:67:\"https://ps.w.org/w3-total-cache/assets/icon-128x128.png?rev=1041806\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/w3-total-cache/assets/banner-772x250.jpg?rev=1041806\";}s:11:\"banners_rtl\";a:0:{}}s:41:\"wordpress-importer/wordpress-importer.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:32:\"w.org/plugins/wordpress-importer\";s:4:\"slug\";s:18:\"wordpress-importer\";s:6:\"plugin\";s:41:\"wordpress-importer/wordpress-importer.php\";s:11:\"new_version\";s:5:\"0.6.4\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/wordpress-importer/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/wordpress-importer.0.6.4.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:71:\"https://ps.w.org/wordpress-importer/assets/icon-256x256.png?rev=1908375\";s:2:\"1x\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";s:3:\"svg\";s:63:\"https://ps.w.org/wordpress-importer/assets/icon.svg?rev=1908375\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-importer/assets/banner-772x250.png?rev=547654\";}s:11:\"banners_rtl\";a:0:{}}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":9:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"11.6\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.11.6.zip\";s:5:\"icons\";a:3:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.png?rev=1834347\";s:2:\"1x\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1946641\";s:3:\"svg\";s:58:\"https://ps.w.org/wordpress-seo/assets/icon.svg?rev=1946641\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=1843435\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=1843435\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=1843435\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=1843435\";}}}}", "no");
INSERT INTO `wp_options` VALUES("719", "rs-templates-new", "", "no");
INSERT INTO `wp_options` VALUES("720", "rs-templates", "a:2:{s:6:\"slider\";a:325:{i:0;a:20:{s:2:\"id\";s:1:\"1\";s:5:\"title\";s:16:\"Classic Carousel\";s:5:\"alias\";s:16:\"classic-carousel\";s:3:\"zip\";s:20:\"classic-carousel.zip\";s:3:\"uid\";s:32:\"146a01dd380c0cdee85c4456ee68cd84\";s:3:\"img\";s:27:\"classic-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/carousel-slider-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">Our classic, full-width carousel example. Drag, swipe or click to navigate!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:1;a:20:{s:2:\"id\";s:1:\"2\";s:5:\"title\";s:14:\"Classic Slider\";s:5:\"alias\";s:13:\"classicslider\";s:3:\"zip\";s:17:\"classicslider.zip\";s:3:\"uid\";s:32:\"a0d6a9248c9066b404ba0f1cdadc5cf2\";s:3:\"img\";s:24:\"classicslider/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-slideshow-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:136:\" <span class=\"ttm_content\">A classic slideshow example with timer, bullets and arrow navigation.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:2;a:20:{s:2:\"id\";s:1:\"3\";s:5:\"title\";s:12:\"Content Tabs\";s:5:\"alias\";s:11:\"contenttabs\";s:3:\"zip\";s:15:\"contenttabs.zip\";s:3:\"uid\";s:32:\"e02e91604b690123a3d07a65582c4fd0\";s:3:\"img\";s:22:\"contenttabs/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-content-tabs-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:170:\" <span class=\"ttm_content\">An auto-size slider with a cool split-text animation effect. Navigate with vertical bullets and thumbs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:3;a:20:{s:2:\"id\";s:1:\"4\";s:5:\"title\";s:13:\"Facebook Feed\";s:5:\"alias\";s:13:\"facebook-feed\";s:3:\"zip\";s:17:\"facebook-feed.zip\";s:3:\"uid\";s:32:\"5506431d5b1babcb25dcf52c508d42e3\";s:3:\"img\";s:24:\"facebook-feed/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-facebook-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:174:\"<span class=\"ttm_content\"> This slider is automatically populated by a Facebook stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Facebook Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:4;a:20:{s:2:\"id\";s:1:\"5\";s:5:\"title\";s:7:\"Fashion\";s:5:\"alias\";s:7:\"fashion\";s:3:\"zip\";s:11:\"fashion.zip\";s:3:\"uid\";s:32:\"4f4b914d6db35e19101ff003c4e7ea3a\";s:3:\"img\";s:18:\"fashion/slider.jpg\";s:7:\"preview\";s:65:\"http://revolution.themepunch.com/wordpress-one-page-slider-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"  <span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:5;a:20:{s:2:\"id\";s:1:\"6\";s:5:\"title\";s:14:\"Flickr Gallery\";s:5:\"alias\";s:14:\"flickr-gallery\";s:3:\"zip\";s:18:\"flickr-gallery.zip\";s:3:\"uid\";s:32:\"ad85cfac7acfa678e6a1b8febfee51ed\";s:3:\"img\";s:25:\"flickr-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-flickr-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\" <span class=\"ttm_content\"> This slider is automatically populated by a Flickr stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:413:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Flickr Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:6;a:20:{s:2:\"id\";s:1:\"7\";s:5:\"title\";s:3:\"Gym\";s:5:\"alias\";s:3:\"gym\";s:3:\"zip\";s:7:\"gym.zip\";s:3:\"uid\";s:32:\"e4d81f13f96fb9bc905f4ad89615032b\";s:3:\"img\";s:14:\"gym/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/one-page-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:189:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the slider menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:7;a:20:{s:2:\"id\";s:1:\"8\";s:5:\"title\";s:18:\"Highlight Carousel\";s:5:\"alias\";s:18:\"highlight-carousel\";s:3:\"zip\";s:22:\"highlight-carousel.zip\";s:3:\"uid\";s:32:\"ada52163f723a942f782351fa0396b3d\";s:3:\"img\";s:29:\"highlight-carousel/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-swipe-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:138:\"  <span class=\"ttm_content\">A swipe-controlled carousel with an additional tab-based navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:8;a:20:{s:2:\"id\";s:1:\"9\";s:5:\"title\";s:18:\"Highlight Showcase\";s:5:\"alias\";s:18:\"highlight-showcase\";s:3:\"zip\";s:22:\"highlight-showcase.zip\";s:3:\"uid\";s:32:\"2bfe0bd410fb48fec9d942eab1e21530\";s:3:\"img\";s:29:\"highlight-showcase/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-parallax-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">A tab-based navigation, a slideshow timer and cool animations make this slider interesting!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:9;a:20:{s:2:\"id\";s:2:\"10\";s:5:\"title\";s:10:\"Image Hero\";s:5:\"alias\";s:10:\"image-hero\";s:3:\"zip\";s:13:\"imagehero.zip\";s:3:\"uid\";s:32:\"7db18781d44f2adc28c962440894aac1\";s:3:\"img\";s:20:\"imagehero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-image/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:121:\"<span class=\"ttm_content\">A commonly used full-width image hero block with texts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:10;a:20:{s:2:\"id\";s:2:\"11\";s:5:\"title\";s:17:\"Instagram Gallery\";s:5:\"alias\";s:13:\"insta-gallery\";s:3:\"zip\";s:17:\"insta-gallery.zip\";s:3:\"uid\";s:32:\"711732b0d42ec2b57818a2b9b1d86cba\";s:3:\"img\";s:24:\"insta-gallery/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-instagram-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"640\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:174:\"<span class=\"ttm_content\">This slider is automatically populated by a Instagram stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:416:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Instagram Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:11;a:20:{s:2:\"id\";s:2:\"12\";s:5:\"title\";s:21:\"Levano Restaurant Bar\";s:5:\"alias\";s:19:\"levanorestaurantbar\";s:3:\"zip\";s:23:\"levanorestaurantbar.zip\";s:3:\"uid\";s:32:\"4178f837db67d1b2eb6cb5840bbd0b42\";s:3:\"img\";s:30:\"levanorestaurantbar/slider.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/wordpress-front-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or bullets.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:12;a:20:{s:2:\"id\";s:2:\"13\";s:5:\"title\";s:19:\"Main Feature Slider\";s:5:\"alias\";s:11:\"mainfeature\";s:3:\"zip\";s:15:\"mainfeature.zip\";s:3:\"uid\";s:32:\"1e002a3230ab00095bedc6f60393ee7f\";s:3:\"img\";s:22:\"mainfeature/slider.jpg\";s:7:\"preview\";s:33:\"http://revolution.themepunch.com/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"750\";s:11:\"description\";s:127:\" <span class=\"ttm_content\">A slightly stripped down version of the main preview slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:13;a:20:{s:2:\"id\";s:2:\"14\";s:5:\"title\";s:17:\"Media Gallery Two\";s:5:\"alias\";s:17:\"media-gallery-two\";s:3:\"zip\";s:21:\"media-gallery-two.zip\";s:3:\"uid\";s:32:\"d002f1b1b55805f9322c264c5504ba5a\";s:3:\"img\";s:28:\"media-gallery-two/slider.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-media-gallery-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:127:\"<span class=\"ttm_content\">A media gallery example with Vimeo, HTML5 and Youtube videos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and titles.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:14;a:20:{s:2:\"id\";s:2:\"15\";s:5:\"title\";s:23:\"Media Carousel Autoplay\";s:5:\"alias\";s:23:\"media-carousel-autoplay\";s:3:\"zip\";s:27:\"media-carousel-autoplay.zip\";s:3:\"uid\";s:32:\"393d7875b1cc9d933378b35e4f645d76\";s:3:\"img\";s:34:\"media-carousel-autoplay/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-media-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"720\";s:6:\"height\";s:3:\"405\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">A media carousel with \"autoplay\" activated. Swipe or click tabs to navigate the slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change media and caption texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:15;a:20:{s:2:\"id\";s:2:\"16\";s:5:\"title\";s:21:\"News Background Video\";s:5:\"alias\";s:21:\"news-background-video\";s:3:\"zip\";s:17:\"news-bg-video.zip\";s:3:\"uid\";s:32:\"a0efe44ac3af0f958b3f84c816a08272\";s:3:\"img\";s:24:\"news-bg-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A hero block with HTML5 background video that plays when entering the screen.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:16;a:20:{s:2:\"id\";s:2:\"17\";s:5:\"title\";s:12:\"News Gallery\";s:5:\"alias\";s:12:\"news-gallery\";s:3:\"zip\";s:16:\"news-gallery.zip\";s:3:\"uid\";s:32:\"3a069c3b286dbb9ee435563f747e3300\";s:3:\"img\";s:23:\"news-gallery/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-news-rotator/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A news gallery slideshow with tab navigation. Great for any blog!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:17;a:20:{s:2:\"id\";s:2:\"18\";s:5:\"title\";s:23:\"News Gallery Post Based\";s:5:\"alias\";s:23:\"news-gallery-post-based\";s:3:\"zip\";s:27:\"news-gallery-post-based.zip\";s:3:\"uid\";s:32:\"32fe05b1039c29ab9420bfd15aec5488\";s:3:\"img\";s:34:\"news-gallery-post-based/slider.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-post-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:18;a:20:{s:2:\"id\";s:2:\"19\";s:5:\"title\";s:9:\"News Hero\";s:5:\"alias\";s:9:\"news-hero\";s:3:\"zip\";s:13:\"news-hero.zip\";s:3:\"uid\";s:32:\"96a0385538a17c8c81ed8175740f70ea\";s:3:\"img\";s:20:\"news-hero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:107:\"<span class=\"ttm_content\">A image hero block with ken burns effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:19;a:20:{s:2:\"id\";s:2:\"20\";s:5:\"title\";s:10:\"News Video\";s:5:\"alias\";s:10:\"news-video\";s:3:\"zip\";s:14:\"news-video.zip\";s:3:\"uid\";s:32:\"f901e9e16e0363248156c2209eb584e9\";s:3:\"img\";s:21:\"news-video/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-content-blocks/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:128:\"<span class=\"ttm_content\">A Vimeo background video hero block with play / pause buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the video and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:20;a:20:{s:2:\"id\";s:2:\"21\";s:5:\"title\";s:15:\"Newsletter Hero\";s:5:\"alias\";s:15:\"newsletter-hero\";s:3:\"zip\";s:19:\"newsletter-hero.zip\";s:3:\"uid\";s:32:\"6290a9864d8c4c6311784586ed1cc5fe\";s:3:\"img\";s:26:\"newsletter-hero/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-newsletter-signup/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:137:\"<span class=\"ttm_content\">This hero block uses a custom styled Mailchimp newsletter signup field.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:435:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and <a href=\"https://www.themepunch.com/faq/how-to-setup-mailchimp-for-the-newsletter-hero-template/\" target=\"_blank\">Mailchimp code</a>.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:21;a:20:{s:2:\"id\";s:2:\"22\";s:5:\"title\";s:11:\"Not Generic\";s:5:\"alias\";s:10:\"notgeneric\";s:3:\"zip\";s:14:\"notgeneric.zip\";s:3:\"uid\";s:32:\"9d87ba95e02210a9f82387add2ceadf9\";s:3:\"img\";s:21:\"notgeneric/slider.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">A full-screen slider with a layer based navigation and sleek content elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:22;a:20:{s:2:\"id\";s:2:\"23\";s:5:\"title\";s:11:\"Photography\";s:5:\"alias\";s:11:\"photography\";s:3:\"zip\";s:15:\"photography.zip\";s:3:\"uid\";s:32:\"1b2072547afb75e49f33b016751ed360\";s:3:\"img\";s:22:\"photography/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-photography-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:23;a:20:{s:2:\"id\";s:2:\"24\";s:5:\"title\";s:20:\"Photography Carousel\";s:5:\"alias\";s:20:\"photography-carousel\";s:3:\"zip\";s:24:\"photography-carousel.zip\";s:3:\"uid\";s:32:\"9a84b859ba23dc49ba8784e3a86545fa\";s:3:\"img\";s:31:\"photography-carousel/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-photo-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">A front-page carousel that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:24;a:20:{s:2:\"id\";s:2:\"25\";s:5:\"title\";s:16:\"Search Form Hero\";s:5:\"alias\";s:16:\"search-form-hero\";s:3:\"zip\";s:20:\"search-form-hero.zip\";s:3:\"uid\";s:32:\"e09eb1bd0f22b3a2b02a1aa251dd1f3e\";s:3:\"img\";s:27:\"search-form-hero/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-search-form-hero/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This hero block uses a custom styled input field to show search results on a WordPress site.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image, texts, and search field code.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:25;a:20:{s:2:\"id\";s:2:\"26\";s:5:\"title\";s:17:\"Showcase Carousel\";s:5:\"alias\";s:16:\"showcasecarousel\";s:3:\"zip\";s:20:\"showcasecarousel.zip\";s:3:\"uid\";s:32:\"c5ca218398331bd2c064efc2f62eae56\";s:3:\"img\";s:27:\"showcasecarousel/slider.jpg\";s:7:\"preview\";s:62:\"http://revolution.themepunch.com/wordpress-cover-flow-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">A fancy carousel that rotates, fades and scales slider items.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:284:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:26;a:20:{s:2:\"id\";s:2:\"27\";s:5:\"title\";s:11:\"Sports Hero\";s:5:\"alias\";s:11:\"sports-hero\";s:3:\"zip\";s:14:\"sportshero.zip\";s:3:\"uid\";s:32:\"8de7a145f32a362d618d2595ffa2f724\";s:3:\"img\";s:21:\"sportshero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-image-hero/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"720\";s:11:\"description\";s:113:\"<span class=\"ttm_content\">An sports themed image hero block with buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:27;a:20:{s:2:\"id\";s:2:\"28\";s:5:\"title\";s:12:\"Twitter Feed\";s:5:\"alias\";s:12:\"twitter-feed\";s:3:\"zip\";s:16:\"twitter-feed.zip\";s:3:\"uid\";s:32:\"efbfc2af5da5258e7b7bed8598e483cc\";s:3:\"img\";s:23:\"twitter-feed/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-twitter-feed/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"640\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a Twitter stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Twitter Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:28;a:20:{s:2:\"id\";s:2:\"29\";s:5:\"title\";s:13:\"Vimeo Gallery\";s:5:\"alias\";s:13:\"vimeo-gallery\";s:3:\"zip\";s:17:\"vimeo-gallery.zip\";s:3:\"uid\";s:32:\"fa824ce1ff3942ec268fc9eda60df539\";s:3:\"img\";s:24:\"vimeo-gallery/slider.jpg\";s:7:\"preview\";s:57:\"http://revolution.themepunch.com/wordpress-vimeo-gallery/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"692\";s:11:\"description\";s:170:\"<span class=\"ttm_content\">This slider is automatically populated by a Vimeo stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:412:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Vimeo Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:29;a:20:{s:2:\"id\";s:2:\"30\";s:5:\"title\";s:10:\"Vimeo Hero\";s:5:\"alias\";s:9:\"vimeohero\";s:3:\"zip\";s:13:\"vimeohero.zip\";s:3:\"uid\";s:32:\"c575575f96173d88589cddcb06120b77\";s:3:\"img\";s:20:\"vimeohero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-hero-vimeo/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:116:\"<span class=\"ttm_content\">A commonly used Vimeo video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:30;a:20:{s:2:\"id\";s:2:\"31\";s:5:\"title\";s:16:\"Web Product Dark\";s:5:\"alias\";s:16:\"web-product-dark\";s:3:\"zip\";s:20:\"web-product-dark.zip\";s:3:\"uid\";s:32:\"39b872cf0608e63c3a503e58374dc30a\";s:3:\"img\";s:27:\"web-product-dark/slider.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/wordpress-frontpage-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:31;a:20:{s:2:\"id\";s:2:\"32\";s:5:\"title\";s:21:\"Web Product Dark Hero\";s:5:\"alias\";s:21:\"web-product-dark-hero\";s:3:\"zip\";s:25:\"web-product-dark-hero.zip\";s:3:\"uid\";s:32:\"b6784e8925221f36677217979d26e6f0\";s:3:\"img\";s:32:\"web-product-dark-hero/slider.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-header-image/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:32;a:20:{s:2:\"id\";s:2:\"33\";s:5:\"title\";s:22:\"Web Product Light Hero\";s:5:\"alias\";s:22:\"web-product-light-hero\";s:3:\"zip\";s:26:\"web-product-light-hero.zip\";s:3:\"uid\";s:32:\"428e65d6aaa6ef775429989d50516492\";s:3:\"img\";s:33:\"web-product-light-hero/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/hero-image-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:162:\"<span class=\"ttm_content\">A modern hero block with three common devices. The screens of each device can be changed easily!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:289:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:33;a:20:{s:2:\"id\";s:2:\"34\";s:5:\"title\";s:17:\"Web Product Light\";s:5:\"alias\";s:15:\"webproductlight\";s:3:\"zip\";s:19:\"webproductlight.zip\";s:3:\"uid\";s:32:\"fa23dab5bf1139c6393828647a9de4e0\";s:3:\"img\";s:26:\"webproductlight/slider.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/wordpress-cover-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:194:\"<span class=\"ttm_content\">A front-page slider that can be used as an intro for your website. Navigate by using mouse-wheel scroll or the layer-based menu.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:583:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Instructions for <a href=\"https://www.themepunch.com/faq/modify-burger-menu/\" target=\"_blank\">changing the menu</a>.</span><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:34;a:20:{s:2:\"id\";s:2:\"35\";s:5:\"title\";s:15:\"Youtube Gallery\";s:5:\"alias\";s:15:\"youtube-gallery\";s:3:\"zip\";s:19:\"youtube-gallery.zip\";s:3:\"uid\";s:32:\"ee9e4928ac74f5f0c0b697ce708f5aa7\";s:3:\"img\";s:26:\"youtube-gallery/slider.jpg\";s:7:\"preview\";s:59:\"http://revolution.themepunch.com/wordpress-youtube-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\"> This slider is automatically populated by a YouTube stream. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:414:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"YouTube Stream\"</a>. Make sure to input your correct API information in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:11:\"socialmedia\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:35;a:20:{s:2:\"id\";s:2:\"36\";s:5:\"title\";s:12:\"Youtube Hero\";s:5:\"alias\";s:11:\"youtubehero\";s:3:\"zip\";s:15:\"youtubehero.zip\";s:3:\"uid\";s:32:\"e0b2c12a45841bdf21cb96305f2c85bf\";s:3:\"img\";s:22:\"youtubehero/slider.jpg\";s:7:\"preview\";s:58:\"http://revolution.themepunch.com/wordpress-youtube-header/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:104:\"<span class=\"ttm_content\">A YouTube video background hero block.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:633:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/enable-sound-for-the-youtube-hero-template/\" target=\"_blank\">enable sound for the background video</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:15:\"Revolution Base\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:36;a:20:{s:2:\"id\";s:2:\"37\";s:5:\"title\";s:13:\"Scroll Effect\";s:5:\"alias\";s:13:\"scroll-effect\";s:3:\"zip\";s:17:\"scroll-effect.zip\";s:3:\"uid\";s:32:\"417f59e9db87aa7e47c8509eb88d4af6\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/big-bold-fullscreen-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen slider with a unique scroll effect and big, bold text.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:37;a:20:{s:2:\"id\";s:2:\"38\";s:5:\"title\";s:12:\"Content Zoom\";s:5:\"alias\";s:12:\"content-zoom\";s:3:\"zip\";s:16:\"content-zoom.zip\";s:3:\"uid\";s:32:\"42ef8cdb70d42ec6ff6fa3b69a027b5f\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/content-zoom-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:243:\"<span class=\"ttm_content\">A very unique full-width slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:38;a:20:{s:2:\"id\";s:2:\"39\";s:5:\"title\";s:13:\"Food Carousel\";s:5:\"alias\";s:13:\"food-carousel\";s:3:\"zip\";s:17:\"food-carousel.zip\";s:3:\"uid\";s:32:\"a7bf54527b6658a0a308c70c729779fe\";s:3:\"img\";s:29:\"foodcarousel/slider_cover.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/food-carousel-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:267:\"<span class=\"ttm_content\">A fancy carousel with detail content on each slide. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to show and hide layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:39;a:20:{s:2:\"id\";s:2:\"40\";s:5:\"title\";s:14:\"Rotating Words\";s:5:\"alias\";s:14:\"rotating-words\";s:3:\"zip\";s:18:\"rotating-words.zip\";s:3:\"uid\";s:32:\"70190463d9376f278c8197b7b2ef6c1b\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";s:7:\"preview\";s:53:\"http://revolution.themepunch.com/rotating-words-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:134:\"<span class=\"ttm_content\">A full-screen hero block with unique animated text and blur effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:495:\"<span class=\"ttm_content\">This is a \"Default\" hero slider. Edit the slide to change the background media and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:40;a:20:{s:2:\"id\";s:2:\"41\";s:5:\"title\";s:22:\"Travel Static Captions\";s:5:\"alias\";s:22:\"travel-static-captions\";s:3:\"zip\";s:26:\"travel-static-captions.zip\";s:3:\"uid\";s:32:\"bbe7d61c7c741ebc7aa1ce1082b0cb71\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";s:7:\"preview\";s:50:\"http://revolution.themepunch.com/travel-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A slideshow example with static captions layers above a rotating image background.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:41;a:20:{s:2:\"id\";s:2:\"42\";s:5:\"title\";s:7:\"Concept\";s:5:\"alias\";s:7:\"concept\";s:3:\"zip\";s:11:\"concept.zip\";s:3:\"uid\";s:32:\"47cb06083e87503762f6746725117a3c\";s:3:\"img\";s:18:\"concept/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/fullscreen-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:232:\"<span class=\"ttm_content\">A full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:42;a:20:{s:2:\"id\";s:2:\"43\";s:5:\"title\";s:15:\"True Fullscreen\";s:5:\"alias\";s:17:\"fullscreen-button\";s:3:\"zip\";s:21:\"fullscreen-button.zip\";s:3:\"uid\";s:32:\"618a43bdf89333b555531f6d6ecde359\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/wordpress-sidebar-slideshow/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A slider with a full-screen button that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:297:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:43;a:20:{s:2:\"id\";s:2:\"44\";s:5:\"title\";s:16:\"Creative Freedom\";s:5:\"alias\";s:15:\"creativefreedom\";s:3:\"zip\";s:19:\"creativefreedom.zip\";s:3:\"uid\";s:32:\"8902bf6c93126c2c6323626b9e872621\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/wordpress-touch-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A full-screen slider with a unique vertical navigation and 3D-parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:290:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images, videos and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:44;a:20:{s:2:\"id\";s:2:\"45\";s:5:\"title\";s:17:\"3D Parallax Scene\";s:5:\"alias\";s:13:\"parallaxscene\";s:3:\"zip\";s:17:\"parallaxscene.zip\";s:3:\"uid\";s:32:\"51566f1ce649708e97a0f5dfaf05ea19\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-3d-parallax/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:328:\"<span class=\"ttm_content\">A 3D-parallax hero scene with mouse-controlled effects. Smart image arrangement creates a convincing 3D effect. Tooltips are shown using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:45;a:20:{s:2:\"id\";s:2:\"46\";s:5:\"title\";s:10:\"Wow Factor\";s:5:\"alias\";s:15:\"slidingoverlays\";s:3:\"zip\";s:19:\"slidingoverlays.zip\";s:3:\"uid\";s:32:\"18002d17e8bc7ca61b0951f5305a759e\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/responsive-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:106:\"<span class=\"ttm_content\">A 3D-parallax effect full-screen slider.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:446:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:46;a:20:{s:2:\"id\";s:2:\"47\";s:5:\"title\";s:14:\"3D Web Product\";s:5:\"alias\";s:25:\"web-product-light-hero-3d\";s:3:\"zip\";s:29:\"web-product-light-hero-3d.zip\";s:3:\"uid\";s:32:\"efd345c5da805414093e46066cefd751\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/wordpress-3d-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"668\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A 3D-parallax hero scene slider with a convincing depth-effect and animated clouds.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:47;a:20:{s:2:\"id\";s:2:\"48\";s:5:\"title\";s:15:\"WooCommerce Big\";s:5:\"alias\";s:6:\"woobig\";s:3:\"zip\";s:10:\"woobig.zip\";s:3:\"uid\";s:32:\"bfb09a39656c7c80e86b468fc5b3403c\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:48;a:20:{s:2:\"id\";s:2:\"49\";s:5:\"title\";s:17:\"WooCommerce Small\";s:5:\"alias\";s:16:\"woocommercesmall\";s:3:\"zip\";s:20:\"woocommercesmall.zip\";s:3:\"uid\";s:32:\"b17c2adcc5c4c4b68a7ac6fee32fa030\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";s:7:\"preview\";s:52:\"http://revolution.themepunch.com/woocommerce-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.1\";s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"266\";s:11:\"description\";s:174:\" <span class=\"ttm_content\">This slider is automatically populated by WooCommerce posts. Just one slide is needed to show a whole feed!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"WooCommerce Slider\"</a>. Make sure to select the products you want to show in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:49;a:20:{s:2:\"id\";s:2:\"50\";s:5:\"title\";s:17:\"Restaurant Header\";s:5:\"alias\";s:10:\"finedining\";s:3:\"zip\";s:14:\"finedining.zip\";s:3:\"uid\";s:32:\"03481a9e258501fbe3888b48830ea845\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/restaurant-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:275:\"<span class=\"ttm_content\">A full-screen hero block slider that shows different background layers on button hover using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:50;a:20:{s:2:\"id\";s:2:\"51\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:12:\"agency-intro\";s:3:\"zip\";s:16:\"agency-intro.zip\";s:3:\"uid\";s:32:\"e9be2afdd55a0c8d0d8d0cc12ba4c82f\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";s:7:\"preview\";s:60:\"http://revolution.themepunch.com/agency-website-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:302:\" <span class=\"ttm_content\">A full-screen hero block slider with ken burns effect and video modal on button click. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:51;a:20:{s:2:\"id\";s:2:\"52\";s:5:\"title\";s:11:\"Team Slider\";s:5:\"alias\";s:7:\"ourteam\";s:3:\"zip\";s:11:\"ourteam.zip\";s:3:\"uid\";s:32:\"d8eb1fec07a79202d1118bb17f70c233\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";s:7:\"preview\";s:74:\"http://revolution.themepunch.com/thumbnail-hover-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:303:\"<span class=\"ttm_content\">A team slider that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:657:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:52;a:20:{s:2:\"id\";s:2:\"53\";s:5:\"title\";s:13:\"Team Carousel\";s:5:\"alias\";s:17:\"our-team-carousel\";s:3:\"zip\";s:21:\"our-team-carousel.zip\";s:3:\"uid\";s:32:\"37656d5dcab1f265c025cb2a3d669809\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";s:7:\"preview\";s:83:\"http://revolution.themepunch.com/thumbnail-hover-carousel-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:306:\" <span class=\"ttm_content\">A team carousel that changes slides and displays additional information on thumbnail hover. It uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to achieve this effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:659:\"<span class=\"ttm_content\">This is a \"Default\" content carousel. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\nLearn how to <a href=\"https://www.themepunch.com/faq/modify-thumbnails-for-our-team-template/\" target=\"_blank\">modify the thumbnails</a><br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:53;a:20:{s:2:\"id\";s:2:\"54\";s:5:\"title\";s:17:\"4K Youtube Slider\";s:5:\"alias\";s:13:\"betteryoutube\";s:3:\"zip\";s:17:\"betteryoutube.zip\";s:3:\"uid\";s:32:\"d7c5fef9f257037d7a148038aa2a1857\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";s:7:\"preview\";s:94:\"http://revolution.themepunch.com/fullscreen-4k-youtube-video-gallery-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.1.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"675\";s:11:\"description\";s:293:\" <span class=\"ttm_content\">A full-screen youtube gallery with 4K videos as an example. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to breathe life into navigation elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:535:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change videos and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:54;a:20:{s:2:\"id\";s:2:\"55\";s:5:\"title\";s:21:\"Agency Website Header\";s:5:\"alias\";s:19:\"agencywebsiteheader\";s:3:\"zip\";s:23:\"agencywebsiteheader.zip\";s:3:\"uid\";s:32:\"c11d272c87277a7a38d9e7fd13e27947\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/fullscreen-hero-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:245:\" <span class=\"ttm_content\">A very unique full-screen slider that uses <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:509:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:55;a:20:{s:2:\"id\";s:2:\"56\";s:5:\"title\";s:11:\"Coming Soon\";s:5:\"alias\";s:10:\"comingsoon\";s:3:\"zip\";s:14:\"comingsoon.zip\";s:3:\"uid\";s:32:\"0f89edf995512e6d6e864a2ee7221829\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";s:7:\"preview\";s:79:\"http://revolution.themepunch.com/coming-soon-wordpress-under-construction-site/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:299:\"<span class=\"ttm_content\">A full-screen slider that can be used as a \"Coming Soon\" page. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a> are used to achieve various interaction possibilities.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:638:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\nInstructions for <a href=\"https://www.themepunch.com/faq/change-date-for-coming-soon-template/\" target=\"_blank\">how to change the date.</a><br /><br />\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:56;a:20:{s:2:\"id\";s:2:\"57\";s:5:\"title\";s:20:\"Christmas Snow Scene\";s:5:\"alias\";s:9:\"snowscene\";s:3:\"zip\";s:13:\"snowscene.zip\";s:3:\"uid\";s:32:\"a747bf0837caff86c62419a746690209\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";s:7:\"preview\";s:54:\"http://revolution.themepunch.com/christmas-snow-scene/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.0.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:141:\"<span class=\"ttm_content\">A slider with multiple christmas themed slides and a neat snow fall effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:485:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:57;a:20:{s:2:\"id\";s:2:\"58\";s:5:\"title\";s:15:\"Rock Band Music\";s:5:\"alias\";s:8:\"rockband\";s:3:\"zip\";s:12:\"rockband.zip\";s:3:\"uid\";s:32:\"5f557a5fad2fd6ca982a6ae6e9619637\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";s:7:\"preview\";s:80:\"http://revolution.themepunch.com/rock-band-music-theme-slider-revolution-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:140:\" <span class=\"ttm_content\">A rock band themed hero block slider with an embedded SoundCloud element.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:464:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background video and texts.<br/><br/></span>\r\nScreencast for <a href=\"https://www.youtube.com/playlist?list=PLSCdqDWVMJPPXEuOEqYEQMAsp0vAYw52_\" target=\"_blank\">mobile video</a> considerations.</a>\r\n<br/><br/>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-24 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:58;a:20:{s:2:\"id\";s:2:\"59\";s:5:\"title\";s:18:\"Sleek Landing Page\";s:5:\"alias\";s:16:\"sleeklandingpage\";s:3:\"zip\";s:20:\"sleeklandingpage.zip\";s:3:\"uid\";s:32:\"07f7f2608936a8ae226213b7d99eee3f\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";s:7:\"preview\";s:70:\"http://revolution.themepunch.com/landing-page-free-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">A full-screen slider that can be used as an App-Landing-Page. The object layers and custom animations create a unique effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-02-22 13:21:33\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:59;a:20:{s:2:\"id\";s:2:\"60\";s:5:\"title\";s:16:\"App Landing Page\";s:5:\"alias\";s:14:\"applandingpage\";s:3:\"zip\";s:18:\"applandingpage.zip\";s:3:\"uid\";s:32:\"38eb600893c1484ab8fd2a3dce3678d7\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/app-landing-page-free-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">A full-screen hero block that can be used as an app landing page. The detail view is build using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:371:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>It might be helpful to use the \"hide/show layer\" feature to efficiently edit all content.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:60;a:20:{s:2:\"id\";s:2:\"61\";s:5:\"title\";s:10:\"Desk Scene\";s:5:\"alias\";s:9:\"deskscene\";s:3:\"zip\";s:13:\"deskscene.zip\";s:3:\"uid\";s:32:\"172a1a89a3e3b333cb4dbeb238f534c5\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";s:7:\"preview\";s:49:\"http://revolution.themepunch.com/hero-desk-scene/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:135:\"<span class=\"ttm_content\">A beautiful desk scene with a cool reveal effect when scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:61;a:20:{s:2:\"id\";s:2:\"62\";s:5:\"title\";s:17:\"Clean News Slider\";s:5:\"alias\";s:15:\"cleannewsslider\";s:3:\"zip\";s:19:\"cleannewsslider.zip\";s:3:\"uid\";s:32:\"82c3f521fe31b80984be0f19e1a9899e\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:132:\"<span class=\"ttm_content\">A slideshow example with clean content and thumbnail navigation.</span>\r\n<span class=\"ttm_space\"></span>\r\n\";s:11:\"setup_notes\";s:282:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:62;a:20:{s:2:\"id\";s:2:\"63\";s:5:\"title\";s:13:\"Image Gallery\";s:5:\"alias\";s:12:\"imagegallery\";s:3:\"zip\";s:16:\"imagegallery.zip\";s:3:\"uid\";s:32:\"cef1d75357df2cb53b990c74a214813e\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">A photo gallery suitable to display your images using <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to their potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:63;a:20:{s:2:\"id\";s:2:\"64\";s:5:\"title\";s:19:\"Standard WP Gallery\";s:5:\"alias\";s:19:\"standard-wp-gallery\";s:3:\"zip\";s:23:\"standard-wp-gallery.zip\";s:3:\"uid\";s:32:\"632035b8a27652d8081dbdfa343dc93d\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";s:7:\"preview\";s:64:\"http://revolution.themepunch.com/wordpress-photo-gallery-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:3:\"667\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A photo gallery that uses the \"Standard WP Gallery\" add-on to display images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:407:\"<span class=\"ttm_content\">Please follow the setup guide on the \"Standard WP Gallery\" add-on page.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";s:166:\"[{\"path\":\"revslider-gallery-addon\\/revslider-gallery-addon.php\",\"name\":\"WP Gallery AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/wordpress-photo-gallery-plugin\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:64;a:20:{s:2:\"id\";s:2:\"65\";s:5:\"title\";s:21:\"Clean News Post Based\";s:5:\"alias\";s:21:\"clean-news-post-based\";s:3:\"zip\";s:25:\"clean-news-post-based.zip\";s:3:\"uid\";s:32:\"f4cf5bbe51afa5a361754bb081cbabf2\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";s:7:\"preview\";s:55:\"http://revolution.themepunch.com/wordpress-news-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:125:\"<span class=\"ttm_content\"> This slider is automatically populated by WordPress posts.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:423:\"<span class=\"ttm_content\">The content source is set to <a href=\"https://www.themepunch.com/slider-revolution/module-content/#flickr\" target=\"_blank\">\"Post-Based Slider\"</a>. Make sure to select the post type you want to display in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:9:\"postbased\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:65;a:20:{s:2:\"id\";s:2:\"66\";s:5:\"title\";s:22:\"Interactive Whiteboard\";s:5:\"alias\";s:21:\"interactivewhiteboard\";s:3:\"zip\";s:25:\"interactivewhiteboard.zip\";s:3:\"uid\";s:32:\"058b4af535d6c6c7bcec5225845e3eb4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";s:7:\"preview\";s:77:\"http://revolution.themepunch.com/interactive-whiteboard-animation-free-addon/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:5:\"5.2.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:269:\"<span class=\"ttm_content\">This is the example slider from the Whiteboard add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used to achieve certain effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:541:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/whiteboard-addon/\" target=\"_blank\">Whiteboard add-on</a> to be installed. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:185:\"[{\"path\":\"revslider-whiteboard-addon\\/revslider-whiteboard-addon.php\",\"name\":\"Whiteboard AddOn\",\"url\":\"http:\\/\\/revolution.themepunch.com\\/interactive-whiteboard-animation-free-addon\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:66;a:20:{s:2:\"id\";s:2:\"68\";s:5:\"title\";s:17:\"Innovation Slider\";s:5:\"alias\";s:10:\"innovation\";s:3:\"zip\";s:14:\"innovation.zip\";s:3:\"uid\";s:32:\"d3440b69126d9c186fddc713b18b0002\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2016/\";s:7:\"version\";s:5:\"1.0.5\";s:8:\"required\";s:7:\"5.2.3.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:258:\"<span class=\"ttm_content\">A full-screen slider with an elegant fade-out parallax effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:493:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images, videos and texts.<br/>For further configuration options please view the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">\"Custom CSS/JS\"</a> section in the slider settings.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"2016-03-29 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:67;a:23:{s:2:\"id\";s:2:\"69\";s:5:\"title\";s:25:\"Dark Content Block - Menu\";s:5:\"alias\";s:24:\"dark-fullsite-block-menu\";s:3:\"zip\";s:34:\"packs/dark-fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"bf4bd226719d3c3d3146592976e31ca1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:68;a:23:{s:2:\"id\";s:2:\"70\";s:5:\"title\";s:25:\"Dark Content Block - Hero\";s:5:\"alias\";s:21:\"dark-fullsite-block-1\";s:3:\"zip\";s:31:\"packs/dark-fullsite-block-1.zip\";s:3:\"uid\";s:32:\"d8859245fe600288ca932dc29aca751f\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:69;a:23:{s:2:\"id\";s:2:\"71\";s:5:\"title\";s:26:\"Dark Content Block - About\";s:5:\"alias\";s:27:\"dark-fullsite-block-2-about\";s:3:\"zip\";s:37:\"packs/dark-fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"298401901521a197a8294c1b4f73df3e\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:70;a:23:{s:2:\"id\";s:2:\"72\";s:5:\"title\";s:29:\"Dark Content Block - Services\";s:5:\"alias\";s:30:\"dark-fullsite-block-3-services\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"8da3ed605472ed6a26c745fb52f85f82\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:71;a:23:{s:2:\"id\";s:2:\"73\";s:5:\"title\";s:29:\"Dark Content Block - Products\";s:5:\"alias\";s:30:\"dark-fullsite-block-4-products\";s:3:\"zip\";s:40:\"packs/dark-fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"99e4f40399d20261a6131043d0e50b0c\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:422:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\r\n\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:72;a:23:{s:2:\"id\";s:2:\"74\";s:5:\"title\";s:33:\"Dark Content Block - Testimonials\";s:5:\"alias\";s:34:\"dark-fullsite-block-5-testimonials\";s:3:\"zip\";s:44:\"packs/dark-fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"2f9121e0eedd51afe85e233d0743acab\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:73;a:23:{s:2:\"id\";s:2:\"75\";s:5:\"title\";s:28:\"Dark Content Block - Callout\";s:5:\"alias\";s:29:\"dark-fullsite-block-6-callout\";s:3:\"zip\";s:39:\"packs/dark-fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"55fbecb113ff21f050be7adc08637329\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:74;a:23:{s:2:\"id\";s:2:\"76\";s:5:\"title\";s:27:\"Dark Content Block - Footer\";s:5:\"alias\";s:28:\"dark-fullsite-block-7-footer\";s:3:\"zip\";s:38:\"packs/dark-fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"2ff517f5c7c54e3e0c2dd733cfd3400e\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:75;a:23:{s:2:\"id\";s:2:\"77\";s:5:\"title\";s:26:\"Light Content Block - Menu\";s:5:\"alias\";s:19:\"fullsite-block-menu\";s:3:\"zip\";s:29:\"packs/fullsite-block-menu.zip\";s:3:\"uid\";s:32:\"8010971f34387d5f94a1f4e577ef382a\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:76;a:23:{s:2:\"id\";s:2:\"78\";s:5:\"title\";s:26:\"Light Content Block - Hero\";s:5:\"alias\";s:15:\"fullsite-block1\";s:3:\"zip\";s:25:\"packs/fullsite-block1.zip\";s:3:\"uid\";s:32:\"45bf7179843e01ce112e8ec754b0455c\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:77;a:23:{s:2:\"id\";s:2:\"79\";s:5:\"title\";s:27:\"Light Content Block - About\";s:5:\"alias\";s:22:\"fullsite-block-2-about\";s:3:\"zip\";s:32:\"packs/fullsite-block-2-about.zip\";s:3:\"uid\";s:32:\"8402b460638a746d36433cb161440b7d\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:78;a:23:{s:2:\"id\";s:2:\"80\";s:5:\"title\";s:30:\"Light Content Block - Services\";s:5:\"alias\";s:25:\"fullsite-block-3-services\";s:3:\"zip\";s:35:\"packs/fullsite-block-3-services.zip\";s:3:\"uid\";s:32:\"7b8cea27f4d6ae17c5e1eae12457bd06\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:79;a:23:{s:2:\"id\";s:2:\"81\";s:5:\"title\";s:30:\"Light Content Block - Products\";s:5:\"alias\";s:25:\"fullsite-block-4-products\";s:3:\"zip\";s:35:\"packs/fullsite-block-4-products.zip\";s:3:\"uid\";s:32:\"d148935362d7122636cda0635eae4be7\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:80;a:23:{s:2:\"id\";s:2:\"82\";s:5:\"title\";s:34:\"Light Content Block - Testimonials\";s:5:\"alias\";s:29:\"fullsite-block-5-testimonials\";s:3:\"zip\";s:39:\"packs/fullsite-block-5-testimonials.zip\";s:3:\"uid\";s:32:\"06255bfd421e40f71fa8197b839dbf03\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:81;a:23:{s:2:\"id\";s:2:\"83\";s:5:\"title\";s:29:\"Light Content Block - Callout\";s:5:\"alias\";s:24:\"fullsite-block-6-callout\";s:3:\"zip\";s:34:\"packs/fullsite-block-6-callout.zip\";s:3:\"uid\";s:32:\"8a88c3447676b613ec5db2fe5d63315c\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:82;a:23:{s:2:\"id\";s:2:\"84\";s:5:\"title\";s:28:\"Light Content Block - Footer\";s:5:\"alias\";s:23:\"fullsite-block-7-footer\";s:3:\"zip\";s:33:\"packs/fullsite-block-7-footer.zip\";s:3:\"uid\";s:32:\"34300b4407a2093eb2e1e08868fa8319\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:83;a:20:{s:2:\"id\";s:2:\"85\";s:5:\"title\";s:12:\"Tech Journal\";s:5:\"alias\";s:11:\"techjournal\";s:3:\"zip\";s:15:\"techjournal.zip\";s:3:\"uid\";s:32:\"7f92d70d1c108378f915b18c2ceb71d6\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:84;a:20:{s:2:\"id\";s:2:\"86\";s:5:\"title\";s:14:\"Car Dealership\";s:5:\"alias\";s:13:\"cardealership\";s:3:\"zip\";s:17:\"cardealership.zip\";s:3:\"uid\";s:32:\"bb010838855a8ae4d1dd68e139bf169e\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/car-dealership-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"650\";s:11:\"description\";s:130:\"<span class=\"ttm_content\">A full-width slider with navigation direction-based transitions.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:85;a:20:{s:2:\"id\";s:2:\"87\";s:5:\"title\";s:22:\"FullScreen Menu Slider\";s:5:\"alias\";s:14:\"fullscreenmenu\";s:3:\"zip\";s:18:\"fullscreenmenu.zip\";s:3:\"uid\";s:32:\"6de81d74c4bf193e2e274d43038adc85\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-fullscreen-menu/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:131:\"<span class=\"ttm_content\">A full-screen slider that contains a menu with slide blur effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:86;a:20:{s:2:\"id\";s:2:\"88\";s:5:\"title\";s:18:\"Creative Frontpage\";s:5:\"alias\";s:17:\"creativefrontpage\";s:3:\"zip\";s:21:\"creativefrontpage.zip\";s:3:\"uid\";s:32:\"0636cb368af3bcaa2f68eb0ebefe6439\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/best-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:246:\"<span class=\"ttm_content\">A full-screen slider with hidden slides that are triggered via  <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\" target=\"_blank\">\"Layer Actions\"</a>.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:87;a:23:{s:2:\"id\";s:2:\"89\";s:5:\"title\";s:20:\"Website Builder Menu\";s:5:\"alias\";s:19:\"websitebuilder-menu\";s:3:\"zip\";s:29:\"packs/websitebuilder-menu.zip\";s:3:\"uid\";s:32:\"d9e6d9c961f123a3a4847b51fc3ba3a2\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:88;a:23:{s:2:\"id\";s:2:\"90\";s:5:\"title\";s:20:\"Website Builder Hero\";s:5:\"alias\";s:19:\"websitebuilder-hero\";s:3:\"zip\";s:29:\"packs/websitebuilder-hero.zip\";s:3:\"uid\";s:32:\"6cb2df9a41ad2e7865bb9bbea7e39cb5\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1230\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:89;a:23:{s:2:\"id\";s:2:\"91\";s:5:\"title\";s:23:\"Website Builder Clients\";s:5:\"alias\";s:22:\"websitebuilder-clients\";s:3:\"zip\";s:32:\"packs/websitebuilder-clients.zip\";s:3:\"uid\";s:32:\"050e59c43c9a693510d01f29532088cf\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"120\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:90;a:23:{s:2:\"id\";s:2:\"92\";s:5:\"title\";s:24:\"Website Builder Services\";s:5:\"alias\";s:23:\"websitebuilder-services\";s:3:\"zip\";s:33:\"packs/websitebuilder-services.zip\";s:3:\"uid\";s:32:\"48d56d67615efce619ae973ab4358c07\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"558\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:91;a:23:{s:2:\"id\";s:2:\"93\";s:5:\"title\";s:24:\"Website Builder Discover\";s:5:\"alias\";s:23:\"websitebuilder-discover\";s:3:\"zip\";s:33:\"packs/websitebuilder-discover.zip\";s:3:\"uid\";s:32:\"425a08a7be338daea3df02a07ff5c316\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"955\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:92;a:23:{s:2:\"id\";s:2:\"94\";s:5:\"title\";s:22:\"Website Builder Slider\";s:5:\"alias\";s:21:\"websitebuilder-slider\";s:3:\"zip\";s:31:\"packs/websitebuilder-slider.zip\";s:3:\"uid\";s:32:\"9d670b7335016accb590dc8d52bfb6f0\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:93;a:23:{s:2:\"id\";s:2:\"95\";s:5:\"title\";s:28:\"Website Builder CallToAction\";s:5:\"alias\";s:27:\"websitebuilder-calltoaction\";s:3:\"zip\";s:37:\"packs/websitebuilder-calltoaction.zip\";s:3:\"uid\";s:32:\"45851baf9e61f55ed9f5fa9d0beff77e\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"960\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:94;a:23:{s:2:\"id\";s:2:\"96\";s:5:\"title\";s:22:\"Website Builder Footer\";s:5:\"alias\";s:21:\"websitebuilder-footer\";s:3:\"zip\";s:31:\"packs/websitebuilder-footer.zip\";s:3:\"uid\";s:32:\"2732bbe66ef28219d6cc53ce8cc78863\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:95;a:20:{s:2:\"id\";s:2:\"97\";s:5:\"title\";s:21:\"Focus Parallax Effect\";s:5:\"alias\";s:13:\"focusparallax\";s:3:\"zip\";s:17:\"focusparallax.zip\";s:3:\"uid\";s:32:\"13bd15fb3ddf8b9841cb55b89389cc73\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";s:7:\"preview\";s:68:\" https://revolution.themepunch.com/parallax-effect-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:256:\"<span class=\"ttm_content\">A full-screen slider with mouse controlled parallax effects. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:415:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/>Some content is in <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">\"Static / Global Layers\"</a><br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:96;a:20:{s:2:\"id\";s:2:\"98\";s:5:\"title\";s:14:\"Duotone Slider\";s:5:\"alias\";s:7:\"duotone\";s:3:\"zip\";s:11:\"duotone.zip\";s:3:\"uid\";s:32:\"494862ceb6cb7c6658ad7cd36848cccd\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-header-image-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.4\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:252:\"<span class=\"ttm_content\">A full-screen slider with unique parallax scroll effect. <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:97;a:23:{s:2:\"id\";s:2:\"99\";s:5:\"title\";s:12:\"Minimal Menu\";s:5:\"alias\";s:6:\"r_menu\";s:3:\"zip\";s:16:\"packs/r_menu.zip\";s:3:\"uid\";s:32:\"30d6a6895db1a5f29b1679061551c9f0\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:98;a:23:{s:2:\"id\";s:3:\"100\";s:5:\"title\";s:12:\"Minimal Hero\";s:5:\"alias\";s:5:\"rhero\";s:3:\"zip\";s:16:\"packs/r_hero.zip\";s:3:\"uid\";s:32:\"b8b46186956f6e66ad0c08e4532bbbde\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"700\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:99;a:23:{s:2:\"id\";s:3:\"101\";s:5:\"title\";s:13:\"Minimal About\";s:5:\"alias\";s:7:\"r_about\";s:3:\"zip\";s:17:\"packs/r_about.zip\";s:3:\"uid\";s:32:\"343010c4b4c03f92888c3e9e95bc2bb1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:100;a:23:{s:2:\"id\";s:3:\"102\";s:5:\"title\";s:16:\"Minimal Products\";s:5:\"alias\";s:10:\"r_products\";s:3:\"zip\";s:20:\"packs/r_products.zip\";s:3:\"uid\";s:32:\"dda93e85c6a4456d132040147f087f39\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1100\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:101;a:23:{s:2:\"id\";s:3:\"103\";s:5:\"title\";s:12:\"Minimal Info\";s:5:\"alias\";s:6:\"r_info\";s:3:\"zip\";s:16:\"packs/r_info.zip\";s:3:\"uid\";s:32:\"d6e368e8fd4862174af6c980389ae530\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:102;a:20:{s:2:\"id\";s:3:\"104\";s:5:\"title\";s:18:\"Inspiration Header\";s:5:\"alias\";s:17:\"inspirationheader\";s:3:\"zip\";s:21:\"inspirationheader.zip\";s:3:\"uid\";s:32:\"69f04b2be0b618fa7e184af83b86b7e7\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/wordpress-theme-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This full-screen hero slider features sequentially animated texts and cool parallax elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:103;a:20:{s:2:\"id\";s:3:\"105\";s:5:\"title\";s:15:\"Magazine Slider\";s:5:\"alias\";s:13:\"magazineposts\";s:3:\"zip\";s:17:\"magazineposts.zip\";s:3:\"uid\";s:32:\"c562f3457e4edbd030959f7c5e6e0f7c\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-magazine-slider/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">A full-width slider with a mouse-controlled 3D-Parallax effect. Enjoy! <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on layers.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:104;a:20:{s:2:\"id\";s:3:\"106\";s:5:\"title\";s:11:\"News Header\";s:5:\"alias\";s:17:\"explorationheader\";s:3:\"zip\";s:21:\"explorationheader.zip\";s:3:\"uid\";s:32:\"8f20d5a868c90ded08b835fb9e8307d7\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/wordpress-news-header/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:288:\"<span class=\"ttm_content\">A full-screen slider that is a perfect fit for displaying news on your websites header! Check out <a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> to add links to buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:277:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:105;a:23:{s:2:\"id\";s:3:\"107\";s:5:\"title\";s:23:\"Minimal Website Package\";s:5:\"alias\";s:23:\"minimal-website-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:23:\"minimal-website-package\";s:3:\"img\";s:31:\"packages/template_group_1_1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/minimal-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"110\";s:11:\"description\";s:181:\"<span class=\"ttm_content\">The Minimal Website Template is a one-pager website with a unique background color change effect on scrolling down.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:890:\"<span class=\"ttm_content\">\r\nIn the <a href=\"https://https://www.themepunch.com/slider-revolution/custom-css-javascript/\" target=\"_blank\">Custom JavaScript</a> section of the \"Minimal Menu\" Template you can scroll down to the color change section.<br/>\r\nFor any elements you want to background color change in addition to the sites body, add this class to the <a href=\"https://www.themepunch.com/revslider-doc/layer-attributes/\" target=\"_blank\">Layers Attributes</a> \".tp-colorchange\".<br/><br/>\r\nIf you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:24:\"Minimal Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"4\";s:9:\"installed\";b:0;}i:106;a:23:{s:2:\"id\";s:3:\"108\";s:5:\"title\";s:23:\"Website Builder Package\";s:5:\"alias\";s:22:\"websitebuilder-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"websitebuilder-package\";s:3:\"img\";s:29:\"packages/template_group_2.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/wordpress-website-builder/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.2.5.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"60\";s:11:\"description\";s:191:\"<span class=\"ttm_content\">The Website Builder Package is a clean, usable collection website modules that can be used all together or each on their own.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Website Builder\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"3\";s:9:\"installed\";b:0;}i:107;a:23:{s:2:\"id\";s:3:\"109\";s:5:\"title\";s:26:\"Dark Content Block Package\";s:5:\"alias\";s:27:\"dark-fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"dark-fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_4.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/dark-wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Fullsite Dark\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"2\";s:9:\"installed\";b:0;}i:108;a:23:{s:2:\"id\";s:3:\"110\";s:5:\"title\";s:27:\"Light Content Block Package\";s:5:\"alias\";s:22:\"fullsite-block-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"fullsite-block-package\";s:3:\"img\";s:29:\"packages/template_group_3.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/wordpress-parallax-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.2.5\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">This Minimal Website Template has some sleek parallax effects and on-demand loading modules.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:8:\"Fullsite\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"1\";s:9:\"installed\";b:0;}i:109;a:20:{s:2:\"id\";s:3:\"111\";s:5:\"title\";s:17:\"Typewriter Effect\";s:5:\"alias\";s:16:\"typewritereffect\";s:3:\"zip\";s:20:\"typewritereffect.zip\";s:3:\"uid\";s:32:\"d6f8bae06cc4a7b158d680c01e59ddc2\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/wordpress-typewriter-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:263:\"<span class=\"ttm_content\">This is the example slider from the Typewriter add-on preview.<br/><a href=\"https://www.themepunch.com/revslider-doc/layer-settings/#layeractions\">\"Layer Actions\"</a> are used for links on buttons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:403:\"<span class=\"ttm_content\">This slider template requires the <a href=\"https://www.themepunch.com/slider-revolution/typewriter-addon/\" target=\"_blank\">Typewriter add-on</a> to be installed. Edit the slides to change images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:110;a:20:{s:2:\"id\";s:3:\"112\";s:5:\"title\";s:17:\"Blend Mode Header\";s:5:\"alias\";s:15:\"blendmodeheader\";s:3:\"zip\";s:19:\"blendmodeheader.zip\";s:3:\"uid\";s:32:\"2e44e976596d757aab40ffa28086dcf9\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";s:7:\"preview\";s:57:\"https://revolution.themepunch.com/blend-mode-hero-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">This full-screen hero header with HMTL5 background video, utilizes the new 5.3 blend mode effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:300:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:111;a:23:{s:2:\"id\";s:3:\"113\";s:5:\"title\";s:17:\"Themeplicity Menu\";s:5:\"alias\";s:17:\"themeplicity_menu\";s:3:\"zip\";s:27:\"packs/themeplicity_menu.zip\";s:3:\"uid\";s:32:\"7d5c1e75eaafa63683895a32a62f4ce0\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:112;a:23:{s:2:\"id\";s:3:\"114\";s:5:\"title\";s:19:\"Themeplicity Header\";s:5:\"alias\";s:19:\"themeplicity_header\";s:3:\"zip\";s:29:\"packs/themeplicity_header.zip\";s:3:\"uid\";s:32:\"907091e4d58acc7d12f802de2f280b7d\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1000\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:113;a:23:{s:2:\"id\";s:3:\"115\";s:5:\"title\";s:18:\"Themeplicity Offer\";s:5:\"alias\";s:18:\"themeplicity_offer\";s:3:\"zip\";s:28:\"packs/themeplicity_offer.zip\";s:3:\"uid\";s:32:\"1bd8f9aa2f3e340449664c65ba17fb51\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"330\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:114;a:23:{s:2:\"id\";s:3:\"116\";s:5:\"title\";s:23:\"Themeplicity What We Do\";s:5:\"alias\";s:21:\"themeplicity_whatwedo\";s:3:\"zip\";s:31:\"packs/themeplicity_whatwedo.zip\";s:3:\"uid\";s:32:\"aa800a44b5a3eab30414dde1f32bfed7\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:115;a:23:{s:2:\"id\";s:3:\"117\";s:5:\"title\";s:21:\"Themeplicity Projects\";s:5:\"alias\";s:21:\"themeplicity_projects\";s:3:\"zip\";s:31:\"packs/themeplicity_projects.zip\";s:3:\"uid\";s:32:\"5f61b3a13033ba6a51a18270163e0a50\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"813\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:116;a:23:{s:2:\"id\";s:3:\"118\";s:5:\"title\";s:24:\"Themeplicity Whats Great\";s:5:\"alias\";s:23:\"themeplicity_whatsgreat\";s:3:\"zip\";s:33:\"packs/themeplicity_whatsgreat.zip\";s:3:\"uid\";s:32:\"ce9faf8c55ed2e33e091b23667e7173b\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:117;a:23:{s:2:\"id\";s:3:\"119\";s:5:\"title\";s:19:\"Themeplicity Tables\";s:5:\"alias\";s:19:\"themeplicity_tables\";s:3:\"zip\";s:29:\"packs/themeplicity_tables.zip\";s:3:\"uid\";s:32:\"f28bb4cd20ec1f29a1de7da5ad09c293\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1059\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:118;a:23:{s:2:\"id\";s:3:\"120\";s:5:\"title\";s:24:\"Themeplicity Contactform\";s:5:\"alias\";s:24:\"themeplicity_contactform\";s:3:\"zip\";s:34:\"packs/themeplicity_contactform.zip\";s:3:\"uid\";s:32:\"3e59da970f534490774fa8e053f5b5ed\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:4:\"1067\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:119;a:23:{s:2:\"id\";s:3:\"121\";s:5:\"title\";s:19:\"Themeplicity Footer\";s:5:\"alias\";s:19:\"themeplicity_footer\";s:3:\"zip\";s:29:\"packs/themeplicity_footer.zip\";s:3:\"uid\";s:32:\"89eeb0b4b852c5f743e1bd76e3e8f2ef\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"780\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:120;a:23:{s:2:\"id\";s:3:\"122\";s:5:\"title\";s:20:\"Themeplicity Package\";s:5:\"alias\";s:20:\"themeplicity-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:20:\"themeplicity-package\";s:3:\"img\";s:38:\"packages/templatepack_themeplicity.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Themeplicity Website Template uses the new groups & rows feature introduced in 5.3 to its full potential.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:29:\"Themeplicity Website Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"5\";s:9:\"installed\";b:0;}i:121;a:23:{s:2:\"id\";s:3:\"123\";s:5:\"title\";s:19:\"Nice And Clean Menu\";s:5:\"alias\";s:17:\"NiceAndClean_Menu\";s:3:\"zip\";s:27:\"packs/NiceAndClean_Menu.zip\";s:3:\"uid\";s:32:\"3f8c01e26c7446428e045c4b1180776d\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:2:\"90\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:122;a:23:{s:2:\"id\";s:3:\"124\";s:5:\"title\";s:21:\"Nice And Clean Header\";s:5:\"alias\";s:19:\"NiceAndClean_Header\";s:3:\"zip\";s:29:\"packs/NiceAndClean_Header.zip\";s:3:\"uid\";s:32:\"76931033addb20a62557c2845a4d6a11\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:123;a:23:{s:2:\"id\";s:3:\"125\";s:5:\"title\";s:23:\"Nice And Clean Services\";s:5:\"alias\";s:21:\"NiceAndClean_Services\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Services.zip\";s:3:\"uid\";s:32:\"02f72ec606800c8215bcadea09624e87\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"360\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:124;a:23:{s:2:\"id\";s:3:\"126\";s:5:\"title\";s:20:\"Nice And Clean About\";s:5:\"alias\";s:18:\"NiceAndClean_About\";s:3:\"zip\";s:28:\"packs/NiceAndClean_About.zip\";s:3:\"uid\";s:32:\"9510f6fdbb8e9473e8c22f692a6bc89f\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:125;a:23:{s:2:\"id\";s:3:\"127\";s:5:\"title\";s:20:\"Nice And Clean Video\";s:5:\"alias\";s:18:\"niceandclean_video\";s:3:\"zip\";s:28:\"packs/niceandclean_video.zip\";s:3:\"uid\";s:32:\"2bb9e1ad329435cc500542d0c7025e15\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:126;a:23:{s:2:\"id\";s:3:\"128\";s:5:\"title\";s:25:\"Nice And Clean Highlights\";s:5:\"alias\";s:23:\"niceandclean_highlights\";s:3:\"zip\";s:33:\"packs/niceandclean_highlights.zip\";s:3:\"uid\";s:32:\"ff396af163a79d2d5b35db17c1ea7aa6\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:127;a:23:{s:2:\"id\";s:3:\"129\";s:5:\"title\";s:23:\"Nice And Clean Projects\";s:5:\"alias\";s:21:\"NiceAndClean_Projects\";s:3:\"zip\";s:31:\"packs/NiceAndClean_Projects.zip\";s:3:\"uid\";s:32:\"1e6695959ef83f8975b52289c08a4d44\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:128;a:23:{s:2:\"id\";s:3:\"130\";s:5:\"title\";s:25:\"Nice And Clean TextBlocks\";s:5:\"alias\";s:23:\"niceandclean_textblocks\";s:3:\"zip\";s:33:\"packs/niceandclean_textblocks.zip\";s:3:\"uid\";s:32:\"1f33eb839c96ea3225faff1c8d382b05\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:129;a:23:{s:2:\"id\";s:3:\"131\";s:5:\"title\";s:22:\"Nice And Clean CallOut\";s:5:\"alias\";s:20:\"niceandclean_callout\";s:3:\"zip\";s:30:\"packs/niceandclean_callout.zip\";s:3:\"uid\";s:32:\"54d4d9bcf79d357de0e614700e909863\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"500\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:130;a:23:{s:2:\"id\";s:3:\"132\";s:5:\"title\";s:21:\"Nice And Clean Footer\";s:5:\"alias\";s:19:\"niceandclean_footer\";s:3:\"zip\";s:29:\"packs/niceandclean_footer.zip\";s:3:\"uid\";s:32:\"5492d7f72b3771a4e754f91bda063b15\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"400\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:542:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">For using the social sharing buttons, please install the social sharing add-on.<br><br></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:131;a:20:{s:2:\"id\";s:3:\"134\";s:5:\"title\";s:15:\"80s Style Intro\";s:5:\"alias\";s:3:\"80s\";s:3:\"zip\";s:7:\"80s.zip\";s:3:\"uid\";s:32:\"98881ab51f71b2fbdb220752d321b15a\";s:3:\"img\";s:14:\"80s/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/80s-style-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:139:\"<span class=\"ttm_content\">This intro hero block takes you back to the 80\'s with some funky effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:317:\"<span class=\"ttm_content\">This is a \"Default\" content hero slider. Just edit the slide to change the background image and text.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:132;a:20:{s:2:\"id\";s:3:\"135\";s:5:\"title\";s:18:\"Blur Effect Slider\";s:5:\"alias\";s:10:\"blurslider\";s:3:\"zip\";s:14:\"blurslider.zip\";s:3:\"uid\";s:32:\"83bd6e1ccef83f03c944fa05b0a2d879\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/blur-effect-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:147:\"<span class=\"ttm_content\">This slider makes use of the brand new blur effects available with version 5.3.1.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:315:\"<span class=\"ttm_content\">This is a \"Default\" content slider. Just edit the slides to change the background images and texts.<br/><br/></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:133;a:20:{s:2:\"id\";s:3:\"136\";s:5:\"title\";s:18:\"Coming Soon Add-On\";s:5:\"alias\";s:15:\"ComingSoonAddon\";s:3:\"zip\";s:19:\"ComingSoonAddon.zip\";s:3:\"uid\";s:32:\"51258492055b940099eb96ba52901fa9\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/coming-soon-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:133:\"<span class=\"ttm_content\">This slider template makes use of the brand new Coming Soon Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:197:\"[{\"path\":\"revslider-maintenance-addon\\/revslider-maintenance-addon.php\",\"name\":\"Coming Soon & Maintenance AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/revslider-doc\\/add-coming-soon-maintenance\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:134;a:23:{s:2:\"id\";s:3:\"137\";s:5:\"title\";s:22:\"Nice And Clean Package\";s:5:\"alias\";s:22:\"nice-and-clean-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:22:\"nice-and-clean-package\";s:3:\"img\";s:38:\"packages/templatepack_niceandclean.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/nice-clean-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"800\";s:11:\"description\";s:242:\"<span class=\"ttm_content\">The Nice & Clean Website Template uses groups & rows for a fully responsive website experience. Elegant blur effects available since version 5.3.1 make this template stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"Nice & Clean Template\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"6\";s:9:\"installed\";b:0;}i:135;a:20:{s:2:\"id\";s:3:\"138\";s:5:\"title\";s:18:\"Snow Effect Add-On\";s:5:\"alias\";s:9:\"snowaddon\";s:3:\"zip\";s:13:\"snowaddon.zip\";s:3:\"uid\";s:32:\"7408d8567b8af5716eaabd390422e51b\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/snow-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:183:\"<span class=\"ttm_content\">Add a pleasant Snow Effect to your website with this slider template. Make sure to install the \"Holiday Snow\" Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:136;a:20:{s:2:\"id\";s:3:\"139\";s:5:\"title\";s:19:\"Particle Effect One\";s:5:\"alias\";s:19:\"particle-effect-one\";s:3:\"zip\";s:23:\"particle-effect-one.zip\";s:3:\"uid\";s:32:\"a4611c906e35ca60f617da86217b5299\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/particle-effect-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:442:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND MODE IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:137;a:20:{s:2:\"id\";s:3:\"140\";s:5:\"title\";s:19:\"Particle Effect Two\";s:5:\"alias\";s:19:\"particle-effect-two\";s:3:\"zip\";s:23:\"particle-effect-two.zip\";s:3:\"uid\";s:32:\"b8ecbf43374a69e4ab329ea834862ef8\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/particle-effect-intro/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:138;a:20:{s:2:\"id\";s:3:\"141\";s:5:\"title\";s:21:\"Particle Effect Three\";s:5:\"alias\";s:21:\"particle-effect-three\";s:3:\"zip\";s:25:\"particle-effect-three.zip\";s:3:\"uid\";s:32:\"b33bc2c5655d8d51cd17c3740f72e748\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/particle-background-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:143:\"<span class=\"ttm_content\">A unique particle effect that can serve as a stunning intro for your website.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:437:\"<span class=\"ttm_content\">The blend mode effect is achieved through a layer image with CSS blend mode. If you want to customize this effect, select the \"BLEND IMAGE\" layer and go to \"advanced style -> filters -> blend mode\".</span>\r\n<span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:139;a:20:{s:2:\"id\";s:3:\"142\";s:5:\"title\";s:16:\"Portfolio Viewer\";s:5:\"alias\";s:15:\"portfolioviewer\";s:3:\"zip\";s:19:\"portfolioviewer.zip\";s:3:\"uid\";s:32:\"9ac7230ff5b880fb6c8f28fbbc123b3b\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-portfolio-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:207:\"<span class=\"ttm_content\">This slider template can be used to display your portfolio highlights in a stunning way, utilising out free particles add-on and blend modes.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:387:\"<span class=\"ttm_content\">The navigation for the slides is found in the <a href=\"https://www.themepunch.com/slider-revolution/global-layers/\" target=\"_blank\">Static Layers</a>.</span><span class=\"ttm_space\"></span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:140;a:20:{s:2:\"id\";s:3:\"143\";s:5:\"title\";s:12:\"App Showcase\";s:5:\"alias\";s:11:\"appshowcase\";s:3:\"zip\";s:15:\"appshowcase.zip\";s:3:\"uid\";s:32:\"082aef931b0369080bc30c3a2a0c331f\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/app-showcase-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.3.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">This template shows off our new \"Polyfold Effects\" Add-On in form of an App product showcase module. Get started now and illustrate your Apps key features in a striking way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:179:\"[{\"path\":\"revslider-polyfold-addon\\/revslider-polyfold-addon.php\",\"name\":\"Polyfold Scroll Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:141;a:20:{s:2:\"id\";s:3:\"144\";s:5:\"title\";s:19:\"Gravity Design Hero\";s:5:\"alias\";s:13:\"gravitydesign\";s:3:\"zip\";s:17:\"gravitydesign.zip\";s:3:\"uid\";s:32:\"7bdbe73a6e5bf290cb4412708ac4134d\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/best-wordpress-slider-plugin-2017/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">This hero template shows a striking mouse-parallax scene and cool particle effects. Requires our \"Particle Effects\" Add-on to be installed.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:142;a:20:{s:2:\"id\";s:3:\"145\";s:5:\"title\";s:14:\"404 Error Page\";s:5:\"alias\";s:12:\"404errorpage\";s:3:\"zip\";s:16:\"404errorpage.zip\";s:3:\"uid\";s:32:\"2dc62d802b42b73088651cac17d0c486\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";s:7:\"preview\";s:58:\"https://revolution.themepunch.com/404-error-page-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.3.1.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This template can be used as a custom error page on your website with our new 404 page Add-On. Of course you can also use this template as a regular hero header.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:330:\"[{\"path\":\"revslider-404-addon\\/revslider-404-addon.php\",\"name\":\"404 Page Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:143;a:20:{s:2:\"id\";s:3:\"146\";s:5:\"title\";s:16:\"Carousel Gallery\";s:5:\"alias\";s:15:\"carouselgallery\";s:3:\"zip\";s:19:\"carouselgallery.zip\";s:3:\"uid\";s:32:\"041838fd32923c40e15c998f0ea19526\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/wordpress-carousel-gallery/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:159:\"<span class=\"ttm_content\">This carousel gallery features a subtle parallax effect, html5 video and a fullscreen button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:8:\"carousel\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:144;a:20:{s:2:\"id\";s:3:\"147\";s:5:\"title\";s:16:\"Filmstrip Effect\";s:5:\"alias\";s:9:\"filmstrip\";s:3:\"zip\";s:13:\"filmstrip.zip\";s:3:\"uid\";s:32:\"7bd142f272cc15d86998a79520e9e581\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";s:7:\"preview\";s:61:\"https://revolution.themepunch.com/filmstrip-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">This template uses our Filmstrip Add-On to display a continuous scrolling set of images per slide.\r\n There is lots of customization options like animation speed and direction.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:180:\"[{\"path\":\"revslider-filmstrip-addon\\/revslider-filmstrip-addon.php\",\"name\":\"Background FilmStrip Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:145;a:20:{s:2:\"id\";s:3:\"148\";s:5:\"title\";s:11:\"Space Opera\";s:5:\"alias\";s:10:\"spaceopera\";s:3:\"zip\";s:14:\"spaceopera.zip\";s:3:\"uid\";s:32:\"a2c8bffcb138a86c0f373adebb6de046\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/space-opera-presentation/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">The Space Opera template can be enjoyed as a slow paced, full-screen slider experience and is great to show your most prominent photos.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:146;a:20:{s:2:\"id\";s:3:\"149\";s:5:\"title\";s:13:\"Website Intro\";s:5:\"alias\";s:12:\"websiteintro\";s:3:\"zip\";s:16:\"websiteintro.zip\";s:3:\"uid\";s:32:\"348df76d999456aa19be58c9df56ae20\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/website-intro-wordpress-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:274:\"<span class=\"ttm_content\">Making use of our new Slicey Add-On, this slider show a really cool effect you just have to experience yourself! Just change the slides background images and the existing slices will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:147;a:20:{s:2:\"id\";s:3:\"150\";s:5:\"title\";s:13:\"Mask Showcase\";s:5:\"alias\";s:12:\"maskshowcase\";s:3:\"zip\";s:16:\"maskshowcase.zip\";s:3:\"uid\";s:32:\"fc943c31e2da9c63b252aeabf554d128\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";s:7:\"preview\";s:56:\"https://revolution.themepunch.com/minimal-mask-showcase/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Mask Showcase template uses gradients and the amazing block layer animations. A minimal slider treat for any website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:148;a:20:{s:2:\"id\";s:3:\"151\";s:5:\"title\";s:20:\"Parallax Zoom Slices\";s:5:\"alias\";s:18:\"parallaxzoomslices\";s:3:\"zip\";s:22:\"parallaxzoomslices.zip\";s:3:\"uid\";s:32:\"83537cae05709ddb9bcb7375470a5894\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";s:7:\"preview\";s:72:\"https://revolution.themepunch.com/parallax-zoom-slices-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:3:\"5.4\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:249:\"<span class=\"ttm_content\">This template uses the Slicey Add-On to add a unique effect to slide background images. You can simple change the background images and the slice effect will automatically be applied.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:149;a:20:{s:2:\"id\";s:3:\"152\";s:5:\"title\";s:22:\"Double Exposure Effect\";s:5:\"alias\";s:20:\"doubleexposureeffect\";s:3:\"zip\";s:24:\"doubleexposureeffect.zip\";s:3:\"uid\";s:32:\"8d9229b5cbcf5bda5fbdc6a8e01a2b8c\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/wordpress-double-exposure-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">Make any website special with the double exposure effect slider. Use as a header module or anywhere you want!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:150;a:20:{s:2:\"id\";s:3:\"153\";s:5:\"title\";s:24:\"Mountain Parallax Header\";s:5:\"alias\";s:22:\"mountainparallaxheader\";s:3:\"zip\";s:26:\"mountainparallaxheader.zip\";s:3:\"uid\";s:32:\"8dc64663f317a2abdf179bbe341d016e\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/mountain-wordpress-parallax-header/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:192:\"<span class=\"ttm_content\">This template is a cool intro for any page, featuring a striking parallax effect. Just change texts and links and you\'re done!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:151;a:23:{s:2:\"id\";s:3:\"154\";s:5:\"title\";s:26:\"GoodNews One-Pager Package\";s:5:\"alias\";s:26:\"goodnews-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"goodnews-one-pager-package\";s:3:\"img\";s:44:\"packages/templatepack_goodnews_one_pager.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:4:{i:0;s:8:\"carousel\";i:1;s:6:\"slider\";i:2;s:4:\"hero\";i:3;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:152;a:23:{s:2:\"id\";s:3:\"155\";s:5:\"title\";s:13:\"GoodNews Menu\";s:5:\"alias\";s:12:\"goodnewsmenu\";s:3:\"zip\";s:22:\"packs/goodnewsmenu.zip\";s:3:\"uid\";s:32:\"4cbc82501ff340fcdc0acf7eb3ba2640\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">You can use this slider as a module on your website or install it as part of a slider pack. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:153;a:23:{s:2:\"id\";s:3:\"156\";s:5:\"title\";s:15:\"GoodNews Header\";s:5:\"alias\";s:14:\"goodnewsheader\";s:3:\"zip\";s:24:\"packs/goodnewsheader.zip\";s:3:\"uid\";s:32:\"c6660b6bdbf596f38466f569596f5259\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:154;a:23:{s:2:\"id\";s:3:\"157\";s:5:\"title\";s:18:\"GoodNews Whats Hot\";s:5:\"alias\";s:16:\"goodnewswhatshot\";s:3:\"zip\";s:26:\"packs/goodnewswhatshot.zip\";s:3:\"uid\";s:32:\"cb841ce64a99a6644adab049cf5405cd\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:155;a:23:{s:2:\"id\";s:3:\"158\";s:5:\"title\";s:17:\"GoodNews Featured\";s:5:\"alias\";s:16:\"goodnewsfeatured\";s:3:\"zip\";s:26:\"packs/goodnewsfeatured.zip\";s:3:\"uid\";s:32:\"00bde4b09e3700da7183999eaf137ccc\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:156;a:23:{s:2:\"id\";s:3:\"159\";s:5:\"title\";s:18:\"GoodNews Spotlight\";s:5:\"alias\";s:17:\"goodnewsspotlight\";s:3:\"zip\";s:27:\"packs/goodnewsspotlight.zip\";s:3:\"uid\";s:32:\"138076241a828e1c5764379944755f2b\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:157;a:23:{s:2:\"id\";s:3:\"160\";s:5:\"title\";s:17:\"GoodNews Carousel\";s:5:\"alias\";s:16:\"goodnewscarousel\";s:3:\"zip\";s:26:\"packs/goodnewscarousel.zip\";s:3:\"uid\";s:32:\"d29d4460a6015e30d08d2714232d3768\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:158;a:23:{s:2:\"id\";s:3:\"161\";s:5:\"title\";s:16:\"GoodNews Callout\";s:5:\"alias\";s:15:\"goodnewscallout\";s:3:\"zip\";s:25:\"packs/goodnewscallout.zip\";s:3:\"uid\";s:32:\"d9568b3193e96577fae630b3a6728785\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:159;a:23:{s:2:\"id\";s:3:\"162\";s:5:\"title\";s:15:\"GoodNews Footer\";s:5:\"alias\";s:14:\"goodnewsfooter\";s:3:\"zip\";s:24:\"packs/goodnewsfooter.zip\";s:3:\"uid\";s:32:\"34f43f891cb8d55375149dc4bbc38298\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"GoodNews One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"7\";s:9:\"installed\";b:0;}i:160;a:23:{s:2:\"id\";s:3:\"163\";s:5:\"title\";s:29:\"GoodNews Content Page Package\";s:5:\"alias\";s:29:\"goodnews-content-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:29:\"goodnews-content-page-package\";s:3:\"img\";s:55:\"packages/templatepack_goodnews_content_page_package.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:161;a:23:{s:2:\"id\";s:3:\"164\";s:5:\"title\";s:18:\"GoodNews Menu Back\";s:5:\"alias\";s:16:\"goodnewsmenuback\";s:3:\"zip\";s:26:\"packs/goodnewsmenuback.zip\";s:3:\"uid\";s:32:\"1340d1aeefba497a7d404d12a1fceed4\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:162;a:23:{s:2:\"id\";s:3:\"165\";s:5:\"title\";s:20:\"GoodNews Blog Header\";s:5:\"alias\";s:18:\"goodnewsblogheader\";s:3:\"zip\";s:28:\"packs/goodnewsblogheader.zip\";s:3:\"uid\";s:32:\"abc4d7c1e48475c6def05f1f6d8bf564\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:163;a:23:{s:2:\"id\";s:3:\"166\";s:5:\"title\";s:21:\"GoodNews Blog Content\";s:5:\"alias\";s:19:\"goodnewsblogcontent\";s:3:\"zip\";s:29:\"packs/goodnewsblogcontent.zip\";s:3:\"uid\";s:32:\"bbf34563da6db2779c29599b503b07e9\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:164;a:23:{s:2:\"id\";s:3:\"167\";s:5:\"title\";s:21:\"GoodNews Testimonials\";s:5:\"alias\";s:20:\"goodnewstestimonials\";s:3:\"zip\";s:30:\"packs/goodnewstestimonials.zip\";s:3:\"uid\";s:32:\"606b7336e86f69c567542d3f43712b56\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:165;a:23:{s:2:\"id\";s:3:\"168\";s:5:\"title\";s:20:\"GoodNews Blog Footer\";s:5:\"alias\";s:18:\"goodnewsblogfooter\";s:3:\"zip\";s:28:\"packs/goodnewsblogfooter.zip\";s:3:\"uid\";s:32:\"1fb88aecfb116fde67ce8d52bd3b5f05\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";s:7:\"preview\";s:78:\"https://revolution.themepunch.com/goodnews-responsive-wordpress-theme-content/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:268:\"<span class=\"ttm_content\">The GoodNews One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:21:\"GoodNews Content Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"8\";s:9:\"installed\";b:0;}i:166;a:20:{s:2:\"id\";s:3:\"169\";s:5:\"title\";s:19:\"Before After Slider\";s:5:\"alias\";s:17:\"beforeafterslider\";s:3:\"zip\";s:21:\"beforeafterslider.zip\";s:3:\"uid\";s:32:\"6e615091a1fc3037c24b985ce5136fb2\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";s:7:\"preview\";s:54:\"https://revolution.themepunch.com/before-after-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.3.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:201:\"<span class=\"ttm_content\">This is the example slider for our Before / After Add-On that allows you to create unique presentations with a comparing functionality.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:167;a:20:{s:2:\"id\";s:3:\"170\";s:5:\"title\";s:16:\"Product Showcase\";s:5:\"alias\";s:15:\"productshowcase\";s:3:\"zip\";s:19:\"productshowcase.zip\";s:3:\"uid\";s:32:\"a43447670260aaa7e8ff66cedfddb57a\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/wordpress-product-showcase-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:165:\"<span class=\"ttm_content\">Looking to sell products effectively? Our product showcase slider is just what you are looking for!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:168;a:20:{s:2:\"id\";s:3:\"171\";s:5:\"title\";s:23:\"Overexposure Transition\";s:5:\"alias\";s:22:\"overexposuretransition\";s:3:\"zip\";s:26:\"overexposuretransition.zip\";s:3:\"uid\";s:32:\"13f16bbe6c6d646c7d0cb817a0d3d181\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/overexposure-transition-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">Subtle overexposure transitions and smooth color fade effects make this slider stand out.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:320:\"<span class=\"ttm_content\">How to install <a href=\"https://www.themepunch.com/slider-revolution/install-addons/\" target=\"_blank\">Add-Ons</a>.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:169;a:20:{s:2:\"id\";s:3:\"172\";s:5:\"title\";s:15:\"Parallax Scroll\";s:5:\"alias\";s:14:\"parallaxscroll\";s:3:\"zip\";s:18:\"parallaxscroll.zip\";s:3:\"uid\";s:32:\"82546ee2f6af6c6682852f495109b3c3\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";s:7:\"preview\";s:50:\"https://revolution.themepunch.com/parallax-scroll/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.5\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:148:\"<span class=\"ttm_content\">A strikingly colourful header for your website with super smooth parallax effects.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:170;a:23:{s:2:\"id\";s:3:\"173\";s:5:\"title\";s:24:\"TechCo One-Pager Package\";s:5:\"alias\";s:24:\"techco-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:24:\"techco-one-pager-package\";s:3:\"img\";s:28:\"packages/techco_overview.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:171;a:23:{s:2:\"id\";s:3:\"174\";s:5:\"title\";s:11:\"TechCo Menu\";s:5:\"alias\";s:11:\"techco-menu\";s:3:\"zip\";s:21:\"packs/techco-menu.zip\";s:3:\"uid\";s:32:\"55e5efee828cdf1ff7e2d3b90a301ea9\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:172;a:23:{s:2:\"id\";s:3:\"175\";s:5:\"title\";s:13:\"TechCo Header\";s:5:\"alias\";s:13:\"techco-header\";s:3:\"zip\";s:23:\"packs/techco-header.zip\";s:3:\"uid\";s:32:\"fb574d1376de9b1e408c91f51e6497d7\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:173;a:23:{s:2:\"id\";s:3:\"176\";s:5:\"title\";s:12:\"TechCo About\";s:5:\"alias\";s:12:\"techco-about\";s:3:\"zip\";s:22:\"packs/techco-about.zip\";s:3:\"uid\";s:32:\"ba216da8231e55118d87e37d2358812c\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:174;a:23:{s:2:\"id\";s:3:\"177\";s:5:\"title\";s:15:\"TechCo Services\";s:5:\"alias\";s:15:\"techco-services\";s:3:\"zip\";s:25:\"packs/techco-services.zip\";s:3:\"uid\";s:32:\"ef4a8ddbb5e1136133f7bc1227248e22\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:175;a:23:{s:2:\"id\";s:3:\"178\";s:5:\"title\";s:12:\"TechCo Video\";s:5:\"alias\";s:12:\"techco-video\";s:3:\"zip\";s:22:\"packs/techco-video.zip\";s:3:\"uid\";s:32:\"d7bb92281d05f39f9bc9eca71f90e402\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:176;a:23:{s:2:\"id\";s:3:\"179\";s:5:\"title\";s:13:\"TechCo Prices\";s:5:\"alias\";s:13:\"techco-prices\";s:3:\"zip\";s:23:\"packs/techco-prices.zip\";s:3:\"uid\";s:32:\"6291f404efbea12bb181352aba71ef11\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:177;a:23:{s:2:\"id\";s:3:\"180\";s:5:\"title\";s:19:\"TechCo Testimonials\";s:5:\"alias\";s:19:\"techco-testimonials\";s:3:\"zip\";s:29:\"packs/techco-testimonials.zip\";s:3:\"uid\";s:32:\"3460bd51f6b80599266fecb7fbb918be\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:178;a:23:{s:2:\"id\";s:3:\"181\";s:5:\"title\";s:13:\"TechCo Footer\";s:5:\"alias\";s:13:\"techco-footer\";s:3:\"zip\";s:23:\"packs/techco-footer.zip\";s:3:\"uid\";s:32:\"640abcd549137520461a4a71ff758a3b\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/techco-one-page-wordpress-theme/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:266:\"<span class=\"ttm_content\">The TechCo One-Pager template pack is a fantastic solution if you want to get a simple website going fast. Use all modules at once as seen in the preview or pick individual modules for usage anywhere!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"TechCo One-Pager\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:1:\"9\";s:9:\"installed\";b:0;}i:179;a:20:{s:2:\"id\";s:3:\"182\";s:5:\"title\";s:12:\"Live Weather\";s:5:\"alias\";s:7:\"weather\";s:3:\"zip\";s:11:\"weather.zip\";s:3:\"uid\";s:32:\"aab92e69374e4c7b8c6741fe02e574b9\";s:3:\"img\";s:18:\"weather/slide1.jpg\";s:7:\"preview\";s:64:\"https://revolution.themepunch.com/wordpress-live-weather-add-on/\";s:7:\"version\";s:5:\"1.0.3\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:173:\"<span class=\"ttm_content\">Showcasing our weather add-on, this slider show a different cities temperatures and forecast on each slide.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:168:\"[{\"path\":\"revslider-weather-addon\\/revslider-weather-addon.php\",\"name\":\"Live Weather Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:180;a:20:{s:2:\"id\";s:3:\"183\";s:5:\"title\";s:17:\"360 Panorama Tour\";s:5:\"alias\";s:11:\"360panorama\";s:3:\"zip\";s:15:\"360panorama.zip\";s:3:\"uid\";s:32:\"332720fdacdbb38f65e8327a2a96c52d\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/360-degree-real-estate-virtual-tour/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.5.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">An example template for our Panorama 360 tour add-on, created for the real estate market.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:165:\"[{\"path\":\"revslider-panorama-addon\\/revslider-panorama-addon.php\",\"name\":\"Panorama AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:181;a:20:{s:2:\"id\";s:3:\"184\";s:5:\"title\";s:14:\"Duotone Add-on\";s:5:\"alias\";s:14:\"duotone-add-on\";s:3:\"zip\";s:18:\"duotone-add-on.zip\";s:3:\"uid\";s:32:\"a428c6f363b3146e96d20a6f44958922\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-duotone-effect-add-on/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:168:\"<span class=\"ttm_content\">This example template showcases 3 of the 30 Duotone filters available in our brand new Duotone Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:350:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-duotonefilters-addon\\/revslider-duotonefilters-addon.php\",\"name\":\"Duotone AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:182;a:20:{s:2:\"id\";s:3:\"185\";s:5:\"title\";s:13:\"Reveal Add-on\";s:5:\"alias\";s:13:\"reveal-add-on\";s:3:\"zip\";s:17:\"reveal-add-on.zip\";s:3:\"uid\";s:32:\"7fa7525d8ff7fa7365cb98a437e88e32\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";s:7:\"preview\";s:66:\"https://revolution.themepunch.com/wordpress-content-reveal-effect/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">An example template that uses our Reveal Add-On, which adds 14 new preloaders combined with reveal loading effects for any slider or hero.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:337:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:201;a:20:{s:2:\"id\";s:3:\"210\";s:5:\"title\";s:21:\"Cryptocurrency Prices\";s:5:\"alias\";s:12:\"cryptoslider\";s:3:\"zip\";s:16:\"cryptoslider.zip\";s:3:\"uid\";s:32:\"c4b02210387f11946223977e940d9e9e\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";s:7:\"preview\";s:95:\"https://revolution.themepunch.com/cryptocurrency-wordpress-price-api-bitcoin-ethereum-litecoin/\";s:7:\"version\";s:5:\"1.0.2\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"900\";s:11:\"description\";s:209:\"<span class=\"ttm_content\">This Template can show live, animated cryptocurrency prices. More than 1300 currencies are supported, getting prices via the cryptocompare API.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:410:\"<span class=\"ttm_content\">Please refer to the \"Custom JavaScript\" section of this sliders settings, for info on how to modify currencies. Provide a class to the row / column / group where the currency text elements are located in.</span>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:202;a:23:{s:2:\"id\";s:3:\"211\";s:5:\"title\";s:18:\"Immersion One Page\";s:5:\"alias\";s:26:\"immersion-one-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"immersion-one-page-package\";s:3:\"img\";s:31:\"packages/immersion_overview.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:3:{i:0;s:6:\"slider\";i:1;s:4:\"hero\";i:2;s:7:\"website\";}s:14:\"plugin_require\";s:343:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:203;a:23:{s:2:\"id\";s:3:\"212\";s:5:\"title\";s:16:\"Immersion Header\";s:5:\"alias\";s:16:\"immersion_header\";s:3:\"zip\";s:26:\"packs/immersion_header.zip\";s:3:\"uid\";s:32:\"853da51256308b341ecd030bd4883229\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:204;a:23:{s:2:\"id\";s:3:\"213\";s:5:\"title\";s:19:\"Immersion Mountains\";s:5:\"alias\";s:19:\"immersion-mountains\";s:3:\"zip\";s:29:\"packs/immersion-mountains.zip\";s:3:\"uid\";s:32:\"817167eb3fe22b7e065ba210cbe6d53c\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-slicey-addon\\/revslider-slicey-addon.php\",\"name\":\"Background Slicey Add-On\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:205;a:23:{s:2:\"id\";s:3:\"214\";s:5:\"title\";s:17:\"Immersion Product\";s:5:\"alias\";s:17:\"immersion-product\";s:3:\"zip\";s:27:\"packs/immersion-product.zip\";s:3:\"uid\";s:32:\"64134f263484d2bbcd7ef088ffbbfb4b\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:206;a:23:{s:2:\"id\";s:3:\"215\";s:5:\"title\";s:16:\"Immersion Design\";s:5:\"alias\";s:16:\"immersion-design\";s:3:\"zip\";s:26:\"packs/immersion-design.zip\";s:3:\"uid\";s:32:\"91e1d77c1a2826438763804f4d02bc26\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:207;a:23:{s:2:\"id\";s:3:\"216\";s:5:\"title\";s:22:\"Immersion Phototgraphy\";s:5:\"alias\";s:21:\"immersion-photography\";s:3:\"zip\";s:31:\"packs/immersion-photography.zip\";s:3:\"uid\";s:32:\"e3ddf0c577b09740f5cbf2e38ffd684d\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:208;a:23:{s:2:\"id\";s:3:\"217\";s:5:\"title\";s:14:\"Immersion Grid\";s:5:\"alias\";s:14:\"immersion-grid\";s:3:\"zip\";s:24:\"packs/immersion-grid.zip\";s:3:\"uid\";s:32:\"b6903868189bb83b2c7a852fde3a7dc3\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";s:7:\"preview\";s:74:\"https://revolution.themepunch.com/immersion-wordpress-one-page-theme-2018/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:292:\"<span class=\"ttm_content\">The Immersion WordPress one page theme is a great fit if you quickly want to setup a visually oriented one page website. Using the power of Slider Revolution, we added some interesting effects like slicing and smooth parallax.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Immersion One Page\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"10\";s:9:\"installed\";b:0;}i:209;a:20:{s:2:\"id\";s:3:\"218\";s:5:\"title\";s:18:\"Funky Intro Slider\";s:5:\"alias\";s:11:\"funkyslider\";s:3:\"zip\";s:15:\"funkyslider.zip\";s:3:\"uid\";s:32:\"2d4187e3fdad19b976be335253c8925d\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";s:7:\"preview\";s:70:\"https://revolution.themepunch.com/funky-intro-slider-wordpress-plugin/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:200:\"<span class=\"ttm_content\">This funky intro slider fits just right if you need a striking introduction to your website! Sleek, beautiful and easily customizable!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:335:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"},{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:210;a:23:{s:2:\"id\";s:3:\"219\";s:5:\"title\";s:19:\"Clear View Magazine\";s:5:\"alias\";s:27:\"clear-view-magazine-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"clear-view-magazine-package\";s:3:\"img\";s:41:\"packages/clear_view_magazine_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:211;a:23:{s:2:\"id\";s:3:\"220\";s:5:\"title\";s:15:\"Clear View Menu\";s:5:\"alias\";s:14:\"clearview_menu\";s:3:\"zip\";s:24:\"packs/clearview_menu.zip\";s:3:\"uid\";s:32:\"eaecee5fa5f3c3a7f4d2a96c4616a353\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:212;a:23:{s:2:\"id\";s:3:\"221\";s:5:\"title\";s:17:\"Clear View Header\";s:5:\"alias\";s:16:\"clearview_header\";s:3:\"zip\";s:26:\"packs/clearview_header.zip\";s:3:\"uid\";s:32:\"25e3dd80ad130875d7438a07952cb0cd\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:213;a:23:{s:2:\"id\";s:3:\"222\";s:5:\"title\";s:18:\"Clear View Mission\";s:5:\"alias\";s:17:\"clearview_mission\";s:3:\"zip\";s:27:\"packs/clearview_mission.zip\";s:3:\"uid\";s:32:\"35b2092a49fd2beb549342e69097eb5b\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:214;a:23:{s:2:\"id\";s:3:\"223\";s:5:\"title\";s:17:\"Clear View Slider\";s:5:\"alias\";s:17:\"clear-view-slider\";s:3:\"zip\";s:27:\"packs/clear-view-slider.zip\";s:3:\"uid\";s:32:\"d2e17edffce16ed78c54b0ef23fd7e05\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:215;a:23:{s:2:\"id\";s:3:\"224\";s:5:\"title\";s:15:\"Clear View News\";s:5:\"alias\";s:15:\"clear-view-news\";s:3:\"zip\";s:25:\"packs/clear-view-news.zip\";s:3:\"uid\";s:32:\"5698d3131ba141e9afcfd2906739dd00\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:216;a:23:{s:2:\"id\";s:3:\"225\";s:5:\"title\";s:18:\"Clear View Clients\";s:5:\"alias\";s:18:\"clear-view-clients\";s:3:\"zip\";s:28:\"packs/clear-view-clients.zip\";s:3:\"uid\";s:32:\"b95616a94832e22bdfac5ce60232be1b\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:217;a:23:{s:2:\"id\";s:3:\"226\";s:5:\"title\";s:18:\"Clear View Contact\";s:5:\"alias\";s:18:\"clear-view-contact\";s:3:\"zip\";s:28:\"packs/clear-view-contact.zip\";s:3:\"uid\";s:32:\"0e0cc1d8f6f6500e5f8a2b091fa3b4cb\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-minimal-magazine-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:19:\"Clear View Magazine\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"11\";s:9:\"installed\";b:0;}i:218;a:23:{s:2:\"id\";s:3:\"227\";s:5:\"title\";s:20:\"Clear View Post Page\";s:5:\"alias\";s:28:\"clear-view-post-page-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"clear-view-post-page-package\";s:3:\"img\";s:42:\"packages/clear_view_post_page_overview.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:219;a:23:{s:2:\"id\";s:3:\"228\";s:5:\"title\";s:22:\"Clear View Single Menu\";s:5:\"alias\";s:22:\"clear-view-single-menu\";s:3:\"zip\";s:32:\"packs/clear-view-single-menu.zip\";s:3:\"uid\";s:32:\"1e80f81982f8a4ea763482d4fa99d321\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:220;a:23:{s:2:\"id\";s:3:\"229\";s:5:\"title\";s:24:\"Clear View Single Header\";s:5:\"alias\";s:24:\"clear-view-single-header\";s:3:\"zip\";s:34:\"packs/clear-view-single-header.zip\";s:3:\"uid\";s:32:\"c8d717627be6cd5e70922ab609694dbf\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:221;a:23:{s:2:\"id\";s:3:\"230\";s:5:\"title\";s:23:\"Clear View Single Media\";s:5:\"alias\";s:23:\"clear-view-single-media\";s:3:\"zip\";s:33:\"packs/clear-view-single-media.zip\";s:3:\"uid\";s:32:\"c480368ded2a64f0cdd44f1674213814\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:222;a:23:{s:2:\"id\";s:3:\"231\";s:5:\"title\";s:22:\"Clear View Single More\";s:5:\"alias\";s:22:\"clear-view-single-more\";s:3:\"zip\";s:32:\"packs/clear-view-single-more.zip\";s:3:\"uid\";s:32:\"9c693190df26218366d1f77e10cf550a\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:223;a:23:{s:2:\"id\";s:3:\"232\";s:5:\"title\";s:25:\"Clear View Single Contact\";s:5:\"alias\";s:25:\"clear-view-single-contact\";s:3:\"zip\";s:35:\"packs/clear-view-single-contact.zip\";s:3:\"uid\";s:32:\"73c0a889f2b654a87b5aba1ff76fbc5c\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/clear-view-single-post-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.6\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:196:\"<span class=\"ttm_content\">The Clear View Minimal Magazine WordPress Template is a full Slider Revolution module arrangement with fully customizable content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Clear View Post Page\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"12\";s:9:\"installed\";b:0;}i:224;a:20:{s:2:\"id\";s:3:\"233\";s:5:\"title\";s:18:\"Clean Landing Page\";s:5:\"alias\";s:16:\"cleanlandingpage\";s:3:\"zip\";s:20:\"cleanlandingpage.zip\";s:3:\"uid\";s:32:\"727a3680d312f22c6a5998ebdb9afe52\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/clean-landing-page-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:203:\"<span class=\"ttm_content\">The Clean Landing Page is a fullscreen Intro Module that is a striking introduction to any minimal website, with no unnecessary elements.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:173:\"[{\"path\":\"revslider-typewriter-addon\\/revslider-typewriter-addon.php\",\"name\":\"Typewriter AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/typewriter-addon\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:225;a:20:{s:2:\"id\";s:3:\"234\";s:5:\"title\";s:9:\"Clear Cut\";s:5:\"alias\";s:8:\"clearcut\";s:3:\"zip\";s:12:\"clearcut.zip\";s:3:\"uid\";s:32:\"07f43c00e9b4d3057a03cdb3385ad2b7\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/clear-cut-portfolio-website-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:240:\"<span class=\"ttm_content\">The Clear Cut Template is an All-In-One Portfolio Website solution that works best for smaller portfolios. Highlight your best work in a striking and mobile friendly fashion!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:226;a:23:{s:2:\"id\";s:3:\"235\";s:5:\"title\";s:22:\"Wonderstruck One-Pager\";s:5:\"alias\";s:30:\"wonderstruck-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:30:\"wonderstruck-one-pager-package\";s:3:\"img\";s:44:\"packages/wonderstruck-one-pager-overview.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:227;a:23:{s:2:\"id\";s:3:\"236\";s:5:\"title\";s:17:\"Wonderstruck Menu\";s:5:\"alias\";s:17:\"wonderstruck_menu\";s:3:\"zip\";s:27:\"packs/wonderstruck_menu.zip\";s:3:\"uid\";s:32:\"0a976e9aaae59c4f795b38f59f5a08d8\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:228;a:23:{s:2:\"id\";s:3:\"237\";s:5:\"title\";s:19:\"Wonderstruck Header\";s:5:\"alias\";s:19:\"wonderstruck_header\";s:3:\"zip\";s:29:\"packs/wonderstruck_header.zip\";s:3:\"uid\";s:32:\"e1379f77a902960a0ce12d44d85a9e0a\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:229;a:23:{s:2:\"id\";s:3:\"238\";s:5:\"title\";s:18:\"Wonderstruck About\";s:5:\"alias\";s:18:\"wonderstruck_about\";s:3:\"zip\";s:28:\"packs/wonderstruck_about.zip\";s:3:\"uid\";s:32:\"d207fb140fd328acc3038300ea52082a\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:230;a:23:{s:2:\"id\";s:3:\"239\";s:5:\"title\";s:18:\"Wonderstruck Works\";s:5:\"alias\";s:18:\"wonderstruck-works\";s:3:\"zip\";s:28:\"packs/wonderstruck-works.zip\";s:3:\"uid\";s:32:\"4476935097e27d92454b0011b7700c1d\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:231;a:23:{s:2:\"id\";s:3:\"240\";s:5:\"title\";s:20:\"Wonderstruck Contact\";s:5:\"alias\";s:20:\"wonderstruck-contact\";s:3:\"zip\";s:30:\"packs/wonderstruck-contact.zip\";s:3:\"uid\";s:32:\"9e4911521f77bce2b8efa40f4c2adc22\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";s:7:\"preview\";s:77:\"https://revolution.themepunch.com/wonderstruck-one-page-website-for-wordpress\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:241:\"<span class=\"ttm_content\">The Wonderstruck One-Pager Template is a clean, colorful way to showcase your portfolio online. Just install, change the content and you have a mobile ready online experience!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:22:\"Wonderstruck One-Pager\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"13\";s:9:\"installed\";b:0;}i:232;a:20:{s:2:\"id\";s:3:\"241\";s:5:\"title\";s:12:\"Bubble Morph\";s:5:\"alias\";s:11:\"bubblemorph\";s:3:\"zip\";s:15:\"bubblemorph.zip\";s:3:\"uid\";s:32:\"1102d6f5460ab82cb612cbe9f1d9514b\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/bubble-morph-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:188:\"<span class=\"ttm_content\">The Bubble Morph Add-On allows you to create interesting Lava-Lamp style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:233;a:20:{s:2:\"id\";s:3:\"242\";s:5:\"title\";s:16:\"Distortion AddOn\";s:5:\"alias\";s:15:\"distortionaddon\";s:3:\"zip\";s:19:\"distortionaddon.zip\";s:3:\"uid\";s:32:\"0ad46c9929bb2fa6316f1e6ced301aaf\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/distortion-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.7\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Distortion Add-On allows you to create interesting Distortion style effects on any of your Slider Revolution content.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:182:\"[{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:234;a:20:{s:2:\"id\";s:3:\"243\";s:5:\"title\";s:10:\"Club Flyer\";s:5:\"alias\";s:9:\"clubflyer\";s:3:\"zip\";s:13:\"clubflyer.zip\";s:3:\"uid\";s:32:\"dab73b9904d0e643a35b0475980998bd\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";s:7:\"preview\";s:81:\"https://revolution.themepunch.com/club-flyer-landing-page-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:227:\"<span class=\"ttm_content\">This Club Fyler Template for Slider Revolution uses the brand new Exploding Layers Add-On to create a captivating effect. Tap into unlimited creative potential. </span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:187:\"[{\"path\":\"revslider-explodinglayers-addon\\/revslider-explodinglayers-addon.php\",\"name\":\"Exploding Layers AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:235;a:20:{s:2:\"id\";s:3:\"244\";s:5:\"title\";s:16:\"Paintbrush AddOn\";s:5:\"alias\";s:15:\"paintbrushaddon\";s:3:\"zip\";s:19:\"paintbrushaddon.zip\";s:3:\"uid\";s:32:\"c85c48a6742b4bf72a2590cc1b50f6a0\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";s:7:\"preview\";s:73:\"https://revolution.themepunch.com/paintbrush-effect-add-on-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:239:\"<span class=\"ttm_content\">The Paintbrush Add-On for WordPress allows you to add cool mouse interaction effects to your Slider Revolution content. Examples: Blur Reveal, Color Reveal, Scratch Me Free.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:171:\"[{\"path\":\"revslider-paintbrush-addon\\/revslider-paintbrush-addon.php\",\"name\":\"Paintbrush AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:236;a:23:{s:2:\"id\";s:3:\"245\";s:5:\"title\";s:18:\"Parallax One-Pager\";s:5:\"alias\";s:26:\"parallax-one-pager-package\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"parallax-one-pager-package\";s:3:\"img\";s:39:\"packages/parallax-one-pager-package.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:237;a:23:{s:2:\"id\";s:3:\"246\";s:5:\"title\";s:15:\"Parallax Header\";s:5:\"alias\";s:15:\"parallax_header\";s:3:\"zip\";s:25:\"packs/parallax_header.zip\";s:3:\"uid\";s:32:\"32bf4a0f5136853bd6bd366275a7a60b\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:238;a:23:{s:2:\"id\";s:3:\"247\";s:5:\"title\";s:16:\"Parallax Content\";s:5:\"alias\";s:16:\"parallax_content\";s:3:\"zip\";s:26:\"packs/parallax_content.zip\";s:3:\"uid\";s:32:\"a25c5fb8f74757476ab4dc038e56f90d\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:239;a:23:{s:2:\"id\";s:3:\"248\";s:5:\"title\";s:15:\"Parallax Footer\";s:5:\"alias\";s:15:\"parallax_footer\";s:3:\"zip\";s:25:\"packs/parallax_footer.zip\";s:3:\"uid\";s:32:\"665dff9ea6eaf162a2a1f160f51a9ddb\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/parallax-one-page-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:230:\"<span class=\"ttm_content\">The Parallax One-Page WordPress Template is consisting of 3 hero blocks and contains a beautiful parallax mountain scene. An impactful opening to your web presence!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Parallax One-Pager\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"14\";s:9:\"installed\";b:0;}i:240;a:23:{s:2:\"id\";s:3:\"249\";s:5:\"title\";s:18:\"Le Chef Restaurant\";s:5:\"alias\";s:18:\"le-chef-restaurant\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"le-chef-restaurant-package\";s:3:\"img\";s:39:\"packages/le-chef-restaurant-package.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:241;a:23:{s:2:\"id\";s:3:\"250\";s:5:\"title\";s:12:\"Le Chef Menu\";s:5:\"alias\";s:12:\"le-chef-menu\";s:3:\"zip\";s:22:\"packs/le-chef-menu.zip\";s:3:\"uid\";s:32:\"2f2a6a333431fefe4a7b3b6a982b2ff5\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:242;a:23:{s:2:\"id\";s:3:\"251\";s:5:\"title\";s:14:\"Le Chef Header\";s:5:\"alias\";s:14:\"le-chef-header\";s:3:\"zip\";s:24:\"packs/le-chef-header.zip\";s:3:\"uid\";s:32:\"06450ca3be5a4a8959f3752ab974e574\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:243;a:23:{s:2:\"id\";s:3:\"252\";s:5:\"title\";s:18:\"Le Chef Philosophy\";s:5:\"alias\";s:18:\"le-chef-philosophy\";s:3:\"zip\";s:28:\"packs/le-chef-philosophy.zip\";s:3:\"uid\";s:32:\"a532fd029addeb18106e751409b8e20a\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:244;a:23:{s:2:\"id\";s:3:\"253\";s:5:\"title\";s:12:\"Le Chef Food\";s:5:\"alias\";s:12:\"le-chef-food\";s:3:\"zip\";s:22:\"packs/le-chef-food.zip\";s:3:\"uid\";s:32:\"cd4b6a2cb5de2dd20a0e8ba0c35451df\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:245;a:23:{s:2:\"id\";s:3:\"254\";s:5:\"title\";s:16:\"Le Chef La Carte\";s:5:\"alias\";s:16:\"le-chef-la-carte\";s:3:\"zip\";s:26:\"packs/le-chef-la-carte.zip\";s:3:\"uid\";s:32:\"6f312749679c3ba52c41189a6b8bf729\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:246;a:23:{s:2:\"id\";s:3:\"255\";s:5:\"title\";s:14:\"Le Chef Footer\";s:5:\"alias\";s:14:\"le-chef-footer\";s:3:\"zip\";s:24:\"packs/le-chef-footer.zip\";s:3:\"uid\";s:32:\"12fc241e8e5b9e5df9758c43448e2907\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/le-chef-restaurant-website-wordpress-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:261:\"<span class=\"ttm_content\">The Le Chef Restaurant Template is a One-Page Website and a full solution for your clients Restaurant. Showcase images in the header slideshow and present the Restaurants offering in a clear way!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:18:\"Le Chef Restaurant\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"15\";s:9:\"installed\";b:0;}i:247;a:20:{s:2:\"id\";s:3:\"256\";s:5:\"title\";s:20:\"News Magazine Slider\";s:5:\"alias\";s:20:\"news-magazine-slider\";s:3:\"zip\";s:24:\"news-magazine-slider.zip\";s:3:\"uid\";s:32:\"31f2c1506babb1fef459401f051d2d52\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/news-magazine-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:205:\"<span class=\"ttm_content\">The Magazine Slider offers various layouts that support static content images, HTML5 and Youtube video. Great for any blog or news website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:248;a:20:{s:2:\"id\";s:3:\"257\";s:5:\"title\";s:18:\"Real Estate Slider\";s:5:\"alias\";s:18:\"real-estate-slider\";s:3:\"zip\";s:22:\"real-estate-slider.zip\";s:3:\"uid\";s:32:\"739ce6336e46815094387c9448e6c804\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/real-estate-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">The Real Estate Slider allows to display real estate offers with a large ken burns background image and additional thumbnail hover images.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:249;a:20:{s:2:\"id\";s:3:\"258\";s:5:\"title\";s:14:\"Fashion Header\";s:5:\"alias\";s:14:\"fashion-header\";s:3:\"zip\";s:18:\"fashion-header.zip\";s:3:\"uid\";s:32:\"24ece4e7f4d31cd90377c62abbd9e25a\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";s:7:\"preview\";s:75:\"https://revolution.themepunch.com/fashion-shop-header-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"5.4.8\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:254:\"<span class=\"ttm_content\">The Fashion Shop Header ist the ideal Slider to display as an intro to your shop website or as a separator in between content. Our unique \"Bubble Morph\" effect makes this module stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:174:\"[{\"path\":\"revslider-bubblemorph-addon\\/revslider-bubblemorph-addon.php\",\"name\":\"BubbleMorph AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:250;a:20:{s:2:\"id\";s:3:\"259\";s:5:\"title\";s:14:\"Seasonal Offer\";s:5:\"alias\";s:13:\"seasonaloffer\";s:3:\"zip\";s:17:\"seasonaloffer.zip\";s:3:\"uid\";s:32:\"caf2f17f8fd64f2f89dcb3c8dd238457\";s:3:\"img\";s:24:\"seasonaloffer/slide1.jpg\";s:7:\"preview\";s:80:\"https://revolution.themepunch.com/seasonal-offer-christmas-header-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:204:\"<span class=\"ttm_content\">Use the Seasonal Offer Header to promote special offers in the holiday season, or just to add some snowy christmas spirit to your website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:153:\"[{\"path\":\"revslider-snow-addon\\/revslider-snow-addon.php\",\"name\":\"Snow AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:251;a:23:{s:2:\"id\";s:3:\"260\";s:5:\"title\";s:11:\"Barber Shop\";s:5:\"alias\";s:11:\"barber-shop\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:19:\"barber-shop-package\";s:3:\"img\";s:32:\"packages/barber-shop-package.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:252;a:23:{s:2:\"id\";s:3:\"261\";s:5:\"title\";s:18:\"Barber Shop Header\";s:5:\"alias\";s:18:\"barber-shop-header\";s:3:\"zip\";s:28:\"packs/barber-shop-header.zip\";s:3:\"uid\";s:32:\"71c995d36d39a0e8a04cffdf753f2ba2\";s:3:\"img\";s:29:\"barber-shop-header/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:253;a:23:{s:2:\"id\";s:3:\"262\";s:5:\"title\";s:23:\"Barber Shop Mobile Menu\";s:5:\"alias\";s:23:\"barber-shop-mobile-menu\";s:3:\"zip\";s:33:\"packs/barber-shop-mobile-menu.zip\";s:3:\"uid\";s:32:\"762c6fb5c6306f37becb1e55773c2592\";s:3:\"img\";s:34:\"barber-shop-mobile-menu/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:254;a:23:{s:2:\"id\";s:3:\"263\";s:5:\"title\";s:24:\"Barber Shop First Screen\";s:5:\"alias\";s:24:\"barber-shop-first-screen\";s:3:\"zip\";s:34:\"packs/barber-shop-first-screen.zip\";s:3:\"uid\";s:32:\"acf70bfd64cff2c3c2ea5585223575da\";s:3:\"img\";s:35:\"barber-shop-first-screen/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:255;a:23:{s:2:\"id\";s:3:\"264\";s:5:\"title\";s:17:\"Barber Shop About\";s:5:\"alias\";s:17:\"barber-shop-about\";s:3:\"zip\";s:27:\"packs/barber-shop-about.zip\";s:3:\"uid\";s:32:\"bc8b63cfc7f8c34173b4fd5b082fc05a\";s:3:\"img\";s:28:\"barber-shop-about/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:256;a:23:{s:2:\"id\";s:3:\"265\";s:5:\"title\";s:20:\"Barber Shop Services\";s:5:\"alias\";s:20:\"barber-shop-services\";s:3:\"zip\";s:30:\"packs/barber-shop-services.zip\";s:3:\"uid\";s:32:\"d65121d6f84fabd812a2b621b768e10e\";s:3:\"img\";s:31:\"barber-shop-services/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:257;a:23:{s:2:\"id\";s:3:\"266\";s:5:\"title\";s:19:\"Barber Shop Barbers\";s:5:\"alias\";s:19:\"barber-shop-barbers\";s:3:\"zip\";s:29:\"packs/barber-shop-barbers.zip\";s:3:\"uid\";s:32:\"003e9fec9693072119c8f8d8b6690c4d\";s:3:\"img\";s:30:\"barber-shop-barbers/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:258;a:23:{s:2:\"id\";s:3:\"267\";s:5:\"title\";s:20:\"Barber Shop Contacts\";s:5:\"alias\";s:20:\"barber-shop-contacts\";s:3:\"zip\";s:30:\"packs/barber-shop-contacts.zip\";s:3:\"uid\";s:32:\"cdcc08f5d6c90dbcfd0502bda2401643\";s:3:\"img\";s:31:\"barber-shop-contacts/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:259;a:23:{s:2:\"id\";s:3:\"268\";s:5:\"title\";s:18:\"Barber Shop Footer\";s:5:\"alias\";s:18:\"barber-shop-footer\";s:3:\"zip\";s:28:\"packs/barber-shop-footer.zip\";s:3:\"uid\";s:32:\"26ca5ae0de7cdbb2ca19348b6e01eda0\";s:3:\"img\";s:29:\"barber-shop-footer/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/barber-shop-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:220:\"<span class=\"ttm_content\">The Barber Shop is a useful One-Page template presenting all information about your business. Build your websites faster with Slider Revolution templates.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Barber Shop\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"16\";s:9:\"installed\";b:0;}i:260;a:20:{s:2:\"id\";s:3:\"269\";s:5:\"title\";s:12:\"Fitness Club\";s:5:\"alias\";s:21:\"fitness-club-template\";s:3:\"zip\";s:25:\"fitness-club-template.zip\";s:3:\"uid\";s:32:\"14ea10d68d6aad1df62b3becf71df754\";s:3:\"img\";s:32:\"fitness-club-template/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/fitness-club-header-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.1\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:223:\"<span class=\"ttm_content\">The Fitness Club Header is the perfect introduction to your fitness themed website. Showcase your current offers or service portfolio with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:261;a:20:{s:2:\"id\";s:3:\"270\";s:5:\"title\";s:13:\"Soccer School\";s:5:\"alias\";s:13:\"soccer-school\";s:3:\"zip\";s:17:\"soccer-school.zip\";s:3:\"uid\";s:32:\"9906b48812aff67097f990eeee42dd41\";s:3:\"img\";s:24:\"soccer-school/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/soccer-club-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:228:\"<span class=\"ttm_content\">The Soccer Club Header is the perfect introduction to your Soccer School themed website. Showcase your current offers or service portfolio with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:262;a:20:{s:2:\"id\";s:3:\"271\";s:5:\"title\";s:10:\"Music Band\";s:5:\"alias\";s:19:\"music-band-template\";s:3:\"zip\";s:23:\"music-band-template.zip\";s:3:\"uid\";s:32:\"91e79657bf1b1812f8114a00ab8e0eb4\";s:3:\"img\";s:30:\"music-band-template/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/music-band-template-for-wordpress/\";s:7:\"version\";s:5:\"1.0.1\";s:8:\"required\";s:7:\"5.4.8.2\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:221:\"<span class=\"ttm_content\">The Music Band Header is the perfect introduction to your Music Band themed website. Showcase your current songs, albums and videos with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:263;a:20:{s:2:\"id\";s:3:\"272\";s:5:\"title\";s:15:\"Restaurant Menu\";s:5:\"alias\";s:15:\"restaurant-menu\";s:3:\"zip\";s:19:\"restaurant-menu.zip\";s:3:\"uid\";s:32:\"078809cffb21b6c4d3f5aaa2daeb193d\";s:3:\"img\";s:26:\"restaurant-menu/slide1.jpg\";s:7:\"preview\";s:71:\"https://revolution.themepunch.com/restaurant-menu-slider-for-wordpress/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:7:\"5.4.8.3\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:208:\"<span class=\"ttm_content\">The Restaurant Menu Header is the perfect introduction to your Restaurant themed website. Showcase your current dishes with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:264;a:20:{s:2:\"id\";s:3:\"273\";s:5:\"title\";s:16:\"Cinematic Slider\";s:5:\"alias\";s:16:\"cinematic-slider\";s:3:\"zip\";s:20:\"cinematic-slider.zip\";s:3:\"uid\";s:32:\"c53e7dcbb6b656ae7b4c91d333589838\";s:3:\"img\";s:27:\"cinematic-slider/slide1.jpg\";s:7:\"preview\";s:60:\"https://revolution.themepunch.com/cinematic-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:138:\"<span class=\"ttm_content\">Bold texts and a cinematic transition effect make this slider stand out!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:265;a:20:{s:2:\"id\";s:3:\"274\";s:5:\"title\";s:17:\"3D Parallax Cubes\";s:5:\"alias\";s:17:\"3d-parallax-cubes\";s:3:\"zip\";s:21:\"3d-parallax-cubes.zip\";s:3:\"uid\";s:32:\"c5b809a1829f8f809c9a768cd3d6b3cb\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/3d-parallax-cubes-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">This amazing 3D cubes parallax effect can be an eye-opening intro for your website!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:266;a:23:{s:2:\"id\";s:3:\"275\";s:5:\"title\";s:33:\"Medicare Medical Services Website\";s:5:\"alias\";s:33:\"medicare-medical-services-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:41:\"medicare-medical-services-website-package\";s:3:\"img\";s:29:\"packages/medicare_package.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:267;a:23:{s:2:\"id\";s:3:\"276\";s:5:\"title\";s:13:\"Medicare Menu\";s:5:\"alias\";s:13:\"medicare-menu\";s:3:\"zip\";s:23:\"packs/medicare-menu.zip\";s:3:\"uid\";s:32:\"0e4ca8fc281e20251b3fffa19d470fed\";s:3:\"img\";s:24:\"medicare-menu/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:268;a:23:{s:2:\"id\";s:3:\"277\";s:5:\"title\";s:15:\"Medicare Header\";s:5:\"alias\";s:15:\"medicare-header\";s:3:\"zip\";s:25:\"packs/medicare-header.zip\";s:3:\"uid\";s:32:\"03e8ade247d8c96f548bc0515f34043f\";s:3:\"img\";s:26:\"medicare-header/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:269;a:23:{s:2:\"id\";s:3:\"278\";s:5:\"title\";s:14:\"Medicare About\";s:5:\"alias\";s:14:\"medicare-about\";s:3:\"zip\";s:24:\"packs/medicare-about.zip\";s:3:\"uid\";s:32:\"a3ab9e89155ef2542820343f30b29f72\";s:3:\"img\";s:25:\"medicare-about/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:270;a:23:{s:2:\"id\";s:3:\"279\";s:5:\"title\";s:18:\"Medicare Highlight\";s:5:\"alias\";s:18:\"medicare-highlight\";s:3:\"zip\";s:28:\"packs/medicare-highlight.zip\";s:3:\"uid\";s:32:\"c3c8a74e5402489f1a85a0c83890ef1f\";s:3:\"img\";s:29:\"medicare-highlight/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:271;a:23:{s:2:\"id\";s:3:\"280\";s:5:\"title\";s:17:\"Medicare Services\";s:5:\"alias\";s:17:\"medicare-services\";s:3:\"zip\";s:27:\"packs/medicare-services.zip\";s:3:\"uid\";s:32:\"8869b0834d4649dcc3221bed65980806\";s:3:\"img\";s:28:\"medicare-services/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:272;a:23:{s:2:\"id\";s:3:\"281\";s:5:\"title\";s:16:\"Medicare Doctors\";s:5:\"alias\";s:16:\"medicare-doctors\";s:3:\"zip\";s:26:\"packs/medicare-doctors.zip\";s:3:\"uid\";s:32:\"2c9d57afd64244b5f7e30b0d87c842f9\";s:3:\"img\";s:27:\"medicare-doctors/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:273;a:23:{s:2:\"id\";s:3:\"282\";s:5:\"title\";s:17:\"Medicare Research\";s:5:\"alias\";s:17:\"medicare-research\";s:3:\"zip\";s:27:\"packs/medicare-research.zip\";s:3:\"uid\";s:32:\"31e84a91fc8b8d5296e715e539a076d0\";s:3:\"img\";s:28:\"medicare-research/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:274;a:23:{s:2:\"id\";s:3:\"283\";s:5:\"title\";s:19:\"Medicare Why Choose\";s:5:\"alias\";s:18:\"medicare-whychoose\";s:3:\"zip\";s:28:\"packs/medicare-whychoose.zip\";s:3:\"uid\";s:32:\"6dad61c672127de9e35884caa45d49a0\";s:3:\"img\";s:29:\"medicare-whychoose/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:275;a:23:{s:2:\"id\";s:3:\"284\";s:5:\"title\";s:16:\"Medicare Contact\";s:5:\"alias\";s:16:\"medicare-contact\";s:3:\"zip\";s:26:\"packs/medicare-contact.zip\";s:3:\"uid\";s:32:\"89bc35ad8beb62a149c42262ae49a270\";s:3:\"img\";s:27:\"medicare-contact/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:276;a:23:{s:2:\"id\";s:3:\"285\";s:5:\"title\";s:15:\"Medicare Footer\";s:5:\"alias\";s:15:\"medicare-footer\";s:3:\"zip\";s:25:\"packs/medicare-footer.zip\";s:3:\"uid\";s:32:\"ccf63e5233b3d63009e5ee90db51b37b\";s:3:\"img\";s:26:\"medicare-footer/slide1.jpg\";s:7:\"preview\";s:68:\"https://revolution.themepunch.com/medicare-medical-services-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:163:\"<span class=\"ttm_content\">The Medicare Medical Services template is a great solution for your medical practice or hospital.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:25:\"Medicare Medical Services\";s:13:\"package_order\";s:2:\"10\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"17\";s:9:\"installed\";b:0;}i:277;a:23:{s:2:\"id\";s:3:\"286\";s:5:\"title\";s:20:\"Coffee Joint Website\";s:5:\"alias\";s:20:\"coffee-joint-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"coffee-joint-website-package\";s:3:\"img\";s:27:\"packages/coffee_package.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:278;a:23:{s:2:\"id\";s:3:\"287\";s:5:\"title\";s:11:\"Coffee Menu\";s:5:\"alias\";s:11:\"coffee-menu\";s:3:\"zip\";s:21:\"packs/coffee-menu.zip\";s:3:\"uid\";s:32:\"81195cad7be3f5180a267b34ce8cf966\";s:3:\"img\";s:22:\"coffee-menu/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:279;a:23:{s:2:\"id\";s:3:\"288\";s:5:\"title\";s:13:\"Coffee Header\";s:5:\"alias\";s:13:\"coffee-header\";s:3:\"zip\";s:23:\"packs/coffee-header.zip\";s:3:\"uid\";s:32:\"5eed8adb9d3ae12168ad4735ac63eb20\";s:3:\"img\";s:24:\"coffee-header/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:280;a:23:{s:2:\"id\";s:3:\"289\";s:5:\"title\";s:17:\"Coffee Philosophy\";s:5:\"alias\";s:17:\"coffee-philosophy\";s:3:\"zip\";s:27:\"packs/coffee-philosophy.zip\";s:3:\"uid\";s:32:\"76b5ccae3fa87fd0f991b87e7ae71c27\";s:3:\"img\";s:28:\"coffee-philosophy/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:281;a:23:{s:2:\"id\";s:3:\"290\";s:5:\"title\";s:12:\"Coffee Carte\";s:5:\"alias\";s:12:\"coffee-carte\";s:3:\"zip\";s:22:\"packs/coffee-carte.zip\";s:3:\"uid\";s:32:\"470214ddd2cec585629fb79a0fd908d6\";s:3:\"img\";s:23:\"coffee-carte/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:282;a:23:{s:2:\"id\";s:3:\"291\";s:5:\"title\";s:13:\"Coffee Teaser\";s:5:\"alias\";s:13:\"coffee-teaser\";s:3:\"zip\";s:23:\"packs/coffee-teaser.zip\";s:3:\"uid\";s:32:\"2ed868896c92a7bfb6431803c79e8486\";s:3:\"img\";s:24:\"coffee-teaser/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:283;a:23:{s:2:\"id\";s:3:\"292\";s:5:\"title\";s:14:\"Coffee Find Us\";s:5:\"alias\";s:13:\"coffee-findus\";s:3:\"zip\";s:23:\"packs/coffee-findus.zip\";s:3:\"uid\";s:32:\"96d3784473dfa64bce9e1e4101919927\";s:3:\"img\";s:24:\"coffee-findus/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:284;a:23:{s:2:\"id\";s:3:\"293\";s:5:\"title\";s:13:\"Coffee Footer\";s:5:\"alias\";s:13:\"coffee-footer\";s:3:\"zip\";s:23:\"packs/coffee-footer.zip\";s:3:\"uid\";s:32:\"6027c25e87a5fe7fd8727a51c0967915\";s:3:\"img\";s:24:\"coffee-footer/slide1.jpg\";s:7:\"preview\";s:76:\"https://revolution.themepunch.com/coffee-joint-coffee-shop-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:144:\"<span class=\"ttm_content\">The Coffee Joint website template is a great solution for your cafe or bistro.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Coffee Joint\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"18\";s:9:\"installed\";b:0;}i:285;a:23:{s:2:\"id\";s:3:\"294\";s:5:\"title\";s:17:\"Minimal Portfolio\";s:5:\"alias\";s:25:\"minimal-portfolio-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:25:\"minimal-portfolio-package\";s:3:\"img\";s:38:\"packages/minimal_portfolio_package.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/minimal-portfolio-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">The Minimal Portfolio template is a slide based website with additional modal detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Minimal Portfolio\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"19\";s:9:\"installed\";b:0;}i:286;a:23:{s:2:\"id\";s:3:\"295\";s:5:\"title\";s:17:\"Minimal Portfolio\";s:5:\"alias\";s:17:\"minimal-portfolio\";s:3:\"zip\";s:27:\"packs/minimal-portfolio.zip\";s:3:\"uid\";s:32:\"183b97b301d5ff0b171c067a87c8a3f5\";s:3:\"img\";s:28:\"minimal-portfolio/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/minimal-portfolio-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">The Minimal Portfolio template is a slide based website with additional modal detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Minimal Portfolio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"19\";s:9:\"installed\";b:0;}i:287;a:23:{s:2:\"id\";s:3:\"296\";s:5:\"title\";s:23:\"Minimal Portfolio Modal\";s:5:\"alias\";s:23:\"minimal-portfolio-modal\";s:3:\"zip\";s:33:\"packs/minimal-portfolio-modal.zip\";s:3:\"uid\";s:32:\"6874e6cec3663670f209a8d8a4f26b16\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/minimal-portfolio-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:157:\"<span class=\"ttm_content\">The Minimal Portfolio template is a slide based website with additional modal detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:17:\"Minimal Portfolio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"19\";s:9:\"installed\";b:0;}i:288;a:23:{s:2:\"id\";s:3:\"297\";s:5:\"title\";s:23:\"Angled Business Website\";s:5:\"alias\";s:23:\"angled-business-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:31:\"angled-business-website-package\";s:3:\"img\";s:27:\"packages/angled_package.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:289;a:23:{s:2:\"id\";s:3:\"298\";s:5:\"title\";s:11:\"Angled Menu\";s:5:\"alias\";s:11:\"angled-menu\";s:3:\"zip\";s:21:\"packs/angled-menu.zip\";s:3:\"uid\";s:32:\"2fe0c4682d1231ee3918be9e4fcb1837\";s:3:\"img\";s:22:\"angled-menu/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:290;a:23:{s:2:\"id\";s:3:\"299\";s:5:\"title\";s:13:\"Angled Header\";s:5:\"alias\";s:13:\"angled-header\";s:3:\"zip\";s:23:\"packs/angled-header.zip\";s:3:\"uid\";s:32:\"09462601d4edca8dff899de6f666dc47\";s:3:\"img\";s:24:\"angled-header/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:291;a:23:{s:2:\"id\";s:3:\"300\";s:5:\"title\";s:11:\"Angled News\";s:5:\"alias\";s:11:\"angled-news\";s:3:\"zip\";s:21:\"packs/angled-news.zip\";s:3:\"uid\";s:32:\"b315105763ed91214cb2f0ac12615729\";s:3:\"img\";s:22:\"angled-news/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:292;a:23:{s:2:\"id\";s:3:\"301\";s:5:\"title\";s:15:\"Angled Services\";s:5:\"alias\";s:15:\"angled-services\";s:3:\"zip\";s:25:\"packs/angled-services.zip\";s:3:\"uid\";s:32:\"7605651c1487e1a6c32edc70017be8ad\";s:3:\"img\";s:26:\"angled-services/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:293;a:23:{s:2:\"id\";s:3:\"302\";s:5:\"title\";s:14:\"Angled Success\";s:5:\"alias\";s:14:\"angled-success\";s:3:\"zip\";s:24:\"packs/angled-success.zip\";s:3:\"uid\";s:32:\"9e3fa974a42ecf80e1ec6ff991fca430\";s:3:\"img\";s:25:\"angled-success/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:294;a:23:{s:2:\"id\";s:3:\"303\";s:5:\"title\";s:13:\"Angled Footer\";s:5:\"alias\";s:13:\"angled-footer\";s:3:\"zip\";s:23:\"packs/angled-footer.zip\";s:3:\"uid\";s:32:\"aed4eaa2f7883351ba9c9947feef153e\";s:3:\"img\";s:24:\"angled-footer/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:295;a:23:{s:2:\"id\";s:3:\"304\";s:5:\"title\";s:20:\"Angled Content Modal\";s:5:\"alias\";s:20:\"angled-content-modal\";s:3:\"zip\";s:30:\"packs/angled-content-modal.zip\";s:3:\"uid\";s:32:\"4ddc74515fdf84f974217e4ed47a7c66\";s:3:\"img\";s:31:\"angled-content-modal/slide1.jpg\";s:7:\"preview\";s:67:\"https://revolution.themepunch.com/angled-business-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:175:\"<span class=\"ttm_content\">The Angled Business Website template is a geometric, parallax one-page website with modal based detail pages.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:15:\"Angled Business\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"20\";s:9:\"installed\";b:0;}i:296;a:23:{s:2:\"id\";s:3:\"305\";s:5:\"title\";s:12:\"Big and Bold\";s:5:\"alias\";s:20:\"big-and-bold-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:28:\"big-and-bold-website-package\";s:3:\"img\";s:29:\"packages/big_bold_package.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/big-bold-minimal-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">The and Bold Website template is a minimal one-page template for simple website needs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Big and Bold\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"21\";s:9:\"installed\";b:0;}i:297;a:23:{s:2:\"id\";s:3:\"306\";s:5:\"title\";s:13:\"Big Bold Menu\";s:5:\"alias\";s:13:\"big-bold-menu\";s:3:\"zip\";s:23:\"packs/big-bold-menu.zip\";s:3:\"uid\";s:32:\"5afb06f47a443b61cfefa32c4e1c08bd\";s:3:\"img\";s:24:\"big-bold-menu/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/big-bold-minimal-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">The and Bold Website template is a minimal one-page template for simple website needs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Big and Bold\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"21\";s:9:\"installed\";b:0;}i:298;a:23:{s:2:\"id\";s:3:\"307\";s:5:\"title\";s:15:\"Big Bold Header\";s:5:\"alias\";s:15:\"big-bold-header\";s:3:\"zip\";s:25:\"packs/big-bold-header.zip\";s:3:\"uid\";s:32:\"3fc6c409a59eafe7998bd16f6084a385\";s:3:\"img\";s:26:\"big-bold-header/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/big-bold-minimal-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">The and Bold Website template is a minimal one-page template for simple website needs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Big and Bold\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"21\";s:9:\"installed\";b:0;}i:299;a:23:{s:2:\"id\";s:3:\"308\";s:5:\"title\";s:16:\"Big Bold Content\";s:5:\"alias\";s:16:\"big-bold-content\";s:3:\"zip\";s:26:\"packs/big-bold-content.zip\";s:3:\"uid\";s:32:\"ccd6042ac7aebd80f30bca0c6426675b\";s:3:\"img\";s:27:\"big-bold-content/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/big-bold-minimal-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">The and Bold Website template is a minimal one-page template for simple website needs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Big and Bold\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"21\";s:9:\"installed\";b:0;}i:300;a:23:{s:2:\"id\";s:3:\"309\";s:5:\"title\";s:13:\"Big Bold Blog\";s:5:\"alias\";s:13:\"big-bold-blog\";s:3:\"zip\";s:23:\"packs/big-bold-blog.zip\";s:3:\"uid\";s:32:\"9c508cba6977aa320aa34b7140a6dbad\";s:3:\"img\";s:24:\"big-bold-blog/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/big-bold-minimal-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">The and Bold Website template is a minimal one-page template for simple website needs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Big and Bold\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"21\";s:9:\"installed\";b:0;}i:301;a:23:{s:2:\"id\";s:3:\"310\";s:5:\"title\";s:18:\"Big Bold Highlight\";s:5:\"alias\";s:18:\"big-bold-highlight\";s:3:\"zip\";s:28:\"packs/big-bold-highlight.zip\";s:3:\"uid\";s:32:\"a1114c0759113f21504fe7a29a06396d\";s:3:\"img\";s:29:\"big-bold-highlight/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/big-bold-minimal-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">The and Bold Website template is a minimal one-page template for simple website needs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Big and Bold\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"21\";s:9:\"installed\";b:0;}i:302;a:23:{s:2:\"id\";s:3:\"311\";s:5:\"title\";s:15:\"Big Bold Footer\";s:5:\"alias\";s:15:\"big-bold-footer\";s:3:\"zip\";s:25:\"packs/big-bold-footer.zip\";s:3:\"uid\";s:32:\"11c0fa0c3084c2977ee90de0764e500d\";s:3:\"img\";s:26:\"big-bold-footer/slide1.jpg\";s:7:\"preview\";s:69:\"https://revolution.themepunch.com/big-bold-minimal-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:152:\"<span class=\"ttm_content\">The and Bold Website template is a minimal one-page template for simple website needs.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:12:\"Big and Bold\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"21\";s:9:\"installed\";b:0;}i:303;a:20:{s:2:\"id\";s:3:\"312\";s:5:\"title\";s:24:\"Retouch Before and After\";s:5:\"alias\";s:7:\"Retouch\";s:3:\"zip\";s:11:\"Retouch.zip\";s:3:\"uid\";s:32:\"58894991f1abd8b448c8d353b1b5fe76\";s:3:\"img\";s:18:\"Retouch/slide1.jpg\";s:7:\"preview\";s:61:\"http://revolution.themepunch.com/retouch-before-after-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">The Retouch Slider is the perfect way to compare your photos before and after retouching.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:304;a:20:{s:2:\"id\";s:3:\"313\";s:5:\"title\";s:11:\"Tech Slider\";s:5:\"alias\";s:11:\"tech-slider\";s:3:\"zip\";s:15:\"tech-slider.zip\";s:3:\"uid\";s:32:\"a98e2b264f00a1116d21808c6a543162\";s:3:\"img\";s:22:\"tech-slider/slide1.jpg\";s:7:\"preview\";s:63:\"http://revolution.themepunch.com/tech-showcase-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:153:\"<span class=\"ttm_content\">This classic slider module with sleek device mockups features a smooth parallax effect.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:305;a:23:{s:2:\"id\";s:3:\"314\";s:5:\"title\";s:19:\"Peak Agency Website\";s:5:\"alias\";s:19:\"peak-agency-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:27:\"peak-agency-website-package\";s:3:\"img\";s:25:\"packages/peak_package.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:306;a:23:{s:2:\"id\";s:3:\"315\";s:5:\"title\";s:11:\"Peak Header\";s:5:\"alias\";s:11:\"peak-header\";s:3:\"zip\";s:21:\"packs/peak-header.zip\";s:3:\"uid\";s:32:\"b721bd612e9fbc5182418ad3fd7d0808\";s:3:\"img\";s:22:\"peak-header/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:307;a:23:{s:2:\"id\";s:3:\"316\";s:5:\"title\";s:10:\"Peak About\";s:5:\"alias\";s:10:\"peak-about\";s:3:\"zip\";s:20:\"packs/peak-about.zip\";s:3:\"uid\";s:32:\"7e68b1012fb03490d45c7f79e8cb1b19\";s:3:\"img\";s:21:\"peak-about/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:308;a:23:{s:2:\"id\";s:3:\"317\";s:5:\"title\";s:14:\"Peak Portfolio\";s:5:\"alias\";s:14:\"peak-portfolio\";s:3:\"zip\";s:24:\"packs/peak-portfolio.zip\";s:3:\"uid\";s:32:\"6198d1885ba9e95221c33e404f21bdbc\";s:3:\"img\";s:25:\"peak-portfolio/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:309;a:23:{s:2:\"id\";s:3:\"318\";s:5:\"title\";s:11:\"Peak Footer\";s:5:\"alias\";s:11:\"peak-footer\";s:3:\"zip\";s:21:\"packs/peak-footer.zip\";s:3:\"uid\";s:32:\"2dead6897ad3b3a709b380d81242f76b\";s:3:\"img\";s:22:\"peak-footer/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/peak-agency-website-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:129:\"<span class=\"ttm_content\">The Peak Agency Website template is a minimal, light one-pager.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:11:\"Peak Agency\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"22\";s:9:\"installed\";b:0;}i:310;a:23:{s:2:\"id\";s:3:\"319\";s:5:\"title\";s:24:\"Modern Portfolio Website\";s:5:\"alias\";s:24:\"modern-portfolio-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:32:\"modern-portfolio-website-package\";s:3:\"img\";s:30:\"packages/portfolio-package.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:311;a:23:{s:2:\"id\";s:3:\"320\";s:5:\"title\";s:17:\"Portfolio Welcome\";s:5:\"alias\";s:17:\"portfolio-welcome\";s:3:\"zip\";s:27:\"packs/portfolio-welcome.zip\";s:3:\"uid\";s:32:\"97336b8785e4a7b27facaf1547e0464d\";s:3:\"img\";s:28:\"portfolio-welcome/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:312;a:23:{s:2:\"id\";s:3:\"321\";s:5:\"title\";s:15:\"Portfolio About\";s:5:\"alias\";s:15:\"portfolio-about\";s:3:\"zip\";s:25:\"packs/portfolio-about.zip\";s:3:\"uid\";s:32:\"5d3a4724fd453de5313ceb6696c1db62\";s:3:\"img\";s:26:\"portfolio-about/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:313;a:23:{s:2:\"id\";s:3:\"322\";s:5:\"title\";s:21:\"Portfolio Works Title\";s:5:\"alias\";s:21:\"portfolio-works-title\";s:3:\"zip\";s:31:\"packs/portfolio-works-title.zip\";s:3:\"uid\";s:32:\"cbb5c6e875cc1f25b463fdf89cabef28\";s:3:\"img\";s:32:\"portfolio-works-title/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:314;a:23:{s:2:\"id\";s:3:\"323\";s:5:\"title\";s:23:\"Portfolio Works Content\";s:5:\"alias\";s:23:\"portfolio-works-content\";s:3:\"zip\";s:33:\"packs/portfolio-works-content.zip\";s:3:\"uid\";s:32:\"5c87311128c7794ffa6ee07ea0648082\";s:3:\"img\";s:34:\"portfolio-works-content/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:315;a:23:{s:2:\"id\";s:3:\"324\";s:5:\"title\";s:18:\"Portfolio Contacts\";s:5:\"alias\";s:18:\"portfolio-contacts\";s:3:\"zip\";s:28:\"packs/portfolio-contacts.zip\";s:3:\"uid\";s:32:\"bd81feffad83b69218f7e837478038e5\";s:3:\"img\";s:29:\"portfolio-contacts/slide1.jpg\";s:7:\"preview\";s:59:\"https://revolution.themepunch.com/modern-portfolio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern portfolio template with fancy scroll animations and a colorful design.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:16:\"Modern Portfolio\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"23\";s:9:\"installed\";b:0;}i:316;a:23:{s:2:\"id\";s:3:\"325\";s:5:\"title\";s:18:\"App Studio Website\";s:5:\"alias\";s:18:\"app-studio-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:26:\"app-studio-website-package\";s:3:\"img\";s:31:\"packages/App_Studio_package.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:317;a:23:{s:2:\"id\";s:3:\"326\";s:5:\"title\";s:18:\"App Studio Welcome\";s:5:\"alias\";s:18:\"App-Studio-Welcome\";s:3:\"zip\";s:28:\"packs/App-Studio-Welcome.zip\";s:3:\"uid\";s:32:\"2ce0f3c54214b04e6c3a9becfd59730c\";s:3:\"img\";s:29:\"App-Studio-Welcome/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:318;a:23:{s:2:\"id\";s:3:\"327\";s:5:\"title\";s:19:\"App Studio Services\";s:5:\"alias\";s:19:\"App-Studio-Services\";s:3:\"zip\";s:29:\"packs/App-Studio-Services.zip\";s:3:\"uid\";s:32:\"5df7776271ec69d2f9edaa6b842715a9\";s:3:\"img\";s:30:\"App-Studio-Services/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:319;a:23:{s:2:\"id\";s:3:\"328\";s:5:\"title\";s:16:\"App Studio About\";s:5:\"alias\";s:16:\"App-Studio-About\";s:3:\"zip\";s:26:\"packs/App-Studio-About.zip\";s:3:\"uid\";s:32:\"af8b84dc116c629df7bd89fc69271a2e\";s:3:\"img\";s:27:\"App-Studio-About/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:320;a:23:{s:2:\"id\";s:3:\"329\";s:5:\"title\";s:19:\"App Studio Contacts\";s:5:\"alias\";s:19:\"App-Studio-Contacts\";s:3:\"zip\";s:29:\"packs/App-Studio-Contacts.zip\";s:3:\"uid\";s:32:\"afbbd2214c983d314f3215a00db9198d\";s:3:\"img\";s:30:\"App-Studio-Contacts/slide1.jpg\";s:7:\"preview\";s:53:\"https://revolution.themepunch.com/app-studio-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:149:\"<span class=\"ttm_content\">A modern one-page presentation website to present your mobile app development team.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:10:\"App Studio\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"24\";s:9:\"installed\";b:0;}i:321;a:20:{s:2:\"id\";s:3:\"330\";s:5:\"title\";s:14:\"Cube Animation\";s:5:\"alias\";s:14:\"cube-animation\";s:3:\"zip\";s:18:\"cube-animation.zip\";s:3:\"uid\";s:32:\"c03dd3cfc60479dfc6d79ddb64fa0ec5\";s:3:\"img\";s:25:\"cube-animation/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/cube-animation-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:155:\"<span class=\"ttm_content\">A modern slider with text elements, cube animations and a striking call to action button.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:322;a:23:{s:2:\"id\";s:3:\"331\";s:5:\"title\";s:13:\"Basic Website\";s:5:\"alias\";s:13:\"basic-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:21:\"basic-website-package\";s:3:\"img\";s:26:\"packages/basic_package.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:323;a:23:{s:2:\"id\";s:3:\"332\";s:5:\"title\";s:10:\"Basic Menu\";s:5:\"alias\";s:10:\"basic-menu\";s:3:\"zip\";s:20:\"packs/basic-menu.zip\";s:3:\"uid\";s:32:\"39277f53b2cb5ac644a1649b47c37270\";s:3:\"img\";s:21:\"basic-menu/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:324;a:23:{s:2:\"id\";s:3:\"333\";s:5:\"title\";s:12:\"Basic Header\";s:5:\"alias\";s:12:\"basic-header\";s:3:\"zip\";s:22:\"packs/basic-header.zip\";s:3:\"uid\";s:32:\"ad7a32dbccb0bdf9de64cf2adfa950a2\";s:3:\"img\";s:23:\"basic-header/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:325;a:23:{s:2:\"id\";s:3:\"334\";s:5:\"title\";s:13:\"Basic Content\";s:5:\"alias\";s:13:\"basic-content\";s:3:\"zip\";s:23:\"packs/basic-content.zip\";s:3:\"uid\";s:32:\"0b12f3b183a3c8206e3a7b28d2d93108\";s:3:\"img\";s:24:\"basic-content/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:326;a:23:{s:2:\"id\";s:3:\"335\";s:5:\"title\";s:14:\"Basic Carousel\";s:5:\"alias\";s:14:\"basic-carousel\";s:3:\"zip\";s:24:\"packs/basic-carousel.zip\";s:3:\"uid\";s:32:\"e4abb5c6d5cf914530575a982d3dfc14\";s:3:\"img\";s:25:\"basic-carousel/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:8:\"carousel\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:327;a:23:{s:2:\"id\";s:3:\"336\";s:5:\"title\";s:13:\"Basic Callout\";s:5:\"alias\";s:13:\"basic-callout\";s:3:\"zip\";s:23:\"packs/basic-callout.zip\";s:3:\"uid\";s:32:\"2ccc208b9322f5435d0f4ff64c6d9dab\";s:3:\"img\";s:24:\"basic-callout/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:328;a:23:{s:2:\"id\";s:3:\"337\";s:5:\"title\";s:10:\"Basic Grid\";s:5:\"alias\";s:10:\"basic-grid\";s:3:\"zip\";s:20:\"packs/basic-grid.zip\";s:3:\"uid\";s:32:\"3cb4b41d2992eba012921b8fb7c96daa\";s:3:\"img\";s:21:\"basic-grid/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:329;a:23:{s:2:\"id\";s:3:\"338\";s:5:\"title\";s:17:\"Basic Video Block\";s:5:\"alias\";s:17:\"basic-video-block\";s:3:\"zip\";s:27:\"packs/basic-video-block.zip\";s:3:\"uid\";s:32:\"e7c1d42b21819741f3e72c1325dae5ed\";s:3:\"img\";s:28:\"basic-video-block/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"7\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:330;a:23:{s:2:\"id\";s:3:\"339\";s:5:\"title\";s:12:\"Basic Footer\";s:5:\"alias\";s:12:\"basic-footer\";s:3:\"zip\";s:22:\"packs/basic-footer.zip\";s:3:\"uid\";s:32:\"ed8f6a554775ebace558af2f4f2dcbac\";s:3:\"img\";s:23:\"basic-footer/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"8\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:331;a:23:{s:2:\"id\";s:3:\"340\";s:5:\"title\";s:14:\"Basic Lightbox\";s:5:\"alias\";s:14:\"basic-lightbox\";s:3:\"zip\";s:24:\"packs/basic-lightbox.zip\";s:3:\"uid\";s:32:\"e4b025b300b1a8f417d04eb80113fac2\";s:3:\"img\";s:25:\"basic-lightbox/slide1.jpg\";s:7:\"preview\";s:48:\"https://revolution.themepunch.com/basic-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:187:\"<span class=\"ttm_content\">The Basic Website template is a minimal one-page website with all the essential modules. Usable and quickly customizable.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:13:\"Basic Website\";s:13:\"package_order\";s:1:\"9\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"25\";s:9:\"installed\";b:0;}i:332;a:20:{s:2:\"id\";s:3:\"341\";s:5:\"title\";s:13:\"Nature Slider\";s:5:\"alias\";s:13:\"nature-slider\";s:3:\"zip\";s:17:\"nature-slider.zip\";s:3:\"uid\";s:32:\"eef1a4584ec1c3b8c26c305cca44e805\";s:3:\"img\";s:24:\"nature-slider/slide1.jpg\";s:7:\"preview\";s:56:\"http://revolution.themepunch.com/nature-explorer-slider/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:151:\"<span class=\"ttm_content\">The Nature Explorer Slider Template uses the Distortion and Particle Effects Add-Ons.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";s:356:\"[{\"path\":\"revslider-particles-addon\\/revslider-particles-addon.php\",\"name\":\"Particles Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"},{\"path\":\"revslider-liquideffect-addon\\/revslider-liquideffect-addon.php\",\"name\":\"Distortion Effect AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:333;a:20:{s:2:\"id\";s:3:\"342\";s:5:\"title\";s:11:\"Art Gallery\";s:5:\"alias\";s:11:\"art-gallery\";s:3:\"zip\";s:15:\"art-gallery.zip\";s:3:\"uid\";s:32:\"b8c5095ae3407337e6e5b2a8515e7d6e\";s:3:\"img\";s:22:\"art-gallery/slide1.jpg\";s:7:\"preview\";s:62:\"https://revolution.themepunch.com/art-gallery-slider-template/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:145:\"<span class=\"ttm_content\">A modern slider with large, geometric elements and interesting mask animations.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:334;a:23:{s:2:\"id\";s:3:\"343\";s:5:\"title\";s:20:\"Construction Company\";s:5:\"alias\";s:28:\"construction-company-website\";s:3:\"zip\";s:0:\"\";s:3:\"uid\";s:36:\"construction-company-website-package\";s:3:\"img\";s:33:\"packages/construction_package.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1024\";s:6:\"height\";s:3:\"768\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:7:\"website\";}s:14:\"plugin_require\";s:163:\"[{\"path\":\"revslider-revealer-addon\\/revslider-revealer-addon.php\",\"name\":\"Reveal AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"0\";s:14:\"package_parent\";s:4:\"true\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:335;a:23:{s:2:\"id\";s:3:\"344\";s:5:\"title\";s:19:\"Construction Header\";s:5:\"alias\";s:19:\"Construction-Header\";s:3:\"zip\";s:29:\"packs/Construction-Header.zip\";s:3:\"uid\";s:32:\"5c77de774b8f5487c1276c4a7b3dc80c\";s:3:\"img\";s:30:\"Construction-Header/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"1\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:336;a:23:{s:2:\"id\";s:3:\"345\";s:5:\"title\";s:17:\"Construction Home\";s:5:\"alias\";s:17:\"Construction-Home\";s:3:\"zip\";s:27:\"packs/Construction-Home.zip\";s:3:\"uid\";s:32:\"fcb277f0c07dad270d2a7cef4431bef8\";s:3:\"img\";s:28:\"Construction-Home/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:6:\"slider\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"2\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:337;a:23:{s:2:\"id\";s:3:\"346\";s:5:\"title\";s:21:\"Construction Projects\";s:5:\"alias\";s:21:\"Construction-Projects\";s:3:\"zip\";s:31:\"packs/Construction-Projects.zip\";s:3:\"uid\";s:32:\"0c847173c3739f79778dc2c0fc9704e4\";s:3:\"img\";s:32:\"Construction-Projects/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"3\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:338;a:23:{s:2:\"id\";s:3:\"347\";s:5:\"title\";s:20:\"Construction History\";s:5:\"alias\";s:20:\"Construction-History\";s:3:\"zip\";s:30:\"packs/Construction-History.zip\";s:3:\"uid\";s:32:\"758da120c4b6c5606692faf0aa43aac6\";s:3:\"img\";s:31:\"Construction-History/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"4\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:339;a:23:{s:2:\"id\";s:3:\"348\";s:5:\"title\";s:21:\"Construction Services\";s:5:\"alias\";s:21:\"Construction-Services\";s:3:\"zip\";s:31:\"packs/Construction-Services.zip\";s:3:\"uid\";s:32:\"5ad5b841c1d89e97ddbf972c8b11abd4\";s:3:\"img\";s:32:\"Construction-Services/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"5\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:340;a:23:{s:2:\"id\";s:3:\"349\";s:5:\"title\";s:21:\"Construction Contacts\";s:5:\"alias\";s:21:\"Construction-Contacts\";s:3:\"zip\";s:31:\"packs/Construction-Contacts.zip\";s:3:\"uid\";s:32:\"b8c3c34046bb91ebb243e4da64745d37\";s:3:\"img\";s:32:\"Construction-Contacts/slide1.jpg\";s:7:\"preview\";s:63:\"https://revolution.themepunch.com/construction-company-website/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:244:\"<span class=\"ttm_content\">The Construction Company is the perfect introduction to your Construction themed website. Showcase your current projects, services and contact information with sleek transitions!</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:420:\"<span class=\"ttm_content\">If you want to setup the full website example as seen in the preview, please follow the <a href=\"https://www.themepunch.com/faq/setup-content-blocks-template/\" target=\"_blank\">Content Blocks instructions here</a>.<br><br>\r\n<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:2:{i:0;s:4:\"hero\";i:1;s:7:\"website\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:7:\"package\";s:20:\"Construction Company\";s:13:\"package_order\";s:1:\"6\";s:14:\"package_parent\";s:0:\"\";s:6:\"active\";s:1:\"1\";s:10:\"package_id\";s:2:\"26\";s:9:\"installed\";b:0;}i:341;a:20:{s:2:\"id\";s:3:\"350\";s:5:\"title\";s:22:\"Classic Cars Evolution\";s:5:\"alias\";s:22:\"Classic-Cars-Evolution\";s:3:\"zip\";s:26:\"Classic-Cars-Evolution.zip\";s:3:\"uid\";s:32:\"7061757f128fd624b0227715dab73b74\";s:3:\"img\";s:33:\"Classic-Cars-Evolution/slide1.jpg\";s:7:\"preview\";s:65:\"https://revolution.themepunch.com/classic-cars-before-after-hero/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:156:\"<span class=\"ttm_content\">The Classic Cars Evolution Slider is a great example of our popular before & after Add-On.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:4:\"hero\";}s:14:\"plugin_require\";s:175:\"[{\"path\":\"revslider-beforeafter-addon\\/revslider-beforeafter-addon.php\",\"name\":\"Before After AddOn\",\"url\":\"https:\\/\\/www.themepunch.com\\/slider-revolution\\/install-addons\\/\"}]\";s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}i:342;a:20:{s:2:\"id\";s:3:\"351\";s:5:\"title\";s:21:\"404 Error Space Theme\";s:5:\"alias\";s:21:\"404-Error-Space-Theme\";s:3:\"zip\";s:25:\"404-Error-Space-Theme.zip\";s:3:\"uid\";s:32:\"6412adc7ec025826328e40e552a14e1e\";s:3:\"img\";s:32:\"404-Error-Space-Theme/slide1.jpg\";s:7:\"preview\";s:49:\"https://revolution.themepunch.com/404-error-page/\";s:7:\"version\";s:5:\"1.0.0\";s:8:\"required\";s:5:\"6.0.0\";s:5:\"width\";s:4:\"1240\";s:6:\"height\";s:3:\"868\";s:11:\"description\";s:158:\"<span class=\"ttm_content\">The Classic Cars Evolution Slider is the perfect way to make your error page more beautiful.</span>\r\n<span class=\"ttm_space\"></span>\";s:11:\"setup_notes\";s:171:\"<span class=\"ttm_content\">Checkout our <a href=\"https://revolution.themepunch.com/documentation\" target=\"_blank\">Documentation</a> for basic Slider Revolution help.</span>\";s:3:\"cat\";s:7:\"Premium\";s:6:\"filter\";a:1:{i:0;s:6:\"slider\";}s:14:\"plugin_require\";N;s:4:\"date\";s:19:\"0000-00-00 00:00:00\";s:13:\"package_order\";s:1:\"0\";s:6:\"active\";s:1:\"1\";s:9:\"installed\";b:0;}}s:6:\"slides\";a:316:{s:16:\"classic-carousel\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"classic-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"classic-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"classic-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"classic-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"classic-carousel/slide5.jpg\";}}s:13:\"classicslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"classicslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"classicslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"classicslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"classicslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:24:\"classicslider/slide5.jpg\";}}s:11:\"contenttabs\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contenttabs/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contenttabs/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contenttabs/slide3.jpg\";}}s:13:\"facebook-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"facebook-feed/slide1.jpg\";}}s:7:\"fashion\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"fashion/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"fashion/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"fashion/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"fashion/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"fashion/slide5.jpg\";}}s:14:\"flickr-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"flickr-gallery/slide1.jpg\";}}s:3:\"gym\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"gym/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:14:\"gym/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:14:\"gym/slide3.jpg\";}}s:18:\"highlight-carousel\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-carousel/slide4.jpg\";}}s:18:\"highlight-showcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"highlight-showcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"highlight-showcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"highlight-showcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"highlight-showcase/slide4.jpg\";}}s:10:\"image-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"imagehero/slide1.jpg\";}}s:13:\"insta-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"insta-gallery/slide1.jpg\";}}s:19:\"levanorestaurantbar\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"levanorestaurantbar/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"levanorestaurantbar/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"levanorestaurantbar/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:30:\"levanorestaurantbar/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:30:\"levanorestaurantbar/slide5.jpg\";}}s:11:\"mainfeature\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"mainfeature/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"mainfeature/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"mainfeature/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"mainfeature/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"mainfeature/slide7.jpg\";}}s:17:\"media-gallery-two\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"media-gallery-two/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"media-gallery-two/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"media-gallery-two/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"media-gallery-two/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"media-gallery-two/slide6.jpg\";}}s:23:\"media-carousel-autoplay\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"media-carousel-autoplay/slide6.jpg\";}}s:21:\"news-background-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"news-bg-video/slide1.jpg\";}}s:12:\"news-gallery\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"news-gallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"news-gallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"news-gallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"news-gallery/slide4.jpg\";}}s:23:\"news-gallery-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"news-gallery-post-based/slide1.jpg\";}}s:9:\"news-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"news-hero/slide1.jpg\";}}s:10:\"news-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"news-video/slide1.jpg\";}}s:15:\"newsletter-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"newsletter-hero/slide1.jpg\";}}s:10:\"notgeneric\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"notgeneric/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"notgeneric/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"notgeneric/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"notgeneric/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"notgeneric/slide5.jpg\";}}s:11:\"photography\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"photography/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"photography/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"photography/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"photography/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:22:\"photography/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:22:\"photography/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:22:\"photography/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:22:\"photography/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:22:\"photography/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:23:\"photography/slide10.jpg\";}}s:20:\"photography-carousel\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"photography-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"photography-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"photography-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"photography-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:31:\"photography-carousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:31:\"photography-carousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:31:\"photography-carousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:31:\"photography-carousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:31:\"photography-carousel/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:32:\"photography-carousel/slide10.jpg\";}}s:16:\"search-form-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"search-form-hero/slide1.jpg\";}}s:16:\"showcasecarousel\";a:9:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"showcasecarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"showcasecarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"showcasecarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"showcasecarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:27:\"showcasecarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:27:\"showcasecarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:27:\"showcasecarousel/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:27:\"showcasecarousel/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:27:\"showcasecarousel/slide9.jpg\";}}s:11:\"sports-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"sportshero/slide1.jpg\";}}s:12:\"twitter-feed\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"twitter-feed/slide1.jpg\";}}s:13:\"vimeo-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"vimeo-gallery/slide1.jpg\";}}s:9:\"vimeohero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"vimeohero/slide1.jpg\";}}s:16:\"web-product-dark\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"web-product-dark/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"web-product-dark/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"web-product-dark/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:27:\"web-product-dark/slide4.jpg\";}}s:21:\"web-product-dark-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"web-product-dark-hero/slide1.jpg\";}}s:22:\"web-product-light-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"web-product-light-hero/slide1.jpg\";}}s:15:\"webproductlight\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"webproductlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"webproductlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"webproductlight/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"webproductlight/slide4.jpg\";}}s:15:\"youtube-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"youtube-gallery/slide1.jpg\";}}s:11:\"youtubehero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"youtubehero/slide1.jpg\";}}s:13:\"scroll-effect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"scrolleffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"scrolleffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"scrolleffect/slide3.jpg\";}}s:12:\"content-zoom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"contentzoom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"contentzoom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"contentzoom/slide3.jpg\";}}s:13:\"food-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"foodcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"foodcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"foodcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"foodcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"foodcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"foodcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"foodcarousel/slide7.jpg\";}}s:14:\"rotating-words\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"rotatingwords/slide1.jpg\";}}s:22:\"travel-static-captions\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"travel-static-captions/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"travel-static-captions/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"travel-static-captions/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:33:\"travel-static-captions/slide4.jpg\";}}s:7:\"concept\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"concept/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"concept/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"concept/slide3.jpg\";}}s:17:\"fullscreen-button\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"fullscreen-button/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"fullscreen-button/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"fullscreen-button/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"fullscreen-button/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"fullscreen-button/slide5.jpg\";}}s:15:\"creativefreedom\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"creativefreedom/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"creativefreedom/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"creativefreedom/slide3.jpg\";}}s:13:\"parallaxscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"parallaxscene/slide1.jpg\";}}s:15:\"slidingoverlays\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"slidingoverlays/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"slidingoverlays/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"slidingoverlays/slide3.jpg\";}}s:25:\"web-product-light-hero-3d\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"web-product-light-hero-3d/slide1.jpg\";}}s:6:\"woobig\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"woobig/slide1.jpg\";}}s:16:\"woocommercesmall\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"woocommercesmall/slide1.jpg\";}}s:10:\"finedining\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"finedining/slide1.jpg\";}}s:12:\"agency-intro\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"agency-intro/slide1.jpg\";}}s:7:\"ourteam\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"ourteam/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"ourteam/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"ourteam/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"ourteam/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"ourteam/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"ourteam/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:18:\"ourteam/slide7.jpg\";}}s:17:\"our-team-carousel\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ourteamcarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"ourteamcarousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"ourteamcarousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"ourteamcarousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"ourteamcarousel/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"ourteamcarousel/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:26:\"ourteamcarousel/slide7.jpg\";}}s:13:\"betteryoutube\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"betteryoutube/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"betteryoutube/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"betteryoutube/slide3.jpg\";}}s:19:\"agencywebsiteheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"agencywebsiteheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"agencywebsiteheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"agencywebsiteheader/slide3.jpg\";}}s:10:\"comingsoon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"comingsoon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"comingsoon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"comingsoon/slide3.jpg\";}}s:9:\"snowscene\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowscene/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowscene/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowscene/slide3.jpg\";}}s:8:\"rockband\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"rockband/slide1.jpg\";}}s:16:\"sleeklandingpage\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"sleeklandingpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"sleeklandingpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"sleeklandingpage/slide3.jpg\";}}s:14:\"applandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"applandingpage/slide1.jpg\";}}s:9:\"deskscene\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"deskscene/slide1.jpg\";}}s:15:\"cleannewsslider\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"cleannewsslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"cleannewsslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"cleannewsslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"cleannewsslider/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"cleannewsslider/slide5.jpg\";}}s:12:\"imagegallery\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"imagegallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"imagegallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"imagegallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"imagegallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:23:\"imagegallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:23:\"imagegallery/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:23:\"imagegallery/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:23:\"imagegallery/slide8.jpg\";}}s:19:\"standard-wp-gallery\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"standard-wp-gallery/slide1.jpg\";}}s:21:\"clean-news-post-based\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"clean-news-post-based/slide1.jpg\";}}s:21:\"interactivewhiteboard\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"interactivewhiteboard/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"interactivewhiteboard/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"interactivewhiteboard/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"interactivewhiteboard/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"interactivewhiteboard/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:32:\"interactivewhiteboard/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:32:\"interactivewhiteboard/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:32:\"interactivewhiteboard/slide8.jpg\";}}s:10:\"innovation\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"innovation/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"innovation/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"innovation/slide3.jpg\";}}s:24:\"dark-fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"dark-fullsite-block-menu/slide1.jpg\";}}s:21:\"dark-fullsite-block-1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"dark-fullsite-block-1/slide1.jpg\";}}s:27:\"dark-fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"dark-fullsite-block-2-about/slide2.jpg\";}}s:30:\"dark-fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-3-services/slide2.jpg\";}}s:30:\"dark-fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:41:\"dark-fullsite-block-4-products/slide5.jpg\";}}s:34:\"dark-fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:45:\"dark-fullsite-block-5-testimonials/slide1.jpg\";}}s:29:\"dark-fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"dark-fullsite-block-6-callout/slide1.jpg\";}}s:28:\"dark-fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:39:\"dark-fullsite-block-7-footer/slide1.jpg\";}}s:19:\"fullsite-block-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"fullsite-block-menu/slide1.jpg\";}}s:15:\"fullsite-block1\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"fullsite-block1/slide1.jpg\";}}s:22:\"fullsite-block-2-about\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"fullsite-block-2-about/slide2.jpg\";}}s:25:\"fullsite-block-3-services\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-3-services/slide2.jpg\";}}s:25:\"fullsite-block-4-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:36:\"fullsite-block-4-products/slide5.jpg\";}}s:29:\"fullsite-block-5-testimonials\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"fullsite-block-5-testimonials/slide1.jpg\";}}s:24:\"fullsite-block-6-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"fullsite-block-6-callout/slide1.jpg\";}}s:23:\"fullsite-block-7-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"fullsite-block-7-footer/slide1.jpg\";}}s:11:\"techjournal\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techjournal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"techjournal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"techjournal/slide3.jpg\";}}s:13:\"cardealership\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"cardealership/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"cardealership/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"cardealership/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"cardealership/slide4.jpg\";}}s:14:\"fullscreenmenu\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fullscreenmenu/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fullscreenmenu/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fullscreenmenu/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"fullscreenmenu/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"fullscreenmenu/slide5.jpg\";}}s:17:\"creativefrontpage\";a:8:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"creativefrontpage/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"creativefrontpage/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"creativefrontpage/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"creativefrontpage/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:28:\"creativefrontpage/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:28:\"creativefrontpage/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:28:\"creativefrontpage/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:28:\"creativefrontpage/slide8.jpg\";}}s:19:\"websitebuilder-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-menu/slide1.jpg\";}}s:19:\"websitebuilder-hero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"websitebuilder-hero/slide1.jpg\";}}s:22:\"websitebuilder-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"websitebuilder-clients/slide1.jpg\";}}s:23:\"websitebuilder-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-services/slide1.jpg\";}}s:23:\"websitebuilder-discover\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"websitebuilder-discover/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"websitebuilder-discover/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"websitebuilder-discover/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"websitebuilder-discover/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"websitebuilder-discover/slide5.jpg\";}}s:21:\"websitebuilder-slider\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"websitebuilder-slider/slide2.jpg\";}}s:27:\"websitebuilder-calltoaction\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"websitebuilder-calltoaction/slide1.jpg\";}}s:21:\"websitebuilder-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"websitebuilder-footer/slide1.jpg\";}}s:13:\"focusparallax\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"focusparallax/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"focusparallax/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"focusparallax/slide3.jpg\";}}s:7:\"duotone\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"duotone/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"duotone/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"duotone/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"duotone/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:18:\"duotone/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:18:\"duotone/slide6.jpg\";}}s:6:\"r_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_menu/slide1.jpg\";}}s:5:\"rhero\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_hero/slide1.jpg\";}}s:7:\"r_about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"r_about/slide1.jpg\";}}s:10:\"r_products\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"r_products/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"r_products/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"r_products/slide3.jpg\";}}s:6:\"r_info\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:17:\"r_info/slide1.jpg\";}}s:17:\"inspirationheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"inspirationheader/slide1.jpg\";}}s:13:\"magazineposts\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"magazineposts/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"magazineposts/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"magazineposts/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:24:\"magazineposts/slide4.jpg\";}}s:17:\"explorationheader\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"explorationheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"explorationheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"explorationheader/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"explorationheader/slide4.jpg\";}}s:16:\"typewritereffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"typewritereffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"typewritereffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"typewritereffect/slide3.jpg\";}}s:15:\"blendmodeheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"blendmodeheader/slide1.jpg\";}}s:17:\"themeplicity_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"themeplicity_menu/slide1.jpg\";}}s:19:\"themeplicity_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_header/slide1.jpg\";}}s:18:\"themeplicity_offer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"themeplicity_offer/slide1.jpg\";}}s:21:\"themeplicity_whatwedo\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_whatwedo/slide1.jpg\";}}s:21:\"themeplicity_projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"themeplicity_projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"themeplicity_projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"themeplicity_projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"themeplicity_projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:32:\"themeplicity_projects/slide5.jpg\";s:3:\"img\";s:7:\"Slide 5\";}}s:23:\"themeplicity_whatsgreat\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"themeplicity_whatsgreat/slide1.jpg\";}}s:19:\"themeplicity_tables\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_tables/slide1.jpg\";}}s:24:\"themeplicity_contactform\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"themeplicity_contactform/slide1.jpg\";}}s:19:\"themeplicity_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"themeplicity_footer/slide1.jpg\";}}s:17:\"NiceAndClean_Menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"NiceAndClean_Menu/slide1.jpg\";}}s:19:\"NiceAndClean_Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"NiceAndClean_Header/slide1.jpg\";}}s:21:\"NiceAndClean_Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Services/slide1.jpg\";}}s:18:\"NiceAndClean_About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"NiceAndClean_About/slide1.jpg\";}}s:18:\"niceandclean_video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"niceandclean_video/slide1.jpg\";}}s:23:\"niceandclean_highlights\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_highlights/slide1.jpg\";}}s:21:\"NiceAndClean_Projects\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:32:\"NiceAndClean_Projects/slide5.jpg\";}}s:23:\"niceandclean_textblocks\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"niceandclean_textblocks/slide1.jpg\";}}s:20:\"niceandclean_callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"niceandclean_callout/slide1.jpg\";}}s:19:\"niceandclean_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"niceandclean_footer/slide1.jpg\";}}s:3:\"80s\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:14:\"80s/slide1.jpg\";}}s:10:\"blurslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"blurslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"blurslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"blurslider/slide3.jpg\";}}s:15:\"ComingSoonAddon\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"ComingSoonAddon/slide1.jpg\";}}s:9:\"snowaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"snowaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"snowaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"snowaddon/slide3.jpg\";}}s:19:\"particle-effect-one\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-one/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"particle-effect-one/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"particle-effect-one/slide3.jpg\";}}s:19:\"particle-effect-two\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"particle-effect-two/slide1.jpg\";}}s:21:\"particle-effect-three\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"particle-effect-three/slide1.jpg\";}}s:15:\"portfolioviewer\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"portfolioviewer/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"portfolioviewer/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"portfolioviewer/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"portfolioviewer/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"portfolioviewer/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"portfolioviewer/slide6.jpg\";}}s:11:\"appshowcase\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"appshowcase/slide1.jpg\";}}s:13:\"gravitydesign\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"gravitydesign/slide1.jpg\";}}s:12:\"404errorpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"404errorpage/slide1.jpg\";}}s:15:\"carouselgallery\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"carouselgallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"carouselgallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"carouselgallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"carouselgallery/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"carouselgallery/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"carouselgallery/slide6.jpg\";}}s:9:\"filmstrip\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"filmstrip/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:20:\"filmstrip/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:20:\"filmstrip/slide3.jpg\";}}s:10:\"spaceopera\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"spaceopera/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:21:\"spaceopera/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:21:\"spaceopera/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:21:\"spaceopera/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:21:\"spaceopera/slide5.jpg\";}}s:12:\"websiteintro\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"websiteintro/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"websiteintro/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"websiteintro/slide3.jpg\";}}s:12:\"maskshowcase\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"maskshowcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"maskshowcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"maskshowcase/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"maskshowcase/slide4.jpg\";}}s:18:\"parallaxzoomslices\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"parallaxzoomslices/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"parallaxzoomslices/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"parallaxzoomslices/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"parallaxzoomslices/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:29:\"parallaxzoomslices/slide5.jpg\";}}s:20:\"doubleexposureeffect\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"doubleexposureeffect/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"doubleexposureeffect/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"doubleexposureeffect/slide3.jpg\";}}s:22:\"mountainparallaxheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"mountainparallaxheader/slide1.jpg\";}}s:12:\"goodnewsmenu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"goodnewsmenu/slide1.jpg\";}}s:14:\"goodnewsheader\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"goodnewsheader/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"goodnewsheader/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"goodnewsheader/slide3.jpg\";}}s:16:\"goodnewswhatshot\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewswhatshot/slide1.jpg\";}}s:16:\"goodnewsfeatured\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewsfeatured/slide1.jpg\";}}s:17:\"goodnewsspotlight\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"goodnewsspotlight/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"goodnewsspotlight/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"goodnewsspotlight/slide3.jpg\";}}s:16:\"goodnewscarousel\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewscarousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"goodnewscarousel/slide2.jpg\";}}s:15:\"goodnewscallout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"goodnewscallout/slide1.jpg\";}}s:14:\"goodnewsfooter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"goodnewsfooter/slide1.jpg\";}}s:16:\"goodnewsmenuback\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"goodnewsmenuback/slide1.jpg\";}}s:18:\"goodnewsblogheader\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"goodnewsblogheader/slide1.jpg\";}}s:19:\"goodnewsblogcontent\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"goodnewsblogcontent/slide1.jpg\";}}s:20:\"goodnewstestimonials\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"goodnewstestimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"goodnewstestimonials/slide2.jpg\";}}s:18:\"goodnewsblogfooter\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"goodnewsblogfooter/slide1.jpg\";}}s:17:\"beforeafterslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"beforeafterslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"beforeafterslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"beforeafterslider/slide3.jpg\";}}s:15:\"productshowcase\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"productshowcase/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"productshowcase/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"productshowcase/slide3.jpg\";}}s:22:\"overexposuretransition\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"overexposuretransition/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"overexposuretransition/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"overexposuretransition/slide3.jpg\";}}s:14:\"parallaxscroll\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"parallaxscroll/slide1.jpg\";}}s:11:\"techco-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"techco-menu/slide1.jpg\";}}s:13:\"techco-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-header/slide1.jpg\";}}s:12:\"techco-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"techco-about/slide1.jpg\";}}s:15:\"techco-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"techco-services/slide1.jpg\";}}s:12:\"techco-video\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"techco-video/slide1.jpg\";}}s:13:\"techco-prices\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-prices/slide1.jpg\";}}s:19:\"techco-testimonials\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"techco-testimonials/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"techco-testimonials/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"techco-testimonials/slide3.jpg\";}}s:13:\"techco-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"techco-footer/slide1.jpg\";}}s:7:\"weather\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"weather/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"weather/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"weather/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:18:\"weather/slide4.jpg\";}}s:11:\"360panorama\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"360panorama/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"360panorama/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"360panorama/slide3.jpg\";}}s:14:\"duotone-add-on\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"duotone-add-on/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"duotone-add-on/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"duotone-add-on/slide3.jpg\";}}s:13:\"reveal-add-on\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"reveal-add-on/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"reveal-add-on/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"reveal-add-on/slide3.jpg\";}}s:16:\"band-tour-poster\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"smartcontent/band-tour-poster/slide1.png\";}}s:14:\"brewery-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"smartcontent/brewery-slider/slide3.png\";}}s:9:\"burgerbar\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:33:\"smartcontent/burgerbar/slide3.png\";}}s:19:\"burger-bar-portrait\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:43:\"smartcontent/burger-bar-portrait/slide3.png\";}}s:8:\"car-rent\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"smartcontent/car-rent/slide1.png\";}}s:6:\"coffee\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"smartcontent/coffee/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"smartcontent/coffee/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"smartcontent/coffee/slide3.png\";}}s:14:\"holiday-advert\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/holiday-advert/slide1.png\";}}s:18:\"iphone-cases-light\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:42:\"smartcontent/iphone-cases-light/slide1.png\";}}s:7:\"medical\";a:2:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"smartcontent/medical/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"smartcontent/medical/slide2.png\";}}s:13:\"mexican-grill\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:37:\"smartcontent/mexican-grill/slide3.png\";}}s:20:\"mobile-retail-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:44:\"smartcontent/mobile-retail-slider/slide3.png\";}}s:14:\"money-exchange\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:38:\"smartcontent/money-exchange/slide3.png\";}}s:28:\"restaurant-menu-first-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:52:\"smartcontent/restaurant-menu-first-screen/slide1.png\";}}s:29:\"restaurant-menu-second-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:53:\"smartcontent/restaurant-menu-second-screen/slide1.png\";}}s:28:\"restaurant-menu-third-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:52:\"smartcontent/restaurant-menu-third-screen/slide1.png\";}}s:11:\"shoes-store\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:35:\"smartcontent/shoes-store/slide3.png\";}}s:20:\"supermarket-products\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide1.png\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide2.png\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide3.png\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide4.png\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:44:\"smartcontent/supermarket-products/slide5.png\";}}s:16:\"travel-insurance\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:40:\"smartcontent/travel-insurance/slide1.png\";}}s:12:\"cryptoslider\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"cryptoslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:23:\"cryptoslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:23:\"cryptoslider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:23:\"cryptoslider/slide4.jpg\";}}s:16:\"immersion_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"immersion_header/slide1.jpg\";}}s:19:\"immersion-mountains\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"immersion-mountains/slide1.jpg\";}}s:17:\"immersion-product\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"immersion-product/slide1.jpg\";}}s:16:\"immersion-design\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"immersion-design/slide1.jpg\";}}s:21:\"immersion-photography\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"immersion-photography/slide1.jpg\";}}s:14:\"immersion-grid\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"immersion-grid/slide1.jpg\";}}s:11:\"funkyslider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"funkyslider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"funkyslider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"funkyslider/slide3.jpg\";}}s:14:\"clearview_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"clearview_menu/slide1.jpg\";}}s:16:\"clearview_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"clearview_header/slide1.jpg\";}}s:17:\"clearview_mission\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"clearview_mission/slide1.jpg\";}}s:17:\"clear-view-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"clear-view-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"clear-view-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"clear-view-slider/slide3.jpg\";}}s:15:\"clear-view-news\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"clear-view-news/slide1.jpg\";}}s:18:\"clear-view-clients\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"clear-view-clients/slide1.jpg\";}}s:18:\"clear-view-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"clear-view-contact/slide1.jpg\";}}s:22:\"clear-view-single-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"clear-view-single-menu/slide1.jpg\";}}s:24:\"clear-view-single-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"clear-view-single-header/slide1.jpg\";}}s:23:\"clear-view-single-media\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"clear-view-single-media/slide1.jpg\";}}s:22:\"clear-view-single-more\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:33:\"clear-view-single-more/slide1.jpg\";}}s:25:\"clear-view-single-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:36:\"clear-view-single-contact/slide1.jpg\";}}s:16:\"cleanlandingpage\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"cleanlandingpage/slide1.jpg\";}}s:8:\"clearcut\";a:10:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:19:\"clearcut/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:19:\"clearcut/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:19:\"clearcut/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:19:\"clearcut/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:19:\"clearcut/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:19:\"clearcut/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:19:\"clearcut/slide7.jpg\";}i:7;a:2:{s:5:\"title\";s:7:\"Slide 8\";s:3:\"img\";s:19:\"clearcut/slide8.jpg\";}i:8;a:2:{s:5:\"title\";s:7:\"Slide 9\";s:3:\"img\";s:19:\"clearcut/slide9.jpg\";}i:9;a:2:{s:5:\"title\";s:8:\"Slide 10\";s:3:\"img\";s:20:\"clearcut/slide10.jpg\";}}s:17:\"wonderstruck_menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"wonderstruck_menu/slide1.jpg\";}}s:19:\"wonderstruck_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"wonderstruck_header/slide1.jpg\";}}s:18:\"wonderstruck_about\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"wonderstruck_about/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"wonderstruck_about/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"wonderstruck_about/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:29:\"wonderstruck_about/slide4.jpg\";}}s:18:\"wonderstruck-works\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"wonderstruck-works/slide1.jpg\";}}s:20:\"wonderstruck-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"wonderstruck-contact/slide1.jpg\";}}s:11:\"bubblemorph\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"bubblemorph/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"bubblemorph/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"bubblemorph/slide3.jpg\";}}s:15:\"distortionaddon\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"distortionaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"distortionaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"distortionaddon/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:26:\"distortionaddon/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:26:\"distortionaddon/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:26:\"distortionaddon/slide6.jpg\";}}s:9:\"clubflyer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:20:\"clubflyer/slide1.jpg\";}}s:15:\"paintbrushaddon\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"paintbrushaddon/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"paintbrushaddon/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"paintbrushaddon/slide3.jpg\";}}s:15:\"parallax_header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"parallax_header/slide1.jpg\";}}s:16:\"parallax_content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"parallax_content/slide1.jpg\";}}s:15:\"parallax_footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"parallax_footer/slide1.jpg\";}}s:12:\"le-chef-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"le-chef-menu/slide1.jpg\";}}s:14:\"le-chef-header\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"le-chef-header/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"le-chef-header/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"le-chef-header/slide3.jpg\";}}s:18:\"le-chef-philosophy\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"le-chef-philosophy/slide1.jpg\";}}s:12:\"le-chef-food\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"le-chef-food/slide1.jpg\";}}s:16:\"le-chef-la-carte\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"le-chef-la-carte/slide1.jpg\";}}s:14:\"le-chef-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"le-chef-footer/slide1.jpg\";}}s:20:\"news-magazine-slider\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"news-magazine-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"news-magazine-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"news-magazine-slider/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"news-magazine-slider/slide4.jpg\";}}s:18:\"real-estate-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"real-estate-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:29:\"real-estate-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:29:\"real-estate-slider/slide3.jpg\";}}s:14:\"fashion-header\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"fashion-header/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"fashion-header/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"fashion-header/slide3.jpg\";}}s:13:\"seasonaloffer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"seasonaloffer/slide1.jpg\";}}s:18:\"barber-shop-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"barber-shop-header/slide1.jpg\";}}s:23:\"barber-shop-mobile-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"barber-shop-mobile-menu/slide1.jpg\";}}s:24:\"barber-shop-first-screen\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:35:\"barber-shop-first-screen/slide1.jpg\";}}s:17:\"barber-shop-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"barber-shop-about/slide1.jpg\";}}s:20:\"barber-shop-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"barber-shop-services/slide1.jpg\";}}s:19:\"barber-shop-barbers\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"barber-shop-barbers/slide1.jpg\";}}s:20:\"barber-shop-contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"barber-shop-contacts/slide1.jpg\";}}s:18:\"barber-shop-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"barber-shop-footer/slide1.jpg\";}}s:21:\"fitness-club-template\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"fitness-club-template/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:32:\"fitness-club-template/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:32:\"fitness-club-template/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:32:\"fitness-club-template/slide4.jpg\";}}s:13:\"soccer-school\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"soccer-school/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"soccer-school/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"soccer-school/slide3.jpg\";}}s:19:\"music-band-template\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"music-band-template/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:30:\"music-band-template/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:30:\"music-band-template/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:30:\"music-band-template/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:30:\"music-band-template/slide5.jpg\";}}s:15:\"restaurant-menu\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"restaurant-menu/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:26:\"restaurant-menu/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:26:\"restaurant-menu/slide3.jpg\";}}s:16:\"cinematic-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"cinematic-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:27:\"cinematic-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:27:\"cinematic-slider/slide3.jpg\";}}s:17:\"3d-parallax-cubes\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"3d-parallax-cubes/slide3.jpg\";}}s:13:\"medicare-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"medicare-menu/slide1.jpg\";}}s:15:\"medicare-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"medicare-header/slide1.jpg\";}}s:14:\"medicare-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"medicare-about/slide1.jpg\";}}s:18:\"medicare-highlight\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"medicare-highlight/slide1.jpg\";}}s:17:\"medicare-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"medicare-services/slide1.jpg\";}}s:16:\"medicare-doctors\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"medicare-doctors/slide1.jpg\";}}s:17:\"medicare-research\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"medicare-research/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"medicare-research/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"medicare-research/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"medicare-research/slide4.jpg\";}}s:18:\"medicare-whychoose\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"medicare-whychoose/slide1.jpg\";}}s:16:\"medicare-contact\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"medicare-contact/slide1.jpg\";}}s:15:\"medicare-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"medicare-footer/slide1.jpg\";}}s:11:\"coffee-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"coffee-menu/slide1.jpg\";}}s:13:\"coffee-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"coffee-header/slide1.jpg\";}}s:17:\"coffee-philosophy\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"coffee-philosophy/slide1.jpg\";}}s:12:\"coffee-carte\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"coffee-carte/slide1.jpg\";}}s:13:\"coffee-teaser\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"coffee-teaser/slide1.jpg\";}}s:13:\"coffee-findus\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"coffee-findus/slide1.jpg\";}}s:13:\"coffee-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"coffee-footer/slide1.jpg\";}}s:17:\"minimal-portfolio\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"minimal-portfolio/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"minimal-portfolio/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"minimal-portfolio/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:28:\"minimal-portfolio/slide4.jpg\";}}s:23:\"minimal-portfolio-modal\";a:7:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide6.jpg\";}i:6;a:2:{s:5:\"title\";s:7:\"Slide 7\";s:3:\"img\";s:34:\"minimal-portfolio-modal/slide7.jpg\";}}s:11:\"angled-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"angled-menu/slide1.jpg\";}}s:13:\"angled-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"angled-header/slide1.jpg\";}}s:11:\"angled-news\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"angled-news/slide1.jpg\";}}s:15:\"angled-services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"angled-services/slide1.jpg\";}}s:14:\"angled-success\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"angled-success/slide1.jpg\";}}s:13:\"angled-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"angled-footer/slide1.jpg\";}}s:20:\"angled-content-modal\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"angled-content-modal/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:31:\"angled-content-modal/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:31:\"angled-content-modal/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:31:\"angled-content-modal/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:31:\"angled-content-modal/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:31:\"angled-content-modal/slide6.jpg\";}}s:13:\"big-bold-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"big-bold-menu/slide1.jpg\";}}s:15:\"big-bold-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"big-bold-header/slide1.jpg\";}}s:16:\"big-bold-content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"big-bold-content/slide1.jpg\";}}s:13:\"big-bold-blog\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"big-bold-blog/slide1.jpg\";}}s:18:\"big-bold-highlight\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"big-bold-highlight/slide1.jpg\";}}s:15:\"big-bold-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"big-bold-footer/slide1.jpg\";}}s:7:\"Retouch\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:18:\"Retouch/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:18:\"Retouch/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:18:\"Retouch/slide3.jpg\";}}s:11:\"tech-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"tech-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"tech-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"tech-slider/slide3.jpg\";}}s:11:\"peak-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"peak-header/slide1.jpg\";}}s:10:\"peak-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"peak-about/slide1.jpg\";}}s:14:\"peak-portfolio\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"peak-portfolio/slide1.jpg\";}}s:11:\"peak-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"peak-footer/slide1.jpg\";}}s:17:\"portfolio-welcome\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"portfolio-welcome/slide1.jpg\";}}s:15:\"portfolio-about\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:26:\"portfolio-about/slide1.jpg\";}}s:21:\"portfolio-works-title\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"portfolio-works-title/slide1.jpg\";}}s:23:\"portfolio-works-content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:34:\"portfolio-works-content/slide1.jpg\";}}s:18:\"portfolio-contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"portfolio-contacts/slide1.jpg\";}}s:18:\"App-Studio-Welcome\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:29:\"App-Studio-Welcome/slide1.jpg\";}}s:19:\"App-Studio-Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"App-Studio-Services/slide1.jpg\";}}s:16:\"App-Studio-About\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:27:\"App-Studio-About/slide1.jpg\";}}s:19:\"App-Studio-Contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"App-Studio-Contacts/slide1.jpg\";}}s:14:\"cube-animation\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"cube-animation/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"cube-animation/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"cube-animation/slide3.jpg\";}}s:10:\"basic-menu\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"basic-menu/slide1.jpg\";}}s:12:\"basic-header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"basic-header/slide1.jpg\";}}s:13:\"basic-content\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"basic-content/slide1.jpg\";}}s:14:\"basic-carousel\";a:5:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"basic-carousel/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"basic-carousel/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"basic-carousel/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"basic-carousel/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"basic-carousel/slide5.jpg\";}}s:13:\"basic-callout\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"basic-callout/slide1.jpg\";}}s:10:\"basic-grid\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:21:\"basic-grid/slide1.jpg\";}}s:17:\"basic-video-block\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"basic-video-block/slide1.jpg\";}}s:12:\"basic-footer\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:23:\"basic-footer/slide1.jpg\";}}s:14:\"basic-lightbox\";a:6:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:25:\"basic-lightbox/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:25:\"basic-lightbox/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:25:\"basic-lightbox/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:25:\"basic-lightbox/slide4.jpg\";}i:4;a:2:{s:5:\"title\";s:7:\"Slide 5\";s:3:\"img\";s:25:\"basic-lightbox/slide5.jpg\";}i:5;a:2:{s:5:\"title\";s:7:\"Slide 6\";s:3:\"img\";s:25:\"basic-lightbox/slide6.jpg\";}}s:13:\"nature-slider\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:24:\"nature-slider/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:24:\"nature-slider/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:24:\"nature-slider/slide3.jpg\";}}s:11:\"art-gallery\";a:4:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:22:\"art-gallery/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:22:\"art-gallery/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:22:\"art-gallery/slide3.jpg\";}i:3;a:2:{s:5:\"title\";s:7:\"Slide 4\";s:3:\"img\";s:22:\"art-gallery/slide4.jpg\";}}s:19:\"Construction-Header\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:30:\"Construction-Header/slide1.jpg\";}}s:17:\"Construction-Home\";a:3:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:28:\"Construction-Home/slide1.jpg\";}i:1;a:2:{s:5:\"title\";s:7:\"Slide 2\";s:3:\"img\";s:28:\"Construction-Home/slide2.jpg\";}i:2;a:2:{s:5:\"title\";s:7:\"Slide 3\";s:3:\"img\";s:28:\"Construction-Home/slide3.jpg\";}}s:21:\"Construction-Projects\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"Construction-Projects/slide1.jpg\";}}s:20:\"Construction-History\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:31:\"Construction-History/slide1.jpg\";}}s:21:\"Construction-Services\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"Construction-Services/slide1.jpg\";}}s:21:\"Construction-Contacts\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"Construction-Contacts/slide1.jpg\";}}s:21:\"404-Error-Space-Theme\";a:1:{i:0;a:2:{s:5:\"title\";s:7:\"Slide 1\";s:3:\"img\";s:32:\"404-Error-Space-Theme/slide1.jpg\";}}}}", "no");
INSERT INTO `wp_options` VALUES("722", "_transient_timeout_wfcredentialstatus_1", "1563694362", "no");
INSERT INTO `wp_options` VALUES("723", "_transient_wfcredentialstatus_1", "06a62fd6406f79c9e9e936c190c780c7081832a63f87f7c5b56154aec0a0ddd18", "no");
INSERT INTO `wp_options` VALUES("724", "_site_transient_timeout_browser_142f658a516c68ad7f6b93280975b3d2", "1564295581", "no");
INSERT INTO `wp_options` VALUES("725", "_site_transient_browser_142f658a516c68ad7f6b93280975b3d2", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:13:\"75.0.3770.142\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `wp_options` VALUES("726", "_site_transient_timeout_php_check_464f4068caea2f8f3edcc5ae59429c65", "1564295583", "no");
INSERT INTO `wp_options` VALUES("727", "_site_transient_php_check_464f4068caea2f8f3edcc5ae59429c65", "a:5:{s:19:\"recommended_version\";s:3:\"7.3\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("728", "_transient_timeout_w3tc.verify_plugins", "1564295583", "no");
INSERT INTO `wp_options` VALUES("729", "_transient_w3tc.verify_plugins", "1", "no");
INSERT INTO `wp_options` VALUES("730", "_transient_timeout_wpseo-statistics-totals", "1563777187", "no");
INSERT INTO `wp_options` VALUES("731", "_transient_wpseo-statistics-totals", "a:1:{i:1;a:2:{s:6:\"scores\";a:1:{i:0;a:4:{s:8:\"seo_rank\";s:2:\"na\";s:5:\"label\";s:48:\"Posts <strong>without</strong> a focus keyphrase\";s:5:\"count\";i:10;s:4:\"link\";s:112:\"http://localhost/gite-ecuries-abbys/wp-admin/edit.php?post_status=publish&#038;post_type=post&#038;seo_filter=na\";}}s:8:\"division\";a:5:{s:3:\"bad\";i:0;s:2:\"ok\";i:0;s:4:\"good\";i:0;s:2:\"na\";i:1;s:7:\"noindex\";i:0;}}}", "no");
INSERT INTO `wp_options` VALUES("732", "_site_transient_timeout_community-events-d41d8cd98f00b204e9800998ecf8427e", "1563733987", "no");
INSERT INTO `wp_options` VALUES("733", "_site_transient_community-events-d41d8cd98f00b204e9800998ecf8427e", "a:2:{s:8:\"location\";a:1:{s:2:\"ip\";b:0;}s:6:\"events\";a:5:{i:0;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:16:\"Zomers samenzijn\";s:3:\"url\";s:65:\"https://www.meetup.com/WordPress-Hasselt-Meetup/events/261625162/\";s:6:\"meetup\";s:24:\"WordPress Hasselt Meetup\";s:10:\"meetup_url\";s:48:\"https://www.meetup.com/WordPress-Hasselt-Meetup/\";s:4:\"date\";s:19:\"2019-08-05 19:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:16:\"Hasselt, Belgium\";s:7:\"country\";s:2:\"be\";s:8:\"latitude\";d:50.932873;s:9:\"longitude\";d:5.340773;}}i:1;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:17:\"WordCamp Brighton\";s:3:\"url\";s:34:\"https://2019.brighton.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2019-08-16 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:12:\"Brighton, UK\";s:7:\"country\";s:2:\"GB\";s:8:\"latitude\";d:50.8324223;s:9:\"longitude\";d:-0.1398574;}}i:2;a:7:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:44:\"WordPress Meetup Antwerp: Summer Break Café\";s:3:\"url\";s:65:\"https://www.meetup.com/Antwerp-WordPress-Meetup/events/262807679/\";s:6:\"meetup\";s:24:\"Antwerp WordPress Meetup\";s:10:\"meetup_url\";s:48:\"https://www.meetup.com/Antwerp-WordPress-Meetup/\";s:4:\"date\";s:19:\"2019-08-20 18:30:00\";s:8:\"location\";a:4:{s:8:\"location\";s:18:\"Antwerpen, Belgium\";s:7:\"country\";s:2:\"be\";s:8:\"latitude\";d:51.23094;s:9:\"longitude\";d:4.423231;}}i:3;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:16:\"WordCamp Zürich\";s:3:\"url\";s:33:\"https://2019.zurich.wordcamp.org/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2019-09-13 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:7:\"Zürich\";s:7:\"country\";s:2:\"CH\";s:8:\"latitude\";d:47.3901863;s:9:\"longitude\";d:8.5158385;}}i:4;a:7:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:17:\"WordCamp Nijmegen\";s:3:\"url\";s:34:\"https://2019.nijmegen.wordcamp.org\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2019-09-20 00:00:00\";s:8:\"location\";a:4:{s:8:\"location\";s:25:\"Nijmegen, The Netherlands\";s:7:\"country\";s:2:\"NL\";s:8:\"latitude\";d:51.8412685;s:9:\"longitude\";d:5.8522385;}}}}", "no");
INSERT INTO `wp_options` VALUES("734", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1563733988", "no");
INSERT INTO `wp_options` VALUES("735", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"News –  – WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WordPress News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 12 Jul 2019 20:20:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.3-alpha-45664\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"People of WordPress: Ugyen Dorji\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2019/07/people-of-wordpress-ugyen-dorji/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 12 Jul 2019 17:20:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:9:\"heropress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7013\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:386:\"You&#8217;ve probably heard that WordPress is open source software, and may know that it&#8217;s created and run by volunteers. WordPress enthusiasts share many examples of how WordPress changed people&#8217;s lives for the better. This monthly series shares some of those lesser-known, amazing stories. Meet Ugyen Dorji from Bhutan Ugyen lives in Bhutan, a landlocked country [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Aditya Kane\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7264:\"\n<p><em>You&#8217;ve probably heard that WordPress is open source software, and may know that it&#8217;s created and run by volunteers. WordPress enthusiasts share many examples of how WordPress changed people&#8217;s lives for the better. This monthly series shares some of those lesser-known, amazing stories.</em></p>\n\n\n\n<h2><strong>Meet Ugyen Dorji from Bhutan</strong></h2>\n\n\n\n<p>Ugyen lives in <a href=\"https://en.wikipedia.org/wiki/Bhutan\">Bhutan</a>, a landlocked country situated between two giant neighbors, India to the south and China to the north. He works for ServMask Inc and is responsible for the Quality Assurance process for All-in-One WP Migration plugin. <br><br>He believes in the Buddhist teaching that “the most valuable service is one rendered to our fellow humans,” and his contributions demonstrates this through his WordPress translation work and multi-lingual support projects for WordPress.</p>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2019/07/60340743_2330687777177099_8058690662683377664_o.jpg?fit=632%2C474&amp;ssl=1\" alt=\"\" class=\"wp-image-7023\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2019/07/60340743_2330687777177099_8058690662683377664_o.jpg?w=1728&amp;ssl=1 1728w, https://i2.wp.com/wordpress.org/news/files/2019/07/60340743_2330687777177099_8058690662683377664_o.jpg?resize=300%2C225&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2019/07/60340743_2330687777177099_8058690662683377664_o.jpg?resize=768%2C576&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2019/07/60340743_2330687777177099_8058690662683377664_o.jpg?resize=1024%2C768&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2019/07/60340743_2330687777177099_8058690662683377664_o.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" /><figcaption>Bhutanese contributors to the Dzongkha locale on WordPress Translation Day</figcaption></figure>\n\n\n\n<h2><strong>How Ugyen started his career with WordPress</strong></h2>\n\n\n\n<p>Back in 2016, Ugyen was looking for a new job after his former cloud company ran into financial difficulties.</p>\n\n\n\n<p>During one interview he was asked many questions about WordPress and, although he had a basic understanding of WordPress, he struggled to give detailed answers. After that interview he resolved to develop his skills and learn as much about WordPress as he could.&nbsp;</p>\n\n\n\n<p>A few months passed and he received a call from ServMask Inc, who had developed a plugin called All-in-One WP Migration. They offered him a position, fulfilling his wish to work with WordPress full-time. And because of that, Ugyen is now an active contributor to the WordPress community.</p>\n\n\n\n<h3><strong>WordCamp Bangkok 2018</strong></h3>\n\n\n\n<p>WordCamp Bangkok 2018 was a turning point event for Ugyen. WordCamps are a great opportunity to meet WordPress community members you don’t otherwise get to know, and he was able to attend his first WordCamp through the sponsorship of his company.</p>\n\n\n\n<p>The first day of WordCamp Bangkok was a Contributor Day, where people volunteer to work together to contribute to the development of WordPress. Ugyen joined the Community team to have conversations with WordPress users from all over the world. He was able to share his ideas for supporting new speakers, events and organizers to help build the WordPress community in places where it is not yet booming.</p>\n\n\n\n<p>During the main day of the event, Ugyen managed a photo booth for speakers, organizers, and attendees to capture their memories of WordCamp.&nbsp;He also got to take some time out to attend several presentations during the conference. What particularly stuck in Ugyen’s mind was learning that having a website content plan has been shown to lead to 100% growth in business development.</p>\n\n\n\n<h3>Co-Organizing<strong> Thimphu</strong>&#8216;s <strong>WordPress Meetup</strong></h3>\n\n\n\n<p>After attending WordCamp Bangkok 2018 as well as a local Meetup event, Ugyen decided to&nbsp;introduce WordPress to his home country and cities.&nbsp;</p>\n\n\n\n<p>As one of the WordPress Translation Day organizers, he realized that his local language, Dzongkha, was not as fully translated as other languages in the WordPress Core Translation. That is when Ugyen knew that he wanted to help build his local community. He organized Thimphu’s first WordPress Meetup to coincide with WordPress Translation Day 4, and it was a huge success!</p>\n\n\n\n<p>Like all WordPress Meetups, the Thimpu WordPress Meetup is an easygoing, volunteer-organized, non-profit meetup which covers everything related to WordPress. But it also keeps in mind the <a href=\"https://en.wikipedia.org/wiki/Gross_National_Happiness\">Bhutanese Gross National Happiness</a> four pillars by aiming to preserve and promote their unique culture and national language.&nbsp;</p>\n\n\n\n<h2><strong>Big dreams get accomplished one step at a time</strong></h2>\n\n\n\n<p>Ugyen has taken an active role in preserving his national language by encouraging his community to use WordPress, including Dzongkha bloggers, online Dzongkha news outlets, and government websites.</p>\n\n\n\n<p>And while Ugyen has only been actively involved in the community for a short period, he has contributed much to the WordPress community, including:</p>\n\n\n\n<ul><li>becoming a Translation Contributor for WordPress Core Translation for Dzongkha;</li><li>participating in the <a href=\"https://wptranslationday.org/\">Global WordPress Translation Day 4</a> Livestream and organizing team;</li><li>inviting WordPress Meetup Thimphu members and WordPress experts from other countries to join the <a href=\"https://wpbhutan.slack.com/\">local Slack instance</a>;</li><li>encouraging ServMask Inc. to become an event sponsor;</li><li>providing the Dzongkha Development Commission the opportunity to involve their language experts.</li></ul>\n\n\n\n<p>When it comes to WordPress, Ugyen particularly focuses on encouraging local and international language WordPress bloggers;&nbsp;helping startups succeed with WordPress;&nbsp;and sharing what he has learned from WordPress with his Bhutanese WordPress community.</p>\n\n\n\n<p>As a contributor, Ugyen hopes to accomplish even more for the Bhutan and Asian WordPress Communities. His dreams for his local community are big, including teaching more people about open source, hosting a local WordCamp, and helping to organize WordCamp Asia in 2020 &#8212; all while raising awareness of his community.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignleft is-resized\"><img src=\"https://i0.wp.com/wordpress.org/news/files/2019/07/heropress_large_white_logo-1.jpg?fit=632%2C474&amp;ssl=1\" alt=\"\" class=\"wp-image-7026\" width=\"110\" height=\"83\" /></figure></div>\n\n\n\n<p><em>This post is based on an article originally published on HeroPress.com, a community initiative created by <a href=\"https://profiles.wordpress.org/topher1kenobe/\">Topher DeRosia</a>. HeroPress highlights people in the WordPress community who have overcome barriers and whose stories would otherwise go unheard.</em></p>\n\n\n\n<p><em>Meet more WordPress community members over at </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7013\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"The Month in WordPress: June 2019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://wordpress.org/news/2019/07/the-month-in-wordpress-june-2019/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 01 Jul 2019 10:07:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=7009\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:337:\"June has certainly been a busy month in the WordPress community — aside from holding the largest WordPress event ever, the project has hit a number of significant milestones and published some big announcements this past month. A Wrap for WordCamp Europe 2019 WordCamp Europe 2019 took place on June 20-22. It was the largest [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8174:\"\n<p>June has certainly been a busy month in the WordPress community — aside from holding the largest WordPress event ever, the project has hit a number of significant milestones and published some big announcements this past month.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>A Wrap for WordCamp Europe 2019</h2>\n\n\n\n<p>WordCamp Europe 2019 took place on June 20-22. It was the largest WordPress event ever, with 3,260 tickets sold and 2,734 attendees. The attendees came from 97 different countries and 1,722 of them had never attended WordCamp Europe before.</p>\n\n\n\n<p>The event featured 60 speakers who delivered talks and workshops on a variety of topics over two conference days, most notably <a href=\"https://profiles.wordpress.org/matt/\">Matt Mullenweg</a>’s keynote that included an update on the current status of WordPress Core development, along with a lively Q&amp;A session. The full session from the live stream is <a href=\"https://youtu.be/UE18IsncB7s?t=13033\">available to watch online</a>.</p>\n\n\n\n<p>For its eighth year, <a href=\"https://2019.europe.wordcamp.org/2019/06/25/wordcamp-europe-2020/\">WordCamp Europe will take place in Porto, Portugal</a>. The 2020 edition of the event will be held on June 4-6. If you would like to get involved with WordCamp Europe next year, fill out <a href=\"https://2020.europe.wordcamp.org/2019/06/22/call-for-organisers/\">the organizer application form</a>.&nbsp;</p>\n\n\n\n<h2>Proposal for XML Sitemaps in WordPress Core</h2>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2019/06/12/xml-sitemaps-feature-project-proposal/\">A proposal this month</a> suggested bringing XML sitemap generation into WordPress Core. This is a feature that has traditionally been handled by plugins, which has resulted in many different implementations across different sites. It also means that many sites do not have XML sitemaps, which can be a problem because they are hugely important to having your site correctly indexed by search engines.</p>\n\n\n\n<p>The proposal details how core sitemaps would be structured and how the team would build them, as well as what aspects of WordPress would not be considered appropriate information to be included.</p>\n\n\n\n<p>Want to get involved in building this feature? Comment on <a href=\"https://make.wordpress.org/core/2019/06/12/xml-sitemaps-feature-project-proposal/\">the proposal</a>, follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Translation Milestone for the Spanish Community</h2>\n\n\n\n<p><a href=\"https://twitter.com/wp_es/status/1138015568563441665\">The WordPress community of Spain has worked hard</a> to make <a href=\"https://translate.wordpress.org/locale/es/\">the es_ES locale</a> the first in the world to fully localize all of WordPress Core along with all Meta projects, apps, and the top 200 plugins. This is made possible by having the largest translation team out of any locale, consisting of 2,951 individual contributors.</p>\n\n\n\n<p>Want to get involved in translating WordPress into our locale? Find your locale on <a href=\"https://translate.wordpress.org/\">the translation platform</a>, follow <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team blog</a>, and join the #polyglots channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>WordPress 5.2.2 Maintenance Release</h2>\n\n\n\n<p>On June 18, <a href=\"https://wordpress.org/news/2019/06/wordpress-5-2-2-maintenance-release/\">v5.2.2 of WordPress was released</a> as a maintenance release, fixing 13 bugs and improving the Site Health feature that was first published in v5.2. If your site has not already been automatically updated to this version, you can <a href=\"https://wordpress.org/download/\">download the update</a> or manually check for updates in your WordPress dashboard. Thanks to <a href=\"https://profiles.wordpress.org/audrasjb/\">JB Audras</a>, <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a>, and <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> for co-leading this release, as well as the 30 other individuals who contributed to it.</p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Full End to End Tests for WordPress Core</h2>\n\n\n\n<p>On June 27, <a href=\"https://make.wordpress.org/core/2019/06/27/introducing-the-wordpress-e2e-tests/\">e2e (end to end) testing was introduced</a> to WordPress and included in the continuous integration pipeline. E2e testing, which has been successfully used by Gutenberg, is used to simulate real user scenarios and validate process flows. Currently, the setup requires <a href=\"https://docs.docker.com/install/\">Docker</a> to run, and a number of e2e test utilities are already available in the&nbsp; <a href=\"https://github.com/WordPress/gutenberg/tree/master/packages/e2e-test-utils/src\">@wordpress/e2e-test-utils</a> package, in the Gutenberg repository.&nbsp;</p>\n\n\n\n<p>Want to use this feature? The more tests that are added, the more stable future releases will be! Follow the <a href=\"https://make.wordpress.org/core/\">the Core team blog</a>, and join the #core-js channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Feature Packages from the Theme Review Team</h2>\n\n\n\n<p>Following a <a href=\"https://make.wordpress.org/themes/2019/06/07/proposal-theme-feature-repositories/\">proposal for theme feature repositories</a>, an <a href=\"https://make.wordpress.org/themes/2019/06/24/feature-packages-update/\">update to the features package was announced</a>. Two new packages have been created that require code review and testing. The first is an Autoload Package, a foundational package for theme developers who are not currently using Composer (although <a href=\"https://getcomposer.org/\">Composer</a> is recommended instead of this package). The second is a Customizer Section Button Package that allows theme authors to create a link/button to any URL.</p>\n\n\n\n<p>There are other proposed ideas for packages that require feedback and additional discussion. Want to add your suggestions and thoughts? Join the conversation on the <a href=\"https://make.wordpress.org/themes/2019/06/24/feature-packages-update/\">Theme Review team blog</a> and join the #themereview channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>Development continues on the Gutenberg project, with <a href=\"https://make.wordpress.org/core/2019/06/26/whats-new-in-gutenberg-26th-june/\">the latest release</a> including layouts for the Columns block, Snackbar notices, markup improvements, and accessibility upgrades.</li><li>The Community team <a href=\"https://make.wordpress.org/community/2019/06/26/wordcamp-europe-2019-recap-of-community-team-activities-at-contributor-day-plans-for-the-future/\">published the results of their work</a> at the WordCamp Europe contributor day.</li><li>The Polyglots team <a href=\"https://make.wordpress.org/polyglots/2019/06/26/proposal-for-handling-pte-requests/\">has put together a proposal</a> for a new way to handle PTE requests.</li><li>This year’s recipient of the Kim Parsell Memorial Scholarship for WordCamp US <a href=\"https://wordpressfoundation.org/2019/2019-kim-parsell-memorial-scholarship-recipient-carol-gann/\">is Carol Gann</a>.</li><li>The Amurrio WordPress community <a href=\"http://wpamurrio.es/wordpress-amurrio-mega-meetup-i-edition/\">hosted their first “mega meetup”</a> &#8211; this is a great event format that bridges the gap between regular meetup event and WordCamp.</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"7009\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 5.2.2 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2019/06/wordpress-5-2-2-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 18 Jun 2019 18:14:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6993\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:348:\"WordPress 5.2.2 is now available! This maintenance release fixes 13 bugs and adds a little bit of polish to the Site Health feature&#160;that made its debut in 5.2. For more info, browse the&#160;full list of changes on Trac or check out the Version 5.2.2 documentation page. WordPress 5.2.2 is a short-cycle maintenance release. The next [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"marybaum\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3961:\"\n<p>WordPress 5.2.2 is now available! This maintenance release fixes 13 bugs and adds a little bit of polish to the Site Health feature&nbsp;<a href=\"https://wordpress.org/news/2019/05/jaco/\">that made its debut in 5.2</a>. </p>\n\n\n\n<p>For more info, browse the&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=5.2.2&amp;order=priority\">full list of changes on Trac</a> or check out <a href=\"https://wordpress.org/support/wordpress-version/version-5-2-2/\">the Version 5.2.2 documentation page.</a></p>\n\n\n\n<p>WordPress 5.2.2 is a short-cycle maintenance release. The next major release will be version 5.3; check <a href=\"https://make.wordpress.org/core/\">make.wordpress.org/core</a> for details as they happen.  </p>\n\n\n\n<p>You can&nbsp;download&nbsp;<a href=\"https://wordpress.org/download/\">WordPress 5.2.2</a>&nbsp;or visit&nbsp;<strong>Dashboard → Updates</strong>&nbsp;and click&nbsp;<strong>Update Now</strong>. Sites that support automatic background updates have already started to update automatically.</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/audrasjb/\">JB Audras</a>, <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a> and <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a> co-led this release, with invaluable guidance from our Executive Director, Josepha Haden Chomphosy, and contributions from 30 other contributors. Thank you to everyone who made this release possible!</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/aduth/\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/jankimoradiya/\">Janki Moradiya</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jitendrabanjara1991/\">jitendrabanjara1991</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">Mary Baum</a>, <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">palmiak</a>, <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendonça</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/tinkerbelly/\">sarah semark</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/shashank3105/\">Shashank Panchal</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/hedgefield/\">Tim Hengeveld</a>, <a href=\"https://profiles.wordpress.org/vaishalipanchal/\">vaishalipanchal</a>, <a href=\"https://profiles.wordpress.org/vrimill/\">vrimill</a>, and <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6993\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"The Month in WordPress: May 2019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2019/06/the-month-in-wordpress-may-2019/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 04 Jun 2019 10:21:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6987\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:319:\"This month saw the 16th anniversary since the launch of the first release of WordPress. A significant milestone to be sure and one that speaks to the strength and stability of the project as a whole. In this anniversary month, we saw a new major release of WordPress, some exciting new development work, and a [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6602:\"\n<p>This month saw the 16th anniversary since <a href=\"https://wordpress.org/news/2003/05/wordpress-now-available/\">the launch of the first release of WordPress</a>. A significant milestone to be sure and one that speaks to the strength and stability of the project as a whole. In this anniversary month, we saw a new major release of WordPress, some exciting new development work, and a significant global event.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Release of WordPress 5.2</h2>\n\n\n\n<p>WordPress 5.2 “Jaco” <a href=\"https://wordpress.org/news/2019/05/jaco/\">was released on May 7</a> shipping some useful site management tools, such as the Site Health Check and PHP Error Protection, as well as a number of accessibility, privacy, and developer updates. You can read <a href=\"https://make.wordpress.org/core/2019/04/16/wordpress-5-2-field-guide/\">the field guide for this release</a> for more detailed information about what was included and how it all works.<br></p>\n\n\n\n<p>327 individual volunteers contributed to the release. If you would like to be a part of that number for future releases, follow <a href=\"https://make.wordpress.org/core\">the Core team blog</a> and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>A Successful WordPress Translation Day 4</h2>\n\n\n\n<p>WordPress Translation Day is a 24-hour event organised by <a href=\"https://make.wordpress.org/polyglots/\">the Polyglots team</a> where community members from all over the world come together to translate WordPress into their local languages. For the fourth edition held on 11 May, 183 brand new contributors joined the Polyglots team from 77 communities across 35 countries in Africa, Asia, Europe, North America, South America, and Oceania.<br></p>\n\n\n\n<p>While the WP Translation Day is a great time for focussed contributions to localizing WordPress, but these contributions can happen at any time of the year, so if you would like to help make WordPress available in your local language, follow <a href=\"https://make.wordpress.org/polyglots\">the Polyglots team blog</a> and join the #polyglots channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Updated Plugin Guidelines Proposal</h2>\n\n\n\n<p>The Plugins team <a href=\"https://make.wordpress.org/plugins/2019/05/14/proposal-to-modify-plugin-guidelines/\">has proposed some updates</a> to the guidelines for developers on the Plugin Directory. The majority of the proposed changes are intended to address significant issues faced by developers who do not speak English as a first language, making the Plugin DIrectory a more accessible and beneficial place for everyone.<br></p>\n\n\n\n<p>The proposal will be open for comments until late June, so the community is encouraged to get involved with commenting on them and the direction they will take the Plugin Directory. If you would like to be involved in this discussion, comment on <a href=\"https://make.wordpress.org/plugins/2019/05/14/proposal-to-modify-plugin-guidelines/\">the proposal</a> and join the #plugin review team in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Continued Gutenberg Development</h2>\n\n\n\n<p>Since the block editor was first released as part of WordPress Core in v5.0, development has continued in leaps and bounds with a new release every two weeks. <a href=\"https://make.wordpress.org/core/2019/05/29/whats-new-in-gutenberg-29th-may/\">The latest update</a> includes some great incremental improvements that will be merged into the 5.2.2 release of WordPress along with the other recent enhancements.<br></p>\n\n\n\n<p>In addition to the editor enhancements, work has been ongoing in the Gutenberg project to bring the block editing experience to the rest of the WordPress dashboard. This second phase of the project has been going well and <a href=\"https://make.wordpress.org/design/2019/05/31/gutenberg-phase-2-friday-design-update-20/\">the latest update</a> shows how much work has been done so far.<br></p>\n\n\n\n<p>In addition to that, the Block Library project that aims to bring a searchable library of available blocks right into the editor is deep in the planning phase with <a href=\"https://make.wordpress.org/design/2019/05/28/block-library-initial-explorations/\">a recent update</a> showing what direction the team is taking things.<br></p>\n\n\n\n<p>If you would like to get involved in planning and development of Gutenberg and the block editor, follow the <a href=\"https://make.wordpress.org/core/\">Core</a> and <a href=\"https://make.wordpress.org/design/\">Design</a> team blogs and join the #core, #design, and #core-editor channels in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The 5.2.2 release of WordPress <a href=\"https://make.wordpress.org/core/2019/05/28/5-2-2-release-agenda/\">is currently in development</a> with a planned release date of 13 June.</li><li>Version 2.1.1 of the WordPress Coding Standards <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/releases/tag/2.1.1\">has been released</a> containing seven small, but relevant fixes.</li><li>The Theme Review Team <a href=\"https://make.wordpress.org/themes/2019/05/07/trusted-authors-changes/\">have updated the details</a> of how the Trusted Authors Program works.</li><li><a href=\"https://make.wordpress.org/community/2019/05/29/who-wants-to-test-the-new-wordcamp-blocks/\">WordCamp-specific blocks have been launched for WordCamp sites</a> with organizers needing to sign up in order to test them out.</li><li>Continuing the growing trend of other platforms adopting the Gutenberg editor, it has now <a href=\"https://octobercms.com/plugin/reazzon-gutenberg\">been ported to a plugin for OctoberCMS</a>.</li><li>Version 3.0 of the popular WordPress development environment, Varying Vagrant Vagrants (VVV), <a href=\"https://varyingvagrantvagrants.org/blog/2019/05/15/vvv-3-0-0.html\">was released this month</a>.</li><li>The Community Team <a href=\"https://make.wordpress.org/community/2019/05/31/the-4-gets-in-wordpress-community-organizing/\">published some info</a> clarifying what organizers get (and don’t get) from being involved with their local communities. </li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em><br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6987\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"WordPress 5.2.1 Maintenance Release\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/news/2019/05/wordpress-5-2-1-maintenance-release/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 21 May 2019 19:04:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:5:\"5.2.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6976\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:405:\"WordPress 5.2.1 is now available! This maintenance release fixes 33 bugs, including improvements to the block editor, accessibility, internationalization, and the Site Health feature introduced in 5.2. You can browse the&#160;full list of changes on Trac. WordPress 5.2.1 is a short-cycle maintenance release. Version 5.2.2 is expected to follow in approximately two weeks. You can&#160;download [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Jonathan Desrosiers\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4923:\"\n<p>WordPress 5.2.1 is now available! This maintenance release fixes 33 bugs, including improvements to the block editor, accessibility, internationalization, and the Site Health feature <a href=\"https://wordpress.org/news/2019/05/jaco/\">introduced in 5.2</a>.</p>\n\n\n\n<p>You can browse the&nbsp;<a href=\"https://core.trac.wordpress.org/query?status=closed&amp;resolution=fixed&amp;milestone=5.2.1&amp;order=priority\">full list of changes on Trac</a>.</p>\n\n\n\n<p>WordPress 5.2.1 is a short-cycle maintenance release. <a href=\"https://core.trac.wordpress.org/query?milestone=5.2.2\">Version 5.2.2</a> is expected to follow in approximately two weeks.</p>\n\n\n\n<p>You can&nbsp;download <a href=\"https://wordpress.org/download/\">WordPress 5.2.1</a>&nbsp;or visit <strong>Dashboard → Updates</strong> and click&nbsp;<strong>Update Now</strong>. Sites that support automatic background updates have already started to update automatically.</p>\n\n\n\n<p>Jonathan Desrosiers and William Earnhardt co-led this release, with contributions from 52 other contributors. Thank you to everyone that made this release possible!</p>\n\n\n\n<p><a href=\"https://profiles.wordpress.org/xavortm/\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/tellyworth/\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/aduth/\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst/\">Andrey &#8220;Rarst&#8221; Savchenko</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/anischarolia/\">anischarolia</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson (birgire)</a>, <a href=\"https://profiles.wordpress.org/chesio/\">chesio</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/daxelrod/\">daxelrod</a>, <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a>, <a href=\"https://profiles.wordpress.org/odminstudios/\">Dima</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella van Durpe</a>, <a href=\"https://profiles.wordpress.org/edocev/\">Emil Dotsev</a>, <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">ghoul</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Grzegorz (Greg) Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/gwwar/\">gwwar</a>, <a href=\"https://profiles.wordpress.org/hareesh-pillai/\">Hareesh</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jb Audras</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/chanthaboune/\">Josepha</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">kjellr</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius L. J.</a>, <a href=\"https://profiles.wordpress.org/mikengarrett/\">MikeNGarrett</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/onlanka/\">onlanka</a>, <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">paragoninitiativeenterprises</a>, <a href=\"https://profiles.wordpress.org/parkcityj/\">parkcityj</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">Sébastien SERRE</a>, <a href=\"https://profiles.wordpress.org/tfrommen/\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/hedgefield/\">Tim Hengeveld</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tonybogdanov/\">tonybogdanov</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, and <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6976\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"Tomorrow is WordPress Translation Day 4\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/news/2019/05/tomorrow-is-wordpress-translation-day-4/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 10 May 2019 09:17:48 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:13:\"Documentation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6961\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:342:\"The fourth edition of WordPress translation day is coming up on Saturday 11 May 2019: tomorrow! Get ready for a 24-hour, global marathon dedicated to localizing the WordPress platform and ecosystem. This event takes place both online and in physical locations across the world, so you can join no matter where you are! The WordPress [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3747:\"\n<p><em>The fourth edition of WordPress translation day is coming up on Saturday 11 May 2019: tomorrow! Get ready for a 24-hour, global marathon dedicated to localizing the WordPress platform and ecosystem.</em> <em>This event takes place both online and in physical locations across the world, so you can join no matter where you are! </em></p>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/polyglots/\">WordPress Polyglots Team</a> has a mission to translate and make available the software’s features into as many languages as possible. As WordPress powers more than 33% of websites, people from across the world use it in their daily life. That means there is a lot that needs translating, and into many different languages. </p>\n\n\n\n<p>On 11 May 2019, from 00:00 UTC until 23:59 UTC, <a href=\"https://wptranslationday.org/\">WordPress Translation Day</a> aims to celebrate the thousands of volunteers who contribute to translation and internalization. The event is also an opportunity for encouraging more people to get involved and help increase the availability of themes and plugins in different languages.</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>&#8220;At the time of the last event in 2017, WordPress was being translated into 178 languages, we have now reached the 200 mark!&#8221;</p><cite>WPtranslationday.org</cite></blockquote></figure>\n\n\n\n<h2>What happens on WordPress Translation Day?</h2>\n\n\n\n<p>There are a number of <a href=\"https://wptranslationday.org/the-local-events/\">local meetings all over the world</a>, as well as online talks by people from the WordPress community. More than 700 people from around the world took part in past WordPress Translation Days, and everyone welcome to join in this time around!</p>\n\n\n\n<p>Everyone is welcome to join the event to help translate and localize WordPress, no matter their level of experience. A lot is happening on the day, so join in and you will learn how to through online sessions!</p>\n\n\n\n<h3>What can you expect?</h3>\n\n\n\n<ul><li><strong>Live online training</strong>: Tutorials in different languages focused on translation and <em>localization</em>, or l10n, of WordPress. These are streamed in multiple languages</li><li><strong>Localization sessions</strong>: General instruction and specifics for particular areas and languages. These sessions are streamed in multiple languages.</li><li><strong>Internalization sessions</strong>: Tutorials about optimizing the code to ease localization processes, also called <em>internationalization</em> or i18n. These sessions are streamed in English.</li><li><strong>Local events</strong>: Polyglot contributors will gather around the world for socializing, discussing, and translating together.</li><li><strong>Remote events</strong>: Translation teams that cannot gather physically, will connect remotely. They will be available for training, mentoring, and supporting new contributors. They will also engage in &#8220;translating marathons&#8221;, in which existing teams translate as many strings as they can!</li></ul>\n\n\n\n<p>A number of experienced WordPress translators and internationalization experts are part of the line-up for the livestream, joined by some first time contributors. </p>\n\n\n\n<p>Whether you have or haven&#8217;t contributed to the Polyglots before, you can join in for WordPress Translation Day. Learn more about both local and online events and stay updated through the website and social media. </p>\n\n\n\n<ul><li><a href=\"https://wptranslationday.org/\">WordPress Translation Day website</a></li><li><a href=\"https://twitter.com/translatewp\">WordPress Translation Day Twitter</a></li><li><a href=\"https://www.facebook.com/WPTranslationDay/\">WordPress Translation Day Facebook</a></li></ul>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6961\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"WordPress 5.2 “Jaco”\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/news/2019/05/jaco/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 May 2019 21:03:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6925\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:426:\"Version 5.2 of WordPress is available for download or update in your WordPress dashboard. New features in this update make it easier than ever to fix your site if something goes wrong. There are even more robust tools for identifying and fixing configuration issues and fatal errors. Whether you are a developer helping clients or you manage your site solo, these tools can help get you the right information when you need it.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:32081:\"\n<h2 style=\"text-align:center\">Keeping Sites Safer</h2>\n\n\n\n<figure class=\"wp-block-image\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2019/05/about_maintain-wordpress-cropped.png?fit=632%2C500&amp;ssl=1\" alt=\"\" class=\"wp-image-6926\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2019/05/about_maintain-wordpress-cropped.png?w=1206&amp;ssl=1 1206w, https://i1.wp.com/wordpress.org/news/files/2019/05/about_maintain-wordpress-cropped.png?resize=300%2C237&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2019/05/about_maintain-wordpress-cropped.png?resize=768%2C608&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2019/05/about_maintain-wordpress-cropped.png?resize=1024%2C810&amp;ssl=1 1024w\" sizes=\"(max-width: 632px) 100vw, 632px\" /></figure>\n\n\n\n<p>Version 5.2 of WordPress, named “Jaco” in honor of renowned and revolutionary jazz bassist Jaco Pastorius, is available for download or update in your WordPress dashboard. New features in this update make it easier than ever to fix your site if something goes wrong.</p>\n\n\n\n<p>There are even more robust tools for identifying and fixing configuration issues and fatal errors. Whether you are a developer helping clients or you manage your site solo, these tools can help get you the right information when you need it.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h3>Site Health Check</h3>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignleft is-resized\"><img src=\"https://i2.wp.com/wordpress.org/news/files/2019/05/about_site-health.png?resize=205%2C143&#038;ssl=1\" alt=\"\" class=\"wp-image-6927\" width=\"205\" height=\"143\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2019/05/about_site-health.png?w=609&amp;ssl=1 609w, https://i2.wp.com/wordpress.org/news/files/2019/05/about_site-health.png?resize=300%2C210&amp;ssl=1 300w\" sizes=\"(max-width: 205px) 100vw, 205px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>Building on the <a href=\"https://wordpress.org/news/2019/02/betty/\">Site Health</a> features introduced in 5.1, this release adds two new pages to help debug common configuration issues. It also adds space where developers can include debugging information for site maintainers.</p>\n\n\n\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<h3>PHP Error Protection</h3>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"alignleft is-resized\"><img src=\"https://i1.wp.com/wordpress.org/news/files/2019/05/about_error-protection.png?resize=202%2C228&#038;ssl=1\" alt=\"\" class=\"wp-image-6930\" width=\"202\" height=\"228\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2019/05/about_error-protection.png?w=487&amp;ssl=1 487w, https://i1.wp.com/wordpress.org/news/files/2019/05/about_error-protection.png?resize=267%2C300&amp;ssl=1 267w\" sizes=\"(max-width: 202px) 100vw, 202px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>This administrator-focused update will let you safely fix or manage fatal errors without requiring developer time. It features better handling of the so-called “white screen of death,” and a way to enter recovery mode, &nbsp;which pauses error-causing plugins or themes.</p>\n\n\n\n<div style=\"height:79px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 style=\"text-align:center\">Improvements for Everyone</h2>\n\n\n\n<h3>Accessibility Updates</h3>\n\n\n\n<p>A number of changes work together to improve contextual awareness and keyboard navigation flow for those using screen readers and other assistive technologies.</p>\n\n\n\n<h3>New Dashboard Icons</h3>\n\n\n\n<p>Thirteen new icons including Instagram, a suite of icons for BuddyPress, and rotated Earth icons for global inclusion. Find them in the Dashboard and have some fun!</p>\n\n\n\n<h3>Plugin Compatibility Checks</h3>\n\n\n\n<p>WordPress will now automatically determine if your site’s version of PHP is compatible with installed plugins. If the plugin requires a higher version of PHP than your site currently uses, WordPress will not allow you to activate it, preventing potential compatibility errors.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 style=\"text-align:center\">Developer Happiness</h2>\n\n\n\n<div class=\"wp-block-columns has-2-columns\">\n<div class=\"wp-block-column\">\n<p><a href=\"https://make.wordpress.org/core/2019/03/26/coding-standards-updates-for-php-5-6/\"><strong>PHP Version Bump</strong></a><strong> </strong></p>\n\n\n\n<p>The minimum supported PHP version is now 5.6.20. As of WordPress 5.2*, themes and plugins can safely take advantage of namespaces, anonymous functions, and more!</p>\n</div>\n\n\n\n<div class=\"wp-block-column\">\n<p><a href=\"https://make.wordpress.org/core/2019/04/24/developer-focused-privacy-updates-in-5-2/\"><strong>Privacy Updates</strong></a><strong> </strong></p>\n\n\n\n<p>A new theme page template, a conditional function, and two CSS classes make designing and customizing the Privacy Policy page easier.</p>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns has-2-columns\">\n<div class=\"wp-block-column\">\n<p><strong><a href=\"https://make.wordpress.org/core/2019/04/24/miscellaneous-developer-updates-in-5-2/\">New Body Hook</a> </strong></p>\n\n\n\n<p>5.2 introduces a wp_body_open hook, which lets themes support injecting code right at the beginning of the &lt;body&gt; element.</p>\n</div>\n\n\n\n<div class=\"wp-block-column\">\n<p><a href=\"https://make.wordpress.org/core/2019/03/25/building-javascript/\"><strong>Building JavaScript</strong></a></p>\n\n\n\n<p>With the addition of webpack and Babel configurations in the wordpress/scripts package, developers won&#8217;t have to worry about setting up complex build tools to write modern JavaScript.</p>\n</div>\n</div>\n\n\n\n<p><em>*If you are running an old version of PHP (less than 5.6.20), <a href=\"https://wordpress.org/support/update-php/\">update your PHP</a> before installing 5.2.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>The Squad</h2>\n\n\n\n<p>This release was led by&nbsp;<a href=\"http://ma.tt/\">Matt Mullenweg</a>, <a href=\"https://josepha.blog/\">Josepha Haden Chomphosy</a>, and&nbsp;<a href=\"https://pento.net/\">Gary Pendergast</a>. They were graciously supported by 327 generous volunteer contributors. Load a Jaco Pastorius playlist on your favorite music service and check out some of their profiles:</p>\n\n\n<a href=\"https://profiles.wordpress.org/aaroncampbell/\">Aaron D. Campbell</a>, <a href=\"https://profiles.wordpress.org/jorbin/\">Aaron Jorbin</a>, <a href=\"https://profiles.wordpress.org/adamsilverstein/\">Adam Silverstein</a>, <a href=\"https://profiles.wordpress.org/adamsoucie/\">Adam Soucie</a>, <a href=\"https://profiles.wordpress.org/oztaser/\">Adil &#214;ztaşer</a>, <a href=\"https://profiles.wordpress.org/ajitbohra/\">Ajit Bohra</a>, <a href=\"https://profiles.wordpress.org/schlessera/\">Alain Schlesser</a>, <a href=\"https://profiles.wordpress.org/aldavigdis/\">Alda Vigd&#237;s</a>, <a href=\"https://profiles.wordpress.org/alexdenning/\">Alex Denning</a>, <a href=\"https://profiles.wordpress.org/xavortm/\">Alex Dimitrov</a>, <a href=\"https://profiles.wordpress.org/akirk/\">Alex Kirk</a>, <a href=\"https://profiles.wordpress.org/viper007bond/\">Alex Mills</a>, <a href=\"https://profiles.wordpress.org/tellyworth/\">Alex Shiels</a>, <a href=\"https://profiles.wordpress.org/lexiqueen/\">Alexis</a>, <a href=\"https://profiles.wordpress.org/alexislloyd/\">Alexis Lloyd</a>, <a href=\"https://profiles.wordpress.org/allancole/\">allancole</a>, <a href=\"https://profiles.wordpress.org/allendav/\">Allen Snook</a>, <a href=\"https://profiles.wordpress.org/arena/\">Andr?</a>, <a href=\"https://profiles.wordpress.org/andraganescu/\">andraganescu</a>, <a href=\"https://profiles.wordpress.org/afercia/\">Andrea Fercia</a>, <a href=\"https://profiles.wordpress.org/andreamiddleton/\">Andrea Middleton</a>, <a href=\"https://profiles.wordpress.org/euthelup/\">Andrei Lupu</a>, <a href=\"https://profiles.wordpress.org/aandrewdixon/\">Andrew Dixon</a>, <a href=\"https://profiles.wordpress.org/aduth/\">Andrew Duthie</a>, <a href=\"https://profiles.wordpress.org/nacin/\">Andrew Nacin</a>, <a href=\"https://profiles.wordpress.org/azaozz/\">Andrew Ozz</a>, <a href=\"https://profiles.wordpress.org/rarst/\">Andrey \"Rarst\" Savchenko</a>, <a href=\"https://profiles.wordpress.org/nosolosw/\">Andrés Maneiro</a>, <a href=\"https://profiles.wordpress.org/afragen/\">Andy Fragen</a>, <a href=\"https://profiles.wordpress.org/andizer/\">Andy Meerwaldt</a>, <a href=\"https://profiles.wordpress.org/aniketpatel/\">Aniket Patel</a>, <a href=\"https://profiles.wordpress.org/anischarolia/\">anischarolia</a>, <a href=\"https://profiles.wordpress.org/atimmer/\">Anton Timmermans</a>, <a href=\"https://profiles.wordpress.org/vanyukov/\">Anton Vanyukov</a>, <a href=\"https://profiles.wordpress.org/avillegasn/\">Antonio Villegas</a>, <a href=\"https://profiles.wordpress.org/antonypuckey/\">antonypuckey</a>, <a href=\"https://profiles.wordpress.org/aristath/\">Ari Stathopoulos</a>, <a href=\"https://profiles.wordpress.org/wpboss/\">Aslam Shekh</a>, <a href=\"https://profiles.wordpress.org/axaak/\">axaak</a>, <a href=\"https://profiles.wordpress.org/pixolin/\">Bego Mario Garde</a>, <a href=\"https://profiles.wordpress.org/empireoflight/\">Ben Dunkle</a>, <a href=\"https://profiles.wordpress.org/britner/\">Ben Ritner - Kadence Themes</a>, <a href=\"https://profiles.wordpress.org/bfintal/\">Benjamin Intal</a>, <a href=\"https://profiles.wordpress.org/billerickson/\">Bill Erickson</a>, <a href=\"https://profiles.wordpress.org/birgire/\">Birgir Erlendsson</a>, <a href=\"https://profiles.wordpress.org/bodohugobarwich/\">Bodo (Hugo) Barwich</a>, <a href=\"https://profiles.wordpress.org/gitlost/\">bonger</a>, <a href=\"https://profiles.wordpress.org/boonebgorges/\">Boone Gorges</a>, <a href=\"https://profiles.wordpress.org/bradleyt/\">Bradley Taylor</a>, <a href=\"https://profiles.wordpress.org/kraftbj/\">Brandon Kraft</a>, <a href=\"https://profiles.wordpress.org/brentswisher/\">Brent Swisher</a>, <a href=\"https://profiles.wordpress.org/burhandodhy/\">Burhan Nasir</a>, <a href=\"https://profiles.wordpress.org/cathibosco1/\">Cathi Bosco</a>, <a href=\"https://profiles.wordpress.org/chetan200891/\">Chetan Prajapati</a>, <a href=\"https://profiles.wordpress.org/chiaralovelaces/\">Chiara Magnani</a>, <a href=\"https://profiles.wordpress.org/chouby/\">Chouby</a>, <a href=\"https://profiles.wordpress.org/chrisvanpatten/\">Chris Van Patten</a>, <a href=\"https://profiles.wordpress.org/dswebsme/\">D.S. Webster</a>, <a href=\"https://profiles.wordpress.org/colorful-tones/\">Damon Cook</a>, <a href=\"https://profiles.wordpress.org/danielbachhuber/\">Daniel Bachhuber</a>, <a href=\"https://profiles.wordpress.org/danieltj/\">Daniel James</a>, <a href=\"https://profiles.wordpress.org/diddledan/\">Daniel Llewellyn</a>, <a href=\"https://profiles.wordpress.org/talldanwp/\">Daniel Richards</a>, <a href=\"https://profiles.wordpress.org/mte90/\">Daniele Scasciafratte</a>, <a href=\"https://profiles.wordpress.org/nerrad/\">Darren Ethier</a>, <a href=\"https://profiles.wordpress.org/drw158/\">Dave Whitley</a>, <a href=\"https://profiles.wordpress.org/davefx/\">DaveFX</a>, <a href=\"https://profiles.wordpress.org/davetgreen/\">davetgreen</a>, <a href=\"https://profiles.wordpress.org/davidbaumwald/\">David Baumwald</a>, <a href=\"https://profiles.wordpress.org/davidbinda/\">David Binovec</a>, <a href=\"https://profiles.wordpress.org/david.binda/\">David Binovec</a>, <a href=\"https://profiles.wordpress.org/dlh/\">David Herrera</a>, <a href=\"https://profiles.wordpress.org/dgroddick/\">David Roddick</a>, <a href=\"https://profiles.wordpress.org/get_dave/\">David Smith</a>, <a href=\"https://profiles.wordpress.org/folletto/\">Davide \'Folletto\' Casali</a>, <a href=\"https://profiles.wordpress.org/daxelrod/\">daxelrod</a>, <a href=\"https://profiles.wordpress.org/dkarfa/\">Debabrata Karfa</a>, <a href=\"https://profiles.wordpress.org/dekervit/\">dekervit</a>, <a href=\"https://profiles.wordpress.org/denis-de-bernardy/\">Denis de Bernardy</a>, <a href=\"https://profiles.wordpress.org/dmsnell/\">Dennis Snell</a>, <a href=\"https://profiles.wordpress.org/valendesigns/\">Derek Herman</a>, <a href=\"https://profiles.wordpress.org/pcfreak30/\">Derrick Hammer</a>, <a href=\"https://profiles.wordpress.org/designsimply/\">designsimply</a>, <a href=\"https://profiles.wordpress.org/dhanukanuwan/\">Dhanukanuwan</a>, <a href=\"https://profiles.wordpress.org/dharm1025/\">Dharmesh Patel</a>, <a href=\"https://profiles.wordpress.org/dianeco/\">Diane</a>, <a href=\"https://profiles.wordpress.org/diegoreymendez/\">diegoreymendez</a>, <a href=\"https://profiles.wordpress.org/dilipbheda/\">Dilip Bheda</a>, <a href=\"https://profiles.wordpress.org/odminstudios/\">Dima</a>, <a href=\"https://profiles.wordpress.org/dd32/\">Dion Hulse</a>, <a href=\"https://profiles.wordpress.org/dency/\">Dixita Dusara</a>, <a href=\"https://profiles.wordpress.org/iamdmitrymayorov/\">Dmitry Mayorov</a>, <a href=\"https://profiles.wordpress.org/ocean90/\">Dominik Schilling</a>, <a href=\"https://profiles.wordpress.org/drewapicture/\">Drew Jaynes</a>, <a href=\"https://profiles.wordpress.org/dsifford/\">dsifford</a>, <a href=\"https://profiles.wordpress.org/seedsca/\">EcoTechie</a>, <a href=\"https://profiles.wordpress.org/etoledom/\">Eduardo Toledo</a>, <a href=\"https://profiles.wordpress.org/iseulde/\">Ella Van Durpe</a>, <a href=\"https://profiles.wordpress.org/edocev/\">Emil Dotsev</a>, <a href=\"https://profiles.wordpress.org/fabiankaegy/\">fabiankaegy</a>, <a href=\"https://profiles.wordpress.org/faisal03/\">Faisal Alvi</a>, <a href=\"https://profiles.wordpress.org/parsmizban/\">Farhad Sakhaei</a>, <a href=\"https://profiles.wordpress.org/flixos90/\">Felix Arntz</a>, <a href=\"https://profiles.wordpress.org/peaceablewhale/\">Franklin Tse</a>, <a href=\"https://profiles.wordpress.org/fuegas/\">Fuegas</a>, <a href=\"https://profiles.wordpress.org/garrett-eclipse/\">Garrett Hyder</a>, <a href=\"https://profiles.wordpress.org/garyj/\">Gary Jones</a>, <a href=\"https://profiles.wordpress.org/soulseekah/\">Gennady Kovshenin</a>, <a href=\"https://profiles.wordpress.org/sachyya-sachet/\">ghoul</a>, <a href=\"https://profiles.wordpress.org/girishpanchal/\">Girish Panchal</a>, <a href=\"https://profiles.wordpress.org/gziolo/\">Grzegorz Ziółkowski</a>, <a href=\"https://profiles.wordpress.org/wido/\">Guido Scialfa</a>, <a href=\"https://profiles.wordpress.org/gutendev/\">GutenDev <img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/270d.png\" alt=\"✍\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /><img src=\"https://s.w.org/images/core/emoji/12.0.0-1/72x72/3299.png\" alt=\"㊙\" class=\"wp-smiley\" style=\"height: 1em; max-height: 1em;\" /></a>, <a href=\"https://profiles.wordpress.org/gwwar/\">gwwar</a>, <a href=\"https://profiles.wordpress.org/hannahmalcolm/\">Hannah Malcolm</a>, <a href=\"https://profiles.wordpress.org/hardik-amipara/\">Hardik Amipara</a>, <a href=\"https://profiles.wordpress.org/thakkarhardik/\">Hardik Thakkar</a>, <a href=\"https://profiles.wordpress.org/luehrsen/\">Hendrik Luehrsen</a>, <a href=\"https://profiles.wordpress.org/henrywright-1/\">Henry</a>, <a href=\"https://profiles.wordpress.org/henrywright/\">Henry Wright</a>, <a href=\"https://profiles.wordpress.org/ryanshoover/\">Hoover</a>, <a href=\"https://profiles.wordpress.org/ianbelanger/\">Ian Belanger</a>, <a href=\"https://profiles.wordpress.org/iandunn/\">Ian Dunn</a>, <a href=\"https://profiles.wordpress.org/ice9js/\">ice9js</a>, <a href=\"https://profiles.wordpress.org/zinigor/\">Igor Zinovyev</a>, <a href=\"https://profiles.wordpress.org/imath/\">imath</a>, <a href=\"https://profiles.wordpress.org/ixium/\">Ixium</a>, <a href=\"https://profiles.wordpress.org/jdgrimes/\">J.D. Grimes</a>, <a href=\"https://profiles.wordpress.org/jakeparis/\">jakeparis</a>, <a href=\"https://profiles.wordpress.org/cc0a/\">James</a>, <a href=\"https://profiles.wordpress.org/janak007/\">janak Kaneriya</a>, <a href=\"https://profiles.wordpress.org/jankimoradiya/\">Janki Moradiya</a>, <a href=\"https://profiles.wordpress.org/jarred-kennedy/\">Jarred Kennedy</a>, <a href=\"https://profiles.wordpress.org/vengisss/\">Javier Villanueva</a>, <a href=\"https://profiles.wordpress.org/jayupadhyay01/\">Jay Upadhyay</a>, <a href=\"https://profiles.wordpress.org/jaydeep-rami/\">Jaydip Rami</a>, <a href=\"https://profiles.wordpress.org/parkcityj/\">Jaye Simons</a>, <a href=\"https://profiles.wordpress.org/jaymanpandya/\">Jayman Pandya</a>, <a href=\"https://profiles.wordpress.org/jdeeburke/\">jdeeburke</a>, <a href=\"https://profiles.wordpress.org/audrasjb/\">Jean-Baptiste Audras</a>, <a href=\"https://profiles.wordpress.org/jeffpaul/\">Jeff Paul</a>, <a href=\"https://profiles.wordpress.org/cheffheid/\">Jeffrey de Wit</a>, <a href=\"https://profiles.wordpress.org/miss_jwo/\">Jenny Wong</a>, <a href=\"https://profiles.wordpress.org/jeremyfelt/\">Jeremy Felt</a>, <a href=\"https://profiles.wordpress.org/endocreative/\">Jeremy Green</a>, <a href=\"https://profiles.wordpress.org/jeherve/\">Jeremy Herve</a>, <a href=\"https://profiles.wordpress.org/jitendrabanjara1991/\">jitendrabanjara1991</a>, <a href=\"https://profiles.wordpress.org/joedolson/\">Joe Dolson</a>, <a href=\"https://profiles.wordpress.org/joemcgill/\">Joe McGill</a>, <a href=\"https://profiles.wordpress.org/joen/\">Joen Asmussen</a>, <a href=\"https://profiles.wordpress.org/j-falk/\">Johan Falk</a>, <a href=\"https://profiles.wordpress.org/johannadevos/\">Johanna de Vos</a>, <a href=\"https://profiles.wordpress.org/johnbillion/\">John Blackbourn</a>, <a href=\"https://profiles.wordpress.org/johnjamesjacoby/\">John James Jacoby</a>, <a href=\"https://profiles.wordpress.org/desrosj/\">Jonathan Desrosiers</a>, <a href=\"https://profiles.wordpress.org/jonathandejong/\">Jonathandejong</a>, <a href=\"https://profiles.wordpress.org/joneiseman/\">joneiseman</a>, <a href=\"https://profiles.wordpress.org/spacedmonkey/\">Jonny Harris</a>, <a href=\"https://profiles.wordpress.org/jonnybojangles/\">jonnybojangles</a>, <a href=\"https://profiles.wordpress.org/joostdevalk/\">Joost de Valk</a>, <a href=\"https://profiles.wordpress.org/jordesign/\">jordesign</a>, <a href=\"https://profiles.wordpress.org/koke/\">Jorge Bernal</a>, <a href=\"https://profiles.wordpress.org/jorgefilipecosta/\">Jorge Costa</a>, <a href=\"https://profiles.wordpress.org/keraweb/\">Jory Hogeveen</a>, <a href=\"https://profiles.wordpress.org/jcastaneda/\">Jose Castaneda</a>, <a href=\"https://profiles.wordpress.org/josephwa/\">josephwa</a>, <a href=\"https://profiles.wordpress.org/builtbynorthby/\">Josh Feck</a>, <a href=\"https://profiles.wordpress.org/joshuawold/\">JoshuaWold</a>, <a href=\"https://profiles.wordpress.org/joyously/\">Joy</a>, <a href=\"https://profiles.wordpress.org/jplojohn/\">jplo</a>, <a href=\"https://profiles.wordpress.org/jrtashjian/\">JR Tashjian</a>, <a href=\"https://profiles.wordpress.org/jrf/\">jrf</a>, <a href=\"https://profiles.wordpress.org/juiiee8487/\">Juhi Patel</a>, <a href=\"https://profiles.wordpress.org/juliarrr/\">juliarrr</a>, <a href=\"https://profiles.wordpress.org/justinahinon/\">Justin Ahinon</a>, <a href=\"https://profiles.wordpress.org/kadamwhite/\">K. Adam White</a>, <a href=\"https://profiles.wordpress.org/kamataryo/\">KamataRyo</a>, <a href=\"https://profiles.wordpress.org/karinedo/\">Karine Do</a>, <a href=\"https://profiles.wordpress.org/katyatina/\">Katyatina</a>, <a href=\"https://profiles.wordpress.org/kelin1003/\">Kelin Chauhan</a>, <a href=\"https://profiles.wordpress.org/ryelle/\">Kelly Dwan</a>, <a href=\"https://profiles.wordpress.org/itzmekhokan/\">Khokan Sardar</a>, <a href=\"https://profiles.wordpress.org/killua99/\">killua99</a>, <a href=\"https://profiles.wordpress.org/ixkaito/\">Kite</a>, <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell Reigstad</a>, <a href=\"https://profiles.wordpress.org/knutsp/\">Knut Sparhell</a>, <a href=\"https://profiles.wordpress.org/olein/\">Koji Kuno</a>, <a href=\"https://profiles.wordpress.org/obenland/\">Konstantin Obenland</a>, <a href=\"https://profiles.wordpress.org/xkon/\">Konstantinos Xenos</a>, <a href=\"https://profiles.wordpress.org/codemascot/\">Kʜᴀɴ (ಠ_ಠ)</a>, <a href=\"https://profiles.wordpress.org/laurelfulford/\">laurelfulford</a>, <a href=\"https://profiles.wordpress.org/lkraav/\">lkraav</a>, <a href=\"https://profiles.wordpress.org/lovingboth/\">lovingboth</a>, <a href=\"https://profiles.wordpress.org/lukecarbis/\">Luke Carbis</a>, <a href=\"https://profiles.wordpress.org/lgedeon/\">Luke Gedeon</a>, <a href=\"https://profiles.wordpress.org/lukepettway/\">Luke Pettway</a>, <a href=\"https://profiles.wordpress.org/palmiak/\">Maciej Palmowski</a>, <a href=\"https://profiles.wordpress.org/maedahbatool/\">Maedah Batool</a>, <a href=\"https://profiles.wordpress.org/travel_girl/\">Maja Benke</a>, <a href=\"https://profiles.wordpress.org/malae/\">Malae</a>, <a href=\"https://profiles.wordpress.org/manzoorwanijk/\">Manzoor Wani</a>, <a href=\"https://profiles.wordpress.org/robobot3000/\">Marcin</a>, <a href=\"https://profiles.wordpress.org/iworks/\">Marcin Pietrzak</a>, <a href=\"https://profiles.wordpress.org/marcofernandes/\">Marco Fernandes</a>, <a href=\"https://profiles.wordpress.org/marco-peralta/\">Marco Peralta</a>, <a href=\"https://profiles.wordpress.org/mkaz/\">Marcus Kazmierczak</a>, <a href=\"https://profiles.wordpress.org/marekhrabe/\">marekhrabe</a>, <a href=\"https://profiles.wordpress.org/clorith/\">Marius Jensen</a>, <a href=\"https://profiles.wordpress.org/mbelchev/\">Mariyan Belchev</a>, <a href=\"https://profiles.wordpress.org/mapk/\">Mark Uraine</a>, <a href=\"https://profiles.wordpress.org/markcallen/\">markcallen</a>, <a href=\"https://profiles.wordpress.org/mechter/\">Markus Echterhoff</a>, <a href=\"https://profiles.wordpress.org/m-e-h/\">Marty Helmick</a>, <a href=\"https://profiles.wordpress.org/marybaum/\">marybaum</a>, <a href=\"https://profiles.wordpress.org/mattnyeus/\">mattnyeus</a>, <a href=\"https://profiles.wordpress.org/mdwolinski/\">mdwolinski</a>, <a href=\"https://profiles.wordpress.org/immeet94/\">Meet Makadia</a>, <a href=\"https://profiles.wordpress.org/melchoyce/\">Mel Choyce</a>, <a href=\"https://profiles.wordpress.org/mheikkila/\">mheikkila</a>, <a href=\"https://profiles.wordpress.org/wpscholar/\">Micah Wood</a>, <a href=\"https://profiles.wordpress.org/michelleweber/\">michelleweber</a>, <a href=\"https://profiles.wordpress.org/mcsf/\">Miguel Fonseca</a>, <a href=\"https://profiles.wordpress.org/mmtr86/\">Miguel Torres</a>, <a href=\"https://profiles.wordpress.org/simison/\">Mikael Korpela</a>, <a href=\"https://profiles.wordpress.org/mauteri/\">Mike Auteri</a>, <a href=\"https://profiles.wordpress.org/mikeschinkel/\">Mike Schinkel [WPLib Box project lead]</a>, <a href=\"https://profiles.wordpress.org/mikeschroder/\">Mike Schroder</a>, <a href=\"https://profiles.wordpress.org/mikeselander/\">Mike Selander</a>, <a href=\"https://profiles.wordpress.org/mikengarrett/\">MikeNGarrett</a>, <a href=\"https://profiles.wordpress.org/dimadin/\">Milan Dinić</a>, <a href=\"https://profiles.wordpress.org/0mirka00/\">mirka</a>, <a href=\"https://profiles.wordpress.org/lord_viper/\">Mobin Ghasempoor</a>, <a href=\"https://profiles.wordpress.org/mohadeseghasemi/\">Mohadese Ghasemi</a>, <a href=\"https://profiles.wordpress.org/saimonh/\">Mohammed Saimon</a>, <a href=\"https://profiles.wordpress.org/mor10/\">Morten Rand-Hendriksen</a>, <a href=\"https://profiles.wordpress.org/man4toman/\">Morteza Geransayeh</a>, <a href=\"https://profiles.wordpress.org/mmuhsin/\">Muhammad Muhsin</a>, <a href=\"https://profiles.wordpress.org/mukesh27/\">Mukesh Panchal</a>, <a href=\"https://profiles.wordpress.org/m_uysl/\">Mustafa Uysal</a>, <a href=\"https://profiles.wordpress.org/mzorz/\">mzorz</a>, <a href=\"https://profiles.wordpress.org/nfmohit/\">Nahid Ferdous Mohit</a>, <a href=\"https://profiles.wordpress.org/naoki0h/\">Naoki Ohashi</a>, <a href=\"https://profiles.wordpress.org/nateallen/\">Nate Allen</a>, <a href=\"https://profiles.wordpress.org/greatislander/\">Ned Zimmerman</a>, <a href=\"https://profiles.wordpress.org/neobabis/\">Neokazis Charalampos</a>, <a href=\"https://profiles.wordpress.org/modernnerd/\">Nick Cernis</a>, <a href=\"https://profiles.wordpress.org/ndiego/\">Nick Diego</a>, <a href=\"https://profiles.wordpress.org/celloexpressions/\">Nick Halsey</a>, <a href=\"https://profiles.wordpress.org/jainnidhi/\">Nidhi Jain</a>, <a href=\"https://profiles.wordpress.org/nielslange/\">Niels</a>, <a href=\"https://profiles.wordpress.org/nielsdeblaauw/\">Niels de Blaauw</a>, <a href=\"https://profiles.wordpress.org/nnikolov/\">Nikolay Nikolov</a>, <a href=\"https://profiles.wordpress.org/rabmalin/\">Nilambar Sharma</a>, <a href=\"https://profiles.wordpress.org/ninio/\">ninio</a>, <a href=\"https://profiles.wordpress.org/notnownikki/\">notnownikki</a>, <a href=\"https://profiles.wordpress.org/bulletdigital/\">Oliver Sadler</a>, <a href=\"https://profiles.wordpress.org/onlanka/\">onlanka</a>, <a href=\"https://profiles.wordpress.org/pandelisz/\">pandelisz</a>, <a href=\"https://profiles.wordpress.org/swissspidy/\">Pascal Birchler</a>, <a href=\"https://profiles.wordpress.org/pbearne/\">Paul Bearne</a>, <a href=\"https://profiles.wordpress.org/pbiron/\">Paul Biron</a>, <a href=\"https://profiles.wordpress.org/pedromendonca/\">Pedro Mendon&#231;a</a>, <a href=\"https://profiles.wordpress.org/peterbooker/\">Peter Booker</a>, <a href=\"https://profiles.wordpress.org/peterwilsoncc/\">Peter Wilson</a>, <a href=\"https://profiles.wordpress.org/pfiled/\">pfiled</a>, <a href=\"https://profiles.wordpress.org/pilou69/\">pilou69</a>, <a href=\"https://profiles.wordpress.org/pranalipatel/\">Pranali Patel</a>, <a href=\"https://profiles.wordpress.org/pratikthink/\">Pratik</a>, <a href=\"https://profiles.wordpress.org/pratikkry/\">Pratik K. Yadav</a>, <a href=\"https://profiles.wordpress.org/presskopp/\">Presskopp</a>, <a href=\"https://profiles.wordpress.org/psealock/\">psealock</a>, <a href=\"https://profiles.wordpress.org/punit5658/\">Punit Patel</a>, <a href=\"https://profiles.wordpress.org/bamadesigner/\">Rachel Cherry</a>, <a href=\"https://profiles.wordpress.org/rahmon/\">Rahmon</a>, <a href=\"https://profiles.wordpress.org/superpoincare/\">Ramanan</a>, <a href=\"https://profiles.wordpress.org/ramiy/\">Rami Yushuvaev</a>, <a href=\"https://profiles.wordpress.org/ramizmanked/\">Ramiz Manked</a>, <a href=\"https://profiles.wordpress.org/ramonopoly/\">ramonopoly</a>, <a href=\"https://profiles.wordpress.org/youknowriad/\">Riad Benguella</a>, <a href=\"https://profiles.wordpress.org/rinatkhaziev/\">Rinat Khaziev</a>, <a href=\"https://profiles.wordpress.org/noisysocks/\">Robert Anderson</a>, <a href=\"https://profiles.wordpress.org/rsusanto/\">Rudy Susanto</a>, <a href=\"https://profiles.wordpress.org/ryan/\">Ryan Boren</a>, <a href=\"https://profiles.wordpress.org/welcher/\">Ryan Welcher</a>, <a href=\"https://profiles.wordpress.org/sebastienserre/\">S&#233;bastien SERRE</a>, <a href=\"https://profiles.wordpress.org/saeedfard/\">Saeed Fard</a>, <a href=\"https://profiles.wordpress.org/salcode/\">Sal Ferrarello</a>, <a href=\"https://profiles.wordpress.org/salar6990/\">Salar Gholizadeh</a>, <a href=\"https://profiles.wordpress.org/samanehmirrajabi/\">Samaneh Mirrajabi</a>, <a href=\"https://profiles.wordpress.org/samikeijonen/\">Sami Keijonen</a>, <a href=\"https://profiles.wordpress.org/elhardoum/\">Samuel Elh</a>, <a href=\"https://profiles.wordpress.org/sgarza/\">Santiago Garza</a>, <a href=\"https://profiles.wordpress.org/saracope/\">Sara Cope</a>, <a href=\"https://profiles.wordpress.org/saracup/\">saracup</a>, <a href=\"https://profiles.wordpress.org/tinkerbelly/\">sarah semark</a>, <a href=\"https://profiles.wordpress.org/paragoninitiativeenterprises/\">Scott Arciszewski</a>, <a href=\"https://profiles.wordpress.org/coffee2code/\">Scott Reilly</a>, <a href=\"https://profiles.wordpress.org/sebastianpisula/\">Sebastian Pisula</a>, <a href=\"https://profiles.wordpress.org/ebrahimzadeh/\">Sekineh Ebrahimzadeh</a>, <a href=\"https://profiles.wordpress.org/sergeybiryukov/\">Sergey Biryukov</a>, <a href=\"https://profiles.wordpress.org/sergioestevao/\">SergioEstevao</a>, <a href=\"https://profiles.wordpress.org/sgastard/\">sgastard</a>, <a href=\"https://profiles.wordpress.org/sharifkiberu/\">sharifkiberu</a>, <a href=\"https://profiles.wordpress.org/shashank3105/\">Shashank Panchal</a>, <a href=\"https://profiles.wordpress.org/shazdeh/\">shazdeh</a>, <a href=\"https://profiles.wordpress.org/shital-patel/\">Shital Marakana</a>, <a href=\"https://profiles.wordpress.org/sky_76/\">sky_76</a>, <a href=\"https://profiles.wordpress.org/soean/\">Soren Wrede</a>, <a href=\"https://profiles.wordpress.org/netweb/\">Stephen Edgar</a>, <a href=\"https://profiles.wordpress.org/stevenkword/\">Steven Word</a>, <a href=\"https://profiles.wordpress.org/subrataemfluence/\">Subrata Sarkar</a>, <a href=\"https://profiles.wordpress.org/sudar/\">Sudar Muthu</a>, <a href=\"https://profiles.wordpress.org/sudhiryadav/\">Sudhir Yadav</a>, <a href=\"https://profiles.wordpress.org/szepeviktor/\">szepe.viktor</a>, <a href=\"https://profiles.wordpress.org/miyauchi/\">Takayuki Miyauchi</a>, <a href=\"https://profiles.wordpress.org/karmatosed/\">Tammie Lister</a>, <a href=\"https://profiles.wordpress.org/themonic/\">Themonic</a>, <a href=\"https://profiles.wordpress.org/thomstark/\">thomstark</a>, <a href=\"https://profiles.wordpress.org/tfrommen/\">Thorsten Frommen</a>, <a href=\"https://profiles.wordpress.org/thrijith/\">Thrijith Thankachan</a>, <a href=\"https://profiles.wordpress.org/hedgefield/\">Tim Hedgefield</a>, <a href=\"https://profiles.wordpress.org/timwright12/\">Tim Wright</a>, <a href=\"https://profiles.wordpress.org/timothyblynjacobs/\">Timothy Jacobs</a>, <a href=\"https://profiles.wordpress.org/timph/\">timph</a>, <a href=\"https://profiles.wordpress.org/tmatsuur/\">tmatsuur</a>, <a href=\"https://profiles.wordpress.org/ohiosierra/\">tmdesigned</a>, <a href=\"https://profiles.wordpress.org/tmdesigned/\">tmdesigned</a>, <a href=\"https://profiles.wordpress.org/tz-media/\">Tobias Zimpel</a>, <a href=\"https://profiles.wordpress.org/tobiasbg/\">TobiasBg</a>, <a href=\"https://profiles.wordpress.org/tomharrigan/\">TomHarrigan</a>, <a href=\"https://profiles.wordpress.org/tonybogdanov/\">tonybogdanov</a>, <a href=\"https://profiles.wordpress.org/tobifjellner/\">Tor-Bjorn Fjellner</a>, <a href=\"https://profiles.wordpress.org/toro_unit/\">Toro_Unit (Hiroshi Urabe)</a>, <a href=\"https://profiles.wordpress.org/torres126/\">torres126</a>, <a href=\"https://profiles.wordpress.org/zodiac1978/\">Torsten Landsiedel</a>, <a href=\"https://profiles.wordpress.org/itowhid06/\">Towhidul Islam</a>, <a href=\"https://profiles.wordpress.org/liljimmi/\">Tracy Levesque</a>, <a href=\"https://profiles.wordpress.org/umang7/\">Umang Bhanvadia</a>, <a href=\"https://profiles.wordpress.org/vaishalipanchal/\">Vaishali Panchal</a>, <a href=\"https://profiles.wordpress.org/vrimill/\">vrimill</a>, <a href=\"https://profiles.wordpress.org/webfactory/\">WebFactory</a>, <a href=\"https://profiles.wordpress.org/westonruter/\">Weston Ruter</a>, <a href=\"https://profiles.wordpress.org/wfmattr/\">WFMattR</a>, <a href=\"https://profiles.wordpress.org/bahia0019/\">William \'Bahia\' Bay</a>, <a href=\"https://profiles.wordpress.org/earnjam/\">William Earnhardt</a>, <a href=\"https://profiles.wordpress.org/williampatton/\">williampatton</a>, <a href=\"https://profiles.wordpress.org/willscrlt/\">Willscrlt</a>, <a href=\"https://profiles.wordpress.org/wolly/\">Wolly aka Paolo Valenti</a>, <a href=\"https://profiles.wordpress.org/wrwrwr0/\">wrwrwr0</a>, <a href=\"https://profiles.wordpress.org/yoavf/\">Yoav Farhi</a>, <a href=\"https://profiles.wordpress.org/fierevere/\">Yui</a>, <a href=\"https://profiles.wordpress.org/zebulan/\">Zebulan Stanphill</a>, and <a href=\"https://profiles.wordpress.org/chesio/\">Česlav Przywara</a>.\n\n\n\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p>Also, many thanks to all of the community volunteers who contribute in the <a href=\"https://wordpress.org/support/\">support forums</a>. They answer questions from people across the world, whether they are using WordPress for the first time or since the first release. These releases are more successful for their efforts!</p>\n\n\n\n<p>If you want learn more about volunteering with WordPress, check out&nbsp;<a href=\"https://make.wordpress.org/\">Make WordPress</a>&nbsp;or the&nbsp;<a href=\"https://make.wordpress.org/core/\">core development blog</a>.</p>\n\n\n\n<p>Thanks for choosing WordPress!</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6925\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:17:\"WordPress 5.2 RC2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/2019/05/wordpress-5-2-rc2/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 May 2019 16:17:59 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6914\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:326:\"The second release candidate for WordPress 5.2 is now available! WordPress 5.2 will be released on Tuesday, May 7, but we need your help to get there—if you haven’t tried 5.2 yet, now is the time! There are two ways to test the WordPress 5.2 release candidate: try the WordPress Beta Tester plugin (you’ll want [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2472:\"\n<p>The second release candidate for WordPress 5.2 is now available!</p>\n\n\n\n<p>WordPress 5.2 will be released on <strong><a href=\"https://make.wordpress.org/core/5-2/\">Tuesday, May 7</a></strong>, but we need <em>your</em> help to get there—if you haven’t tried 5.2 yet, now is the time!</p>\n\n\n\n<p>There are two ways to test the WordPress 5.2 release candidate: try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want to select the “bleeding edge nightlies” option), or you can <a href=\"https://wordpress.org/wordpress-5.2-RC2.zip\">download the release candidate here</a> (zip).</p>\n\n\n\n<p>For details about what to expect in WordPress 5.2, please see the <a href=\"https://wordpress.org/news/2019/04/wordpress-5-2-release-candidate/\">first release candidate post</a>.</p>\n\n\n\n<p>This release includes the final About page design. It also contains fixes for:</p>\n\n\n\n<ul><li>Proper translation of the recovery mode notification emails (#47093).</li><li>Improvements to the way Site Health works with multisite installs (#47084).</li></ul>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.2 and update the <em>Tested up to</em> version in the readme to 5.2. If you find compatibility problems, please be sure to post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a> so we can figure those out before the final release.</p>\n\n\n\n<p>The&nbsp;<a href=\"https://make.wordpress.org/core/2019/04/16/wordpress-5-2-field-guide/\">WordPress 5.2 Field Guide</a>&nbsp;has also been published, which details the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a></p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can post to the <a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a> in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report, <a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find <a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>It&#8217;s the start of May<br>and the release is coming.<br>We all give a cheer!</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6914\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:48:\"\n		\n		\n				\n		\n				\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"The Month in WordPress: April 2019\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2019/05/the-month-in-wordpress-april-2019/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 May 2019 09:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Month in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6918\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:324:\"This past month has been filled with anticipation as the community builds up towards a big new release, plans some important events, and builds new tools to grow the future of the project. WordPress 5.2 Almost Due for Release WordPress 5.2 is due for release on May 7 with many new features included for developers [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Hugh Lashbrooke\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8386:\"\n<p>This past month has been filled with anticipation as the community builds up towards a big new release, plans some important events, and builds new tools to grow the future of the project.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>WordPress 5.2 Almost Due for Release</h2>\n\n\n\n<p>WordPress 5.2 is due for release on May 7 with many new features included for developers and end-users alike. <a href=\"https://make.wordpress.org/core/2019/04/16/wordpress-5-2-field-guide/\">The Field Guide for the release</a> provides a lot of information about what is in it and what you can expect, including a few key elements:</p>\n\n\n\n<h3>Site Health Check</h3>\n\n\n\n<p>One of the most highly anticipated features for v5.2 is <a href=\"https://make.wordpress.org/core/2019/04/25/site-health-check-in-5-2/\">the Site Health Check</a>. This feature adds two new pages in the admin interface to help end users maintain a healthy site through common configuration issues and other elements that go along with having a robust online presence. It also provides a standardized location for developers to add debugging information.</p>\n\n\n\n<h3>Fatal Error Recovery Mode</h3>\n\n\n\n<p><a href=\"https://make.wordpress.org/core/2019/04/16/fatal-error-recovery-mode-in-5-2/\">The Fatal Error Recovery Mode feature</a> was originally planned for the 5.1 release but was delayed to patch up some last-minute issues that arose. This feature will help site-owners recover more quickly from fatal errors that break the display or functionality of their site that would ordinarily require code or database edits to fix.</p>\n\n\n\n<h3>Privacy and Accessibility Updates</h3>\n\n\n\n<p>Along with the headlining features mentioned above, there are some important enhancements to the privacy and accessibility features included in Core. These include <a href=\"https://make.wordpress.org/core/2019/04/24/developer-focused-privacy-updates-in-5-2/\">some important developer-focused changes</a> to how privacy policy pages are displayed and user data is exported, as well as <a href=\"https://make.wordpress.org/core/2019/04/02/admin-tabs-semantic-improvements-in-5-2/\">moving to more semantic markup for admin tabs</a> and <a href=\"https://make.wordpress.org/core/2019/04/24/notable-accessibility-changes-in-5-2/\">other improvements</a> such as switching post format icons to drop-down menus on post list tables, improved admin toolbar markup, and contextual improvements to archive widget drop-down menu.</p>\n\n\n\n<h3>New Dashicons</h3>\n\n\n\n<p>The <a href=\"https://developer.wordpress.org/resource/dashicons/\">Dashicons</a> library was last updated was over 3 years ago. Now, in the upcoming release, <a href=\"https://make.wordpress.org/core/2019/04/11/dashicons-in-wordpress-5-2/\">a set of 13 new icons will be added to the library</a> along with improvements to the build process and file format of the icons.</p>\n\n\n\n<h3>Block Editor Upgrades</h3>\n\n\n\n<p>The Block Editor has seen <a href=\"https://make.wordpress.org/core/2019/04/17/whats-new-in-gutenberg-17th-april/\">numerous improvements</a> lately that will all be included in the v5.2 release. Along with the interface upgrades, the underlying Javascript module <a href=\"https://make.wordpress.org/core/2019/04/09/the-block-editor-javascript-module-in-5-2/\">has been reorganized</a>, improvements have been made to <a href=\"https://make.wordpress.org/core/2019/04/17/block-editor-detection-improvements-in-5-2/\">how the block editor is detected</a> on the post edit screen, and <a href=\"https://make.wordpress.org/core/2019/03/25/building-javascript/\">the Javascript build process has been enhanced</a>.</p>\n\n\n\n<p><a href=\"https://wordpress.org/news/2019/04/wordpress-5-2-release-candidate/\">WordPress 5.2 is now in the Release Candidate phase</a> and you can test it by installing <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">the Beta Tester plugin</a> on any WordPress site.</p>\n\n\n\n<p>Want to get involved in building WordPress Core? Follow <a href=\"https://make.wordpress.org/core\">the Core team blog</a> and join the #core channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>WordPress Translation Day 4 is Almost Here</h2>\n\n\n\n<p>On 11 May 2019, <a href=\"https://make.wordpress.org/polyglots/2019/03/01/global-wordpress-translation-day-4-is-coming/\">the fourth WordPress Translation Day</a> will take place. This is a 24-hour global event dedicated to the translation of all things WordPress, from Core to themes, plugins to marketing.</p>\n\n\n\n<p>Over the course of 24 hours, WordPress communities will meet to translate WordPress into their local languages and watch talks and sessions broadcast on <a href=\"https://wptranslationday.org/\">wptranslationday.org</a>. During the previous WordPress Translation Day, 71 local events took place in 29 countries, and even more communities are expected to take part this time.</p>\n\n\n\n<p>Want to get involved in WordPress Translation Day 4? Find out <a href=\"https://make.wordpress.org/community/2019/03/22/global-wordpress-translation-day-4-info-for-event-organizers/\">how to organize a local event</a>, follow the updates on <a href=\"https://make.wordpress.org/polyglots/tag/gwtd4/\">the Polyglots team blog</a>, and join the #polyglots channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<h2>Block Library Project Gets Started</h2>\n\n\n\n<p>Since <a href=\"https://make.wordpress.org/meta/2019/03/08/the-block-directory-and-a-new-type-of-plugin/\">the initial proposal</a> for a Block Library that would be made available from inside the block editor, work has been done to put together <a href=\"https://make.wordpress.org/design/2019/04/02/call-for-design-installing-blocks-from-within-gutenberg/\">some designs</a> for how this would look. Since then the project has received a more direct focus with <a href=\"https://make.wordpress.org/design/2019/04/26/block-library-installing-blocks-from-within-gutenberg/\">a planned out scope and timeline</a>.</p>\n\n\n\n<p>The project is being managed <a href=\"https://github.com/WordPress/block-directory/projects/1\">on GitHub</a> and people interested in contributing are encouraged to get involved there. You can also keep up to date by following <a href=\"https://make.wordpress.org/design/\">the Design team blog</a> and joining the #design channel in <a href=\"https://make.wordpress.org/chat/\">the Making WordPress Slack group</a>.</p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2>Further Reading:</h2>\n\n\n\n<ul><li>The results from the 5.0 release retrospective survey <a href=\"https://make.wordpress.org/updates/2019/04/26/5-0-release-retrospective-wrap-up/\">have been published</a> &#8211; this is the first time this kind of open retrospective has been done for a WordPress release and the results provide valuable insight into the project and its contributors.</li><li>The team behind the WordPress Coding Standards <a href=\"https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/releases/tag/2.1.0\">has released version 2.1</a>, including some very useful new sniffs.</li><li>The community <a href=\"https://make.wordpress.org/community/2019/04/18/the-get-involved-table-at-wceu-2019/\">is looking for volunteers for the Get Involved table</a> at WordCamp Europe on 20-22 June.</li><li>Gutenberg has been ported <a href=\"https://github.com/VanOns/laraberg/\">for use within the Laravel framework</a> in a project dubbed Laraberg.</li><li>The 2019 WordCamp for Publishers event <a href=\"https://2019-columbus.publishers.wordcamp.org/2019/04/12/call-for-speakers/\">has opened its call for speakers</a>.</li><li>The Gutenberg team <a href=\"https://github.com/WordPress/gutenberg/blob/add/blocks-in-widget-areas-rfc/docs/rfcs/blocks-in-widget-areas.md\">has published an RFC</a> regarding blocks being used in widgets.</li><li>WordCamp Europe, taking place on 20-22 June, has published <a href=\"https://2019.europe.wordcamp.org/schedule/\">the schedule for the event</a>.</li><li>The Community Team <a href=\"https://make.wordpress.org/community/2019/04/18/2018-meetup-survey/\">has published the results</a> of the 2018 meetup group survey.</li></ul>\n\n\n\n<p><em>Have a story that we should include in the next “Month in WordPress” post? Please </em><a href=\"https://make.wordpress.org/community/month-in-wordpress-submissions/\"><em>submit it here</em></a><em>.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6918\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:51:\"\n		\n		\n				\n		\n				\n		\n\n		\n				\n								\n										\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"WordPress 5.2 Release Candidate\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://wordpress.org/news/2019/04/wordpress-5-2-release-candidate/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 26 Apr 2019 01:28:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"https://wordpress.org/news/?p=6909\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:364:\"The first release candidate for WordPress 5.2 is now available! This is an important milestone as we progress toward the WordPress 5.2 release date. “Release Candidate” means that the new version is ready for release, but with millions of users and thousands of plugins and themes, it’s possible something was missed. WordPress 5.2 is scheduled to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Josepha\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3117:\"\n<p>The first release candidate for WordPress 5.2 is now available!</p>\n\n\n\n<p>This is an important milestone as we progress toward the WordPress 5.2 release date. “Release Candidate” means that the new version is ready for release, but with millions of users and thousands of plugins and themes, it’s possible something was missed. WordPress 5.2 is scheduled to be released on <strong>Tuesday, May 7</strong>, but we need <em>your</em> help to get there—if you haven’t tried 5.2 yet, now is the time!</p>\n\n\n\n<p>There are two ways to test the WordPress 5.2 release candidate: try the <a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\">WordPress Beta Tester</a> plugin (you’ll want to select the “bleeding edge nightlies” option), or you can <a href=\"https://wordpress.org/wordpress-5.2-RC1.zip\">download the release candidate here</a> (zip).</p>\n\n\n\n<h2>What&#8217;s in WordPress 5.2?</h2>\n\n\n\n<p>Continuing with the theme from the last release, WordPress 5.2 gives you even more robust tools for identifying and fixing configuration issues and fatal errors. Whether you are a developer helping clients or you manage your site solo, these tools can help get you the right information when you need it.</p>\n\n\n\n<p>The Site Health Check and PHP Error Protection tools have brand new features, giving you peace of mind if you discover any issues with plugins or themes on your site. There are also updates to the icons available in your dashboard, fresh accessibility considerations for anyone using assistive technologies and more.</p>\n\n\n\n<h2>Plugin and Theme Developers</h2>\n\n\n\n<p>Please test your plugins and themes against WordPress 5.2 and update the <em>Tested up to</em> version in the readme to 5.2. If you find compatibility problems, please be sure to post to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">support forums</a> so we can figure those out before the final release.</p>\n\n\n\n<p>The <a href=\"https://make.wordpress.org/core/2019/04/16/wordpress-5-2-field-guide/\">WordPress 5.2 Field Guide</a> has also been published, which goes into the details of the major changes.</p>\n\n\n\n<h2>How to Help</h2>\n\n\n\n<p>Do you speak a language other than English? <a href=\"https://translate.wordpress.org/projects/wp/dev\">Help us translate WordPress into more than 100 languages!</a> This release also marks the <a href=\"https://make.wordpress.org/polyglots/handbook/glossary/#hard-freeze\">hard string freeze</a> point of the 5.2 release schedule.</p>\n\n\n\n<p><em><strong>If you think you’ve found a bug</strong>, you can post to the&nbsp;<a href=\"https://wordpress.org/support/forum/alphabeta\">Alpha/Beta area</a>&nbsp;in the support forums. We’d love to hear from you! If you’re comfortable writing a reproducible bug report,&nbsp;<a href=\"https://make.wordpress.org/core/reports/\">file one on WordPress Trac</a>, where you can also find&nbsp;<a href=\"https://core.trac.wordpress.org/tickets/major\">a list of known bugs</a>.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<p><em>Howdy, RC 1!<br>With tools this interesting,<br>I can hardly wait.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"6909\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:32:\"https://wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"14607090\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:9:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sun, 21 Jul 2019 06:34:06 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Fri, 12 Jul 2019 20:20:46 GMT\";s:4:\"link\";s:63:\"<https://wordpress.org/news/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";s:14:\"20130911030210\";}", "no");
INSERT INTO `wp_options` VALUES("736", "_transient_timeout_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1563733988", "no");
INSERT INTO `wp_options` VALUES("737", "_transient_feed_mod_9bbd59226dc36b9b26cd43f15694c5c3", "1563690788", "no");
INSERT INTO `wp_options` VALUES("738", "_transient_timeout_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "1563733989", "no");
INSERT INTO `wp_options` VALUES("739", "_transient_feed_d117b5738fbd35bd8c0391cda1f2b5d9", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:61:\"\n	\n	\n	\n	\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"WordPress Planet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"en\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress Planet - http://planet.wordpress.org/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:50:{i:0;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"Matt: Animated WordPress Wallpaper\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"https://ma.tt/?p=49859\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://ma.tt/2019/07/animated-wordpress-wallpaper/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:729:\"<p>I didn&#8217;t realize this, but apparently MacOS has a built-in ability to show really stunning animated wallpapers, like <a href=\"https://dynamicwallpaper.club/wallpaper/j82e55k6yds\"><a href=\"https://dynamicwallpaper.club/wallpaper/j82e55k6yds\">this one created by Folletto</a></a> that subtly changes colors throughout the day in an incredibly engaging well:</p>\n\n\n\n<a href=\"https://dynamicwallpaper.club/wallpaper/j82e55k6yds\" target=\"_blank\" rel=\"noreferrer noopener\"><img /></a>\n\n\n\n<p>Check out Folletto&#8217;s blog for <a href=\"https://intenseminimalism.com/2019/dynamic-wallpapers-for-macos/\">another dynamic wallpaper and some of process behind creating it</a>. This would be awesome to have for iPhones as well.</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 19 Jul 2019 15:09:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Matt\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"WPTavern: All-in-One WP Migration 7.0 Patches XSS Vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://wptavern.com/?p=91751\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://wptavern.com/all-in-one-wp-migration-7-0-patches-xss-vulnerability\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1822:\"<p>Those who use the <a href=\"https://wordpress.org/plugins/all-in-one-wp-migration/\">All-in-One WP Migration</a> plugin are encouraged to update to version 7.0 as soon as possible as 6.97 contains an admin backend cross-site-scripting vulnerability. </p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>An attacker would already have to be able to either compromise the database or gain access to a user account with high enough privileges to view the backup history, so some damage has already been done, but such an attacker could then also insert some XSS in order to compromise other admin users. </p><p>When double-clicking the backup description on the backup history overview page, in order to edit the description text, the text is not sanitized/escaped via html entities when generating the input field.</p><cite><a href=\"https://wpvulndb.com/vulnerabilities/9461\">Vulnerability Report</a></cite></blockquote>\n\n\n\n<p>Version 7.0 was released on the plugin directory about a day ago and patches the vulnerability. According to the stats on the WordPress plugin directory, All-in-One WP Migration is actively installed on more than two million sites. </p>\n\n\n\n<p>A proof of concept will be published on July 24th which gives site owners about a week to update. Unfortunately, users who view the changelog prior to updating will not be able to determine it patches a security issue due to the patch being labeled as <a href=\"https://wordpress.org/plugins/all-in-one-wp-migration/#developers\">a general fix</a>. </p>\n\n\n\n<h2>Updated July 19th</h2>\n\n\n\n<p>All-in-One WP Migration has <a href=\"https://wordpress.org/plugins/all-in-one-wp-migration/#developers\">released a new update</a> that addresses a different security issue that was introduced in 7.0. Users are strongly encouraged to update to 7.1 as soon as possible. </p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Jul 2019 21:19:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"WPTavern: WPWeekly Episode 360 – CBD and E-Commerce With Javier Cano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wptavern.com/?p=91730&preview=true&preview_id=91730\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"https://wptavern.com/wpweekly-episode-360-cbd-and-e-commerce-with-javier-cano\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:1247:\"<p>In this episode, <a href=\"http://jjj.me\">John James Jacoby</a> and I are joined by <a href=\"https://www.liquidweb.com/blog/author/jcano/\">Javier Cano</a>, Director of Marketing for Liquid Web. We discuss the challenges people are facing selling CBD products on e-commerce platforms such as Shopify and WooCommerce and what Liquid Web is doing to be an ally to the industry. We also talk about high-risk payment processors and the brick and mortar approach versus selling high-risk products online. Cano also shares his experiences from attending and speaking at recent CBD expos.</p>\n<h2>WPWeekly Meta:</h2>\n<p><strong>Next Episode:</strong> Wednesday, July 24th 3:00 P.M. Eastern</p>\n<p>Subscribe to <a href=\"https://itunes.apple.com/us/podcast/wordpress-weekly/id694849738\">WordPress Weekly via Itunes</a></p>\n<p>Subscribe to <a href=\"https://www.wptavern.com/feed/podcast\">WordPress Weekly via RSS</a></p>\n<p>Subscribe to <a href=\"http://www.stitcher.com/podcast/wordpress-weekly-podcast?refid=stpr\">WordPress Weekly via Stitcher Radio</a></p>\n<p>Subscribe to <a href=\"https://play.google.com/music/listen?u=0#/ps/Ir3keivkvwwh24xy7qiymurwpbe\">WordPress Weekly via Google Play</a></p>\n<p><strong>Listen To Episode #360:</strong><br />\n</p>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 18 Jul 2019 01:46:29 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Jeff Chandler\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:13:\"\n	\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"HeroPress: History and Future of Kids Heroes in WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://heropress.com/?post_type=heropress-essays&p=2926\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:166:\"https://heropress.com/essays/history-and-future-of-kids-heroes-in-wordpress/#utm_source=rss&utm_medium=rss&utm_campaign=history-and-future-of-kids-heroes-in-wordpress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:12088:\"<img width=\"560\" height=\"315\" src=\"https://s20094.pcdn.co/wp-content/uploads/2020/07/WordPress-and-its-surrounding-communities-have-the-opportunity-to-change-the-lives-of-kids-all-over-the-world..png\" class=\"attachment-large size-large wp-post-image\" alt=\"\" /><p>Kids events are not a new thing in the WordCamp and WordPress event space, however, the number of these events happening around the world are on the rise. Kids events focus on teaching children how to become content creators, creative thinkers, and even business owners. Numerous repeat attendees have morphed their personal blogs into businesses and these kids are only 8-13 years old. Kids events provide an opportunity for local communities to foster long term community growth. These events also offer opportunities for a more diverse event in that kids bring a new perspective to any event. WordPress and its surrounding communities have the opportunity to change the lives of kids all over the world.</p>\n<h2>History of Kids Events</h2>\n<p>The history of Kids Events is full of many Heroes who have worked tirelessly to ensure that children in our community are included in events. Most of these events happen in tandem with WordCamps, but that is not always the case. Here is the history of most of the Kids Events and the Heroes behind them.</p>\n<ul>\n<li>2010-03-06 &#8211; Kilkenny, Ireland &#8211; Sabrina Dent<a href=\"https://www.krishna.me/wordcamp-ireland-in-kilkenny-has-its-own-kids-camp/\"> https://www.krishna.me/wordcamp-ireland-in-kilkenny-has-its-own-kids-camp/</a></li>\n<li>2011-01-29 &#8211; Phoenix, AZ &#8211; Abbie Sanderson<a href=\"https://2015.dfw.wordcamp.org/2015/07/06/announcing-wordcamp-for-kids/\"> https://2015.dfw.wordcamp.org/2015/07/06/announcing-wordcamp-for-kids/</a></li>\n<li>2013-01-20 &#8211; Phoenix &#8211; Natalie MacLees<a href=\"https://2013.phoenix.wordcamp.org/schedule/sunday/\"> https://2013.phoenix.wordcamp.org/schedule/sunday/</a></li>\n<li>2013-04-06 &#8211; Miami</li>\n<li>2014-05-11 &#8211; Miami &#8211; Tammy Lister and Sarah Gooding <a href=\"https://2014.miami.wordcamp.org/wordcamp-miami-kids-workshop/\"> https://2014.miami.wordcamp.org/wordcamp-miami-kids-workshop/</a></li>\n<li>2014-01-19 &#8211; Phoenix &#8211; Bernice Lee and Andy Christian<a href=\"https://2014.phoenix.wordcamp.org/session/wordcamp-kids/\"> https://2014.phoenix.wordcamp.org/session/wordcamp-kids/</a></li>\n<li>2014-03-15 &#8211; Atlanta &#8211; Syed Balkhi, Sara Cannon, Micah Wood, and Russell Fair <a href=\"https://2014.atlanta.wordcamp.org/kidscamp-atlanta/\"> https://2014.atlanta.wordcamp.org/kidscamp-atlanta/</a></li>\n<li>2015-03-15 &#8211; St Louis &#8211; Russell Fair, Chris Koerner, Lucas Lima, Eric Juden, Michele Butcher-Jones <a href=\"https://2015.stlouis.wordcamp.org/session/kids-camp/\">https://2015.stlouis.wordcamp.org/session/kids-camp/</a></li>\n<li>2015-03-27 &#8211; Atlanta, GA &#8211; Russell Fair<a href=\"https://2015.atlanta.wordcamp.org/\"> https://2015.atlanta.wordcamp.org/</a></li>\n<li>2015-05-31 &#8211; Miami FL Nikhil V, Sarrah Vesselov, Shawn Hooper and Michele Butcher-Jones. <a href=\"https://2015.miami.wordcamp.org/wordcamp-for-kids-tickets-now-available/\">https://2015.miami.wordcamp.org/wordcamp-for-kids-tickets-now-available/</a></li>\n<li>2016-02-20 &#8211; Miami, FL &#8211; Sandy Edwards, Kimberly Lipari, Michele Butcher-Jones, Shawn Hooper,  and Chris Christoff https://2016.miami.wordcamp.org/2016/02/05/details-on-weekend-kids-activities/#workshop</li>\n<li>2016-09-26 &#8211; Dallas/Ft. Worth, TX &#8211;<a href=\"https://2015.dfw.wordcamp.org/2015/07/06/announcing-wordcamp-for-kids/\"> https://2015.dfw.wordcamp.org/2015/07/06/announcing-wordcamp-for-kids/</a></li>\n<li>2016-10-29 &#8211; Seattle &#8211;<a href=\"https://2016.seattle.wordcamp.org/speaker/nichole-betterley/\"> Nichole Betterley</a> &#8211;<a href=\"https://2016.seattle.wordcamp.org/session/kidscamp/\"> https://2016.seattle.wordcamp.org/session/kidscamp/</a></li>\n<li>2017-03-18 &#8211; Atlanta, GA &#8211; Sandy Edwards<a href=\"https://2017.atlanta.wordcamp.org/2017/01/28/kids-camp/\"> https://2017.atlanta.wordcamp.org/2017/01/28/kids-camp/</a></li>\n<li>2017-05-20 &#8211; Jacksonville, FL &#8211; Sandy Edwards<a href=\"https://2017.jacksonville.wordcamp.org/kidscamp/\"> https://2017.jacksonville.wordcamp.org/kidscamp/</a></li>\n<li>2017-08-21 &#8211; Austin &#8211;<a href=\"https://2017.austin.wordcamp.org/kidscamp/\"> https://2017.austin.wordcamp.org/kidscamp/</a></li>\n<li>2017-11-11 &#8211; Orlando, FL &#8211; Sandy Edwards<a href=\"https://2017.orlando.wordcamp.org/kidscamp/\"> https://2017.orlando.wordcamp.org/kidscamp/</a></li>\n<li>2018-03-17 &#8211; Miami, FL &#8211; Chris Christoff, Sandy Edwards, Sam Smith, Paul Champeau, Angelica Yarde, Andrew Wikel, Josh Pollock, David Wolfpaw, Adam Warner, Brian Richards, Chris Edwards, Beka Rice, Joe Howard, Dr Nancy Richmond, Peta Bisset<a href=\"https://2018.miami.wordcamp.org/kids/\"> https://2018.miami.wordcamp.org/kids/</a></li>\n<li>2018-04-07 &#8211; Jacksonville, FL &#8211; Sandy Edwards<a href=\"https://2018.jacksonville.wordcamp.org/kidscamp/\"> https://2018.jacksonville.wordcamp.org/kidscamp/</a></li>\n<li>2018-04-14 &#8211; Atlanta, GA &#8211; Sandy Edwards<a href=\"https://2018.atlanta.wordcamp.org/schedule/\"> https://2018.atlanta.wordcamp.org/schedule/</a></li>\n<li>2018-05-26 &#8211; Calgary, Canada &#8211; Christina Workman &#8211;<a href=\"https://2018.calgary.wordcamp.org/kidscamp/\"> https://2018.calgary.wordcamp.org/kidscamp/</a></li>\n<li>2018-07-22 &#8211; San Jose, Costa Rica &#8211; Roberto Remedios, Ana Maria Montero<a href=\"https://2018.sanjose.wordcamp.org/programa/kids-camp/\"> https://2018.sanjose.wordcamp.org/programa/kids-camp/</a></li>\n<li>2018-11-24 &#8211; Harrare, Africa &#8211; Thelma Mutete &#8211;<a href=\"https://2018.harare.wordcamp.org/2018/11/17/the-wordcamp-juniors-workshop/\"> https://2018.harare.wordcamp.org/2018/11/17/the-wordcamp-juniors-workshop/</a></li>\n<li>2018-11-10 &#8211; Orlando, FL &#8211; William Jackson, Aida Correa &#8211;<a href=\"https://www.krishna.me/wordcamp-ireland-in-kilkenny-has-its-own-kids-camp/\"> https://www.krishna.me/wordcamp-ireland-in-kilkenny-has-its-own-kids-camp/</a></li>\n<li>2019-03-07 &#8211; Nordic, Helsinki, Finland &#8211; Petya<a href=\"https://2019.nordic.wordcamp.org/contributor-day/wordpress-workshop-for-kids/\"> https://2019.nordic.wordcamp.org/contributor-day/wordpress-workshop-for-kids/</a></li>\n<li>2019-04-06 &#8211; Raleigh, NC &#8211; Sandy Edwards, Patrik Seus<a href=\"https://2019.raleigh.wordcamp.org/kidscamp/\"> https://2019.raleigh.wordcamp.org/kidscamp/</a></li>\n<li>2019-05-11 &#8211; Calgary, Canada &#8211; Christina Workman <a href=\"https://2019.calgary.wordcamp.org/2019/03/19/kidscamp-is-back/\"> https://2019.calgary.wordcamp.org/2019/03/19/kidscamp-is-back/</a></li>\n<li>2019-06-29 &#8211; Jacksonville, Fl &#8211; William Jackson, Aida Correa <a href=\"https://2019.jacksonville.wordcamp.org/kidscamp/\">https://2019.jacksonville.wordcamp.org/kidscamp/</a></li>\n<li>2019-07-20 &#8211; Boston, MA &#8211; Sandy Edwards, Jim Reevoir, and Elizabeth Desrosiers <a href=\"https://2019.boston.wordcamp.org/kidscamp/\">https://2019.boston.wordcamp.org/kidscamp/</a></li>\n</ul>\n<h2>More Kids Event Information</h2>\n<p>Kids programming with WordPress is here to provide a solid opportunity for minors to be included in the community. The programs offer events, workshops, and inclusion in the ever-growing WordPress community.</p>\n<p>The community as a whole has always provided educational and networking events to further personal development. Kids Programming is no different.</p>\n<p>Events focus on key skill sets such as public speaking, writing, networking, and communication. Children get to work with peers in exciting and fulfilling ways and leave the events with new friends. These friends often live in various places around the globe and create the opportunity for long-distance friendships fostered through technological resources.</p>\n<p>For example, my son lives in Orlando and has friends in Tampa, Jacksonville and even out of state. He keeps in touch through Facebook Messenger or Slack.</p>\n<p>The fact is our kids need a fun way to use real-world skills in a non-threatening environment. A place where they won’t be tested and where they can’t fail.</p>\n<p>These programs offer just that. With over 40 different volunteers helping to foster this program across the globe it is becoming a WordPress community staple.</p>\n<p>There is still much to do. Safety has to be our #1 priority when working with minors and that means keeping things pretty consistent. There is a group of amazing volunteers documenting the process of planning a kids event and class cur